#include <stdio.h>
#include <string.h>

#include "mag_snapshot.h"
#include "df.h"

void main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp,SD_id;
  struct MagSnapSet testdata;
  int ii,jj,kk,retval;

  if (argc!=2)
    {
      printf("Usage: rd_hdf hdf_file\n");
      exit(1);
    }

  /* open hdf input file */

  if ((hdf_fp=Hopen(argv[1], DFACC_READ, 0))==FAIL)
    {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
    }
  Vstart(hdf_fp);
  if ((SD_id=SDstart(argv[1], DFACC_RDONLY))==FAIL)
      {
	fprintf(stderr, "SDstart: could not open hdf file\n");
	exit(-1);
      }

  init_rd_mag_snap(hdf_fp, SD_id);

  ii=0;
  while((retval= read_mag_snap(&testdata,ii))!=-1) {
	  printf("%4d sc clock = %8d\n", ii++,testdata.sctime);
 	  for(jj=0;jj<3;jj++){
	    for(kk=0;kk<(SNPVAL);kk++)
 	      printf("sample of hxyz %4x %4x %4x \n", testdata.hxyz[jj][kk]);
          }
          printf("\n");
 }

  /* all done, close HDF file */

  close_rd_mag_snap();
  Vend(hdf_fp);
  if (Hclose(hdf_fp)==FAIL)
    {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
    }
  exit(0);
}
    
