#include <stdio.h>
#include <string.h>

#include "mag_hskp.h"
#include "df.h"

void main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp,SD_id;
  struct MagHskpSet testdata;
  int ii,retval;

  if (argc!=2)
    {
      printf("Usage: rd_hdf hdf_file\n");
      exit(1);
    }

  /* open hdf input file */

  if ((hdf_fp=Hopen(argv[1], DFACC_READ, 0))==FAIL)
    {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
    }
  Vstart(hdf_fp);
  if ((SD_id=SDstart(argv[1], DFACC_RDONLY))==FAIL)
    {
      fprintf(stderr, "SDstart: could not open hdf file\n");
      exit(-1);
    }

  init_rd_mag_hskp(hdf_fp, SD_id);

  ii=0;
  while((retval= read_mag_hskp(&testdata,ii))!=-1) {
	  printf("%4d sc clock = %8d\n", ii++,testdata.sctime);
	  printf("  %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %4x\n",
	    testdata.st1a, testdata.st2a, testdata.st3,    testdata.st4, 
	    testdata.st5,  testdata.st6,  testdata.pctemp, testdata.cmon, 
	    testdata.hk1,  testdata.hk2,  testdata.hk3,    testdata.hk4,
	    testdata.hk5,  testdata.sync, testdata.st);
  }

  /* all done, close HDF file */

  close_rd_mag_hskp();
  fprintf(stderr,"VS detached \n");
  Vend(hdf_fp);
  fprintf(stderr,"VS ended \n");
  if (Hclose(hdf_fp)==FAIL)
    {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
    }
  fprintf(stderr,"file closed \n");
  

  exit(0);
}
    
