/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.20 1997/03/19 17:58:31 steves Exp $ */

/* The include file used to create this file is: */
/* $Id: mag_hskp.h,v 1.6 1996/06/25 18:53:22 jeff Exp $ */

#include "mag_hskp.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w;

/****  init write function  ****/

int32 init_wr_mag_hskp(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  void mag_hskp_error();

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "mag_hskp");
  VSsetclass(vdata_id_w, classname);

   if (VSfdefine(vdata_id_w, "MagHskpSet_sctime", DFNT_UINT32, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_sctime error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_QAC", DFNT_UINT32, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_QAC error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_st1a", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_st1a error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_st2a", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_st2a error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_st3", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_st3 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_st4", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_st4 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_st5", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_st5 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_st6", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_st6 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_pctemp", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_pctemp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_cmon", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_cmon error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_st1b", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_st1b error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_st2b", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_st2b error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_hk1", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_hk1 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_hk2", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_hk2 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_hk3", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_hk3 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_hk4", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_hk4 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_hk5", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_hk5 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_sync", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_sync error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_st", DFNT_UINT16, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_st error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_in_temp", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_in_temp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_out_temp", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_out_temp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_in_pwrlvl", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_in_pwrlvl error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_out_pwrlvl", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_out_pwrlvl error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_current", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_current error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_SenIntTempPosY", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_SenIntTempPosY error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_SenIntTempNegY", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_SenIntTempNegY error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagHskpSet_MagPowBits", DFNT_UINT8, (1) )) {
     mag_hskp_error("VSfdefine MagHskpSet_MagPowBits error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"MagHskpSet_sctime, MagHskpSet_QAC, MagHskpSet_st1a, MagHskpSet_st2a, MagHskpSet_st3, MagHskpSet_st4, MagHskpSet_st5, MagHskpSet_st6, MagHskpSet_pctemp, MagHskpSet_cmon, MagHskpSet_st1b, MagHskpSet_st2b, MagHskpSet_hk1, MagHskpSet_hk2, MagHskpSet_hk3, MagHskpSet_hk4, MagHskpSet_hk5, MagHskpSet_sync, MagHskpSet_st, MagHskpSet_in_temp, MagHskpSet_out_temp, MagHskpSet_in_pwrlvl, MagHskpSet_out_pwrlvl, MagHskpSet_current, MagHskpSet_SenIntTempPosY, MagHskpSet_SenIntTempNegY, MagHskpSet_MagPowBits")){
    mag_hskp_error("VSsetfields error");
    retval = -1;
  }
  return(retval);
}

/****** write function ******/

int32 write_mag_hskp(struct MagHskpSet MagHskpSet_struc)
{
int32 retval = 0;
uint8 *odata;

void pack_mag_hskp();

  odata = (uint8 *) malloc(sizeof(struct MagHskpSet));
  pack_mag_hskp(odata, &MagHskpSet_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing MAG HSKP data\n");
  } 
  memset(&MagHskpSet_struc, 0, sizeof(struct MagHskpSet));
  free(odata);
  return(retval);
}

void close_wr_mag_hskp() {
  VSdetach(vdata_id_w);
}

/*     init read function    */

int32 init_rd_mag_hskp(int32 hdf_fp, int32 sd_id)
{
  int32 vdata_ref;
  int32 retval=0;

  void mag_hskp_error();


  if ((vdata_ref = VSfind(hdf_fp, "mag_hskp"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"MagHskpSet_sctime, MagHskpSet_QAC, MagHskpSet_st1a, MagHskpSet_st2a, MagHskpSet_st3, MagHskpSet_st4, MagHskpSet_st5, MagHskpSet_st6, MagHskpSet_pctemp, MagHskpSet_cmon, MagHskpSet_st1b, MagHskpSet_st2b, MagHskpSet_hk1, MagHskpSet_hk2, MagHskpSet_hk3, MagHskpSet_hk4, MagHskpSet_hk5, MagHskpSet_sync, MagHskpSet_st, MagHskpSet_in_temp, MagHskpSet_out_temp, MagHskpSet_in_pwrlvl, MagHskpSet_out_pwrlvl, MagHskpSet_current, MagHskpSet_SenIntTempPosY, MagHskpSet_SenIntTempNegY, MagHskpSet_MagPowBits")) {
    mag_hskp_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_mag_hskp(struct MagHskpSet *MagHskpSet_struc, int32 recnum_rd)
{
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_mag_hskp();

  odata = (uint8 *) malloc(sizeof(struct MagHskpSet));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_mag_hskp(odata, MagHskpSet_struc);
  return(retval);
}

void mag_hskp_error(int8 *mess)
  { fprintf(stderr,"MAG HSKP: %s\n",mess); }

void close_rd_mag_hskp() {
  VSdetach(vdata_id_r);
}
/*   pack function    */

void pack_mag_hskp(uint8 *data, struct MagHskpSet *MagHskpSet_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &MagHskpSet_ptr->sctime, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->QAC, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->st1a, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->st2a, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->st3, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->st4, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->st5, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->st6, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->pctemp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->cmon, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->st1b, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->st2b, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->hk1, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->hk2, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->hk3, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->hk4, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->hk5, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->sync, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->st, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->in_temp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->out_temp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->in_pwrlvl, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->out_pwrlvl, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->current, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->SenIntTempPosY, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->SenIntTempNegY, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &MagHskpSet_ptr->MagPowBits, ((1)*(1)) );
   ptr+= ((1)*(1));
}

/*   unpack function    */

void unpack_mag_hskp(uint8 *data, struct MagHskpSet *MagHskpSet_ptr)
{
int32 ptr=0;

   memcpy(&MagHskpSet_ptr->sctime, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&MagHskpSet_ptr->QAC, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&MagHskpSet_ptr->st1a, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->st2a, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->st3, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->st4, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->st5, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->st6, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->pctemp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->cmon, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->st1b, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->st2b, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->hk1, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->hk2, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->hk3, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->hk4, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->hk5, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->sync, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->st, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&MagHskpSet_ptr->in_temp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->out_temp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->in_pwrlvl, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->out_pwrlvl, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->current, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->SenIntTempPosY, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->SenIntTempNegY, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&MagHskpSet_ptr->MagPowBits, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
}
