/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.20 1997/03/19 17:58:31 steves Exp $ */

/* The include file used to create this file is: */
/* $Id: mag_fft.h,v 1.6 1997/03/21 18:42:16 jeff Exp $ */

#include "mag_fft.h"
#include "mfhdf.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w;
static int32 sds_id_r1, sds_id_w1, sds_id_r2, sds_id_w2;


/****  init write function  ****/

int32 init_wr_mag_fft(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  int32 dim_sizes[3];
  int32 rank;

  void mag_fft_error();

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "mag_fft");
  VSsetclass(vdata_id_w, classname);

   if (VSfdefine(vdata_id_w, "MagFFTSet_sctime", DFNT_UINT32, (1) )) {
     mag_fft_error("VSfdefine MagFFTSet_sctime error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MagFFTSet_QAC", DFNT_UINT32, (1) )) {
     mag_fft_error("VSfdefine MagFFTSet_QAC error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"MagFFTSet_sctime, MagFFTSet_QAC")){
    mag_fft_error("VSsetfields error");
    retval = -1;
  }
  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = MJ_FFT_CYC;
  if((sds_id_w1=SDcreate(sd_id, "MagFFTSet_fft_statbits", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create MagFFTSet_fft_statbits \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = 10;
  dim_sizes[2] = FFTBIN;
  if((sds_id_w2=SDcreate(sd_id, "MagFFTSet_fft_val", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create MagFFTSet_fft_val \n");

  return(retval);
}

/****** write function ******/

int32 write_mag_fft(struct MagFFTSet MagFFTSet_struc)
{
int32 start[3], edges[3];
int32 retval = 0;
uint8 *odata;
static int32 recnum_wr=0;

void pack_mag_fft();

  odata = (uint8 *) malloc(sizeof(struct MagFFTSet));
  pack_mag_fft(odata, &MagFFTSet_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing MAG FFT data\n");
  } 
  start[0] = recnum_wr++;
  start[1] = 0;
  start[2] = 0;
  edges[0] = 1;

  edges[1] = MJ_FFT_CYC;
  if (SDwritedata(sds_id_w1,start,NULL,edges,(VOIDP) (MagFFTSet_struc.fft_statbits ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing fft_statbits data.\n");
  }
  edges[1] = 10;
  edges[2] = FFTBIN;
  if (SDwritedata(sds_id_w2,start,NULL,edges,(VOIDP) (MagFFTSet_struc.fft_val ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing fft_val data.\n");
  }
  memset(&MagFFTSet_struc, 0, sizeof(struct MagFFTSet));
  free(odata);
  return(retval);
}

void close_wr_mag_fft() {
  VSdetach(vdata_id_w);
  SDendaccess(sds_id_w1);
  SDendaccess(sds_id_w2);
}

/*     init read function    */

int32 init_rd_mag_fft(int32 hdf_fp, int32 sd_id)
{
  static int32 sds_index1;
  static int32 sds_index2;
  int32 vdata_ref;
  int32 retval=0;

  void mag_fft_error();

    if((sds_index1=SDnametoindex(sd_id, "MagFFTSet_fft_statbits" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find MagFFTSet_fft_statbits\n");
      retval = -1;
    }
    if((sds_id_r1=SDselect(sd_id, sds_index1))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index1\n");
      retval = -1;
    }
    if((sds_index2=SDnametoindex(sd_id, "MagFFTSet_fft_val" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find MagFFTSet_fft_val\n");
      retval = -1;
    }
    if((sds_id_r2=SDselect(sd_id, sds_index2))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index2\n");
      retval = -1;
    }

  if ((vdata_ref = VSfind(hdf_fp, "mag_fft"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"MagFFTSet_sctime, MagFFTSet_QAC")) {
    mag_fft_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_mag_fft(struct MagFFTSet *MagFFTSet_struc, int32 recnum_rd)
{
int32 start[3], edges[3];
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_mag_fft();

  start[0] = recnum_rd;
  start[1] = 0;
  start[2] = 0;
  edges[0] = 1;

  odata = (uint8 *) malloc(sizeof(struct MagFFTSet));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  edges[1] = MJ_FFT_CYC;
  if(SDreaddata(sds_id_r1,start,NULL,edges, (VOIDP)(MagFFTSet_struc->fft_statbits ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read fft_statbits\n");
    retval = -1;
  }
  edges[1] = 10;
  edges[2] = FFTBIN;
  if(SDreaddata(sds_id_r2,start,NULL,edges, (VOIDP)(MagFFTSet_struc->fft_val ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read fft_val\n");
    retval = -1;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_mag_fft(odata, MagFFTSet_struc);
  return(retval);
}

void mag_fft_error(int8 *mess)
  { fprintf(stderr,"MAG FFT: %s\n",mess); }

void close_rd_mag_fft() {
  VSdetach(vdata_id_r);
  SDendaccess(sds_id_r1);
  SDendaccess(sds_id_r2);
}
/*   pack function    */

void pack_mag_fft(uint8 *data, struct MagFFTSet *MagFFTSet_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &MagFFTSet_ptr->sctime, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &MagFFTSet_ptr->QAC, ((4)*(1)) );
   ptr+= ((4)*(1));
}

/*   unpack function    */

void unpack_mag_fft(uint8 *data, struct MagFFTSet *MagFFTSet_ptr)
{
int32 ptr=0;

   memcpy(&MagFFTSet_ptr->sctime, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&MagFFTSet_ptr->QAC, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
}
