#include <stdio.h>
#include <string.h>

#include "s3_cpha.h"
#include "df.h"

void main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp, SD_id;
  struct cpha testdata;
  int ii,jj,kk,retval;

  if (argc!=2)
    {
      printf("Usage: %s hdf_file\n",argv[0]);
      exit(1);
    }

  /* open hdf input file */

  if ((hdf_fp=Hopen(argv[1], DFACC_READ, 0))==FAIL)
    {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
    }
  Vstart(hdf_fp);
  if ((SD_id=SDstart(argv[1], DFACC_RDONLY))==FAIL)
    {
      fprintf(stderr, "SDstart: could not open hdf file\n");
      exit(-1);
    }

  init_rd_s3_cpha(hdf_fp, SD_id);

  /* read and print data */
  ii=0;
  while((retval=read_s3_cpha(&testdata,ii))!=-1) {
    printf("ii=%4d %10u %3d %3d %4d\n", 
	    ii++, testdata.sctime_readout, testdata.QAC,
	    testdata.concat,testdata.elements);
    printf("Rg Sec  Energy  Time\n");
    for(jj=0;jj<10;jj++) { 
       printf("%2d %2d %6d %6d \n",
       testdata.range[jj][0],testdata.sector[jj][0],
       testdata.energy[jj][0],testdata.time[jj][0]);
    }
   printf("\n");
  }

  /* all done, close HDF interface */

  close_rd_s3_cpha();
  Vend(hdf_fp);
  SDend(SD_id);
  if (Hclose(hdf_fp)==FAIL)
    {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
    }
  exit(0);
}
    
