/* $Id: swepam_ical.h,v 1.4 1997/05/07 22:45:05 jeff Exp $ */
#include "hdfi.h"

struct CALI               /* CALI Data Mode */
{
  uint32 output_sctime;   /* time for beginning of data output cycle */
  uint32 collect_sctime;  /* time for beginning of data collection */
  uint8  QAC;              /* number of bad frames in this cycle */
  
  /* Major Frame Header */
  uint8  SCid[4];         /* SubCom ID */
  uint8  FmtFC[4];        /* Frame Format Count */
  uint8  FmtID[4];        /* Format ID */
  uint8  EF[4];           /* Event Flag */
  uint16 CS[4];           /* subcom Configuration Status */
  uint8  DB[4];           /* DataBase paramter */

  /* Data set header */
  uint8 PhiLim;            /* Current sensor limit */
  uint8 DQAlarm;            /* Data Quality alarm */
  uint8 CEMLev;            /* CEM level */
  uint8 Lmx;               /* ESA lvl with max count rate.0-199.255=invalid*/


  /* spectral segment headers */
  uint8 RLmxs[5];          /* Rel ESA lvl with max rate in Spec seg s */
  uint8 DCLmxs[5];          /* Data Channel of Lmxs */
  uint8 PhiLmxs[5];          /* Phi of Lmxs */

  uint8 DiscThld[5][27][2][16]; 
};
