/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.21 1997/05/07 21:31:18 steves Exp $ */

/* The include file used to create this file is: */
/* $Id: uleis_statblk_trl.h,v 1.6 1997/04/10 22:21:35 steves Exp $ */

#include "uleis_statblk_trl.h"
#include "mfhdf.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w, vgrp_id;
static int32 sds_id_r1, sds_id_w1;


/****  init write function  ****/

int32 init_wr_uleis_statblk_trl(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  int32 dim_sizes[3];
  int32 rank;

  void uleis_statblk_trl_error();

  vgrp_id = Vattach(hdf_fp, -1, "w");
    Vsetname(vgrp_id, "NVgrpuleis_statblk_trl");
    Vsetclass(vgrp_id, "CVgrpuleis_statblk_trl");

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "UStatBlkTrlSet");
  VSsetclass(vdata_id_w, classname);

Vinsert(vgrp_id, vdata_id_w);

   if (VSfdefine(vdata_id_w, "output_sctime", DFNT_UINT32, (1) )) {
     uleis_statblk_trl_error("VSfdefine output_sctime error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "collect_sctime", DFNT_UINT32, (1) )) {
     uleis_statblk_trl_error("VSfdefine collect_sctime error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "QAC", DFNT_UINT32, (1) )) {
     uleis_statblk_trl_error("VSfdefine QAC error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Sync", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Sync error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SoftwareID", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine SoftwareID error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MinFrCnt", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine MinFrCnt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "CmdAccCnt", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine CmdAccCnt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "CmdRejCnt", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine CmdRejCnt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "CmdEcho", DFNT_UINT32, (1) )) {
     uleis_statblk_trl_error("VSfdefine CmdEcho error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "RejCmdEcho", DFNT_UINT32, (1) )) {
     uleis_statblk_trl_error("VSfdefine RejCmdEcho error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "CmdSide1IntrCnt", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine CmdSide1IntrCnt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "CmdSide2IntrCnt", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine CmdSide2IntrCnt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "CodePagNum", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine CodePagNum error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SunSectrID", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine SunSectrID error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SpinCntReg", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine SpinCntReg error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "WatchdogCnt", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine WatchdogCnt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "RamPag1TestRslts", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine RamPag1TestRslts error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "RamPag2TestRslts", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine RamPag2TestRslts error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "EEPROMCksum", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine EEPROMCksum error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "TimerIntrCnt", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine TimerIntrCnt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "CurTLMSide", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine CurTLMSide error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "DefTLMSide", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine DefTLMSide error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MemPekVal", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine MemPekVal error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MemPekPagNum", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine MemPekPagNum error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MemPekAddr", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine MemPekAddr error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MemPokVal", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine MemPokVal error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MemPokPagNum", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine MemPokPagNum error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MemPokAddr", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine MemPokAddr error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MemDmpPagNum", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine MemDmpPagNum error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MemDmpAddrPntr", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine MemDmpAddrPntr error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "OutputPort0PokVal", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine OutputPort0PokVal error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "OutputPort1PokVal", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine OutputPort1PokVal error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "OutputPort2PokVal", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine OutputPort2PokVal error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "OutputPort6PokVal", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine OutputPort6PokVal error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "InputPort0Val", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine InputPort0Val error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "InputPort1Val", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine InputPort1Val error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "InputPort2Val", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine InputPort2Val error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "InputPort6Val", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine InputPort6Val error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "EEPROMPag3Stat", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine EEPROMPag3Stat error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "EEPROMPag67Stat", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine EEPROMPag67Stat error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "CtrlWord2CmdStat", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine CtrlWord2CmdStat error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MemLdSiz", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine MemLdSiz error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MemLdPag", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine MemLdPag error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MemLdAddr", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine MemLdAddr error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MemLdCksum", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine MemLdCksum error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MemLdComCksum", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine MemLdComCksum error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MemLdCksumErrCnt", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine MemLdCksumErrCnt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "AECmdErrCnt", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine AECmdErrCnt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "AECmdIntrCnt", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine AECmdIntrCnt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MajFrCntx8", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine MajFrCntx8 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Spn1SpnCnt", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Spn1SpnCnt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Spn2SpnCnt", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Spn2SpnCnt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Spn3SpnCnt", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Spn3SpnCnt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Spn4SpnCnt", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Spn4SpnCnt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Spn5SpnCnt", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Spn5SpnCnt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Spn6SpnCnt", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Spn6SpnCnt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Spn7SpnCnt", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Spn7SpnCnt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Spn8SpnCnt", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Spn8SpnCnt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Spn9SpnCnt", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Spn9SpnCnt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Spn10SpnCnt", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Spn10SpnCnt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "CumSpnCnt", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine CumSpnCnt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "EvntCnt", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine EvntCnt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Spn1MinFrCnt", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Spn1MinFrCnt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "HVAutFlg", DFNT_UINT8, (1) )) {
     uleis_statblk_trl_error("VSfdefine HVAutFlg error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "HVActFlg", DFNT_UINT8, (1) )) {
     uleis_statblk_trl_error("VSfdefine HVActFlg error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PHAFrzFlg", DFNT_UINT8, (1) )) {
     uleis_statblk_trl_error("VSfdefine PHAFrzFlg error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SSDEnaFlg", DFNT_UINT8, (1) )) {
     uleis_statblk_trl_error("VSfdefine SSDEnaFlg error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "AEAutoResetEnaFlg", DFNT_UINT8, (1) )) {
     uleis_statblk_trl_error("VSfdefine AEAutoResetEnaFlg error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "CalModFlg", DFNT_UINT8, (1) )) {
     uleis_statblk_trl_error("VSfdefine CalModFlg error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "TOFFlg", DFNT_UINT8, (1) )) {
     uleis_statblk_trl_error("VSfdefine TOFFlg error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "AETlltlBits", DFNT_UINT8, (1) )) {
     uleis_statblk_trl_error("VSfdefine AETlltlBits error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MotrAutFlg", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine MotrAutFlg error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MotrPwrFlg", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine MotrPwrFlg error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MotrPostn", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine MotrPostn error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Rt1MinSectr", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Rt1MinSectr error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Rt1MinSpn", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Rt1MinSpn error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Rt1HiSecErrLim", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Rt1HiSecErrLim error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Rt1LoSecErrLim", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Rt1LoSecErrLim error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Rt1HiSpnErrLim", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Rt1HiSpnErrLim error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Rt1LoSpnErrLim", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Rt1LoSpnErrLim error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Rt1Indx", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Rt1Indx error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Rt2MinSectr", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Rt2MinSectr error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Rt2MinSpn", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Rt2MinSpn error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Rt2HiSecErrLim", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Rt2HiSecErrLim error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Rt2LoSecErrLim", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Rt2LoSecErrLim error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Rt2HiSpnErrLim", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Rt2HiSpnErrLim error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Rt2LoSpnErrLim", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Rt2LoSpnErrLim error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "Rt2Indx", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine Rt2Indx error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MtrErrFlg", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine MtrErrFlg error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MtrMotnFlg", DFNT_UINT8, (1) )) {
     uleis_statblk_trl_error("VSfdefine MtrMotnFlg error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "EvntRdoutFmt", DFNT_UINT8, (1) )) {
     uleis_statblk_trl_error("VSfdefine EvntRdoutFmt error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "MUXSelMd", DFNT_UINT8, (1) )) {
     uleis_statblk_trl_error("VSfdefine MUXSelMd error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "VS1Enab", DFNT_UINT8, (1) )) {
     uleis_statblk_trl_error("VSfdefine VS1Enab error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "VS2Enab", DFNT_UINT8, (1) )) {
     uleis_statblk_trl_error("VSfdefine VS2Enab error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "VS1VS2Enab", DFNT_UINT8, (1) )) {
     uleis_statblk_trl_error("VSfdefine VS1VS2Enab error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PHARnkSpn1Sec1", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine PHARnkSpn1Sec1 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PHARnkSpn1Sec2", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine PHARnkSpn1Sec2 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PHARnkSpn1Sec3", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine PHARnkSpn1Sec3 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PHARnkSpn1Sec4", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine PHARnkSpn1Sec4 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PHARnkSpn1Sec5", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine PHARnkSpn1Sec5 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PHARnkSpn1Sec6", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine PHARnkSpn1Sec6 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PHARnkSpn1Sec7", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine PHARnkSpn1Sec7 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PHARnkSpn1Sec8", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine PHARnkSpn1Sec8 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SciRecCksum", DFNT_UINT16, (1) )) {
     uleis_statblk_trl_error("VSfdefine SciRecCksum error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"output_sctime, collect_sctime, QAC, Sync, SoftwareID, MinFrCnt, CmdAccCnt, CmdRejCnt, CmdEcho, RejCmdEcho, CmdSide1IntrCnt, CmdSide2IntrCnt, CodePagNum, SunSectrID, SpinCntReg, WatchdogCnt, RamPag1TestRslts, RamPag2TestRslts, EEPROMCksum, TimerIntrCnt, CurTLMSide, DefTLMSide, MemPekVal, MemPekPagNum, MemPekAddr, MemPokVal, MemPokPagNum, MemPokAddr, MemDmpPagNum, MemDmpAddrPntr, OutputPort0PokVal, OutputPort1PokVal, OutputPort2PokVal, OutputPort6PokVal, InputPort0Val, InputPort1Val, InputPort2Val, InputPort6Val, EEPROMPag3Stat, EEPROMPag67Stat, CtrlWord2CmdStat, MemLdSiz, MemLdPag, MemLdAddr, MemLdCksum, MemLdComCksum, MemLdCksumErrCnt, AECmdErrCnt, AECmdIntrCnt, MajFrCntx8, Spn1SpnCnt, Spn2SpnCnt, Spn3SpnCnt, Spn4SpnCnt, Spn5SpnCnt, Spn6SpnCnt, Spn7SpnCnt, Spn8SpnCnt, Spn9SpnCnt, Spn10SpnCnt, CumSpnCnt, EvntCnt, Spn1MinFrCnt, HVAutFlg, HVActFlg, PHAFrzFlg, SSDEnaFlg, AEAutoResetEnaFlg, CalModFlg, TOFFlg, AETlltlBits, MotrAutFlg, MotrPwrFlg, MotrPostn, Rt1MinSectr, Rt1MinSpn, Rt1HiSecErrLim, Rt1LoSecErrLim, Rt1HiSpnErrLim, Rt1LoSpnErrLim, Rt1Indx, Rt2MinSectr, Rt2MinSpn, Rt2HiSecErrLim, Rt2LoSecErrLim, Rt2HiSpnErrLim, Rt2LoSpnErrLim, Rt2Indx, MtrErrFlg, MtrMotnFlg, EvntRdoutFmt, MUXSelMd, VS1Enab, VS2Enab, VS1VS2Enab, PHARnkSpn1Sec1, PHARnkSpn1Sec2, PHARnkSpn1Sec3, PHARnkSpn1Sec4, PHARnkSpn1Sec5, PHARnkSpn1Sec6, PHARnkSpn1Sec7, PHARnkSpn1Sec8, SciRecCksum")){
    uleis_statblk_trl_error("VSsetfields error");
    retval = -1;
  }
  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = 16;
  dim_sizes[2] = 3;
  if((sds_id_w1=SDcreate(sd_id, "UStatBlkTrlSet_HK_ADC", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create UStatBlkTrlSet_HK_ADC \n");

  return(retval);
}

/****** write function ******/

int32 write_uleis_statblk_trl(struct UStatBlkTrlSet UStatBlkTrlSet_struc)
{
int32 start[3], edges[3];
int32 retval = 0;
uint8 *odata;
static int32 recnum_wr=0;

void pack_uleis_statblk_trl();

  odata = (uint8 *) malloc(sizeof(struct UStatBlkTrlSet));
  pack_uleis_statblk_trl(odata, &UStatBlkTrlSet_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing ULEIS STATBLK TRL data\n");
  } 
  start[0] = recnum_wr++;
  start[1] = 0;
  start[2] = 0;
  edges[0] = 1;

  edges[1] = 16;
  edges[2] = 3;
  if (SDwritedata(sds_id_w1,start,NULL,edges,(VOIDP) (UStatBlkTrlSet_struc.HK_ADC ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing HK_ADC data.\n");
  }
  memset(&UStatBlkTrlSet_struc, 0, sizeof(struct UStatBlkTrlSet));
  free(odata);
  return(retval);
}

void close_wr_uleis_statblk_trl() {
  VSdetach(vdata_id_w);
  Vdetach(vgrp_id);
  SDendaccess(sds_id_w1);
}

/*     init read function    */

int32 init_rd_uleis_statblk_trl(int32 hdf_fp, int32 sd_id)
{
  static int32 sds_index1;
  int32 vdata_ref;
  int32 retval=0;

  void uleis_statblk_trl_error();

    if((sds_index1=SDnametoindex(sd_id, "UStatBlkTrlSet_HK_ADC" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find UStatBlkTrlSet_HK_ADC\n");
      retval = -1;
    }
    if((sds_id_r1=SDselect(sd_id, sds_index1))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index1\n");
      retval = -1;
    }

  if ((vdata_ref = VSfind(hdf_fp, "UStatBlkTrlSet"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"output_sctime, collect_sctime, QAC, Sync, SoftwareID, MinFrCnt, CmdAccCnt, CmdRejCnt, CmdEcho, RejCmdEcho, CmdSide1IntrCnt, CmdSide2IntrCnt, CodePagNum, SunSectrID, SpinCntReg, WatchdogCnt, RamPag1TestRslts, RamPag2TestRslts, EEPROMCksum, TimerIntrCnt, CurTLMSide, DefTLMSide, MemPekVal, MemPekPagNum, MemPekAddr, MemPokVal, MemPokPagNum, MemPokAddr, MemDmpPagNum, MemDmpAddrPntr, OutputPort0PokVal, OutputPort1PokVal, OutputPort2PokVal, OutputPort6PokVal, InputPort0Val, InputPort1Val, InputPort2Val, InputPort6Val, EEPROMPag3Stat, EEPROMPag67Stat, CtrlWord2CmdStat, MemLdSiz, MemLdPag, MemLdAddr, MemLdCksum, MemLdComCksum, MemLdCksumErrCnt, AECmdErrCnt, AECmdIntrCnt, MajFrCntx8, Spn1SpnCnt, Spn2SpnCnt, Spn3SpnCnt, Spn4SpnCnt, Spn5SpnCnt, Spn6SpnCnt, Spn7SpnCnt, Spn8SpnCnt, Spn9SpnCnt, Spn10SpnCnt, CumSpnCnt, EvntCnt, Spn1MinFrCnt, HVAutFlg, HVActFlg, PHAFrzFlg, SSDEnaFlg, AEAutoResetEnaFlg, CalModFlg, TOFFlg, AETlltlBits, MotrAutFlg, MotrPwrFlg, MotrPostn, Rt1MinSectr, Rt1MinSpn, Rt1HiSecErrLim, Rt1LoSecErrLim, Rt1HiSpnErrLim, Rt1LoSpnErrLim, Rt1Indx, Rt2MinSectr, Rt2MinSpn, Rt2HiSecErrLim, Rt2LoSecErrLim, Rt2HiSpnErrLim, Rt2LoSpnErrLim, Rt2Indx, MtrErrFlg, MtrMotnFlg, EvntRdoutFmt, MUXSelMd, VS1Enab, VS2Enab, VS1VS2Enab, PHARnkSpn1Sec1, PHARnkSpn1Sec2, PHARnkSpn1Sec3, PHARnkSpn1Sec4, PHARnkSpn1Sec5, PHARnkSpn1Sec6, PHARnkSpn1Sec7, PHARnkSpn1Sec8, SciRecCksum")) {
    uleis_statblk_trl_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_uleis_statblk_trl(struct UStatBlkTrlSet *UStatBlkTrlSet_struc, int32 recnum_rd)
{
int32 start[3], edges[3];
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_uleis_statblk_trl();

  start[0] = recnum_rd;
  start[1] = 0;
  start[2] = 0;
  edges[0] = 1;

  odata = (uint8 *) malloc(sizeof(struct UStatBlkTrlSet));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  edges[1] = 16;
  edges[2] = 3;
  if(SDreaddata(sds_id_r1,start,NULL,edges, (VOIDP)(UStatBlkTrlSet_struc->HK_ADC ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read HK_ADC\n");
    retval = -1;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_uleis_statblk_trl(odata, UStatBlkTrlSet_struc);
  free(odata);
  return(retval);
}

void uleis_statblk_trl_error(int8 *mess)
  { fprintf(stderr,"ULEIS STATBLK TRL: %s\n",mess); }

void close_rd_uleis_statblk_trl() {
  VSdetach(vdata_id_r);
  SDendaccess(sds_id_r1);
}
/*   pack function    */

void pack_uleis_statblk_trl(uint8 *data, struct UStatBlkTrlSet *UStatBlkTrlSet_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &UStatBlkTrlSet_ptr->output_sctime, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->collect_sctime, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->QAC, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Sync, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->SoftwareID, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->MinFrCnt, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->CmdAccCnt, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->CmdRejCnt, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->CmdEcho, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->RejCmdEcho, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->CmdSide1IntrCnt, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->CmdSide2IntrCnt, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->CodePagNum, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->SunSectrID, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->SpinCntReg, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->WatchdogCnt, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->RamPag1TestRslts, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->RamPag2TestRslts, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->EEPROMCksum, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->TimerIntrCnt, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->CurTLMSide, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->DefTLMSide, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->MemPekVal, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->MemPekPagNum, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->MemPekAddr, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->MemPokVal, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->MemPokPagNum, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->MemPokAddr, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->MemDmpPagNum, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->MemDmpAddrPntr, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->OutputPort0PokVal, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->OutputPort1PokVal, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->OutputPort2PokVal, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->OutputPort6PokVal, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->InputPort0Val, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->InputPort1Val, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->InputPort2Val, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->InputPort6Val, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->EEPROMPag3Stat, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->EEPROMPag67Stat, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->CtrlWord2CmdStat, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->MemLdSiz, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->MemLdPag, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->MemLdAddr, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->MemLdCksum, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->MemLdComCksum, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->MemLdCksumErrCnt, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->AECmdErrCnt, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->AECmdIntrCnt, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->MajFrCntx8, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Spn1SpnCnt, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Spn2SpnCnt, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Spn3SpnCnt, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Spn4SpnCnt, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Spn5SpnCnt, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Spn6SpnCnt, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Spn7SpnCnt, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Spn8SpnCnt, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Spn9SpnCnt, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Spn10SpnCnt, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->CumSpnCnt, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->EvntCnt, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Spn1MinFrCnt, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->HVAutFlg, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->HVActFlg, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->PHAFrzFlg, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->SSDEnaFlg, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->AEAutoResetEnaFlg, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->CalModFlg, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->TOFFlg, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->AETlltlBits, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->MotrAutFlg, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->MotrPwrFlg, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->MotrPostn, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Rt1MinSectr, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Rt1MinSpn, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Rt1HiSecErrLim, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Rt1LoSecErrLim, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Rt1HiSpnErrLim, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Rt1LoSpnErrLim, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Rt1Indx, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Rt2MinSectr, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Rt2MinSpn, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Rt2HiSecErrLim, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Rt2LoSecErrLim, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Rt2HiSpnErrLim, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Rt2LoSpnErrLim, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->Rt2Indx, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->MtrErrFlg, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->MtrMotnFlg, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->EvntRdoutFmt, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->MUXSelMd, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->VS1Enab, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->VS2Enab, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->VS1VS2Enab, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->PHARnkSpn1Sec1, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->PHARnkSpn1Sec2, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->PHARnkSpn1Sec3, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->PHARnkSpn1Sec4, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->PHARnkSpn1Sec5, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->PHARnkSpn1Sec6, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->PHARnkSpn1Sec7, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->PHARnkSpn1Sec8, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &UStatBlkTrlSet_ptr->SciRecCksum, ((2)*(1)) );
   ptr+= ((2)*(1));
}

/*   unpack function    */

void unpack_uleis_statblk_trl(uint8 *data, struct UStatBlkTrlSet *UStatBlkTrlSet_ptr)
{
int32 ptr=0;

   memcpy(&UStatBlkTrlSet_ptr->output_sctime, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&UStatBlkTrlSet_ptr->collect_sctime, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&UStatBlkTrlSet_ptr->QAC, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Sync, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->SoftwareID, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->MinFrCnt, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->CmdAccCnt, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->CmdRejCnt, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->CmdEcho, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&UStatBlkTrlSet_ptr->RejCmdEcho, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&UStatBlkTrlSet_ptr->CmdSide1IntrCnt, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->CmdSide2IntrCnt, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->CodePagNum, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->SunSectrID, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->SpinCntReg, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->WatchdogCnt, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->RamPag1TestRslts, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->RamPag2TestRslts, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->EEPROMCksum, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->TimerIntrCnt, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->CurTLMSide, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->DefTLMSide, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->MemPekVal, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->MemPekPagNum, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->MemPekAddr, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->MemPokVal, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->MemPokPagNum, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->MemPokAddr, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->MemDmpPagNum, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->MemDmpAddrPntr, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->OutputPort0PokVal, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->OutputPort1PokVal, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->OutputPort2PokVal, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->OutputPort6PokVal, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->InputPort0Val, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->InputPort1Val, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->InputPort2Val, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->InputPort6Val, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->EEPROMPag3Stat, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->EEPROMPag67Stat, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->CtrlWord2CmdStat, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->MemLdSiz, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->MemLdPag, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->MemLdAddr, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->MemLdCksum, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->MemLdComCksum, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->MemLdCksumErrCnt, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->AECmdErrCnt, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->AECmdIntrCnt, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->MajFrCntx8, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Spn1SpnCnt, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Spn2SpnCnt, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Spn3SpnCnt, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Spn4SpnCnt, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Spn5SpnCnt, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Spn6SpnCnt, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Spn7SpnCnt, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Spn8SpnCnt, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Spn9SpnCnt, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Spn10SpnCnt, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->CumSpnCnt, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->EvntCnt, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Spn1MinFrCnt, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->HVAutFlg, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&UStatBlkTrlSet_ptr->HVActFlg, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&UStatBlkTrlSet_ptr->PHAFrzFlg, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&UStatBlkTrlSet_ptr->SSDEnaFlg, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&UStatBlkTrlSet_ptr->AEAutoResetEnaFlg, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&UStatBlkTrlSet_ptr->CalModFlg, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&UStatBlkTrlSet_ptr->TOFFlg, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&UStatBlkTrlSet_ptr->AETlltlBits, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&UStatBlkTrlSet_ptr->MotrAutFlg, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->MotrPwrFlg, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->MotrPostn, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Rt1MinSectr, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Rt1MinSpn, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Rt1HiSecErrLim, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Rt1LoSecErrLim, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Rt1HiSpnErrLim, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Rt1LoSpnErrLim, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Rt1Indx, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Rt2MinSectr, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Rt2MinSpn, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Rt2HiSecErrLim, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Rt2LoSecErrLim, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Rt2HiSpnErrLim, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Rt2LoSpnErrLim, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->Rt2Indx, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->MtrErrFlg, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->MtrMotnFlg, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&UStatBlkTrlSet_ptr->EvntRdoutFmt, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&UStatBlkTrlSet_ptr->MUXSelMd, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&UStatBlkTrlSet_ptr->VS1Enab, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&UStatBlkTrlSet_ptr->VS2Enab, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&UStatBlkTrlSet_ptr->VS1VS2Enab, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&UStatBlkTrlSet_ptr->PHARnkSpn1Sec1, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->PHARnkSpn1Sec2, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->PHARnkSpn1Sec3, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->PHARnkSpn1Sec4, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->PHARnkSpn1Sec5, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->PHARnkSpn1Sec6, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->PHARnkSpn1Sec7, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->PHARnkSpn1Sec8, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&UStatBlkTrlSet_ptr->SciRecCksum, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
}
