/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.21 1997/05/07 21:31:18 steves Exp $ */

/* The include file used to create this file is: */
/*$Id: uleis_stat_tlm.h,v 1.4 1997/05/09 22:05:53 steves Exp $*/

#include "uleis_stat_tlm.h"
#include "mfhdf.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w, vgrp_id;
static int32 sds_id_r1, sds_id_w1;


/****  init write function  ****/

int32 init_wr_uleis_stat_tlm(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  int32 dim_sizes[2];
  int32 rank;

  void uleis_stat_tlm_error();

  vgrp_id = Vattach(hdf_fp, -1, "w");
    Vsetname(vgrp_id, "NVgrpuleis_stat_tlm");
    Vsetclass(vgrp_id, "CVgrpuleis_stat_tlm");

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "UStatTLMSet");
  VSsetclass(vdata_id_w, classname);

Vinsert(vgrp_id, vdata_id_w);

   if (VSfdefine(vdata_id_w, "output_sctime", DFNT_UINT32, (1) )) {
     uleis_stat_tlm_error("VSfdefine output_sctime error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "collect_sctime", DFNT_UINT32, (1) )) {
     uleis_stat_tlm_error("VSfdefine collect_sctime error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "QAC", DFNT_UINT32, (1) )) {
     uleis_stat_tlm_error("VSfdefine QAC error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "stattlmtime_offset", DFNT_UINT16, (1) )) {
     uleis_stat_tlm_error("VSfdefine stattlmtime_offset error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"output_sctime, collect_sctime, QAC, stattlmtime_offset")){
    uleis_stat_tlm_error("VSsetfields error");
    retval = -1;
  }
  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = U_STAT_TLM_SIZE;
  if((sds_id_w1=SDcreate(sd_id, "UStatTLMSet_StatusTLM", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create UStatTLMSet_StatusTLM \n");

  return(retval);
}

/****** write function ******/

int32 write_uleis_stat_tlm(struct UStatTLMSet UStatTLMSet_struc)
{
int32 start[2], edges[2];
int32 retval = 0;
uint8 *odata;
static int32 recnum_wr=0;

void pack_uleis_stat_tlm();

  odata = (uint8 *) malloc(sizeof(struct UStatTLMSet));
  pack_uleis_stat_tlm(odata, &UStatTLMSet_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing ULEIS STAT TLM data\n");
  } 
  start[0] = recnum_wr++;
  start[1] = 0;
  edges[0] = 1;

  edges[1] = U_STAT_TLM_SIZE;
  if (SDwritedata(sds_id_w1,start,NULL,edges,(VOIDP) (UStatTLMSet_struc.StatusTLM ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing StatusTLM data.\n");
  }
  memset(&UStatTLMSet_struc, 0, sizeof(struct UStatTLMSet));
  free(odata);
  return(retval);
}

void close_wr_uleis_stat_tlm() {
  VSdetach(vdata_id_w);
  Vdetach(vgrp_id);
  SDendaccess(sds_id_w1);
}

/*     init read function    */

int32 init_rd_uleis_stat_tlm(int32 hdf_fp, int32 sd_id)
{
  static int32 sds_index1;
  int32 vdata_ref;
  int32 retval=0;

  void uleis_stat_tlm_error();

    if((sds_index1=SDnametoindex(sd_id, "UStatTLMSet_StatusTLM" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find UStatTLMSet_StatusTLM\n");
      retval = -1;
    }
    if((sds_id_r1=SDselect(sd_id, sds_index1))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index1\n");
      retval = -1;
    }

  if ((vdata_ref = VSfind(hdf_fp, "UStatTLMSet"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"output_sctime, collect_sctime, QAC, stattlmtime_offset")) {
    uleis_stat_tlm_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_uleis_stat_tlm(struct UStatTLMSet *UStatTLMSet_struc, int32 recnum_rd)
{
int32 start[2], edges[2];
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_uleis_stat_tlm();

  start[0] = recnum_rd;
  start[1] = 0;
  edges[0] = 1;

  odata = (uint8 *) malloc(sizeof(struct UStatTLMSet));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  edges[1] = U_STAT_TLM_SIZE;
  if(SDreaddata(sds_id_r1,start,NULL,edges, (VOIDP)(UStatTLMSet_struc->StatusTLM ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read StatusTLM\n");
    retval = -1;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_uleis_stat_tlm(odata, UStatTLMSet_struc);
  free(odata);
  return(retval);
}

void uleis_stat_tlm_error(int8 *mess)
  { fprintf(stderr,"ULEIS STAT TLM: %s\n",mess); }

void close_rd_uleis_stat_tlm() {
  VSdetach(vdata_id_r);
  SDendaccess(sds_id_r1);
}
/*   pack function    */

void pack_uleis_stat_tlm(uint8 *data, struct UStatTLMSet *UStatTLMSet_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &UStatTLMSet_ptr->output_sctime, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &UStatTLMSet_ptr->collect_sctime, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &UStatTLMSet_ptr->QAC, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &UStatTLMSet_ptr->stattlmtime_offset, ((2)*(1)) );
   ptr+= ((2)*(1));
}

/*   unpack function    */

void unpack_uleis_stat_tlm(uint8 *data, struct UStatTLMSet *UStatTLMSet_ptr)
{
int32 ptr=0;

   memcpy(&UStatTLMSet_ptr->output_sctime, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&UStatTLMSet_ptr->collect_sctime, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&UStatTLMSet_ptr->QAC, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&UStatTLMSet_ptr->stattlmtime_offset, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
}
