/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.21 1997/05/07 21:31:18 steves Exp $ */

/* The include file used to create this file is: */
/* $Id: uleis_rate.h,v 1.5 1997/04/10 22:19:24 steves Exp $ */

#include "uleis_rate.h"
#include "mfhdf.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w, vgrp_id;
static int32 sds_id_r1, sds_id_w1, sds_id_r2, sds_id_w2, sds_id_r3, sds_id_w3;


/****  init write function  ****/

int32 init_wr_uleis_rate(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  int32 dim_sizes[4];
  int32 rank;

  void uleis_rate_error();

  vgrp_id = Vattach(hdf_fp, -1, "w");
    Vsetname(vgrp_id, "NVgrpuleis_rate");
    Vsetclass(vgrp_id, "CVgrpuleis_rate");

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "URateSet");
  VSsetclass(vdata_id_w, classname);

Vinsert(vgrp_id, vdata_id_w);

   if (VSfdefine(vdata_id_w, "output_sctime", DFNT_UINT32, (1) )) {
     uleis_rate_error("VSfdefine output_sctime error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "collect_sctime", DFNT_UINT32, (1) )) {
     uleis_rate_error("VSfdefine collect_sctime error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "QAC", DFNT_UINT32, (1) )) {
     uleis_rate_error("VSfdefine QAC error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"output_sctime, collect_sctime, QAC")){
    uleis_rate_error("VSsetfields error");
    retval = -1;
  }
  dim_sizes[0] = SD_UNLIMITED;
  rank = 4;
  dim_sizes[1] = U_MTRX_RATE_SIZE;
  dim_sizes[2] = U_SPINS;
  dim_sizes[3] = U_SECTRS;
  if((sds_id_w1=SDcreate(sd_id, "URateSet_Matrx", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create URateSet_Matrx \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 4;
  dim_sizes[1] = U_MTRX_PRS_RATE_SIZE;
  dim_sizes[2] = U_SPINPRS;
  dim_sizes[3] = U_SECTRS;
  if((sds_id_w2=SDcreate(sd_id, "URateSet_Matrx_prs", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create URateSet_Matrx_prs \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 4;
  dim_sizes[1] = U_SNGL_RATE_SIZE;
  dim_sizes[2] = U_SPINPRS;
  dim_sizes[3] = U_SECTRS;
  if((sds_id_w3=SDcreate(sd_id, "URateSet_Single", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create URateSet_Single \n");

  return(retval);
}

/****** write function ******/

int32 write_uleis_rate(struct URateSet URateSet_struc)
{
int32 start[4], edges[4];
int32 retval = 0;
uint8 *odata;
static int32 recnum_wr=0;

void pack_uleis_rate();

  odata = (uint8 *) malloc(sizeof(struct URateSet));
  pack_uleis_rate(odata, &URateSet_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing ULEIS RATE data\n");
  } 
  start[0] = recnum_wr++;
  start[1] = 0;
  start[2] = 0;
  start[3] = 0;
  edges[0] = 1;

  edges[1] = U_MTRX_RATE_SIZE;
  edges[2] = U_SPINS;
  edges[3] = U_SECTRS;
  if (SDwritedata(sds_id_w1,start,NULL,edges,(VOIDP) (URateSet_struc.Matrx ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing Matrx data.\n");
  }
  edges[1] = U_MTRX_PRS_RATE_SIZE;
  edges[2] = U_SPINPRS;
  edges[3] = U_SECTRS;
  if (SDwritedata(sds_id_w2,start,NULL,edges,(VOIDP) (URateSet_struc.Matrx_prs ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing Matrx_prs data.\n");
  }
  edges[1] = U_SNGL_RATE_SIZE;
  edges[2] = U_SPINPRS;
  edges[3] = U_SECTRS;
  if (SDwritedata(sds_id_w3,start,NULL,edges,(VOIDP) (URateSet_struc.Single ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing Single data.\n");
  }
  memset(&URateSet_struc, 0, sizeof(struct URateSet));
  free(odata);
  return(retval);
}

void close_wr_uleis_rate() {
  VSdetach(vdata_id_w);
  Vdetach(vgrp_id);
  SDendaccess(sds_id_w1);
  SDendaccess(sds_id_w2);
  SDendaccess(sds_id_w3);
}

/*     init read function    */

int32 init_rd_uleis_rate(int32 hdf_fp, int32 sd_id)
{
  static int32 sds_index1;
  static int32 sds_index2;
  static int32 sds_index3;
  int32 vdata_ref;
  int32 retval=0;

  void uleis_rate_error();

    if((sds_index1=SDnametoindex(sd_id, "URateSet_Matrx" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find URateSet_Matrx\n");
      retval = -1;
    }
    if((sds_id_r1=SDselect(sd_id, sds_index1))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index1\n");
      retval = -1;
    }
    if((sds_index2=SDnametoindex(sd_id, "URateSet_Matrx_prs" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find URateSet_Matrx_prs\n");
      retval = -1;
    }
    if((sds_id_r2=SDselect(sd_id, sds_index2))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index2\n");
      retval = -1;
    }
    if((sds_index3=SDnametoindex(sd_id, "URateSet_Single" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find URateSet_Single\n");
      retval = -1;
    }
    if((sds_id_r3=SDselect(sd_id, sds_index3))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index3\n");
      retval = -1;
    }

  if ((vdata_ref = VSfind(hdf_fp, "URateSet"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"output_sctime, collect_sctime, QAC")) {
    uleis_rate_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_uleis_rate(struct URateSet *URateSet_struc, int32 recnum_rd)
{
int32 start[4], edges[4];
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_uleis_rate();

  start[0] = recnum_rd;
  start[1] = 0;
  start[2] = 0;
  start[3] = 0;
  edges[0] = 1;

  odata = (uint8 *) malloc(sizeof(struct URateSet));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  edges[1] = U_MTRX_RATE_SIZE;
  edges[2] = U_SPINS;
  edges[3] = U_SECTRS;
  if(SDreaddata(sds_id_r1,start,NULL,edges, (VOIDP)(URateSet_struc->Matrx ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read Matrx\n");
    retval = -1;
  }
  edges[1] = U_MTRX_PRS_RATE_SIZE;
  edges[2] = U_SPINPRS;
  edges[3] = U_SECTRS;
  if(SDreaddata(sds_id_r2,start,NULL,edges, (VOIDP)(URateSet_struc->Matrx_prs ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read Matrx_prs\n");
    retval = -1;
  }
  edges[1] = U_SNGL_RATE_SIZE;
  edges[2] = U_SPINPRS;
  edges[3] = U_SECTRS;
  if(SDreaddata(sds_id_r3,start,NULL,edges, (VOIDP)(URateSet_struc->Single ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read Single\n");
    retval = -1;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_uleis_rate(odata, URateSet_struc);
  free(odata);
  return(retval);
}

void uleis_rate_error(int8 *mess)
  { fprintf(stderr,"ULEIS RATE: %s\n",mess); }

void close_rd_uleis_rate() {
  VSdetach(vdata_id_r);
  SDendaccess(sds_id_r1);
  SDendaccess(sds_id_r2);
  SDendaccess(sds_id_r3);
}
/*   pack function    */

void pack_uleis_rate(uint8 *data, struct URateSet *URateSet_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &URateSet_ptr->output_sctime, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &URateSet_ptr->collect_sctime, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &URateSet_ptr->QAC, ((4)*(1)) );
   ptr+= ((4)*(1));
}

/*   unpack function    */

void unpack_uleis_rate(uint8 *data, struct URateSet *URateSet_ptr)
{
int32 ptr=0;

   memcpy(&URateSet_ptr->output_sctime, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&URateSet_ptr->collect_sctime, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&URateSet_ptr->QAC, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
}
