/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.21 1997/05/07 21:31:18 steves Exp $ */

/* The include file used to create this file is: */
/* $Id: uleis_dump.h,v 1.6 1997/05/09 22:04:40 steves Exp $ */

#include "uleis_dump.h"
#include "mfhdf.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w, vgrp_id;
static int32 sds_id_r1, sds_id_w1;


/****  init write function  ****/

int32 init_wr_uleis_dump(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  int32 dim_sizes[2];
  int32 rank;

  void uleis_dump_error();

  vgrp_id = Vattach(hdf_fp, -1, "w");
    Vsetname(vgrp_id, "NVgrpuleis_dump");
    Vsetclass(vgrp_id, "CVgrpuleis_dump");

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "UDumpSet");
  VSsetclass(vdata_id_w, classname);

Vinsert(vgrp_id, vdata_id_w);

   if (VSfdefine(vdata_id_w, "output_sctime", DFNT_UINT32, (1) )) {
     uleis_dump_error("VSfdefine output_sctime error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "collect_sctime", DFNT_UINT32, (1) )) {
     uleis_dump_error("VSfdefine collect_sctime error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "QAC", DFNT_UINT32, (1) )) {
     uleis_dump_error("VSfdefine QAC error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "dumptime_offset", DFNT_UINT16, (1) )) {
     uleis_dump_error("VSfdefine dumptime_offset error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"output_sctime, collect_sctime, QAC, dumptime_offset")){
    uleis_dump_error("VSsetfields error");
    retval = -1;
  }
  dim_sizes[0] = SD_UNLIMITED;
  rank = 2;
  dim_sizes[1] = U_DUMP_SIZE;
  if((sds_id_w1=SDcreate(sd_id, "UDumpSet_dump", DFNT_UINT8, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create UDumpSet_dump \n");

  return(retval);
}

/****** write function ******/

int32 write_uleis_dump(struct UDumpSet UDumpSet_struc)
{
int32 start[2], edges[2];
int32 retval = 0;
uint8 *odata;
static int32 recnum_wr=0;

void pack_uleis_dump();

  odata = (uint8 *) malloc(sizeof(struct UDumpSet));
  pack_uleis_dump(odata, &UDumpSet_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing ULEIS DUMP data\n");
  } 
  start[0] = recnum_wr++;
  start[1] = 0;
  edges[0] = 1;

  edges[1] = U_DUMP_SIZE;
  if (SDwritedata(sds_id_w1,start,NULL,edges,(VOIDP) (UDumpSet_struc.dump ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing dump data.\n");
  }
  memset(&UDumpSet_struc, 0, sizeof(struct UDumpSet));
  free(odata);
  return(retval);
}

void close_wr_uleis_dump() {
  VSdetach(vdata_id_w);
  Vdetach(vgrp_id);
  SDendaccess(sds_id_w1);
}

/*     init read function    */

int32 init_rd_uleis_dump(int32 hdf_fp, int32 sd_id)
{
  static int32 sds_index1;
  int32 vdata_ref;
  int32 retval=0;

  void uleis_dump_error();

    if((sds_index1=SDnametoindex(sd_id, "UDumpSet_dump" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find UDumpSet_dump\n");
      retval = -1;
    }
    if((sds_id_r1=SDselect(sd_id, sds_index1))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index1\n");
      retval = -1;
    }

  if ((vdata_ref = VSfind(hdf_fp, "UDumpSet"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"output_sctime, collect_sctime, QAC, dumptime_offset")) {
    uleis_dump_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_uleis_dump(struct UDumpSet *UDumpSet_struc, int32 recnum_rd)
{
int32 start[2], edges[2];
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_uleis_dump();

  start[0] = recnum_rd;
  start[1] = 0;
  edges[0] = 1;

  odata = (uint8 *) malloc(sizeof(struct UDumpSet));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  edges[1] = U_DUMP_SIZE;
  if(SDreaddata(sds_id_r1,start,NULL,edges, (VOIDP)(UDumpSet_struc->dump ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read dump\n");
    retval = -1;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_uleis_dump(odata, UDumpSet_struc);
  free(odata);
  return(retval);
}

void uleis_dump_error(int8 *mess)
  { fprintf(stderr,"ULEIS DUMP: %s\n",mess); }

void close_rd_uleis_dump() {
  VSdetach(vdata_id_r);
  SDendaccess(sds_id_r1);
}
/*   pack function    */

void pack_uleis_dump(uint8 *data, struct UDumpSet *UDumpSet_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &UDumpSet_ptr->output_sctime, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &UDumpSet_ptr->collect_sctime, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &UDumpSet_ptr->QAC, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &UDumpSet_ptr->dumptime_offset, ((2)*(1)) );
   ptr+= ((2)*(1));
}

/*   unpack function    */

void unpack_uleis_dump(uint8 *data, struct UDumpSet *UDumpSet_ptr)
{
int32 ptr=0;

   memcpy(&UDumpSet_ptr->output_sctime, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&UDumpSet_ptr->collect_sctime, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&UDumpSet_ptr->QAC, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&UDumpSet_ptr->dumptime_offset, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
}
