/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.21 1997/05/07 21:31:18 steves Exp $ */

/* The include file used to create this file is: */
/* $Id: s3_mhk.h,v 1.2 1997/05/06 19:11:02 jeff Exp $ */

#include "s3_mhk.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w, vgrp_id;

/****  init write function  ****/

int32 init_wr_s3_mhk(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  void s3_mhk_error();

  vgrp_id = Vattach(hdf_fp, -1, "w");
    Vsetname(vgrp_id, "NVgrps3_mhk");
    Vsetclass(vgrp_id, "CVgrps3_mhk");

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "ssmhk");
  VSsetclass(vdata_id_w, classname);

Vinsert(vgrp_id, vdata_id_w);

   if (VSfdefine(vdata_id_w, "sctime_readout", DFNT_UINT32, (1) )) {
     s3_mhk_error("VSfdefine sctime_readout error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "sctime_collection", DFNT_UINT32, (1) )) {
     s3_mhk_error("VSfdefine sctime_collection error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "QAC", DFNT_UINT32, (1) )) {
     s3_mhk_error("VSfdefine QAC error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GRP282V", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine GRP282V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GRP9V", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine GRP9V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GRP5V", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine GRP5V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GRM5V", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine GRM5V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GRM12V", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine GRM12V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GR1T", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine GR1T error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GR2T", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine GR2T error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SPARE1", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine SPARE1 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GRP281I", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine GRP281I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GRP282I", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine GRP282I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GRP5I", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine GRP5I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SPARE2", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine SPARE2 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SPARE3", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine SPARE3 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SPARE4", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine SPARE4 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GRWAVEEQ", DFNT_UINT16, (1) )) {
     s3_mhk_error("VSfdefine GRWAVEEQ error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GRVF", DFNT_UINT16, (1) )) {
     s3_mhk_error("VSfdefine GRVF error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "VFP28V", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine VFP28V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "VFP9V", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine VFP9V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "VFP6V", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine VFP6V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "VFP5V", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine VFP5V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "VFM5V", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine VFM5V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "VFM12V", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine VFM12V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "VF1T", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine VF1T error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "VF2T", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine VF2T error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "VFP28I", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine VFP28I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "VFP6I", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine VFP6I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "VFP5I", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine VFP5I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "VFM5I", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine VFM5I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "VFSTART", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine VFSTART error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SPARE5", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine SPARE5 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "VFSTOP", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine VFSTOP error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "VFHPS", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine VFHPS error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "STATE", DFNT_UINT8, (1) )) {
     s3_mhk_error("VSfdefine STATE error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"sctime_readout, sctime_collection, QAC, GRP282V, GRP9V, GRP5V, GRM5V, GRM12V, GR1T, GR2T, SPARE1, GRP281I, GRP282I, GRP5I, SPARE2, SPARE3, SPARE4, GRWAVEEQ, GRVF, VFP28V, VFP9V, VFP6V, VFP5V, VFM5V, VFM12V, VF1T, VF2T, VFP28I, VFP6I, VFP5I, VFM5I, VFSTART, SPARE5, VFSTOP, VFHPS, STATE")){
    s3_mhk_error("VSsetfields error");
    retval = -1;
  }
  return(retval);
}

/****** write function ******/

int32 write_s3_mhk(struct ssmhk ssmhk_struc)
{
int32 retval = 0;
uint8 *odata;

void pack_s3_mhk();

  odata = (uint8 *) malloc(sizeof(struct ssmhk));
  pack_s3_mhk(odata, &ssmhk_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing S3 MHK data\n");
  } 
  memset(&ssmhk_struc, 0, sizeof(struct ssmhk));
  free(odata);
  return(retval);
}

void close_wr_s3_mhk() {
  VSdetach(vdata_id_w);
  Vdetach(vgrp_id);
}

/*     init read function    */

int32 init_rd_s3_mhk(int32 hdf_fp, int32 sd_id)
{
  int32 vdata_ref;
  int32 retval=0;

  void s3_mhk_error();


  if ((vdata_ref = VSfind(hdf_fp, "ssmhk"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"sctime_readout, sctime_collection, QAC, GRP282V, GRP9V, GRP5V, GRM5V, GRM12V, GR1T, GR2T, SPARE1, GRP281I, GRP282I, GRP5I, SPARE2, SPARE3, SPARE4, GRWAVEEQ, GRVF, VFP28V, VFP9V, VFP6V, VFP5V, VFM5V, VFM12V, VF1T, VF2T, VFP28I, VFP6I, VFP5I, VFM5I, VFSTART, SPARE5, VFSTOP, VFHPS, STATE")) {
    s3_mhk_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_s3_mhk(struct ssmhk *ssmhk_struc, int32 recnum_rd)
{
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_s3_mhk();

  odata = (uint8 *) malloc(sizeof(struct ssmhk));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_s3_mhk(odata, ssmhk_struc);
  free(odata);
  return(retval);
}

void s3_mhk_error(int8 *mess)
  { fprintf(stderr,"S3 MHK: %s\n",mess); }

void close_rd_s3_mhk() {
  VSdetach(vdata_id_r);
}
/*   pack function    */

void pack_s3_mhk(uint8 *data, struct ssmhk *ssmhk_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &ssmhk_ptr->sctime_readout, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ssmhk_ptr->sctime_collection, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ssmhk_ptr->QAC, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ssmhk_ptr->GRP282V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->GRP9V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->GRP5V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->GRM5V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->GRM12V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->GR1T, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->GR2T, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->SPARE1, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->GRP281I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->GRP282I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->GRP5I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->SPARE2, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->SPARE3, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->SPARE4, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->GRWAVEEQ, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &ssmhk_ptr->GRVF, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &ssmhk_ptr->VFP28V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->VFP9V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->VFP6V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->VFP5V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->VFM5V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->VFM12V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->VF1T, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->VF2T, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->VFP28I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->VFP6I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->VFP5I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->VFM5I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->VFSTART, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->SPARE5, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->VFSTOP, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->VFHPS, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &ssmhk_ptr->STATE, ((1)*(1)) );
   ptr+= ((1)*(1));
}

/*   unpack function    */

void unpack_s3_mhk(uint8 *data, struct ssmhk *ssmhk_ptr)
{
int32 ptr=0;

   memcpy(&ssmhk_ptr->sctime_readout, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ssmhk_ptr->sctime_collection, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ssmhk_ptr->QAC, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ssmhk_ptr->GRP282V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->GRP9V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->GRP5V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->GRM5V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->GRM12V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->GR1T, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->GR2T, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->SPARE1, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->GRP281I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->GRP282I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->GRP5I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->SPARE2, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->SPARE3, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->SPARE4, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->GRWAVEEQ, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&ssmhk_ptr->GRVF, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&ssmhk_ptr->VFP28V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->VFP9V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->VFP6V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->VFP5V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->VFM5V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->VFM12V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->VF1T, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->VF2T, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->VFP28I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->VFP6I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->VFP5I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->VFM5I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->VFSTART, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->SPARE5, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->VFSTOP, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->VFHPS, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&ssmhk_ptr->STATE, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
}
