/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.21 1997/05/07 21:31:18 steves Exp $ */

/* The include file used to create this file is: */
/* $Id: s3_chk.h,v 1.2 1997/05/06 18:06:01 jeff Exp $ */

#include "s3_chk.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w, vgrp_id;

/****  init write function  ****/

int32 init_wr_s3_chk(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  void s3_chk_error();

  vgrp_id = Vattach(hdf_fp, -1, "w");
    Vsetname(vgrp_id, "NVgrps3_chk");
    Vsetclass(vgrp_id, "CVgrps3_chk");

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "csmhk");
  VSsetclass(vdata_id_w, classname);

Vinsert(vgrp_id, vdata_id_w);

   if (VSfdefine(vdata_id_w, "sctime_readout", DFNT_UINT32, (1) )) {
     s3_chk_error("VSfdefine sctime_readout error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "sctime_collection", DFNT_UINT32, (1) )) {
     s3_chk_error("VSfdefine sctime_collection error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "QAC", DFNT_UINT32, (1) )) {
     s3_chk_error("VSfdefine QAC error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GRP282V", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine GRP282V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GR20V", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine GR20V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GRP10V", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine GRP10V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GRP5V", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine GRP5V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GRM5V", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine GRM5V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SPARE1", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine SPARE1 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GR1T", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine GR1T error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GR2T", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine GR2T error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GRP281I", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine GRP281I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GRP282I", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine GRP282I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GRP5I", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine GRP5I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GR20I", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine GR20I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GRPAPS", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine GRPAPS error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SPARE2", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine SPARE2 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GRDPPSL", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine GRDPPSL error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "GRDPPSH", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine GRDPPSH error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SPARE3", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine SPARE3 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PAC7", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine PAC7 error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PA1T", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine PA1T error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PA2T", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine PA2T error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PAP5V", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine PAP5V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PAP5I", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine PAP5I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PAM5V", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine PAM5V error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PAM5I", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine PAM5I error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "PAMCP", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine PAMCP error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "FLAGS", DFNT_UINT8, (1) )) {
     s3_chk_error("VSfdefine FLAGS error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"sctime_readout, sctime_collection, QAC, GRP282V, GR20V, GRP10V, GRP5V, GRM5V, SPARE1, GR1T, GR2T, GRP281I, GRP282I, GRP5I, GR20I, GRPAPS, SPARE2, GRDPPSL, GRDPPSH, SPARE3, PAC7, PA1T, PA2T, PAP5V, PAP5I, PAM5V, PAM5I, PAMCP, FLAGS")){
    s3_chk_error("VSsetfields error");
    retval = -1;
  }
  return(retval);
}

/****** write function ******/

int32 write_s3_chk(struct csmhk csmhk_struc)
{
int32 retval = 0;
uint8 *odata;

void pack_s3_chk();

  odata = (uint8 *) malloc(sizeof(struct csmhk));
  pack_s3_chk(odata, &csmhk_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing S3 CHK data\n");
  } 
  memset(&csmhk_struc, 0, sizeof(struct csmhk));
  free(odata);
  return(retval);
}

void close_wr_s3_chk() {
  VSdetach(vdata_id_w);
  Vdetach(vgrp_id);
}

/*     init read function    */

int32 init_rd_s3_chk(int32 hdf_fp, int32 sd_id)
{
  int32 vdata_ref;
  int32 retval=0;

  void s3_chk_error();


  if ((vdata_ref = VSfind(hdf_fp, "csmhk"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"sctime_readout, sctime_collection, QAC, GRP282V, GR20V, GRP10V, GRP5V, GRM5V, SPARE1, GR1T, GR2T, GRP281I, GRP282I, GRP5I, GR20I, GRPAPS, SPARE2, GRDPPSL, GRDPPSH, SPARE3, PAC7, PA1T, PA2T, PAP5V, PAP5I, PAM5V, PAM5I, PAMCP, FLAGS")) {
    s3_chk_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_s3_chk(struct csmhk *csmhk_struc, int32 recnum_rd)
{
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_s3_chk();

  odata = (uint8 *) malloc(sizeof(struct csmhk));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_s3_chk(odata, csmhk_struc);
  free(odata);
  return(retval);
}

void s3_chk_error(int8 *mess)
  { fprintf(stderr,"S3 CHK: %s\n",mess); }

void close_rd_s3_chk() {
  VSdetach(vdata_id_r);
}
/*   pack function    */

void pack_s3_chk(uint8 *data, struct csmhk *csmhk_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &csmhk_ptr->sctime_readout, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &csmhk_ptr->sctime_collection, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &csmhk_ptr->QAC, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &csmhk_ptr->GRP282V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &csmhk_ptr->GR20V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &csmhk_ptr->GRP10V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &csmhk_ptr->GRP5V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &csmhk_ptr->GRM5V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &csmhk_ptr->SPARE1, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &csmhk_ptr->GR1T, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &csmhk_ptr->GR2T, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &csmhk_ptr->GRP281I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &csmhk_ptr->GRP282I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &csmhk_ptr->GRP5I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &csmhk_ptr->GR20I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &csmhk_ptr->GRPAPS, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &csmhk_ptr->SPARE2, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &csmhk_ptr->GRDPPSL, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &csmhk_ptr->GRDPPSH, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &csmhk_ptr->SPARE3, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &csmhk_ptr->PAC7, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &csmhk_ptr->PA1T, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &csmhk_ptr->PA2T, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &csmhk_ptr->PAP5V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &csmhk_ptr->PAP5I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &csmhk_ptr->PAM5V, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &csmhk_ptr->PAM5I, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &csmhk_ptr->PAMCP, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &csmhk_ptr->FLAGS, ((1)*(1)) );
   ptr+= ((1)*(1));
}

/*   unpack function    */

void unpack_s3_chk(uint8 *data, struct csmhk *csmhk_ptr)
{
int32 ptr=0;

   memcpy(&csmhk_ptr->sctime_readout, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&csmhk_ptr->sctime_collection, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&csmhk_ptr->QAC, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&csmhk_ptr->GRP282V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&csmhk_ptr->GR20V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&csmhk_ptr->GRP10V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&csmhk_ptr->GRP5V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&csmhk_ptr->GRM5V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&csmhk_ptr->SPARE1, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&csmhk_ptr->GR1T, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&csmhk_ptr->GR2T, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&csmhk_ptr->GRP281I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&csmhk_ptr->GRP282I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&csmhk_ptr->GRP5I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&csmhk_ptr->GR20I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&csmhk_ptr->GRPAPS, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&csmhk_ptr->SPARE2, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&csmhk_ptr->GRDPPSL, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&csmhk_ptr->GRDPPSH, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&csmhk_ptr->SPARE3, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&csmhk_ptr->PAC7, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&csmhk_ptr->PA1T, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&csmhk_ptr->PA2T, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&csmhk_ptr->PAP5V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&csmhk_ptr->PAP5I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&csmhk_ptr->PAM5V, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&csmhk_ptr->PAM5I, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&csmhk_ptr->PAMCP, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&csmhk_ptr->FLAGS, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
}
