/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.21 1997/05/07 21:31:18 steves Exp $ */

/* The include file used to create this file is: */
/* $Id: s3_sbasic.h,v 1.5 1997/05/06 18:03:52 jeff Exp $	     */

#include "s3_sbasic.h"
#include "mfhdf.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w, vgrp_id;
static int32 sds_id_r1, sds_id_w1, sds_id_r2, sds_id_w2;


/****  init write function  ****/

int32 init_wr_s3_sbasic(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  int32 dim_sizes[4];
  int32 rank;

  void s3_sbasic_error();

  vgrp_id = Vattach(hdf_fp, -1, "w");
    Vsetname(vgrp_id, "NVgrps3_sbasic");
    Vsetclass(vgrp_id, "CVgrps3_sbasic");

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "sbasic");
  VSsetclass(vdata_id_w, classname);

Vinsert(vgrp_id, vdata_id_w);

   if (VSfdefine(vdata_id_w, "sctime_readout", DFNT_UINT32, (1) )) {
     s3_sbasic_error("VSfdefine sctime_readout error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "sctime_collection", DFNT_UINT32, (1) )) {
     s3_sbasic_error("VSfdefine sctime_collection error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "QAC", DFNT_UINT32, (1) )) {
     s3_sbasic_error("VSfdefine QAC error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"sctime_readout, sctime_collection, QAC")){
    s3_sbasic_error("VSsetfields error");
    retval = -1;
  }
  dim_sizes[0] = SD_UNLIMITED;
  rank = 4;
  dim_sizes[1] = SBAS_CYC;
  dim_sizes[2] = SBAS_N;
  dim_sizes[3] = SBAS_S;
  if((sds_id_w1=SDcreate(sd_id, "sbasic_BASIC", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create sbasic_BASIC \n");

  dim_sizes[0] = SD_UNLIMITED;
  rank = 3;
  dim_sizes[1] = SBAS_CYC;
  dim_sizes[2] = SBAS_NFILL;
  if((sds_id_w2=SDcreate(sd_id, "sbasic_FILL", DFNT_UINT16, rank, dim_sizes)) == FAIL)
    fprintf(stderr,"SDcreate: Could not create sbasic_FILL \n");

  return(retval);
}

/****** write function ******/

int32 write_s3_sbasic(struct sbasic sbasic_struc)
{
int32 start[4], edges[4];
int32 retval = 0;
uint8 *odata;
static int32 recnum_wr=0;

void pack_s3_sbasic();

  odata = (uint8 *) malloc(sizeof(struct sbasic));
  pack_s3_sbasic(odata, &sbasic_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing S3 SBASIC data\n");
  } 
  start[0] = recnum_wr++;
  start[1] = 0;
  start[2] = 0;
  start[3] = 0;
  edges[0] = 1;

  edges[1] = SBAS_CYC;
  edges[2] = SBAS_N;
  edges[3] = SBAS_S;
  if (SDwritedata(sds_id_w1,start,NULL,edges,(VOIDP) (sbasic_struc.BASIC ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing BASIC data.\n");
  }
  edges[1] = SBAS_CYC;
  edges[2] = SBAS_NFILL;
  if (SDwritedata(sds_id_w2,start,NULL,edges,(VOIDP) (sbasic_struc.FILL ))==FAIL) {
    fprintf(stderr,"SDwritedata: Problem writing FILL data.\n");
  }
  memset(&sbasic_struc, 0, sizeof(struct sbasic));
  free(odata);
  return(retval);
}

void close_wr_s3_sbasic() {
  VSdetach(vdata_id_w);
  Vdetach(vgrp_id);
  SDendaccess(sds_id_w1);
  SDendaccess(sds_id_w2);
}

/*     init read function    */

int32 init_rd_s3_sbasic(int32 hdf_fp, int32 sd_id)
{
  static int32 sds_index1;
  static int32 sds_index2;
  int32 vdata_ref;
  int32 retval=0;

  void s3_sbasic_error();

    if((sds_index1=SDnametoindex(sd_id, "sbasic_BASIC" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find sbasic_BASIC\n");
      retval = -1;
    }
    if((sds_id_r1=SDselect(sd_id, sds_index1))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index1\n");
      retval = -1;
    }
    if((sds_index2=SDnametoindex(sd_id, "sbasic_FILL" ))==FAIL) {
      fprintf(stderr,"SDnametoindex: Could not find sbasic_FILL\n");
      retval = -1;
    }
    if((sds_id_r2=SDselect(sd_id, sds_index2))==FAIL) {
      fprintf(stderr,"SDselect: Could not select sds_index2\n");
      retval = -1;
    }

  if ((vdata_ref = VSfind(hdf_fp, "sbasic"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"sctime_readout, sctime_collection, QAC")) {
    s3_sbasic_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_s3_sbasic(struct sbasic *sbasic_struc, int32 recnum_rd)
{
int32 start[4], edges[4];
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_s3_sbasic();

  start[0] = recnum_rd;
  start[1] = 0;
  start[2] = 0;
  start[3] = 0;
  edges[0] = 1;

  odata = (uint8 *) malloc(sizeof(struct sbasic));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  edges[1] = SBAS_CYC;
  edges[2] = SBAS_N;
  edges[3] = SBAS_S;
  if(SDreaddata(sds_id_r1,start,NULL,edges, (VOIDP)(sbasic_struc->BASIC ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read BASIC\n");
    retval = -1;
  }
  edges[1] = SBAS_CYC;
  edges[2] = SBAS_NFILL;
  if(SDreaddata(sds_id_r2,start,NULL,edges, (VOIDP)(sbasic_struc->FILL ))==FAIL) {
    fprintf(stderr,"SDreaddata: Could not read FILL\n");
    retval = -1;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_s3_sbasic(odata, sbasic_struc);
  free(odata);
  return(retval);
}

void s3_sbasic_error(int8 *mess)
  { fprintf(stderr,"S3 SBASIC: %s\n",mess); }

void close_rd_s3_sbasic() {
  VSdetach(vdata_id_r);
  SDendaccess(sds_id_r1);
  SDendaccess(sds_id_r2);
}
/*   pack function    */

void pack_s3_sbasic(uint8 *data, struct sbasic *sbasic_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &sbasic_ptr->sctime_readout, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &sbasic_ptr->sctime_collection, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &sbasic_ptr->QAC, ((4)*(1)) );
   ptr+= ((4)*(1));
}

/*   unpack function    */

void unpack_s3_sbasic(uint8 *data, struct sbasic *sbasic_ptr)
{
int32 ptr=0;

   memcpy(&sbasic_ptr->sctime_readout, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&sbasic_ptr->sctime_collection, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&sbasic_ptr->QAC, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
}
