/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.21 1997/05/07 21:31:18 steves Exp $ */

/* The include file used to create this file is: */
/* $Id: s3schk.h,v 1.1 1997/05/07 16:43:45 jeff Exp $ */

#include "s3schk.h"
#include "df.h"

static int32 vdata_id_r, vdata_id_w, vgrp_id;

/****  init write function  ****/

int32 init_wr_s3schk(int32 hdf_fp, int32 sd_id, char *classname)
{
  int32 retval=0;
  void s3schk_error();

  vgrp_id = Vattach(hdf_fp, -1, "w");
    Vsetname(vgrp_id, "NVgrps3schk");
    Vsetclass(vgrp_id, "CVgrps3schk");

  if ((vdata_id_w = VSattach(hdf_fp, -1, "w"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }
  VSsetname(vdata_id_w, "s3schk");
  VSsetclass(vdata_id_w, classname);

Vinsert(vgrp_id, vdata_id_w);

   if (VSfdefine(vdata_id_w, "sctime_readout", DFNT_UINT32, (1) )) {
     s3schk_error("VSfdefine sctime_readout error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "S3PwrCvtVol", DFNT_UINT8, (1) )) {
     s3schk_error("VSfdefine S3PwrCvtVol error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "S3Cur", DFNT_UINT8, (1) )) {
     s3schk_error("VSfdefine S3Cur error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "S3ConSecCur", DFNT_UINT8, (1) )) {
     s3schk_error("VSfdefine S3ConSecCur error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "S3PowSupATmp", DFNT_UINT8, (1) )) {
     s3schk_error("VSfdefine S3PowSupATmp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "S3Log", DFNT_UINT8, (1) )) {
     s3schk_error("VSfdefine S3Log error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SepDecTmp", DFNT_UINT8, (1) )) {
     s3schk_error("VSfdefine SepDecTmp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SepCur", DFNT_UINT8, (1) )) {
     s3schk_error("VSfdefine SepCur error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SepIsoButTmp", DFNT_UINT8, (1) )) {
     s3schk_error("VSfdefine SepIsoButTmp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SepLog", DFNT_UINT8, (1) )) {
     s3schk_error("VSfdefine SepLog error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SwcCur", DFNT_UINT8, (1) )) {
     s3schk_error("VSfdefine SwcCur error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SwcIntTmp", DFNT_UINT8, (1) )) {
     s3schk_error("VSfdefine SwcIntTmp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SwcLog", DFNT_UINT8, (1) )) {
     s3schk_error("VSfdefine SwcLog error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SwmCur", DFNT_UINT8, (1) )) {
     s3schk_error("VSfdefine SwmCur error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SwmIntTmp", DFNT_UINT8, (1) )) {
     s3schk_error("VSfdefine SwmIntTmp error");
     retval = -1;
   }
   if (VSfdefine(vdata_id_w, "SwmLog", DFNT_UINT8, (1) )) {
     s3schk_error("VSfdefine SwmLog error");
     retval = -1;
   }

  if (VSsetfields(vdata_id_w,"sctime_readout, S3PwrCvtVol, S3Cur, S3ConSecCur, S3PowSupATmp, S3Log, SepDecTmp, SepCur, SepIsoButTmp, SepLog, SwcCur, SwcIntTmp, SwcLog, SwmCur, SwmIntTmp, SwmLog")){
    s3schk_error("VSsetfields error");
    retval = -1;
  }
  return(retval);
}

/****** write function ******/

int32 write_s3schk(struct s3schk s3schk_struc)
{
int32 retval = 0;
uint8 *odata;

void pack_s3schk();

  odata = (uint8 *) malloc(sizeof(struct s3schk));
  pack_s3schk(odata, &s3schk_struc);

  if( VSwrite(vdata_id_w, (uint8 *)odata, 1, FULL_INTERLACE) == -1) {
    fprintf(stderr,"VSwrite: Problem writing S3SCHK data\n");
  } 
  memset(&s3schk_struc, 0, sizeof(struct s3schk));
  free(odata);
  return(retval);
}

void close_wr_s3schk() {
  VSdetach(vdata_id_w);
  Vdetach(vgrp_id);
}

/*     init read function    */

int32 init_rd_s3schk(int32 hdf_fp, int32 sd_id)
{
  int32 vdata_ref;
  int32 retval=0;

  void s3schk_error();


  if ((vdata_ref = VSfind(hdf_fp, "s3schk"))==FAIL) {
    fprintf(stderr,"VSfind: Could not get vdata_ref\n");
    retval=-1;
  }
  if ((vdata_id_r = VSattach(hdf_fp, vdata_ref, "r"))==FAIL) {
    fprintf(stderr,"VSattach: Could not attach hdf_fp\n");
    retval=-1;
  }

  if (VSsetfields(vdata_id_r,"sctime_readout, S3PwrCvtVol, S3Cur, S3ConSecCur, S3PowSupATmp, S3Log, SepDecTmp, SepCur, SepIsoButTmp, SepLog, SwcCur, SwcIntTmp, SwcLog, SwmCur, SwmIntTmp, SwmLog")) {
    s3schk_error("VSsetfields error");
  }
  return(retval);
}

/****** read function ******/

int32 read_s3schk(struct s3schk *s3schk_struc, int32 recnum_rd)
{
static int32 last_recnum = -1;
int32 maxrec;
int32 retval = 0;
uint8 *odata;

void unpack_s3schk();

  odata = (uint8 *) malloc(sizeof(struct s3schk));
  VSinquire(vdata_id_r, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec || last_recnum>=maxrec-1) return(-1);
  if (recnum_rd >= 0) {
    last_recnum = recnum_rd;
    if (VSseek(vdata_id_r, recnum_rd)==FAIL) {
      fprintf(stderr,"VSseek unsuccessful\n");
      retval = -1;
    }
  } else {
    recnum_rd = ++last_recnum;
  }
  if(VSread(vdata_id_r, (uint8 *)odata, 1, FULL_INTERLACE)==FAIL) {
    fprintf(stderr,"VSread: Could not read\n");
    retval = -1;
  }
  unpack_s3schk(odata, s3schk_struc);
  free(odata);
  return(retval);
}

void s3schk_error(int8 *mess)
  { fprintf(stderr,"S3SCHK: %s\n",mess); }

void close_rd_s3schk() {
  VSdetach(vdata_id_r);
}
/*   pack function    */

void pack_s3schk(uint8 *data, struct s3schk *s3schk_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &s3schk_ptr->sctime_readout, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &s3schk_ptr->S3PwrCvtVol, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &s3schk_ptr->S3Cur, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &s3schk_ptr->S3ConSecCur, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &s3schk_ptr->S3PowSupATmp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &s3schk_ptr->S3Log, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &s3schk_ptr->SepDecTmp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &s3schk_ptr->SepCur, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &s3schk_ptr->SepIsoButTmp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &s3schk_ptr->SepLog, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &s3schk_ptr->SwcCur, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &s3schk_ptr->SwcIntTmp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &s3schk_ptr->SwcLog, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &s3schk_ptr->SwmCur, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &s3schk_ptr->SwmIntTmp, ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(data+ptr, &s3schk_ptr->SwmLog, ((1)*(1)) );
   ptr+= ((1)*(1));
}

/*   unpack function    */

void unpack_s3schk(uint8 *data, struct s3schk *s3schk_ptr)
{
int32 ptr=0;

   memcpy(&s3schk_ptr->sctime_readout, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&s3schk_ptr->S3PwrCvtVol, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&s3schk_ptr->S3Cur, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&s3schk_ptr->S3ConSecCur, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&s3schk_ptr->S3PowSupATmp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&s3schk_ptr->S3Log, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&s3schk_ptr->SepDecTmp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&s3schk_ptr->SepCur, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&s3schk_ptr->SepIsoButTmp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&s3schk_ptr->SepLog, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&s3schk_ptr->SwcCur, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&s3schk_ptr->SwcIntTmp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&s3schk_ptr->SwcLog, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&s3schk_ptr->SwmCur, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&s3schk_ptr->SwmIntTmp, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
   memcpy(&s3schk_ptr->SwmLog, data+ptr,  ((1)*(1)) );
   ptr+= ((1)*(1));
}
