pro sun,utc,gst,sra,sdec
; implementation of SUN from C.T. Russell, Cosmic Electrodynamics, 1971
; UTC - structure containing time values (see gps2utc)
; gst - Greenwich mean siderial time (returned)
; sra - solar right ascension (deg)
; sdec - solar declination (deg)

yr=utc.year
sec=utc.sec
month=utc.month
day=utc.day
ni=long(n_elements(utc))
dj=dblarr(ni)

fday=double(sec/86400.)
jd0=double(julday(1,1,1900)-1)
for ic=0l,ni-1 do $
	dj(ic)=double(julday(month(ic),day(ic),yr(ic)))+fday(ic)-(.5d)-jd0
T = DJ / 36525
VL = (279.696678 + 0.9856473354*DJ) mod 360.D0
GST = (279.690983 + 0.9856473354*DJ + 360.*FDAY + 180.) mod 360.D0
G =  (358.475845 + 0.985600267*DJ mod 360.D0) * !dtor 
SLONG = VL + (1.91946 -0.004789*T)*SIN(G) + 0.020094*SIN (2.*G) 
OBLIQ = (23.45229 -0.0130125*T) * !dtor
SLP = (SLONG -0.005686) *!dtor 
SIND = SIN (OBLIQ)*SIN (SLP)
COSD = SQRT(1.-SIND^2)
SDEC = !radeg * ATAN (SIND/COSD)
SRASN = 180. -!radeg*ATAN(((1.d)/tan(OBLIQ))*SIND/COSD, -COS (SLP)/COSD)
sra=srasn
RETURN
end



function svec,ra,dec
; convert ra and dec to sun vector (assumes arrays)

rra=!dtor*ra
rdec=!dtor*dec
n=n_elements(ra)
sv=dblarr(3,n)
x=cos(rra)*cos(rdec)
y=sin(rra)*cos(rdec)
z=sin(rdec)
sv(0,*)=x
sv(1,*)=y
sv(2,*)=z
return,sv
end



