/homes/spike/timed/sds/geom/geoc2geod.pro                                                           0100644 0002007 0002067 00000002116 06447560132 0021113 0                                                                                                    ustar 00spike                           timed                           0000243 0000611                                                                                                                                                                        pro geoc2geod,hc,latc,hd,latd,flat=flat,req=req
; convert geocentric altitude and latitude (hc, latc) [km,deg]
; to geodetic altitude and latitude (hd,latd). Uses
; algorithm from Hedman, J. Spacecraft, vol 7, No. 8, aug 1970
; flat is the optional flattening term for the shape of the earth
;	by default, flat =1./298.25722356
; req is the mean equitorial radius
;	by default, req =6378.1370
; itmax is the maximum iterations allowed (default=10)
; tol is the convergence criteria for latitude in deg., default 1.e-5

common earth,re,e2,E,F

f=(1d)/298.25722356
re=6378.1370
if keyword_set(flat) then f=flat
if keyword_set(req) then re=req
one=1d
e2=one-(one-f)^2
b=re*sqrt(one-e2)
E=(hc+re)*cos(!dtor*latc)
F=(hc+re)*sin(!dtor*latc)


phi0=atan(re^2*F,b^2*E)
phi=newton(phi0,'minfun')
latd=!radeg*phi
nsub=re/sqrt(one-e2*sin(phi)^2)
xsub=nsub*cos(phi)
ysub=(nsub*(one-e2))*sin(phi)
biga=sqrt((E-xsub)^2+(F-ysub)^2)
bigb=xsub*(E-xsub)+ysub*(F-ysub)
hd=biga*(bigb)/abs(bigb)
return
end

function minfun,phi
common earth,re,e2,E,F
one=1d
return,re*e2/sqrt(one-e2*sin(phi)^2)-E/cos(phi)+F/sin(phi)
end


                                                                                                                                                                                                                                                                                                                                                                                                                                                  /homes/spike/timed/sds/geom/geod2geoc.pro                                                           0100644 0002007 0002067 00000001255 06447540156 0021122 0                                                                                                    ustar 00spike                           timed                           0000243 0000611                                                                                                                                                                        pro geod2geoc,hd,latd,hc,latc,flat=flat,req=req
; convert geodetic altitude and latitude (hd, latd) [km,deg]
; to geocentric altitude and latitude (hc,latc). Uses
; algorithm from Hedman, J. Spacecraft, vol 7, No. 8, aug 1970
; flat is the optional flattening term for the shape of the earth
;	by default, flat =1./298.25722356
; req is the mean equitorial radius
;	by default, req =6378.1370

f=(1d)/298.25722356
re=6378.1370
if keyword_set(flat) then f=flat
if keyword_set(req) then re=req
one=1d
e2=one-(one-f)^2

phi=!dtor*latd
N= re/sqrt((one-e2*sin(phi)^2))
E=(N+hd)*cos(phi)
F=(N*(1-e2)+hd)*sin(phi)

latc=!radeg*atan(E,F)
latc=!radeg*atan(F,E)
hc=sqrt((E^2+F^2))-re
return
end
                                                                                                                                                                                                                                                                                                                                                   /homes/spike/timed/sds/geom/sc2eci_mat.pro                                                          0100644 0002007 0002067 00000001237 06444033462 0021267 0                                                                                                    ustar 00spike                           timed                           0000243 0000611                                                                                                                                                                        pro sc2eci_mat,q,s2emat
; build transformation matrix (spacecraft -> eci) from quaternions
; q - attitude quaternions (4,n)
; s2emat - transformation matrices(3,3,n)


n=n_elements(q(0,*))
s2emat=dblarr(3,3,n)

s2emat(0,0,*)=q(0,*)^2-q(1,*)^2-q(2,*)^2+q(3,*)^2
s2emat(1,1,*)=-q(0,*)^2+q(1,*)^2-q(2,*)^2+q(3,*)^2
s2emat(2,2,*)=-q(0,*)^2-q(1,*)^2+q(2,*)^2+q(3,*)^2
s2emat(0,1,*)=(2d)*(q(0,*)*q(1,*)+q(3,*)*q(2,*))
s2emat(0,2,*)=(2d)*(q(0,*)*q(2,*)-q(3,*)*q(1,*))
s2emat(1,0,*)=(2d)*(q(1,*)*q(0,*)-q(3,*)*q(2,*))
s2emat(1,2,*)=(2d)*(q(1,*)*q(2,*)+q(3,*)*q(0,*))
s2emat(2,0,*)=(2d)*(q(2,*)*q(0,*)+q(3,*)*q(1,*))
s2emat(2,1,*)=(2d)*(q(2,*)*q(0,*)-q(3,*)*q(0,*))
return
end



                                                                                                                                                                                                                                                                                                                                                                 /homes/spike/timed/sds/geom/sun.f                                                                   0100744 0002007 0002067 00000003625 06443574225 0017522 0                                                                                                    ustar 00spike                           timed                           0000243 0000611                                                                                                                                                                        c from C.T. Russell, Geophysical Coordinate Transformations" Cosmic
c Electrodynamics, 2, 1971, pp 184-196.
c
c Appendix 2. The Calculation of the Position of the Sun
c 
c G.D. Mead (private communication) has written a simple subroutine to calculate the position of the Sun in GEI coordinates.
c It is accurate for years 1901 through 2099, to within 0.006 deg. The input is the year, day of year and seconds of the day in
c UT. The output is Greenwich Mean Sideral Time in degrees, the ecliptic longitude, apparent right ascension and declination
c of the Sun in degrees. The listing of this program follows. We note that the cartesian coordinates of the vector from the Earth
c to the Sun are: 
c 
c   X = cos(SRASN) cos(SDEC)
c   Y = sin(SRASN) cos(SDEC)
c   Z = sin(SDEC)
c 
c 
  SUBROUTINE SUN(IYR, IDAY, SECS, GST, SLONG, SRASN, SDEC)
C PROGRAM TO CALCULATE SIDEREAL TIME AND POSITION OF THE SUN. 
C GOOD FOR YEARS 1901 THROUGH 2099. ACCURACY 0.006 DEGREE.
C INPUT IS IYR, IDAY (INTEGERS), AND SECS, DEFINING UN. TIME. 
C OUTPUT IS GREENWICH MEAN SIDEREAL TIME (GST) IN DEGREES,
C LONGITUDE ALONG ECLIPTIC (SLONG), AND APPARENT RIGHT ASCENSION
C AND DECLINATION (SRASN, SDEC) OF THE SUN, ALL IN DEGREES
  DATA RAD /57.29578/ 
  DOUBLE PRECISION DJ, FDAY 
  IF(IYR. LT. 1901. OR. IYR. GT. 2099) RETURN
  FDAY = SECS/86400
  DJ = 365* (IYR-1900) + (IYR-1901)/4 + IDAY + FDAY -0.5D0 
  T = DJ / 36525 
  VL = DMOD (279.696678 + 0.9856473354*DJ, 360.D0) 
  GST = DMOD (279.690983 + 0.9856473354*DJ + 360.*FDAY + 180., 360.D0)
  G = DMOD (358.475845 + 0.985600267*DJ, 360.D0) / RAD 
  SLONG = VL + (1.91946 -0.004789*T)*SIN(G) + 0.020094*SIN (2.*G) 
  OBLIQ = (23.45229 -0.0130125*T) / RAD 
  SLP = (SLONG -0.005686) / RAD 
  SIND = SIN (OBLIQ)*SIN (SLP) 
  COSD = SQRT(1.-SIND**2)
  SDEC = RAD * ATAN (SIND/COSD) 
  SRASN = 180. -RAD*ATAN2
  (COTAN (OBLIQ)*SIND/COSD, COS (SLP)/COSD) 
  RETURN 
  END
                                                                                                           /homes/spike/timed/sds/geom/sun.pro                                                                 0100644 0002007 0002067 00000002323 06443607467 0020073 0                                                                                                    ustar 00spike                           timed                           0000243 0000611                                                                                                                                                                        pro sun,utc,gst,sra,sdec
; implementation of SUN from C.T. Russell, Cosmic Electrodynamics, 1971
; UTC - structure containing time values (see gps2utc)
; gst - Greenwich mean siderial time (returned)
; sra - solar right ascension (deg)
; sdec - solar declination (deg)

yr=utc.year
sec=utc.sec
month=utc.month
day=utc.day
ni=n_elements(utc)
dj=dblarr(ni)

fday=double(sec/86400.)
jd0=double(julday(1,1,1900)-1)
for ic=0,ni-1 do $
	dj(ic)=double(julday(month(ic),day(ic),yr(ic)))+fday(ic)-(.5d)-jd0
T = DJ / 36525
VL = (279.696678 + 0.9856473354*DJ) mod 360.D0
GST = (279.690983 + 0.9856473354*DJ + 360.*FDAY + 180.) mod 360.D0
G =  (358.475845 + 0.985600267*DJ mod 360.D0) * !dtor 
SLONG = VL + (1.91946 -0.004789*T)*SIN(G) + 0.020094*SIN (2.*G) 
OBLIQ = (23.45229 -0.0130125*T) * !dtor
SLP = (SLONG -0.005686) *!dtor 
SIND = SIN (OBLIQ)*SIN (SLP)
COSD = SQRT(1.-SIND^2)
SDEC = !radeg * ATAN (SIND/COSD)
SRASN = 180. -!radeg*ATAN(((1.d)/tan(OBLIQ))*SIND/COSD, COS (SLP)/COSD)
sra=srasn
RETURN
end



function svec,ra,dec
; convert ra and dec to sun vector (assumes arrays)

rra=!dtor*ra
rdec=!dtor*dec
n=n_elements(ra)
sv=dblarr(3,n)
x=cos(rra)*cos(rdec)
y=sin(rra)*cos(rdec)
z=sin(rdec)
sv(0,*)=x
sv(1,*)=y
sv(2,*)=z
return,sv
end



                                                                                                                                                                                                                                                                                                             /homes/spike/timed/sds/geom/tanhgt.pro                                                              0100644 0002007 0002067 00000003150 06452222612 0020533 0                                                                                                    ustar 00spike                           timed                           0000243 0000611                                                                                                                                                                        pro tanhgt,pv,Rs,th,tlat,tp,flat=flat,Req=Req,notan=notan,pp=pp
; given a line of sight unit vector (pv) and 
; the observers position vector (Rs) calculate the
; tangent height (th) and the geodetic latitude tlat and 
; the cartesian position of the taangent point (tp) in ECI. Defaults
; for the equitorial radius and flatness of the earth
; are assumed, but ay be input by the user with the
; Req and flat keywords.
; If th is negative, the pierce point (the point at which the
; line of sight intersects the earth) longitude and latitude will
; be returned in the keyword pp.
; if no tangent point is found, the keyword notan will be set on return

notan=0.
f=(1d)/298.25722356
re=double(6378.1370)
if keyword_set(flat) then f=flat
if keyword_set(req) then re=req
one=1d
e=(one/(one-f)^2)-one
al=[1d,1d,e+1d]

Rsu=Rs/sqrt(total(Rs^2))
cv=-crossp(pv,crossp(Rsu,pv))
cv=cv/sqrt(total(cv^2))

pop=total(al*pv^2)
coc=total(al*cv^2)
RoR=total(al*Rs^2)
poc=total(al*pv*cv)
Roc=total(al*Rs*cv)
Rop=total(al*Rs*pv)

a=pop*poc^2-pop^2*coc
b=pop*(Roc*poc-Rop*coc)
c=(Re^2-RoR)*poc^2+((2d)*Roc*poc-coc*Rop)*Rop

rad0=b^2-a*c
if rad0 lt 0 then begin
	notan=1
	return
endif
L=[(-b+sqrt(rad0))/a,(-b-sqrt(rad0))/a]

ah=[coc,coc]
bh=(Roc+L*poc)
ch=pop*L^2+(2d)*L*Rop+RoR-Re^2
h=[[(-bh+sqrt(bh^2-ah*ch))/ah],[(-bh-sqrt(bh^2-ah*ch))/ah]]
th=min(abs(h),ic)
th=h(ic)
LL=L(0)
if ic mod 2 then LL=L(1)

tp=Rs+LL*pv+th*cv
tpu=tp/sqrt((total(tp*tp)))
glat=90.-acos(tpu(2))*!radeg

if th lt 0 and keyword_set(pp) then begin
   ap=pop
   bp=Rop
   cp=(RoR-Re^2)
   Lp=min([(-bp+sqrt(bp^2-ap*cp))/ap,(-bp-sqrt(bp^2-ap*cp))/ap])
   pp=Rs+Lp*pv
endif
return
end


                                                                                                                                                                                                                                                                                                                                                                                                                        /homes/spike/timed/sds/geom/timeconv.pro                                                            0100644 0002007 0002067 00000001512 06444010670 0021072 0                                                                                                    ustar 00spike                           timed                           0000243 0000611                                                                                                                                                                        pro gps2utc,gps,nleap,utc,vern=vern

secday=86400l
secmin=60l
minhour=60l
sechour= secmin*minhour
ver=0.
if keyword_set(vern) then ver=vern

utcbin=gps-nleap
gps0_jday=julday(1,6,1980)
days1=long(utcbin/secday)
jday_utc=gps0_jday+days1
caldat,jday_utc,um,ud,uy
jul0=julday(1,1,uy)
doy=jday_utc-jul0+1
us=double(utcbin mod secday)+ver
ss =us mod secmin
mm0=long(us/secmin)
mm=mm0 mod minhour
hh=long(us/sechour)

utc={utc,utcbin:utcbin,year:uy,month:um,day:ud,sec:us,doy:doy, $
	hour:hh,min:mm,ss:ss}
return
end

pro gps2utc_1,gps,nleap,utc,vern=vern
; array version of above routine

n=n_elements(gps)
vr=dblarr(n)
if keyword_set(vern) then vr=vern
gps2utc,gps(0),nleap(0),u0

if n le 1 then begin
   utc=u0
   return
endif

utc=replicate(u0,n)
for ic=0,n-1 do begin
   gps2utc,gps(ic),nleap(ic),u0,ver=vr(ic)
   utc(ic)=u0
endfor
return
end
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      