;+
;Purpose:
;  Returns structure containing supplementary information 
;  for analysis of FPI data.  
;
;Return value:
;  Info structure containing tables to be indexed by energy table
;  and energy/angle bin index.
;      { 
;        electron_energy: 3 x 32 array of electron energy tables
;        ion_energy:      3 x 32 array of ion energy tables
;        azimuth:         Azimuth of instrument look direction
;        elevation:       Colatitude of instrument look direction
;       }
;
;Notes:
;  These values are approximate and should only be used in the absense of official support data!
;  Energies are in eV from stepper tables.
;  The first two columns of energies correspond to stepperTableParity = 0,1 for burst data (may be indexed).
;  The last energy row is a geometric average of first two and is applicable to fast survey data.
;  
;
;$LastChangedBy: aaflores $
;$LastChangedDate: 2016-09-02 17:52:09 -0700 (Fri, 02 Sep 2016) $
;$LastChangedRevision: 21796 $
;$URL: svn+ssh://thmsvn@ambrosia.ssl.berkeley.edu/repos/spdsoft/tags/spedas_5_0/projects/mms/fpi/mms_get_fpi_info.pro $
;-
function mms_get_fpi_info

    compile_opt idl2, hidden


;ion energies
ion_energy = [ $
            [10.638297872340400, 12.056918488861300, 11.32541789], $
            [13.664712644022300, 15.486906693132800,  14.54730661], $
            [17.552090934508100, 19.892668192405900,  18.68576787], $
            [22.545362218649400, 25.551793889778200,  24.00155096], $
            [28.959134240284600, 32.820844578051800,  30.82958391], $
            [37.197515294436700, 42.157816529960400,  39.60007608], $
            [47.779575611589700, 54.150998166644300,  50.86562406], $
            [61.372052072656600, 69.556035957412300,  65.33602881], $
            [78.831356859001700, 89.343544937440200,  83.92301755], $
            [101.257536848764000, 114.760263607831000, 107.7976884], $
            [130.063583543506000, 147.407606364406000, 138.4642969], $
            [167.064460489937000, 189.342562756200000, 177.8550339], $
            [214.591457488620000, 243.207300866546000, 228.4517655], $
            [275.639076629728000, 312.395640651345000, 293.4424065], $
            [354.053704907234000, 401.266886110113000, 376.9217793], $
            [454.775960982230000, 515.420489072094000, 484.1496135], $
            [584.151985477739000, 662.048850157091000, 621.8819424], $
            [750.333288066910000, 850.390485607990000, 798.7967759], $
            [963.790344255800000, 1092.312112378110000,  1026.04087], $
            [1237.972301713850000,  1403.056326523800000,  1317.932043], $
            [1590.154361832790000,  1802.201983380580000,  1692.861289], $
            [2042.526226923880000,  2314.897789561970000,  2174.451528], $
            [2623.590192126620000,  2973.446830896790000,  2793.045997], $
            [3369.956970682050000,  3819.341871609440000,  3587.62007], $
            [4328.652400946460000,  4905.879661493580000,  4608.236949], $
            [5560.080372310320000,  6301.518969003540000,  5919.201968], $
            [7141.828653137180000,  8094.193917635170000,  7603.114233], $
            [9173.557412008650000,  10396.854393130900000, 9766.070893], $
            [11783.278440102700000, 13354.582602284200000, 12544.35193], $
            [15135.420705519600000, 17153.734171660900000, 16113.00665], $
            [19441.190420607200000, 22033.679733403100000, 20696.88294], $
            [24971.878372199800000, 28301.886792452900000, 26584.79405] ]


;electron energies
electron_energy = [ $
            [10.95890411, 12.40937936, 11.66161217], $
            [14.05183351, 15.91167611, 14.95286673], $
            [18.01767978, 20.4024254,  19.17301144], $
            [23.10280608, 26.16059799, 24.58420677], $
            [29.6231066,  33.54389854, 31.52260272], $
            [37.98363029, 43.01098657, 40.41922083], $
            [48.70374296, 55.14996905, 51.82672975], $
            [62.44939098, 70.71493421, 66.45377773], $
            [80.07447059, 90.67279651, 85.20901465], $
            [102.673873,  116.2633624, 109.2575384], $
            [131.6515005, 149.0763489, 140.0932726], $
            [168.8074782, 191.1501382, 179.63177], $
            [216.4499803, 245.0984049, 230.3292099], $
            [277.5386166, 314.2724806, 295.3349785], $
            [355.868287,  402.9695424, 378.6873127], $
            [456.3049253, 516.6995589, 485.5641602], $
            [585.0877766, 662.5275761, 622.6048397], $
            [750.2169874, 849.5126066, 798.322484], $
            [961.9505835, 1089.270386, 1023.632885], $
            [1233.441712, 1396.694958, 1312.532598], $
            [1581.555729, 1790.883908, 1682.968421], $
            [2027.917899, 2296.324729, 2157.952275], $
            [2600.256777, 2944.416016, 2766.99073], $
            [3334.126748, 3775.417982, 3547.917992], $
            [4275.116699, 4840.953473, 4549.246205], $
            [5481.682063, 6207.214841, 5833.179086], $
            [7028.776138, 7959.075893, 7479.476099], $
            [9012.506277, 10205.36435, 9590.4072], $
            [11556.10419, 13085.62237, 12297.10598], $
            [14817.58126, 16778.77506, 15767.71584], $
            [18999.54437, 21514.24552, 20217.83525], $
            [24361.78212, 27586.2069, 25923.91101] ]


;elevation grid in latitude by index
;(0th index see particles moving towards -z) 
elevation =  findgen(16) * 11.25 + 5.625 


;azimuth grid by index
;(0th index see particles moving towards -x) 
;(8th index see particles moving towards -y)
azimuth = findgen(32) * 11.25 + 5.625
azimuth = azimuth mod 360

s = { $
      electron_energy: electron_energy, $
      ion_energy: ion_energy, $
      azimuth: azimuth, $
      elevation: elevation $
     }

return, s


end