function get_akb_orb_txt_template

  tmpl = { $
    version:float(1.0), $
    datastart:long(1), $
    delimiter:byte(32), $
    missingvalue:float('NaN'), $
    commentsymbol:'', $
    fieldcount:long(40), $
    fieldtypes:long([ 3,  5,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  3,  4,  4,  4,  4,  4,  4,  4,  4,  4]), $
    fieldnames:['pass','ut', 'ksc_azm', 'ksc_elv', 'ksc_dis', 'ksc_ang', 'syo_azm', 'syo_elv', 'syo_dis', 'syo_ang', 'pra_azm', 'pra_elv', 'pra_dis', 'pra_ang', 'esr_azm', 'esr_elv', 'esr_dis', 'esr_ang', 'gclat', 'gclon', 'inv', 'fmlat', 'mlat', 'mlt', 'bmdl_x', 'bmdl_y', 'bmdl_z', 'xxlon_sc', 'xxlat_sc', 'aheight', 'lsun', 's_direc_x', 's_direc_y', 's_direc_z', 'sc_pos_x', 'sc_pos_y', 'sc_pos_z', 'sc_vel_x', 'sc_vel_y', 'sc_vel_z'], $
    fieldlocations:long([  0,  11,  25,  33,  40,  51,  58,  66,  74,  84,  91,  99, 106, 117, 124, 132, 140, 150, 157, 165, 174, 181, 189, 197, 204, 214, 224, 234, 242, 251, 258, 260, 268, 276, 286, 295, 305, 315, 321, 327]), $
    fieldgroups:long([ 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39]) $
  }
  
  return, tmpl
end

pro read_akb_orb_txt_file, fpath, dat
  
  ;Initialize the structure as an empty string ''. 
  dat = ''
   filen=n_elements(fpath)
  
  ;Error check
  npar = n_params()
  if npar ne 2 then return      ;incorrect number of arguments 
  if ~file_test(fpath) then return    ;cannot find a given data file
  
  ;Get the template structure for read_asii(). This is generated by ascii_template() usually. 
  tmpl = get_akb_orb_txt_template()
  ;Read the ascii file to store data into the structure defined by tmpl. 
  print, fpath
  dat = read_ascii( fpath, template=tmpl )
  
  return
  
end



pro akb_str2tplot, files 
 
 prefix_project = 'akb_' 
  prefix_descriptor = 'orb_'
  prefix = prefix_project + prefix_descriptor
  
 
  fln=n_elements(files)
 
 for j=0, fln-1 do begin
 afile=files(j) 
 read_akb_orb_txt_file, afile, dat
 append_array,sum_ut,dat.ut
 append_array,sum_xxlon_sc,dat.xxlon_sc
 append_array,sum_xxlat_sc,dat.xxlat_sc
 append_array,sum_ahght,dat.aheight
 append_array,sum_gclat,dat.gclat 
 append_array,sum_gclon, dat.gclon
 append_array,sum_inv,dat.inv
 append_array,sum_fmlat,dat.fmlat
 append_array,sum_mlat,dat.mlat
 append_array,sum_mlt,dat.mlt
 append_array,geo_x,dat.sc_pos_x
 append_array,geo_y,dat.sc_pos_y
 append_array,geo_z,dat.sc_pos_z
 
 endfor
 
 str_aut=string(sum_ut,format='(i12.12)')
 str_yy=strmid(str_aut,0,2)
 str_mm=strmid(str_aut,2,2)
 str_dd=strmid(str_aut,4,2)
 str_hh=strmid(str_aut,6,2)
 str_im=strmid(str_aut,8,2)
 str_se=strmid(str_aut,10,2)
str_yyyy=str_yy

 wyyyy=where(fix(str_yy) lt 80, nyyy)
 if nyyy ge 1 then str_yyyy(wyyyy)=string(fix(str_yy(wyyyy))+2000L,format='(i4.4)')  
 wyyyy=where(fix(str_yy) ge 80, nyyy)
 if nyyy ge 1 then str_yyyy(wyyyy)=string(fix(str_yy(wyyyy))+1900L  ,format='(i4.4)') 

dyymmddhrm=str_yyyy+'-'+str_mm+'-'+str_dd+'/'+str_hh+':'+str_im+':'+str_se
d_double=time_double(dyymmddhrm)

km_in_re = 6374.4

 
 ;e2=.00669438002290079D
 ;lda=6378.137
 ;Nr=double(lda/sqrt(1.-e2*sin(sum_xxlat_sc/!radeg)^2))/km_in_re
 ;sum_ahght=sum_ahght/km_in_re
 ;geo_x=(Nr+sum_ahght)*cos(sum_xxlat_sc/!radeg)*cos(sum_xxlon_sc/!radeg)
 ; geo_y=(Nr+sum_ahght)*cos(sum_xxlat_sc/!radeg)*sin(sum_xxlon_sc/!radeg)
 ; geo_z=(Nr*(1-e2)+sum_ahght)*sin(sum_xxlat_sc/!radeg)
 xyz_to_polar,[[geo_x],[geo_y],[geo_z]],mag=rr,theta=th,phi=ph,/PH_0_360
 
  store_data,prefix+'geo',data={x:d_double,y:[[geo_x/km_in_re],[geo_y/km_in_re],[geo_z/km_in_re]]},$
           dlimits={ytitle:'Position', ysubtitle:'[km]', $
                    data_att:{units:'km', coord_sys:'geo'}, $
                    labels:['X','Y','Z'], colors:[2,4,6], labflag:1, log:0B, $
                    cdf:{filename:files[0]}}
  store_data,prefix+'gdlat',data={x:d_double,y:sum_gclat}
  store_data,prefix+'gdlon',data={x:d_double,y:sum_gclon}
  store_data,prefix+'inv',data={x:d_double,y:sum_inv}
  store_data,prefix+'fmlat',data={x:d_double,y:sum_fmlat}
  store_data,prefix+'MLT',data={x:d_double,y:sum_mlt}
  store_data,prefix+'gcalt',data={x:d_double,y:rr/km_in_re}
  store_data,prefix+'gclat',data={x:d_double,y:th}
  store_data,prefix+'gclon',data={x:d_double,y:ph}
  
 ;store_data,'akb_orb_geo',data={x:d_double,y:sum_ahght}


  options,prefix+'geo','ytitle','GEO' 
  options,prefix+'geo','ysubtitle','[Re]'
  options,prefix+'gdlat','ytitle','Geodetic latitude of the magnetic footprint'
  options,prefix+'gdlat','ysubtitle', '(120km altitude) [deg]'
  options,prefix+'gdlon','ytitle','Geodetic longitude of the magnetic footprint'
  options,prefix+'gdlon','ysubtitle',' (120km altitude) [deg]'
  options,prefix+'inv','ytitle','Invariant Latitude of the magnetic footprint' 
  options,prefix+'inv','ysubtitle','(120km altitude) [deg]'
  options,prefix+'fmlat','ytitle','Geomagnetic Latitude of the magnetic footprint' 
  options,prefix+'fmlat','ysubtitle','(120km altitude) [deg]'
  options,prefix+'MLT','ytitle','Magnetic Local Time'
  options,prefix+'MLT','ysubtitle','[hours]'
  options,prefix+'gcalt','ytitle','Geocentric Altitude'
  options,prefix+'gcalt','ysubtitle','[Re]'
  options,prefix+'gclat','ytitle','Geocentric Latitude'
  options,prefix+'gclat','ysubtitle','[deg]'
  options,prefix+'gclon','ytitle','Geocentric Longitude'
  options,prefix+'gclon','ysubtitle','[deg]'
  

end
