;+
; $LastChangedBy: ali $
; $LastChangedDate: 2021-06-14 10:41:21 -0700 (Mon, 14 Jun 2021) $
; $LastChangedRevision: 30043 $
; $URL: svn+ssh://thmsvn@ambrosia.ssl.berkeley.edu/repos/spdsoft/tags/spedas_5_0/projects/SPP/COMMON/sc/spp_sc_hk_0x254_apdat__define.pro $
;-

;FSW_GC_HK_HK_TOTAL_VALID_QUAT,                                256,    4,    8;
;FSW_GC_HK_HK_ANGRATE_BODY_MAGNITUDE,                          257,    4,   32;
;FSW_GC_HK_HK_SYS_MOMENTUM_MAGNITUDE,                          261,    4,   16;
;FSW_GC_HK_HK_WHLSPD0,                                         263,    4,   16;
;FSW_GC_HK_HK_WHLSPD1,                                         265,    4,   16;
;FSW_GC_HK_HK_WHLSPD2,                                         267,    4,   16;
;FSW_GC_HK_HK_WHLSPD3,                                         269,    4,   16;
;FSW_GC_HK_HK_CTRL_MODE,                                       271,    4,    8;
;FSW_GC_HK_HK_POINTING_ACTIVITY,                               272,    4,    8;
;FSW_GC_HK_HK_SUN_SRC,                                         273,    4,    8;
;FSW_GC_HK_HK_DIST_BODY_TO_SUN_QUANTIZED,                      274,    4,    8;
;FSW_GC_HK_HK_RED_DUMP_MODE,                                   275,    4,    8;
;FSW_GC_HK_HK_WHITE_DUMP_MODE,                                 276,    4,    8;
;FSW_GC_HK_HK_DUMP_TYPE,                                       277,    4,    8;
;FSW_GC_HK_HK_WHEEL_CTRL_MODE,                                 278,    4,    8;
;FSW_GC_HK_HK_SLEW_SEG,                                        279,    4,    8;
;FSW_GC_HK_HK_THRUST_CTRL_ENA,                                 304,    4,    8;
;PDU_SWEAP_ENA_STATE,                                          565,    6,    1;
;PDU_SWEAP_PWR_STATE,                                          565,    5,    2;


function spp_SC_HK_0x254_struct,ccsds_data
if n_elements(ccsds_data) eq 0 then ccsds_data = bytarr(789)

a0 = -1047.197551197d
a1 = 0.03195793308d
spd0 = spp_swp_data_select(ccsds_data, 263*8 +7-4 ,  16)
spd1 = spp_swp_data_select(ccsds_data, 265*8 +7-4 ,  16)
spd2 = spp_swp_data_select(ccsds_data, 267*8 +7-4 ,  16)
spd3 = spp_swp_data_select(ccsds_data, 269*8 +7-4 ,  16)
spd_all = [spd0,spd1,spd2,spd3]
str = {time:   !values.d_nan  ,$
  met: !values.d_nan,  $
  seqn: 0u, $
  pkt_size: 0u,  $
;  FSW_GC_HK_HK_WHLSPD0:  spd0  , $   ;   
;  FSW_GC_HK_HK_WHLSPD1:  spd1  , $   ;
;  FSW_GC_HK_HK_WHLSPD2:  spd2  , $   ;
;  FSW_GC_HK_HK_WHLSPD3:  spd3  , $   ;
  HK_WHLSPD_RAW:  spd_all , $ 
  HK_WHLFREQ_all: (a0 + a1* spd_all)/!dpi/2 , $   ;
  HK_WHLFREQ_abs: abs(a0 + a1* spd_all)/!dpi/2 , $   ;
  
  FSW_GC_HK_HK_ANGRATE_BODY_MAGNITUDE:                    spp_swp_data_select(ccsds_data,257*8+7-4,32),$
  FSW_GC_HK_HK_SYS_MOMENTUM_MAGNITUDE:-5.0+0.00244140625* spp_swp_data_select(ccsds_data,261*8+7-4,16),$
  FSW_GC_HK_HK_CTRL_MODE:                                 spp_swp_data_select(ccsds_data,271*8+7-4, 8),$
  FSW_GC_HK_HK_POINTING_ACTIVITY:                         spp_swp_data_select(ccsds_data,272*8+7-4, 8),$
  FSW_GC_HK_HK_SUN_SRC:                                   spp_swp_data_select(ccsds_data,273*8+7-4, 8),$
  FSW_GC_HK_HK_DIST_BODY_TO_SUN_QUANTIZED:701240.0156*    spp_swp_data_select(ccsds_data,274*8+7-4, 8),$
  FSW_GC_HK_HK_RED_DUMP_MODE:                             spp_swp_data_select(ccsds_data,275*8+7-4, 8),$
  FSW_GC_HK_HK_WHITE_DUMP_MODE:                           spp_swp_data_select(ccsds_data,276*8+7-4, 8),$
  FSW_GC_HK_HK_DUMP_TYPE:                                 spp_swp_data_select(ccsds_data,277*8+7-4, 8),$
  FSW_GC_HK_HK_WHEEL_CTRL_MODE:                           spp_swp_data_select(ccsds_data,278*8+7-4, 8),$
  FSW_GC_HK_HK_SLEW_SEG:                                  spp_swp_data_select(ccsds_data,279*8+7-4, 8),$
  FSW_GC_HK_HK_THRUST_CTRL_ENA:                           spp_swp_data_select(ccsds_data,304*8+7-4, 8),$
  PDU_SWEAP_ENA_STATE:                                    spp_swp_data_select(ccsds_data,565*8+7-6, 1),$
  PDU_SWEAP_PWR_STATE:                                    spp_swp_data_select(ccsds_data,565*8+7-5, 2),$
  RIU_3A_CH15N_COUNTS:                                    spp_swp_data_select(ccsds_data,696*8+7-0,10),$ ;CalChannel for SC_HK_0x256.SWEAP_SPAN_B_ELECT_BOX_TEMP and SC_HK_0x256.SWEAP_SPAN_B_TOP_ANALYZER_TEMP
  RIU_3B_CH15N_COUNTS:                                    spp_swp_data_select(ccsds_data,701*8+7-0,10),$ ;CalChannel for SC_HK_0x256.SWEAP_SPAN_A_POS_TOP_ANALYZER_TEMP
  gap:0B}
return, str
end

;EU(Raw='SC_HK_0x254.FSW_GC_HK_HK_SYS_MOMENTUM_MAGNITUDE') := fPolynomial([-5.0, 0.00244140625], Raw)
;RIU_3A_CH15N_COUNTS,                                          696,    0,   10;
;RIU_3B_CH15N_COUNTS,                                          701,    0,   10;

function SPP_SC_HK_0x254_apdat::decom,ccsds, source_dict=source_dict   ;,ptp_header=ptp_header

ccsds_data = spp_swp_ccsds_data(ccsds)

str2 = spp_SC_HK_0x254_struct(ccsds_data)
struct_assign,ccsds,str2,/nozero

return,str2

end


PRO spp_SC_HK_0x254_apdat__define

  void = {spp_SC_HK_0x254_apdat, $
    inherits spp_gen_apdat, $    ; superclass
    flag: 0 $
  }
END


;SC_HK_0x254
;{
;( Block[778],                                                      ,     ,    8; )
;HK_HIGH_TPPH_VERSION,                                           0,    7,    3;
;HK_HIGH_TPPH_TYPE,                                              0,    4,    1;
;HK_HIGH_TPPH_SEC_HDR_FLAG,                                      0,    3,    1;
;HK_HIGH_TPPH_APID,                                              0,    2,   11;
;SC_D_APID,                                                      0,    2,   11;
;HK_HIGH_TPPH_SEQ_FLAGS,                                         2,    7,    2;
;HK_HIGH_TPPH_SEQ_CNT,                                           2,    5,   14;
;HK_HIGH_TPPH_LENGTH,                                            4,    7,   16;
;HK_HIGH_TPSH_MET_SEC,                                           6,    7,   32;
;SC_D_MET_SEC,                                                   6,    7,   32;
;HK_HIGH_TPSH_MET_SUBSEC,                                       10,    7,    8;
;HK_HIGH_TPSH_SBC_PHYS_ID,                                      11,    7,    2;
;SBC_RIO_TPPH_VERSION,                                           0,    7,    3;
;SBC_RIO_TPPH_TYPE,                                              0,    4,    1;
;SBC_RIO_TPPH_SEC_HDR_FLAG,                                      0,    3,    1;
;SBC_RIO_TPPH_APID,                                              0,    2,   11;
;SC_D_APID_DUP0,                                                 0,    2,   11;
;SBC_RIO_TPPH_SEQ_FLAGS,                                         2,    7,    2;
;SBC_RIO_TPPH_SEQ_CNT,                                           2,    5,   14;
;SBC_RIO_TPPH_LENGTH,                                            4,    7,   16;
;SBC_RIO_TPSH_MET_SEC,                                           6,    7,   32;
;SC_D_MET_SEC_DUP1,                                              6,    7,   32;
;SBC_RIO_TPSH_MET_SUBSEC,                                       10,    7,    8;
;SBC_RIO_TPSH_SBC_PHYS_ID,                                      11,    7,    2;
;PUMP_A_5HZ0_MEAS_MOTOR_SPEED,                                  12,    7,   16;
;PUMP_A_MEAS_MOTOR_SPEED,                                       12,    7,   16;
;PUMP_A_5HZ0_COMMANDED_PWM,                                     14,    7,   12;
;RIU_1A_TAC_RIU_PP,                                             15,    3,    1;
;PUMP_A_5HZ0_GOOD_CMD_CNTS,                                     15,    2,    8;
;PUMP_A_GOOD_CMD_CNTS,                                          15,    2,    8;
;PUMP_A_5HZ0_BAD_CMD_CNTS,                                      16,    2,    8;
;PUMP_A_BAD_CMD_CNTS,                                           16,    2,    8;
;PUMP_B_5HZ0_MEAS_MOTOR_SPEED,                                  17,    2,   16;
;PUMP_B_MEAS_MOTOR_SPEED,                                       17,    2,   16;
;PUMP_B_5HZ0_COMMANDED_PWM,                                     19,    2,   12;
;PUMP_B_5HZ0_GOOD_CMD_CNTS,                                     21,    6,    8;
;PUMP_B_GOOD_CMD_CNTS,                                          21,    6,    8;
;PUMP_B_5HZ0_BAD_CMD_CNTS,                                      22,    6,    8;
;PUMP_B_BAD_CMD_CNTS,                                           22,    6,    8;
;TAC_DELTA_PRESS_A0,                                            23,    6,   12;
;TAC_DELTA_PRESS_B0,                                            24,    2,   12;
;TAC_RED_DELTA_PRESS_A0,                                        26,    6,   12;
;TAC_RED_DELTA_PRESS_B0,                                        27,    2,   12;
;RIU_1A_CH3_COUNTS,                                             29,    6,   10;
;RIU_1A_CH7_COUNTS,                                             30,    4,   10;
;RIU_1A_CH12_COUNTS,                                            31,    2,   10;
;RIU_1A_CH13_COUNTS,                                            32,    0,   10;
;RIU_1A_CH14_COUNTS,                                            34,    6,   10;
;RIU_1B_CH1_COUNTS,                                             35,    4,   10;
;RIU_1B_CH3_COUNTS,                                             36,    2,   10;
;RIU_1B_CH8_COUNTS,                                             37,    0,   10;
;RIU_1B_CH12_COUNTS,                                            39,    6,   10;
;RIU_1B_CH14_COUNTS,                                            40,    4,   10;
;RIU_4A_CH12_COUNTS,                                            41,    2,   10;
;RIU_4A_CH13_COUNTS,                                            42,    0,   10;
;RIU_4A_CH14_COUNTS,                                            44,    6,   10;
;RIU_4B_CH12_COUNTS,                                            45,    4,   10;
;RIU_4B_CH13_COUNTS,                                            46,    2,   10;
;RIU_4B_CH14_COUNTS,                                            47,    0,   10;
;RIU_5A_CH11_COUNTS,                                            49,    6,   10;
;RIU_5A_CH12_COUNTS,                                            50,    4,   10;
;RIU_5A_CH13_COUNTS,                                            51,    2,   10;
;RIU_5A_CH14_COUNTS,                                            52,    0,   10;
;RIU_5B_CH11_COUNTS,                                            54,    6,   10;
;RIU_5B_CH12_COUNTS,                                            55,    4,   10;
;RIU_5B_CH13_COUNTS,                                            56,    2,   10;
;RIU_5B_CH14_COUNTS,                                            57,    0,   10;
;RIU_6A_CH1_COUNTS,                                             59,    6,   10;
;RIU_6A_CH4_COUNTS,                                             60,    4,   10;
;PDU_PRIO40_READ_PORT_VALUE_REG_7_0,                            61,    2,    8;
;PDU_PRIO42_READ_PORT_VALUE_REG_7_0,                            62,    2,    8;
;PDU_PRIO48_READ_PORT_VALUE_REG_7_0,                            63,    2,    8;
;PDU_PRIO4A_READ_PORT_VALUE_REG_7_0,                            64,    2,    8;
;PDU_PRIO80_READ_PORT_VALUE_REG_7_0,                            65,    2,    8;
;PDU_PRIO80_READ_PORT_VALUE_REG_15_8,                           66,    2,    8;
;PDU_PRIO82_READ_PORT_VALUE_REG_7_0,                            67,    2,    8;
;PDU_PRIO82_READ_PORT_VALUE_REG_15_8,                           68,    2,    8;
;PDU_PRIO84_READ_PORT_VALUE_REG_7_0,                            69,    2,    8;
;PDU_PRIO84_READ_PORT_VALUE_REG_15_8,                           70,    2,    8;
;PDU_PRIO88_READ_PORT_VALUE_REG_7_0,                            71,    2,    8;
;PDU_PRIO88_READ_PORT_VALUE_REG_15_8,                           72,    2,    8;
;PDU_PRIO8A_READ_PORT_VALUE_REG_7_0,                            73,    2,    8;
;PDU_PRIO8A_READ_PORT_VALUE_REG_15_8,                           74,    2,    8;
;PDU_PRIO8C_READ_PORT_VALUE_REG_7_0,                            75,    2,    8;
;PDU_PRIO8C_READ_PORT_VALUE_REG_15_8,                           76,    2,    8;
;PDU_PRIO90_READ_PORT_VALUE_REG_7_0,                            77,    2,    8;
;PDU_PRIO90_READ_PORT_VALUE_REG_15_8,                           78,    2,    8;
;PDU_PRIO92_READ_PORT_VALUE_REG_7_0,                            79,    2,    8;
;PDU_PRIO92_READ_PORT_VALUE_REG_15_8,                           80,    2,    8;
;PDU_PRIO94_READ_PORT_VALUE_REG_7_0,                            81,    2,    8;
;PDU_PRIO94_READ_PORT_VALUE_REG_15_8,                           82,    2,    8;
;PDU_PRIO98_READ_PORT_VALUE_REG_7_0,                            83,    2,    8;
;PDU_PRIO98_READ_PORT_VALUE_REG_15_8,                           84,    2,    8;
;PDU_PRIO9A_READ_PORT_VALUE_REG_7_0,                            85,    2,    8;
;PDU_PRIO9A_READ_PORT_VALUE_REG_15_8,                           86,    2,    8;
;PDU_PRIO9C_READ_PORT_VALUE_REG_7_0,                            87,    2,    8;
;PDU_PRIO9C_READ_PORT_VALUE_REG_15_8,                           88,    2,    8;
;PDU_PRIOA0_READ_PORT_VALUE_REG_7_0,                            89,    2,    8;
;PDU_PRIOA0_READ_PORT_VALUE_REG_15_8,                           90,    2,    8;
;PDU_PRIOA2_READ_PORT_VALUE_REG_7_0,                            91,    2,    8;
;PDU_PRIOA2_READ_PORT_VALUE_REG_15_8,                           92,    2,    8;
;PDU_PRIOA4_READ_PORT_VALUE_REG_7_0,                            93,    2,    8;
;PDU_PRIOA4_READ_PORT_VALUE_REG_15_8,                           94,    2,    8;
;PDU_PRIOA8_READ_PORT_VALUE_REG_7_0,                            95,    2,    8;
;PDU_PRIOA8_READ_PORT_VALUE_REG_15_8,                           96,    2,    8;
;PDU_PRIOAA_READ_PORT_VALUE_REG_7_0,                            97,    2,    8;
;PDU_PRIOAA_READ_PORT_VALUE_REG_15_8,                           98,    2,    8;
;PDU_PRIOAC_READ_PORT_VALUE_REG_7_0,                            99,    2,    8;
;PDU_PRIOAC_READ_PORT_VALUE_REG_15_8,                          100,    2,    8;
;RADIOA_STATUS_RESET_SRC,                                      101,    2,    8;
;RADIOA_STATUS_POWERON_RESET,                                  102,    2,    1;
;RADIOA_STATUS_SW_RESET,                                       102,    1,    1;
;RADIOA_STATUS_INT_MEM_DBL_EVENT_ERR,                          102,    0,    1;
;RADIOA_STATUS_FIRMWARE_RESET,                                 103,    7,    1;
;RADIOA_STATUS_EXT_MEM_DBL_EVENT_ERR,                          103,    6,    1;
;RADIOA_STATUS_MIPS_WDOG_TIMER,                                103,    5,    1;
;RADIOA_STATUS_RF_CCD_CLT,                                     103,    4,    1;
;RADIOA_STATUS_RX_1_CARRIER_LOOP_SWCH_LOCKOUT,                 103,    3,    1;
;RADIOA_STATUS_SW_WDOG_ENA,                                    103,    2,    1;
;RADIOA_STATUS_RX_1_CARRIER_LOCK,                              103,    1,    1;
;RADIOA_STATUS_COHERENCY_STATE,                                103,    0,    1;
;RADIOA_STATUS_DEU_SRAM_CNT,                                   104,    7,    8;
;RADIOA_STATUS_DSP_DECC_FRAME_BAD_CNT,                         105,    7,    8;
;RADIOA_STATUS_DSP_DECC_FRAME_GOOD_CNT,                        106,    7,    8;
;RADIOA_STATUS_RX_1_AGC_LEVEL,                                 107,    7,   12;
;RADIOA_STATUS_RX_1_CARRIER_AMPLITUDE,                         108,    3,   12;
;RADIOA_STATUS_RX_1_CARRIER_LOOP_SEL,                          110,    7,    2;
;RADIOA_STATUS_RX_1_SUBCAR_LOCK,                               110,    5,    1;
;RADIOA_STATUS_RX_1_COHERENCY_ENA,                             110,    4,    1;
;RADIOA_STATUS_RX_1_FAULT_STATUS,                              110,    3,    4;
;RADIOA_STATUS_DSP_TLM_DL_REJ_CNT,                             111,    7,    8;
;RADIOA_STATUS_RX_1_CARRIER_SPE,                               112,    7,   32;
;RADIOA_STATUS_RX_1_SUBCAR_SPE,                                116,    7,   32;
;RADIOA_STATUS_SEFI_DAC_CTRL_OVERRIDE,                         120,    7,    1;
;RADIOA_STATUS_SEFI_DAC_CTRL_ENA,                              120,    6,    1;
;RADIOA_STATUS_RX_1_SUBCAR_AMPLITUDE,                          120,    5,   16;
;RADIOB_STATUS_RESET_SRC,                                      122,    5,    8;
;RADIOB_STATUS_POWERON_RESET,                                  123,    5,    1;
;RADIOB_STATUS_SW_RESET,                                       123,    4,    1;
;RADIOB_STATUS_INT_MEM_DBL_EVENT_ERR,                          123,    3,    1;
;RADIOB_STATUS_FIRMWARE_RESET,                                 123,    2,    1;
;RADIOB_STATUS_EXT_MEM_DBL_EVENT_ERR,                          123,    1,    1;
;RADIOB_STATUS_MIPS_WDOG_TIMER,                                123,    0,    1;
;RADIOB_STATUS_RF_CCD_CLT,                                     124,    7,    1;
;RADIOB_STATUS_RX_1_CARRIER_LOOP_SWCH_LOCKOUT,                 124,    6,    1;
;RADIOB_STATUS_SW_WDOG_ENA,                                    124,    5,    1;
;RADIOB_STATUS_RX_1_CARRIER_LOCK,                              124,    4,    1;
;RADIOB_STATUS_COHERENCY_STATE,                                124,    3,    1;
;RADIOB_STATUS_DEU_SRAM_CNT,                                   124,    2,    8;
;RADIOB_STATUS_DSP_DECC_FRAME_BAD_CNT,                         125,    2,    8;
;RADIOB_STATUS_DSP_DECC_FRAME_GOOD_CNT,                        126,    2,    8;
;RADIOB_STATUS_RX_1_AGC_LEVEL,                                 127,    2,   12;
;RADIOB_STATUS_RX_1_CARRIER_AMPLITUDE,                         129,    6,   12;
;RADIOB_STATUS_RX_1_CARRIER_LOOP_SEL,                          130,    2,    2;
;RADIOB_STATUS_RX_1_SUBCAR_LOCK,                               130,    0,    1;
;RADIOB_STATUS_RX_1_COHERENCY_ENA,                             131,    7,    1;
;RADIOB_STATUS_RX_1_FAULT_STATUS,                              131,    6,    4;
;RADIOB_STATUS_DSP_TLM_DL_REJ_CNT,                             131,    2,    8;
;RADIOB_STATUS_RX_1_CARRIER_SPE,                               132,    2,   32;
;RADIOB_STATUS_RX_1_SUBCAR_SPE,                                136,    2,   32;
;RADIOB_STATUS_SEFI_DAC_CTRL_OVERRIDE,                         140,    2,    1;
;RADIOB_STATUS_SEFI_DAC_CTRL_ENA,                              140,    1,    1;
;RADIOB_STATUS_RX_1_SUBCAR_AMPLITUDE,                          140,    0,   16;
;PSE_5HZ_MF1_A_BATT_VOLT_A,                                    142,    0,   16;
;PSE_A_BATT_VOLT,                                              142,    0,   16;
;PSE_5HZ_MF1_A_PSE_BUS_VOLT_A,                                 144,    0,   16;
;PSE_A_PSE_BUS_VOLT,                                           144,    0,   16;
;PSE_5HZ_MF1_A_BATT_CURR_POS_A,                                146,    0,   16;
;PSE_A_BATT_CURR_POS,                                          146,    0,   16;
;PSE_5HZ_MF1_A_BATT_CURR_NEG_A,                                148,    0,   16;
;PSE_A_BATT_CURR_NEG,                                          148,    0,   16;
;PSE_5HZ_MF1_A_SC_LOAD_CURR_A,                                 150,    0,   16;
;PSE_A_SC_LOAD_CURR,                                           150,    0,   16;
;PSE_5HZ_MF1_A_SA_POSY_PRI_CURR_A,                             152,    0,   16;
;PSE_A_SA_POSY_PRI_CURR,                                       152,    0,   16;
;PSE_5HZ_MF1_A_SA_POSY_SEC_CURR_A,                             154,    0,   16;
;PSE_A_SA_POSY_SEC_CURR,                                       154,    0,   16;
;PSE_5HZ_MF1_A_SA_NEGY_PRI_CURR_A,                             156,    0,   16;
;PSE_A_SA_NEGY_PRI_CURR,                                       156,    0,   16;
;PSE_5HZ_MF1_A_SA_NEGY_SEC_CURR_A,                             158,    0,   16;
;PSE_A_SA_NEGY_SEC_CURR,                                       158,    0,   16;
;PSE_5HZ_MF1_A_SA_VOLT_A,                                      160,    0,   16;
;PSE_A_SA_VOLT,                                                160,    0,   16;
;PSE_5HZ_MF1_A_SA_SCE_POSY_1_1_ISC_A,                          162,    0,   16;
;PSE_A_SA_SCE_POSY_1_1_ISC,                                    162,    0,   16;
;PSE_5HZ_MF1_A_SA_SCE_POSY_2_1_ISC_A,                          164,    0,   16;
;PSE_A_SA_SCE_POSY_2_1_ISC,                                    164,    0,   16;
;PSE_5HZ_MF1_A_SA_SCE_NEGY_1_1_ISC_A,                          166,    0,   16;
;PSE_A_SA_SCE_NEGY_1_1_ISC,                                    166,    0,   16;
;PSE_5HZ_MF1_A_SA_SCE_NEGY_2_1_ISC_A,                          168,    0,   16;
;PSE_A_SA_SCE_NEGY_2_1_ISC,                                    168,    0,   16;
;PSE_5HZ_MF1_A_SA_PRT_POSY_PRI_1_A,                            170,    0,   16;
;PSE_A_SA_PRT_POSY_PRI_1,                                      170,    0,   16;
;PSE_5HZ_MF1_A_SA_PRT_POSY_SEC_1_A,                            172,    0,   16;
;PSE_A_SA_PRT_POSY_SEC_1,                                      172,    0,   16;
;PSE_5HZ_MF1_A_SA_PRT_NEGY_PRI_1_A,                            174,    0,   16;
;PSE_A_SA_PRT_NEGY_PRI_1,                                      174,    0,   16;
;PSE_5HZ_MF1_A_SA_PRT_NEGY_SEC_1_A,                            176,    0,   16;
;PSE_A_SA_PRT_NEGY_SEC_1,                                      176,    0,   16;
;PSE_5HZ_MF1_A_BCB_CTRLR_STATUS,                               178,    0,    1;
;PSE_A_BCB_CTRLR_STATUS,                                       178,    0,    1;
;PSE_5HZ_MF1_A_SAV_PPT_CTRLR_STATUS,                           179,    7,    1;
;PSE_A_SAV_PPT_CTRLR_STATUS,                                   179,    7,    1;
;PSE_5HZ_MF1_A_CURR_WING_NEGY_CTRLR_STATUS,                    179,    6,    1;
;PSE_A_CURR_WING_NEGY_CTRLR_STATUS,                            179,    6,    1;
;PSE_5HZ_MF1_A_CURR_WING_POSY_CTRLR_STATUS,                    179,    5,    1;
;PSE_A_CURR_WING_POSY_CTRLR_STATUS,                            179,    5,    1;
;PSE_5HZ_MF1_A_CURR_BATT_CTRLR_STATUS,                         179,    4,    1;
;PSE_A_CURR_BATT_CTRLR_STATUS,                                 179,    4,    1;
;PSE_5HZ_MF1_A_VOLT_BATT_CTRLR_STATUS,                         179,    3,    1;
;PSE_A_VOLT_BATT_CTRLR_STATUS,                                 179,    3,    1;
;PSE_5HZ_MF1_B_BATT_VOLT_B,                                    179,    2,   16;
;PSE_B_BATT_VOLT,                                              179,    2,   16;
;PSE_5HZ_MF1_B_PSE_BUS_VOLT_B,                                 181,    2,   16;
;PSE_B_PSE_BUS_VOLT,                                           181,    2,   16;
;PSE_5HZ_MF1_B_BATT_CURR_POS_B,                                183,    2,   16;
;PSE_B_BATT_CURR_POS,                                          183,    2,   16;
;PSE_5HZ_MF1_B_BATT_CURR_NEG_B,                                185,    2,   16;
;PSE_B_BATT_CURR_NEG,                                          185,    2,   16;
;PSE_5HZ_MF1_B_SC_LOAD_CURR_B,                                 187,    2,   16;
;PSE_B_SC_LOAD_CURR,                                           187,    2,   16;
;PSE_5HZ_MF1_B_SA_POSY_PRI_CURR_B,                             189,    2,   16;
;PSE_B_SA_POSY_PRI_CURR,                                       189,    2,   16;
;PSE_5HZ_MF1_B_SA_POSY_SEC_CURR_B,                             191,    2,   16;
;PSE_B_SA_POSY_SEC_CURR,                                       191,    2,   16;
;PSE_5HZ_MF1_B_SA_NEGY_PRI_CURR_B,                             193,    2,   16;
;PSE_B_SA_NEGY_PRI_CURR,                                       193,    2,   16;
;PSE_5HZ_MF1_B_SA_NEGY_SEC_CURR_B,                             195,    2,   16;
;PSE_B_SA_NEGY_SEC_CURR,                                       195,    2,   16;
;PSE_5HZ_MF1_B_SA_VOLT_B,                                      197,    2,   16;
;PSE_B_SA_VOLT,                                                197,    2,   16;
;PSE_5HZ_MF1_B_SA_SCE_POSY_1_1_ISC_B,                          199,    2,   16;
;PSE_B_SA_SCE_POSY_1_1_ISC,                                    199,    2,   16;
;PSE_5HZ_MF1_B_SA_SCE_POSY_2_1_ISC_B,                          201,    2,   16;
;PSE_B_SA_SCE_POSY_2_1_ISC,                                    201,    2,   16;
;PSE_5HZ_MF1_B_SA_SCE_NEGY_1_1_ISC_B,                          203,    2,   16;
;PSE_B_SA_SCE_NEGY_1_1_ISC,                                    203,    2,   16;
;PSE_5HZ_MF1_B_SA_SCE_NEGY_2_1_ISC_B,                          205,    2,   16;
;PSE_B_SA_SCE_NEGY_2_1_ISC,                                    205,    2,   16;
;PSE_5HZ_MF1_B_SA_PRT_POSY_PRI_1_B,                            207,    2,   16;
;PSE_B_SA_PRT_POSY_PRI_1,                                      207,    2,   16;
;PSE_5HZ_MF1_B_SA_PRT_POSY_SEC_1_B,                            209,    2,   16;
;PSE_B_SA_PRT_POSY_SEC_1,                                      209,    2,   16;
;PSE_5HZ_MF1_B_SA_PRT_NEGY_PRI_1_B,                            211,    2,   16;
;PSE_B_SA_PRT_NEGY_PRI_1,                                      211,    2,   16;
;PSE_5HZ_MF1_B_SA_PRT_NEGY_SEC_1_B,                            213,    2,   16;
;PSE_B_SA_PRT_NEGY_SEC_1,                                      213,    2,   16;
;PSE_5HZ_MF1_B_BCB_CTRLR_STATUS,                               215,    2,    1;
;PSE_B_BCB_CTRLR_STATUS,                                       215,    2,    1;
;PSE_5HZ_MF1_B_SAV_PPT_CTRLR_STATUS,                           215,    1,    1;
;PSE_B_SAV_PPT_CTRLR_STATUS,                                   215,    1,    1;
;PSE_5HZ_MF1_B_CURR_WING_NEGY_CTRLR_STATUS,                    215,    0,    1;
;PSE_B_CURR_WING_NEGY_CTRLR_STATUS,                            215,    0,    1;
;PSE_5HZ_MF1_B_CURR_WING_POSY_CTRLR_STATUS,                    216,    7,    1;
;PSE_B_CURR_WING_POSY_CTRLR_STATUS,                            216,    7,    1;
;PSE_5HZ_MF1_B_CURR_BATT_CTRLR_STATUS,                         216,    6,    1;
;PSE_B_CURR_BATT_CTRLR_STATUS,                                 216,    6,    1;
;PSE_5HZ_MF1_B_VOLT_BATT_CTRLR_STATUS,                         216,    5,    1;
;PSE_B_VOLT_BATT_CTRLR_STATUS,                                 216,    5,    1;
;FSW_GC_HK_HK_ECU_ERROR_CODE,                                  216,    4,   32;
;FSW_GC_HK_HK_ACT_ANG_CMD0,                                    220,    4,   16;
;FSW_GC_HK_HK_ACT_ANG_CMD1,                                    222,    4,   16;
;FSW_GC_HK_HK_TEMP_ARRAY_FILTER_STATE_T,                       224,    4,   16;
;FSW_GC_HK_HK_BATTERY_SOC,                                     226,    4,   16;
;FSW_GC_HK_HK_PSE_ERR_CODE,                                    228,    4,    8;
;FSW_GC_HK_HK_SMSA_HIGH_FLUX_ERR_CODE,                         229,    4,    8;
;FSW_GC_HK_HK_SMSA_LOW_FLUX_ERR_CODE,                          230,    4,    8;
;FSW_GC_HK_HK_ACTUATION_IN_PROGRESS0,                          231,    4,    8;
;FSW_GC_HK_HK_ACTUATION_IN_PROGRESS1,                          232,    4,    8;
;FSW_GC_HK_HK_ACTUATION_IN_PROGRESS2,                          233,    4,    8;
;FSW_GC_HK_HK_ACTUATION_IN_PROGRESS3,                          234,    4,    8;
;FSW_GC_HK_HK_ACTUATION_IN_PROGRESS4,                          235,    4,    8;
;FSW_GC_HK_HK_ECU_SIDE_A_FLAG,                                 236,    4,    8;
;FSW_GC_HK_HK_EPS_DATA_1HZ_VALID,                              237,    4,    8;
;FSW_GC_HK_HK_PPT_FLAG_1HZ,                                    238,    4,    8;
;FSW_GC_HK_HK_BATTERY_SOC_VALID,                               239,    4,    8;
;FSW_GC_HK_HK_TEMP_ARRAY_FILTER_STATE_VALID,                   240,    4,    8;
;FSW_GC_HK_HK_EPS_SIDE_A_FLAG,                                 241,    4,    8;
;FSW_GC_HK_HK_ST_PROC_MODE_STATUS_ST_TRANSITION_STATUS0,       242,    4,    8;
;FSW_GC_HK_HK_ST_PROC_MODE_STATUS_ST_MODE0,                    243,    4,    8;
;FSW_GC_HK_HK_ST_PROC_MODE_STATUS_ST_TRANSITION_STATUS1,       244,    4,    8;
;FSW_GC_HK_HK_ST_PROC_MODE_STATUS_ST_MODE1,                    245,    4,    8;
;FSW_GC_HK_HK_FLTR_RESET_CNT,                                  246,    4,   16;
;FSW_GC_HK_HK_OSC_ID,                                          248,    4,    8;
;FSW_GC_HK_HK_ST_VALID_NUM_MSMT0,                              249,    4,    8;
;FSW_GC_HK_HK_ST_VALID_NUM_MSMT1,                              250,    4,    8;
;FSW_GC_HK_HK_TDT_VALID,                                       251,    4,    8;
;FSW_GC_HK_HK_USE_LOCAL_TIME,                                  252,    4,    8;
;FSW_GC_HK_HK_ST_HW_PROBLEM_FLAG0,                             253,    4,    8;
;FSW_GC_HK_HK_ST_HW_PROBLEM_FLAG1,                             254,    4,    8;
;FSW_GC_HK_HK_IN_OUT_FLAG,                                     255,    4,    8;
;FSW_GC_HK_HK_TOTAL_VALID_QUAT,                                256,    4,    8;
;FSW_GC_HK_HK_ANGRATE_BODY_MAGNITUDE,                          257,    4,   32;
;FSW_GC_HK_HK_SYS_MOMENTUM_MAGNITUDE,                          261,    4,   16;
;FSW_GC_HK_HK_WHLSPD0,                                         263,    4,   16;
;FSW_GC_HK_HK_WHLSPD1,                                         265,    4,   16;
;FSW_GC_HK_HK_WHLSPD2,                                         267,    4,   16;
;FSW_GC_HK_HK_WHLSPD3,                                         269,    4,   16;
;FSW_GC_HK_HK_CTRL_MODE,                                       271,    4,    8;
;FSW_GC_HK_HK_POINTING_ACTIVITY,                               272,    4,    8;
;FSW_GC_HK_HK_SUN_SRC,                                         273,    4,    8;
;FSW_GC_HK_HK_DIST_BODY_TO_SUN_QUANTIZED,                      274,    4,    8;
;FSW_GC_HK_HK_RED_DUMP_MODE,                                   275,    4,    8;
;FSW_GC_HK_HK_WHITE_DUMP_MODE,                                 276,    4,    8;
;FSW_GC_HK_HK_DUMP_TYPE,                                       277,    4,    8;
;FSW_GC_HK_HK_WHEEL_CTRL_MODE,                                 278,    4,    8;
;FSW_GC_HK_HK_SLEW_SEG,                                        279,    4,    8;
;FSW_GC_HK_HK_BUFFER_CNT_VAL0,                                 280,    4,    8;
;FSW_GC_HK_HK_BUFFER_CNT_VAL1,                                 281,    4,    8;
;FSW_GC_HK_HK_BUFFER_CNT_VAL2,                                 282,    4,    8;
;FSW_GC_HK_HK_BUFFER_CNT_VAL3,                                 283,    4,    8;
;FSW_GC_HK_HK_SLS_WEIGHTED_SUN_PRESENCE_L30,                   284,    4,    8;
;FSW_GC_HK_HK_SLS_WEIGHTED_SUN_PRESENCE_L31,                   285,    4,    8;
;FSW_GC_HK_HK_SLS_WEIGHTED_SUN_PRESENCE_L32,                   286,    4,    8;
;FSW_GC_HK_HK_SLS_WEIGHTED_SUN_PRESENCE_L33,                   287,    4,    8;
;FSW_GC_HK_HK_SLS_WEIGHTED_SUN_PRESENCE_L34,                   288,    4,    8;
;FSW_GC_HK_HK_SLS_WEIGHTED_SUN_PRESENCE_L35,                   289,    4,    8;
;FSW_GC_HK_HK_SLS_WEIGHTED_SUN_PRESENCE_L36,                   290,    4,    8;
;FSW_GC_HK_HK_THR_CNTS_BY_SET0,                                291,    4,    8;
;FSW_GC_HK_HK_THR_CNTS_BY_SET1,                                292,    4,    8;
;FSW_GC_HK_HK_THR_CNTS_BY_SET2,                                293,    4,    8;
;FSW_GC_HK_HK_IN_SKI_AAV_UVOW,                                 294,    4,    8;
;FSW_GC_HK_HK_SOLAR_DIST_LESS_0P25AU_STICKY_FLAG,              295,    4,    8;
;FSW_GC_HK_HK_QUAT_VALID,                                      296,    4,    8;
;FSW_GC_HK_HK_RATE_VALID,                                      297,    4,    8;
;FSW_GC_HK_HK_KALMAN_INVERSE_FAIL,                             298,    4,    8;
;FSW_GC_HK_HK_CHI_SQUARED_FAIL,                                299,    4,    8;
;FSW_GC_HK_HK_PASS_QUAT_THRSHLD,                               300,    4,    8;
;FSW_GC_HK_HK_PASS_CMD_SUN_THRSHLD,                            301,    4,    8;
;FSW_GC_HK_HK_PASS_DEF_SUN_THRSHLD,                            302,    4,    8;
;FSW_GC_HK_HK_ANGRATE_ERR_IN_TOL,                              303,    4,    8;
;FSW_GC_HK_HK_THRUST_CTRL_ENA,                                 304,    4,    8;
;FSW_GC_HK_HK_USING_DEFAULT,                                   305,    4,    8;
;FSW_GC_HK_HK_RETARGET_PATH_PLAN,                              306,    4,    8;
;FSW_GC_HK_HK_IN_SKI_CMD,                                      307,    4,    8;
;FSW_GC_HK_HK_SC_EPH_VAL_FLAG,                                 308,    4,    8;
;FSW_GC_HK_HK_EARTH_EPH_VAL_FLAG,                              309,    4,    8;
;FSW_GC_HK_HK_VENUS_EPH_VAL_FLAG,                              310,    4,    8;
;FSW_GC_HK_HK_MET_VAL,                                         311,    4,    8;
;FSW_GC_HK_HK_PPSM_A_STATUS,                                   312,    4,    8;
;FSW_GC_HK_HK_GYRO_ACCEL_STATUS,                               313,    4,    8;
;FSW_GC_HK_HK_SIRU_HW_PROBLEM,                                 314,    4,    8;
;FSW_GC_HK_HK_GYRO_FAILURE_PROBLEM0,                           315,    4,    8;
;FSW_GC_HK_HK_GYRO_FAILURE_PROBLEM1,                           316,    4,    8;
;FSW_GC_HK_HK_GYRO_FAILURE_PROBLEM2,                           317,    4,    8;
;FSW_GC_HK_HK_GYRO_FAILURE_PROBLEM3,                           318,    4,    8;
;FSW_GC_HK_HK_TOTAL_VAL_FLAG_PERSIST,                          319,    4,    8;
;FSW_GC_HK_HK_SSE_DATA_DROPOUT_FLAG0,                          320,    4,    8;
;FSW_GC_HK_HK_SSE_DATA_DROPOUT_FLAG1,                          321,    4,    8;
;FSW_GC_HK_HK_DATA_VAL_LEVEL2_SLS_PACKED,                      322,    4,   16;
;FSW_GC_HK_HK_SUN_VEC_VAL_LOCK_DSS,                            324,    4,    8;
;FSW_GC_HK_HK_SP_FLAG_SLS_PACKED,                              325,    4,   16;
;FSW_GC_HK_HK_SAT_FLAG_SLS_PACKED,                             327,    4,   16;
;FSW_GC_HK_HK_SUN_PRES_FINAL_MATCH_SET_SLS_PACKED,             329,    4,    8;
;FSW_GC_HK_HK_WHEEL_SPD_DROP_CNTS_EXCEEDED,                    330,    4,    8;
;FSW_GC_HK_HK_WHEEL_GOOD0,                                     331,    4,    8;
;FSW_GC_HK_HK_WHEEL_GOOD1,                                     332,    4,    8;
;FSW_GC_HK_HK_WHEEL_GOOD2,                                     333,    4,    8;
;FSW_GC_HK_HK_WHEEL_GOOD3,                                     334,    4,    8;
;FSW_GC_HK_HK_NUM_IMU_MSGS,                                    335,    4,    8;
;FSW_GC_HK_HK_RESET_INTEGRAL_PATH,                             336,    4,    8;
;FSW_GC_HK_HK_RESET_INTEGRAL_PATH_FLAG,                        337,    4,    8;
;FSW_GC_HK_HK_SOLAR_DIST_LESS_07_AU_STKY,                      338,    4,    8;
;FSW_GC_HK_HK_SP_FLAG_DSS0,                                    339,    4,    8;
;FSW_GC_HK_HK_SP_FLAG_DSS1,                                    340,    4,    8;
;FSW_AUT_AUT_RULE_FAULT_TRIGGER_CNT,                           341,    4,   16;
;FSW_AUT_FAULT_ROLLING_AUT_RULE_NUM0,                          343,    4,   16;
;FSW_AUT_FAULT_ROLLING_AUT_RULE_MET0,                          345,    4,   32;
;FSW_SI_HK_SC_MODE,                                            349,    4,    8;
;FSW_SI_HK_PRIMARY_REM,                                        350,    4,    8;
;FSW_SI_HK_PRIMARY_RADIO,                                      351,    4,    8;
;FSW_SI_HK_PRIMARY_ECU,                                        352,    4,    8;
;FSW_SI_HK_PRIMARY_PUMP,                                       353,    4,    8;
;FSW_SI_HK_PRIMARY_IMU,                                        354,    4,    8;
;FSW_SI_HK_PRIMARY_ACTR_HTR,                                   355,    4,    8;
;FSW_SI_HK_PRIMARY_ACTUATOR_HTR,                               355,    4,    8;
;FSW_SI_HK_PRIMARY_BATT_HTR,                                   356,    4,    8;
;FSW_SI_HK_PRIMARY_TWTA_KA,                                    357,    4,    8;
;RIU_SCIF_SIDE,                                                358,    4,   32;
;RIU_C1_PROP_PRES_VIA_REM_A,                                   362,    4,   10;
;RIU_C1_PROP_PRES_VIA_REM_B,                                   363,    2,   10;
;RIU_C1_PROP_LV_A_ST,                                          364,    0,    1;
;RIU_C1_PROP_LV_B_ST,                                          365,    7,    1;
;RIU_7A_CH8_COUNTS,                                            365,    6,   10;
;RIU_7B_CH9_COUNTS,                                            366,    4,   10;
;SCIF_SCIF_SIDE,                                               367,    2,   32;
;SCIF_TEST_SCIF_B_SEL_N,                                       371,    2,    1;
;TAC_TIMECODE_TIMEOUT,                                         371,    1,    1;
;TAC_RIU_B_OVERCURR,                                           371,    0,    1;
;TAC_RIU_A_OVERCURR,                                           372,    7,    1;
;TAC_THRUST_CHNL_OVERCURR,                                     372,    6,    1;
;TAC_RIU_B_LDO_REG_STATUS,                                     372,    5,    1;
;TAC_THRUSTER_OC_12_1,                                         372,    4,   12;
;TAC_SCRUB_STATUS,                                             373,    0,   32;
;HS_FSW_SPP_HK_POR_RESET,                                      377,    0,    1;
;HS_FSW_SPP_HK_MC_RESET,                                       378,    7,    1;
;HS_FSW_SPP_HK_SW_RESET,                                       378,    6,    1;
;HS_FSW_SPP_HK_WDOG_RESET,                                     378,    5,    1;
;HS_FSW_SPP_HK_WDT_RESET,                                      378,    5,    1;
;HS_FSW_SPP_HK_FLASH_STATUS,                                   378,    4,    1;
;HS_FSW_SPP_HK_SOFTWARE_TIMER_STATUS,                          378,    3,    1;
;HS_FSW_SPP_HK_FLASH_PWR_STATUS,                               378,    2,    1;
;HS_FSW_SPP_HK_SMF,                                            378,    1,    1;
;HS_FSW_SPP_HK_IMAGE_2_WRITE_ENA,                              378,    0,    1;
;HS_FSW_SPP_HK_IMAGE_2_WRITE_ENABLE,                           378,    0,    1;
;HS_FSW_SPP_HK_IMAGE_1_WRITE_ENA,                              379,    7,    1;
;HS_FSW_SPP_HK_IMAGE_1_WRITE_ENABLE,                           379,    7,    1;
;HS_FSW_SPP_HK_MC_C_IMAGE_SEL,                                 379,    6,    1;
;HS_FSW_SPP_HK_MC_C_RESET_DCRT,                                379,    5,    1;
;HS_FSW_SPP_HK_MC_C_RESET_DISCRT,                              379,    5,    1;
;HS_FSW_SPP_HK_MC_B_IMAGE_SEL,                                 379,    4,    1;
;HS_FSW_SPP_HK_MC_B_RESET_DCRT,                                379,    3,    1;
;HS_FSW_SPP_HK_MC_B_RESET_DISCRT,                              379,    3,    1;
;HS_FSW_SPP_HK_MC_A_IMAGE_SEL,                                 379,    2,    1;
;HS_FSW_SPP_HK_MC_A_RESET_DCRT,                                379,    1,    1;
;HS_FSW_SPP_HK_MC_A_RESET_DISCRT,                              379,    1,    1;
;HS_FSW_SPP_HK_SBC_APP_IMAGE_BOOTED,                           379,    0,    2;
;HS_FSW_SPP_HK_SECONDARY_CHECKSUM_FAIL,                        380,    6,    1;
;HS_FSW_SPP_HK_PRIMARY_CHECKSUM_FAIL,                          380,    5,    1;
;HS_FSW_SPP_HK_SBC_APP_IMAGE_VOTED,                            380,    4,    2;
;HS_FSW_SPP_HK_BRKWIRE0,                                       380,    2,    1;
;HS_FSW_SPP_HK_BRKWIRE1,                                       380,    1,    1;
;HS_FSW_SPP_HK_WATCHDOG_EN_DIS,                                380,    0,    1;
;FSW_SPP_HK_POR_RESET,                                         381,    7,    1;
;FSW_SPP_HK_MC_RESET,                                          381,    6,    1;
;FSW_SPP_HK_SW_RESET,                                          381,    5,    1;
;FSW_SPP_HK_WDOG_RESET,                                        381,    4,    1;
;FSW_SPP_HK_WDT_RESET,                                         381,    4,    1;
;FSW_SPP_HK_FLASH_STATUS,                                      381,    3,    1;
;FSW_SPP_HK_SOFTWARE_TIMER_STATUS,                             381,    2,    1;
;FSW_SPP_HK_FLASH_PWR_STATUS,                                  381,    1,    1;
;FSW_SPP_HK_SMF,                                               381,    0,    1;
;FSW_SPP_HK_IMAGE_2_WRITE_ENA,                                 382,    7,    1;
;FSW_SPP_HK_IMAGE_2_WRITE_ENABLE,                              382,    7,    1;
;FSW_SPP_HK_IMAGE_1_WRITE_ENA,                                 382,    6,    1;
;FSW_SPP_HK_IMAGE_1_WRITE_ENABLE,                              382,    6,    1;
;FSW_SPP_HK_MC_C_IMAGE_SEL,                                    382,    5,    1;
;FSW_SPP_HK_MC_C_RESET_DCRT,                                   382,    4,    1;
;FSW_SPP_HK_MC_C_RESET_DISCRT,                                 382,    4,    1;
;FSW_SPP_HK_MC_B_IMAGE_SEL,                                    382,    3,    1;
;FSW_SPP_HK_MC_B_RESET_DCRT,                                   382,    2,    1;
;FSW_SPP_HK_MC_B_RESET_DISCRT,                                 382,    2,    1;
;FSW_SPP_HK_MC_A_IMAGE_SEL,                                    382,    1,    1;
;FSW_SPP_HK_MC_A_RESET_DCRT,                                   382,    0,    1;
;FSW_SPP_HK_MC_A_RESET_DISCRT,                                 382,    0,    1;
;FSW_SPP_HK_SBC_APP_IMAGE_BOOTED,                              383,    7,    2;
;FSW_SPP_HK_SECONDARY_CHECKSUM_FAIL,                           383,    5,    1;
;FSW_SPP_HK_PRIMARY_CHECKSUM_FAIL,                             383,    4,    1;
;FSW_SPP_HK_SBC_APP_IMAGE_VOTED,                               383,    3,    2;
;FSW_SPP_HK_BRKWIRE0,                                          383,    1,    1;
;FSW_SPP_HK_BRKWIRE1,                                          383,    0,    1;
;FSW_SPP_HK_WATCHDOG_EN_DIS,                                   384,    7,    1;
;BS_FSW_SPP_HK_POR_RESET,                                      384,    6,    1;
;BS_FSW_SPP_HK_MC_RESET,                                       384,    5,    1;
;BS_FSW_SPP_HK_SW_RESET,                                       384,    4,    1;
;BS_FSW_SPP_HK_WDOG_RESET,                                     384,    3,    1;
;BS_FSW_SPP_HK_WDT_RESET,                                      384,    3,    1;
;BS_FSW_SPP_HK_FLASH_STATUS,                                   384,    2,    1;
;BS_FSW_SPP_HK_SOFTWARE_TIMER_STATUS,                          384,    1,    1;
;BS_FSW_SPP_HK_FLASH_PWR_STATUS,                               384,    0,    1;
;BS_FSW_SPP_HK_SMF,                                            385,    7,    1;
;BS_FSW_SPP_HK_IMAGE_2_WRITE_ENA,                              385,    6,    1;
;BS_FSW_SPP_HK_IMAGE_2_WRITE_ENABLE,                           385,    6,    1;
;BS_FSW_SPP_HK_IMAGE_1_WRITE_ENA,                              385,    5,    1;
;BS_FSW_SPP_HK_IMAGE_1_WRITE_ENABLE,                           385,    5,    1;
;BS_FSW_SPP_HK_MC_C_IMAGE_SEL,                                 385,    4,    1;
;BS_FSW_SPP_HK_MC_C_RESET_DCRT,                                385,    3,    1;
;BS_FSW_SPP_HK_MC_C_RESET_DISCRT,                              385,    3,    1;
;BS_FSW_SPP_HK_MC_B_IMAGE_SEL,                                 385,    2,    1;
;BS_FSW_SPP_HK_MC_B_RESET_DCRT,                                385,    1,    1;
;BS_FSW_SPP_HK_MC_B_RESET_DISCRT,                              385,    1,    1;
;BS_FSW_SPP_HK_MC_A_IMAGE_SEL,                                 385,    0,    1;
;BS_FSW_SPP_HK_MC_A_RESET_DCRT,                                386,    7,    1;
;BS_FSW_SPP_HK_MC_A_RESET_DISCRT,                              386,    7,    1;
;BS_FSW_SPP_HK_SBC_APP_IMAGE_BOOTED,                           386,    6,    2;
;BS_FSW_SPP_HK_SECONDARY_CHECKSUM_FAIL,                        386,    4,    1;
;BS_FSW_SPP_HK_PRIMARY_CHECKSUM_FAIL,                          386,    3,    1;
;BS_FSW_SPP_HK_SBC_APP_IMAGE_VOTED,                            386,    2,    2;
;BS_FSW_SPP_HK_BRKWIRE0,                                       386,    0,    1;
;BS_FSW_SPP_HK_BRKWIRE1,                                       387,    7,    1;
;BS_FSW_SPP_HK_WATCHDOG_EN_DIS,                                387,    6,    1;
;FSW_CI_HK_RADIOA_CCD_CNT,                                     387,    5,   16;
;FSW_CI_HK_XPDRA_CCD_CNT,                                      387,    5,   16;
;FSW_CI_HK_RADIOB_CCD_CNT,                                     389,    5,   16;
;FSW_CI_HK_XPDRB_CCD_CNT,                                      389,    5,   16;
;FSW_CI_HK_ARC_CCD_CNT,                                        391,    5,   16;
;FSW_CI_HK_TT_RADIO_LOCK,                                      393,    5,    1;
;FSW_CI_HK_TT_XPDR_LOCK,                                       393,    5,    1;
;FSW_CI_HK_TT_RADIO_SCID,                                      393,    4,    1;
;FSW_CI_HK_TT_XPDR_SCID,                                       393,    4,    1;
;FSW_CI_HK_TT_RADIO_VCID,                                      393,    3,    1;
;FSW_CI_HK_TT_XPDR_VCID,                                       393,    3,    1;
;FSW_CI_HK_TT_RADIO_FRAME_LEN,                                 393,    2,    1;
;FSW_CI_HK_TT_RADIO_TAIL,                                      393,    1,    1;
;FSW_CI_HK_TT_XPDR_TAIL,                                       393,    1,    1;
;FSW_CI_HK_TT_RADIO_FERC,                                      393,    0,    1;
;FSW_CI_HK_TT_XPDR_FERC,                                       393,    0,    1;
;FSW_CM_HK_AUT_CMD_EXEC_SUCCESS_CNT,                           394,    7,   16;
;FSW_CM_HK_TT_CMD_EXEC_SUCCESS_CNT,                            396,    7,   16;
;FSW_CM_HK_FI_CMD_EXEC_SUCCESS_CNT,                            398,    7,   16;
;FSW_CM_HK_FI_MACRO_CMD_EXEC_SUCCESS_CNT,                      400,    7,   16;
;FSW_CM_HK_AUT_CMD_FAIL_CNT,                                   402,    7,   16;
;FSW_CM_HK_TT_CMD_FAIL_CNT,                                    404,    7,   16;
;FSW_CM_HK_FI_CMD_FAIL_CNT,                                    406,    7,   16;
;FSW_CM_HK_FI_MACRO_CMD_FAIL_CNT,                              408,    7,   16;
;FSW_CPU_HK_POR_RESET,                                         410,    7,    1;
;FSW_CPU_HK_MC_RESET,                                          410,    6,    1;
;FSW_CPU_HK_SW_RESET,                                          410,    5,    1;
;FSW_CPU_HK_WDOG_RESET,                                        410,    4,    1;
;FSW_CPU_HK_WDT_RESET,                                         410,    4,    1;
;FSW_FI_HK_CDH_FILE_CNT,                                       410,    3,   16;
;FSW_FI_HK_CDH_SEQ_CNT,                                        412,    3,   16;
;FSW_FI_HK_CDH_STATE,                                          414,    3,   16;
;FSW_FI_HK_CDH_EXEC_CMDS,                                      416,    3,   16;
;FSW_FI_HK_CDH_FAILED_CMDS,                                    418,    3,   16;
;FSW_FI_HK_CDH_PROCESSING_FILE,                                420,    3,   16;
;FSW_FI_HK_CDH_STACK_INDEX,                                    422,    3,   32;
;FSW_CPU_HK_IDLER_TASK_CYCLES,                                 426,    3,   32;
;FSW_CPU_HK_DURATION_OF_IDLER_TASK_SAMPLE,                     430,    3,   32;
;FSW_FI_HK_AUTO_DELETE_STATE,                                  434,    3,    8;
;FSW_ITF_FIELDS1_CT_VC_ALIVE_TT,                               435,    3,    1;
;FSW_ITF_FIELDS2_CT_VC_ALIVE_TT,                               435,    2,    1;
;FSW_ITF_SWEAP_CT_VC_ALIVE_TT,                                 435,    1,    1;
;FSW_ITF_EPI_HI_CT_VC_ALIVE_TT,                                435,    0,    1;
;FSW_ITF_EPI_LO_CT_VC_ALIVE_TT,                                436,    7,    1;
;FSW_ITF_WISPR_CT_VC_ALIVE_TT,                                 436,    6,    1;
;FSW_ITF_WISPR_IMAGE_VC_ALIVE_TT,                              436,    5,    1;
;FSW_ITF_WISPR_IMG_VC_ALIVE_TT,                                436,    5,    1;
;FSW_ITF_SBC_P_HS_CT_VC_ALIVE_TT,                              436,    4,    1;
;FSW_ITF_SBC_P_BS_CT_VC_ALIVE_TT,                              436,    3,    1;
;FSW_ITF_SBC_P_A_CT_VC_ALIVE_TT,                               436,    2,    1;
;FSW_ITF_SBC_P_B_CT_VC_ALIVE_TT,                               436,    1,    1;
;FSW_ITF_SBC_P_C_CT_VC_ALIVE_TT,                               436,    0,    1;
;FSW_ITF_SBC_P_HS_XSBC_VC_ALIVE_TT,                            437,    7,    1;
;FSW_ITF_SBC_P_BS_XSBC_VC_ALIVE_TT,                            437,    6,    1;
;FSW_ITF_SBC_P_A_XSBC_VC_ALIVE_TT,                             437,    5,    1;
;FSW_ITF_SBC_P_B_XSBC_VC_ALIVE_TT,                             437,    4,    1;
;FSW_ITF_SBC_P_C_XSBC_VC_ALIVE_TT,                             437,    3,    1;
;FSW_ITF_PCOM_SCIF_ACTIVE_VC_ALIVE_TT,                         437,    2,    1;
;FSW_ITF_PCOM_SCIF_BACKUP_VC_ALIVE_TT,                         437,    1,    1;
;FSW_ITF_ECUA_TLM_VC_ALIVE_TT,                                 437,    0,    1;
;FSW_ITF_ECUB_TLM_VC_ALIVE_TT,                                 438,    7,    1;
;FSW_ITF_RADIOA_TLM_VC_ALIVE_TT,                               438,    6,    1;
;FSW_ITF_RADIOB_TLM_VC_ALIVE_TT,                               438,    5,    1;
;FSW_ITF_PSEA_TLM_VC_ALIVE_TT,                                 438,    4,    1;
;FSW_ITF_PSEB_TLM_VC_ALIVE_TT,                                 438,    3,    1;
;FSW_ITF_PUMP_ELECA_TLM_VC_ALIVE_TT,                           438,    2,    1;
;FSW_ITF_PUMP_ELECB_TLM_VC_ALIVE_TT,                           438,    1,    1;
;FSW_ITF_SSEA_TLM_VC_ALIVE_TT,                                 438,    0,    1;
;FSW_ITF_SSEB_TLM_VC_ALIVE_TT,                                 439,    7,    1;
;FSW_ITF_PDUA_TLM_VC_ALIVE_TT,                                 439,    6,    1;
;FSW_ITF_PDUB_TLM_VC_ALIVE_TT,                                 439,    5,    1;
;FSW_TTAG_HK_LAST_FIRED_RULE_NUM,                              439,    4,   16;
;FSW_SI_HK_TIME_CODE_LAST_SIDE,                                441,    4,    8;
;FSW_SI_HK_SAFE_MODE_SA_FLAG,                                  442,    4,    1;
;FSW_SI_HK_SAFE_MODE_STB_FLAG,                                 442,    3,    1;
;FSW_SI_HK_SAFE_MODE_EA_FLAG,                                  442,    2,    1;
;FSW_SI_HK_OPER_MODE_LEVEL,                                    442,    1,    2;
;FSW_SI_HK_STATE_ACTIVITY_MODE,                                443,    7,    8;
;FSW_SI_HK_SBCA_LOGICAL_ID,                                    444,    7,    8;
;FSW_SI_HK_SBCB_LOGICAL_ID,                                    445,    7,    8;
;FSW_SI_HK_SBCC_LOGICAL_ID,                                    446,    7,    8;
;FSW_SI_HK_REM_TOTAL_MINOR_FRAME_SKIP_CNT,                     447,    7,   16;
;FSW_SI_HK_PROC_ROTATION_CNTR,                                 449,    7,   32;
;FSW_SI_HK_SIDE_SWCH_CNTR,                                     453,    7,   32;
;FSW_MOH_HK_COPY_DUMP_STATUS,                                  457,    7,   32;
;HS_FSW_MOH_HK_COPY_DUMP_STATUS,                               461,    7,   32;
;BS_FSW_MOH_HK_COPY_DUMP_STATUS,                               465,    7,   32;
;FSW_GC_HK_HK_FLAP_GUIDANCE_MODE,                              469,    7,    8;
;FSW_GC_HK_HK_FTHR_GUIDANCE_MODE,                              470,    7,    8;
;FSW_GC_HK_HK_HGA_GUIDANCE_MODE,                               471,    7,    8;
;FSW_AUT_AUT_RULE_MAINT_TRIGGER_CNT,                           472,    7,   16;
;FSW_AUT_AUT_RULE_SUSPEND_LEVEL,                               474,    7,   16;
;FSW_AUT_CT238_CLT_COUNTDOWN,                                  476,    7,   32;
;FSW_AUT_FAULT_ROLLING_AUT_RULE_MET1,                          480,    7,   32;
;FSW_AUT_FAULT_ROLLING_AUT_RULE_MET2,                          484,    7,   32;
;FSW_AUT_FAULT_ROLLING_AUT_RULE_NUM1,                          488,    7,   16;
;FSW_AUT_FAULT_ROLLING_AUT_RULE_NUM2,                          490,    7,   16;
;FSW_AUT_MAINT_ROLLING_AUT_RULE_MET0,                          492,    7,   32;
;FSW_AUT_MAINT_ROLLING_AUT_RULE_MET1,                          496,    7,   32;
;FSW_AUT_MAINT_ROLLING_AUT_RULE_MET2,                          500,    7,   32;
;FSW_AUT_MAINT_ROLLING_AUT_RULE_NUM0,                          504,    7,   16;
;FSW_AUT_MAINT_ROLLING_AUT_RULE_NUM1,                          506,    7,   16;
;FSW_AUT_MAINT_ROLLING_AUT_RULE_NUM2,                          508,    7,   16;
;FSW_AUT_SV036_CLT_EXPIRATION_MET,                             510,    7,   32;
;FSW_FI_HK_EPIHI_SEQ_CNT,                                      514,    7,   16;
;FSW_FI_HK_EPIHI_STATE,                                        516,    7,   16;
;FSW_FI_HK_EPILO_SEQ_CNT,                                      518,    7,   16;
;FSW_FI_HK_EPILO_STATE,                                        520,    7,   16;
;FSW_FI_HK_FIELDS1_SEQ_CNT,                                    522,    7,   16;
;FSW_FI_HK_FIELDS1_STATE,                                      524,    7,   16;
;FSW_FI_HK_FIELDS2_SEQ_CNT,                                    526,    7,   16;
;FSW_FI_HK_FIELDS2_STATE,                                      528,    7,   16;
;FSW_FI_HK_SWEAP_SEQ_CNT,                                      530,    7,   16;
;FSW_FI_HK_SWEAP_STATE,                                        532,    7,   16;
;FSW_FI_HK_WISPR_SEQ_CNT,                                      534,    7,   16;
;FSW_FI_HK_WISPR_STATE,                                        536,    7,   16;
;FSW_FM_HK_FS_ACCESS_SSR,                                      538,    7,    1;
;FSW_SI_HK_PRIMARY_PDU,                                        538,    6,    8;
;FSW_SI_HK_PRIMARY_PSE,                                        539,    6,    8;
;FSW_SI_HK_PRIMARY_TAC,                                        540,    6,    8;
;FSW_SI_TIME_REG_CRYSTAL_CLOCK_CNTR,                           541,    6,   27;
;FSW_SI_TIME_REG_EMXO_A_CLOCK_CNTR,                            544,    3,   27;
;FSW_SI_TIME_REG_EMXO_B_CLOCK_CNTR,                            547,    0,   27;
;FSW_TO_HK_TBL_SEL,                                            551,    5,    8;
;FSW_TTAG_HK_RULE_SUSPEND_LEVEL,                               552,    5,   16;
;HS_FSW_FI_HK_CDH_SEQ_CNT,                                     554,    5,   16;
;HS_FSW_FM_HK_FS_ACCESS_SSR,                                   556,    5,    1;
;BS_FSW_FI_HK_CDH_SEQ_CNT,                                     556,    4,   16;
;BS_FSW_FM_HK_FS_ACCESS_SSR,                                   558,    4,    1;
;MCA_TLM_HK_BACKUP_FAILED_PWR_STATE,                           558,    3,    1;
;MCA_TLM_HK_SW_VOTES_PDUA_PWR_STATE,                           558,    2,    1;
;MCA_TLM_HK_SW_VOTES_PDUB_PWR_STATE,                           558,    1,    1;
;MCA_TLM_HK_SW_VOTES_RADIOA_PWR_STATE,                         558,    0,    1;
;MCA_TLM_HK_SW_VOTES_RADIOB_PWR_STATE,                         559,    7,    1;
;MCA_TLM_HK_SW_VOTES_REMA_PWR_STATE,                           559,    6,    1;
;MCA_TLM_HK_SW_VOTES_REMB_PWR_STATE,                           559,    5,    1;
;MCB_TLM_HK_BACKUP_FAILED_PWR_STATE,                           559,    4,    1;
;MCB_TLM_HK_SW_VOTES_PDUA_PWR_STATE,                           559,    3,    1;
;MCB_TLM_HK_SW_VOTES_PDUB_PWR_STATE,                           559,    2,    1;
;MCB_TLM_HK_SW_VOTES_RADIOA_PWR_STATE,                         559,    1,    1;
;MCB_TLM_HK_SW_VOTES_RADIOB_PWR_STATE,                         559,    0,    1;
;MCB_TLM_HK_SW_VOTES_REMA_PWR_STATE,                           560,    7,    1;
;MCB_TLM_HK_SW_VOTES_REMB_PWR_STATE,                           560,    6,    1;
;MCC_TLM_HK_BACKUP_FAILED_PWR_STATE,                           560,    5,    1;
;MCC_TLM_HK_SW_VOTES_PDUA_PWR_STATE,                           560,    4,    1;
;MCC_TLM_HK_SW_VOTES_PDUB_PWR_STATE,                           560,    3,    1;
;MCC_TLM_HK_SW_VOTES_RADIOA_PWR_STATE,                         560,    2,    1;
;MCC_TLM_HK_SW_VOTES_RADIOB_PWR_STATE,                         560,    1,    1;
;MCC_TLM_HK_SW_VOTES_REMA_PWR_STATE,                           560,    0,    1;
;MCC_TLM_HK_SW_VOTES_REMB_PWR_STATE,                           561,    7,    1;
;PDU_EPIHI_PWR_STATE,                                          561,    6,    2;
;PDU_EPILO_PWR_STATE,                                          561,    4,    2;
;PDU_FIELDS1_ENA_STATE,                                        561,    2,    1;
;PDU_FIELDS1_PWR_STATE,                                        561,    1,    2;
;PDU_FIELDS2_ENA_STATE,                                        562,    7,    1;
;PDU_FIELDS2_PWR_STATE,                                        562,    6,    2;
;PDU_MAIN_BUS_A_VOLT,                                          562,    4,    8;
;PDU_MAIN_BUS_VOLT_RELAY_CAP_0,                                562,    4,    8;
;PDU_MAIN_BUS_B_VOLT,                                          563,    4,    8;
;PDU_MAIN_BUS_VOLT_RELAY_CAP_1,                                563,    4,    8;
;PDU_PUMP_ENA_A_FOR_PUMP_A_ENA_STATE_GRP21,                    564,    4,    1;
;PDU_PUMP_ENA_A_FOR_PUMP_A_PWR_STATE_GRP21,                    564,    3,    2;
;PDU_PUMP_ENA_A_FOR_PUMP_B_ENA_STATE_GRP21,                    564,    1,    1;
;PDU_PUMP_ENA_B_FOR_PUMP_A_PWR_STATE_GRP21,                    564,    0,    2;
;PDU_SWEAP_ENA_STATE,                                          565,    6,    1;
;PDU_SWEAP_PWR_STATE,                                          565,    5,    2;
;PDU_TOTAL_CURR_RELAY_CAP_0,                                   565,    3,    8;
;PDU_TOTAL_CURR_RELAY_CAP_1,                                   566,    3,    8;
;PDU_WISPR_ENA_STATE,                                          567,    3,    1;
;PDU_WISPR_PWR_STATE,                                          567,    2,    2;
;PSE_A_BATT_TEMP_1,                                            567,    0,   16;
;PSE_A_BATT_TEMP_2,                                            569,    0,   16;
;PSE_A_BATT_TEMP_3,                                            571,    0,   16;
;PSE_A_COUL,                                                   573,    0,   32;
;PSE_A_SA_PRT_NEGY_PRI_2,                                      577,    0,   16;
;PSE_A_SA_PRT_NEGY_SEC_2,                                      579,    0,   16;
;PSE_A_SA_PRT_POSY_PRI_2,                                      581,    0,   16;
;PSE_A_SA_PRT_POSY_SEC_2,                                      583,    0,   16;
;PSE_A_SA_SCE_NEGY_1_2_ISC,                                    585,    0,   16;
;PSE_A_SA_SCE_NEGY_2_2_ISC,                                    587,    0,   16;
;PSE_A_SA_SCE_POSY_1_2_ISC,                                    589,    0,   16;
;PSE_A_SA_SCE_POSY_2_2_ISC,                                    591,    0,   16;
;PSE_A_SOC,                                                    593,    0,   32;
;PSE_B_BATT_TEMP_1,                                            597,    0,   16;
;PSE_B_BATT_TEMP_2,                                            599,    0,   16;
;PSE_B_BATT_TEMP_3,                                            601,    0,   16;
;PSE_B_COUL,                                                   603,    0,   32;
;PSE_B_SA_PRT_NEGY_PRI_2,                                      607,    0,   16;
;PSE_B_SA_PRT_NEGY_SEC_2,                                      609,    0,   16;
;PSE_B_SA_PRT_POSY_PRI_2,                                      611,    0,   16;
;PSE_B_SA_PRT_POSY_SEC_2,                                      613,    0,   16;
;PSE_B_SA_SCE_NEGY_1_2_ISC,                                    615,    0,   16;
;PSE_B_SA_SCE_NEGY_2_2_ISC,                                    617,    0,   16;
;PSE_B_SA_SCE_POSY_1_2_ISC,                                    619,    0,   16;
;PSE_B_SA_SCE_POSY_2_2_ISC,                                    621,    0,   16;
;PSE_B_SOC,                                                    623,    0,   32;
;PSE_A_BCB1_INPUT_CURR,                                        627,    0,   16;
;PSE_A_BCB1_OUTPUT_CURR,                                       629,    0,   16;
;PSE_A_BCB2_INPUT_CURR,                                        631,    0,   16;
;PSE_A_BCB2_OUTPUT_CURR,                                       633,    0,   16;
;PSE_A_BCB3_INPUT_CURR,                                        635,    0,   16;
;PSE_A_BCB3_OUTPUT_CURR,                                       637,    0,   16;
;PSE_A_BCB4_INPUT_CURR,                                        639,    0,   16;
;PSE_A_BCB4_OUTPUT_CURR,                                       641,    0,   16;
;PSE_A_SA_NEGY_STRING_1_CURR,                                  643,    0,   16;
;PSE_A_SA_NEGY_STRING_2_CURR,                                  645,    0,   16;
;PSE_A_SA_POSY_STRING_1_CURR,                                  647,    0,   16;
;PSE_A_SA_POSY_STRING_2_CURR,                                  649,    0,   16;
;PSE_B_BCB1_INPUT_CURR,                                        651,    0,   16;
;PSE_B_BCB1_OUTPUT_CURR,                                       653,    0,   16;
;PSE_B_BCB2_INPUT_CURR,                                        655,    0,   16;
;PSE_B_BCB2_OUTPUT_CURR,                                       657,    0,   16;
;PSE_B_BCB3_INPUT_CURR,                                        659,    0,   16;
;PSE_B_BCB3_OUTPUT_CURR,                                       661,    0,   16;
;PSE_B_BCB4_INPUT_CURR,                                        663,    0,   16;
;PSE_B_BCB4_OUTPUT_CURR,                                       665,    0,   16;
;PSE_B_SA_NEGY_STRING_1_CURR,                                  667,    0,   16;
;PSE_B_SA_NEGY_STRING_2_CURR,                                  669,    0,   16;
;PSE_B_SA_POSY_STRING_1_CURR,                                  671,    0,   16;
;PSE_B_SA_POSY_STRING_2_CURR,                                  673,    0,   16;
;PUMP_A_MOTOR_ST,                                              675,    0,    1;
;PUMP_B_MOTOR_ST,                                              676,    7,    1;
;RADIOA_STATUS_MODC_RNG_ENA,                                   676,    6,    1;
;RADIOA_STATUS_OPER_MODE,                                      676,    5,    4;
;RADIOA_STATUS_RX_1_DATA_RATE,                                 676,    1,    4;
;RADIOB_STATUS_MODC_RNG_ENA,                                   677,    5,    1;
;RADIOB_STATUS_OPER_MODE,                                      677,    4,    4;
;RADIOB_STATUS_RX_1_DATA_RATE,                                 677,    0,    4;
;RIU_C2_DEVICE_DI1,                                            678,    4,    1;
;RIU_C2_DEVICE_DI2,                                            678,    3,    1;
;RIU_C2_DEVICE_DI3,                                            678,    2,    1;
;RIU_C2_DEVICE_DI4,                                            678,    1,    1;
;TAC_P1_PRESS0,                                                678,    0,   12;
;TAC_RED_P1_PRESS1,                                            680,    4,   12;
;RIU_1A_CH0_COUNTS,                                            681,    0,   10;
;RIU_1A_CH10_COUNTS,                                           683,    6,   10;
;RIU_1A_CH15N_COUNTS,                                          684,    4,   10;
;RIU_1A_CH9_COUNTS,                                            685,    2,   10;
;RIU_1B_CH0_COUNTS,                                            686,    0,   10;
;RIU_1B_CH15N_COUNTS,                                          688,    6,   10;
;RIU_1B_CH2_COUNTS,                                            689,    4,   10;
;RIU_1B_CH5_COUNTS,                                            690,    2,   10;
;RIU_3A_CH0_COUNTS,                                            691,    0,   10;
;RIU_3A_CH11_COUNTS,                                           693,    6,   10;
;RIU_3A_CH12_COUNTS,                                           694,    4,   10;
;RIU_3A_CH13_COUNTS,                                           695,    2,   10;
;RIU_3A_CH15N_COUNTS,                                          696,    0,   10;
;RIU_3B_CH0_COUNTS,                                            698,    6,   10;
;RIU_3B_CH12_COUNTS,                                           699,    4,   10;
;RIU_3B_CH13_COUNTS,                                           700,    2,   10;
;RIU_3B_CH15N_COUNTS,                                          701,    0,   10;
;RIU_7A_CH15N_COUNTS,                                          703,    6,   10;
;RIU_7B_CH15N_COUNTS,                                          704,    4,   10;
;RADIOA_STATUS_RX_1_TEMP,                                      705,    2,   12;
;RADIOB_STATUS_RX_1_TEMP,                                      707,    6,   12;
;PDU_GRP_A_CATBED_HTR_A_PWR_STATE,                             708,    2,    2;
;PDU_GRP_B_CATBED_HTR_A_PWR_STATE,                             708,    0,    2;
;PDU_GRP_C_CATBED_HTR_A_PWR_STATE,                             709,    6,    2;
;PDU_GRP_A_CATBED_HTR_B_PWR_STATE_GRP23,                       709,    4,    2;
;PDU_GRP_B_CATBED_HTR_B_PWR_STATE_GRP23,                       709,    2,    2;
;PDU_GRP_C_CATBED_HTR_B_PWR_STATE_GRP23,                       709,    0,    2;
;PDU_PROP_PRESXDCR_A_PWR_STATE,                                710,    6,    2;
;PDU_PROP_PRESXDCR_B_PWR_STATE,                                710,    4,    2;
;FSW_CPU_HK_RESET_MODE,                                        710,    2,   32;
;FSW_FM_HK_FS_ALMOST_FULL_SSR,                                 714,    2,    1;
;FSW_GC_HK_HK_AVG_WATER_TEMP,                                  714,    1,   32;
;FSW_GC_HK_HK_NO_MANIFOLD_TEMP,                                718,    1,    8;
;FSW_GC_HK_HK_ACT_ANG_CMD2,                                    719,    1,   16;
;FSW_GC_HK_HK_ACT_ANG_CMD3,                                    721,    1,   16;
;FSW_GC_HK_HK_ACT_ANG_CMD4,                                    723,    1,   16;
;FSW_GC_HK_HK_ACT_ANG_INIT_CODE2,                              725,    1,    8;
;FSW_GC_HK_HK_ACT_ANG_INIT_CODE3,                              726,    1,    8;
;FSW_GC_HK_HK_ACT_ANG_INIT_CODE4,                              727,    1,    8;
;FSW_GC_HK_HK_THR_EVT_COUNTER,                                 728,    1,    8;
;FSW_GC_HK_QUAT_I_TO_B0,                                       730,    7,   64;
;FSW_GC_HK_QUAT_I_TO_B1,                                       738,    7,   64;
;FSW_GC_HK_QUAT_I_TO_B2,                                       746,    7,   64;
;FSW_GC_HK_QUAT_I_TO_B3,                                       754,    7,   64;
;FSW_GC_HK_EST_VAL_TIME,                                       762,    7,   64;
;FSW_GC_HK_HK_SUN_AZ_BEST,                                     770,    7,   16;
;FSW_GC_HK_HK_SUN_EL_BEST,                                     772,    7,   16;
;FSW_GC_HK_HK_ST_HW_PROBLEM_CODE0,                             774,    7,    8;
;FSW_GC_HK_HK_ST_HW_PROBLEM_CODE1,                             775,    7,    8;
;FSW_GC_HK_HK_ST_HW_PROBLEM_CODE2,                             776,    7,    8;
;FSW_GC_HK_HK_ST_HW_PROBLEM_CODE3,                             777,    7,    8;
;SC_HK_HIGH_DERIVED_TRIGGER_PT,                                777,    7,    8;
;}

;#old!!
;SC_HK_0x254
;{
;( Block[789],                                                      ,     ,    8; )
;HK_HIGH_TPPH_VERSION,                                           0,    7,    3;
;HK_HIGH_TPPH_TYPE,                                              0,    4,    1;
;HK_HIGH_TPPH_SEC_HDR_FLAG,                                      0,    3,    1;
;HK_HIGH_TPPH_APID,                                              0,    2,   11;
;SC_D_APID,                                                      0,    2,   11;
;HK_HIGH_TPPH_SEQ_FLAGS,                                         2,    7,    2;
;HK_HIGH_TPPH_SEQ_CNT,                                           2,    5,   14;
;HK_HIGH_TPPH_LENGTH,                                            4,    7,   16;
;HK_HIGH_TPSH_MET_SEC,                                           6,    7,   32;
;SC_D_MET_SEC,                                                   6,    7,   32;
;HK_HIGH_TPSH_MET_SUBSEC,                                       10,    7,    8;
;HK_HIGH_TPSH_SBC_PHYS_ID,                                      11,    7,    2;
;SBC_RIO_TPPH_VERSION,                                           0,    7,    3;
;SBC_RIO_TPPH_TYPE,                                              0,    4,    1;
;SBC_RIO_TPPH_SEC_HDR_FLAG,                                      0,    3,    1;
;SBC_RIO_TPPH_APID,                                              0,    2,   11;
;SC_D_APID_DUP0,                                                 0,    2,   11;
;SBC_RIO_TPPH_SEQ_FLAGS,                                         2,    7,    2;
;SBC_RIO_TPPH_SEQ_CNT,                                           2,    5,   14;
;SBC_RIO_TPPH_LENGTH,                                            4,    7,   16;
;SBC_RIO_TPSH_MET_SEC,                                           6,    7,   32;
;SC_D_MET_SEC_DUP1,                                              6,    7,   32;
;SBC_RIO_TPSH_MET_SUBSEC,                                       10,    7,    8;
;SBC_RIO_TPSH_SBC_PHYS_ID,                                      11,    7,    2;
;PUMP_A_5HZ0_MEAS_MOTOR_SPEED,                                  12,    7,   16;
;PUMP_A_5HZ0_COMMANDED_PWM,                                     14,    7,   12;
;RIU_1A_TAC_RIU_PP,                                             15,    3,    1;
;PUMP_A_5HZ0_GOOD_CMD_CNTS,                                     15,    2,    8;
;PUMP_A_5HZ0_BAD_CMD_CNTS,                                      16,    2,    8;
;PUMP_B_5HZ0_MEAS_MOTOR_SPEED,                                  17,    2,   16;
;PUMP_B_5HZ0_COMMANDED_PWM,                                     19,    2,   12;
;PUMP_B_5HZ0_GOOD_CMD_CNTS,                                     21,    6,    8;
;PUMP_B_5HZ0_BAD_CMD_CNTS,                                      22,    6,    8;
;TAC_DELTA_PRESS_A0,                                            23,    6,   12;
;TAC_DELTA_PRESS_B0,                                            24,    2,   12;
;TAC_RED_DELTA_PRESS_A0,                                        26,    6,   12;
;TAC_RED_DELTA_PRESS_B0,                                        27,    2,   12;
;RIU_1A_CH3_COUNTS,                                             29,    6,   10;
;RIU_1A_CH7_COUNTS,                                             30,    4,   10;
;RIU_1A_CH12_COUNTS,                                            31,    2,   10;
;RIU_1A_CH13_COUNTS,                                            32,    0,   10;
;RIU_1A_CH14_COUNTS,                                            34,    6,   10;
;RIU_1B_CH1_COUNTS,                                             35,    4,   10;
;RIU_1B_CH3_COUNTS,                                             36,    2,   10;
;RIU_1B_CH8_COUNTS,                                             37,    0,   10;
;RIU_1B_CH12_COUNTS,                                            39,    6,   10;
;RIU_1B_CH14_COUNTS,                                            40,    4,   10;
;RIU_4A_CH12_COUNTS,                                            41,    2,   10;
;RIU_4A_CH13_COUNTS,                                            42,    0,   10;
;RIU_4A_CH14_COUNTS,                                            44,    6,   10;
;RIU_4B_CH12_COUNTS,                                            45,    4,   10;
;RIU_4B_CH13_COUNTS,                                            46,    2,   10;
;RIU_4B_CH14_COUNTS,                                            47,    0,   10;
;RIU_5A_CH11_COUNTS,                                            49,    6,   10;
;RIU_5A_CH12_COUNTS,                                            50,    4,   10;
;RIU_5A_CH13_COUNTS,                                            51,    2,   10;
;RIU_5A_CH14_COUNTS,                                            52,    0,   10;
;RIU_5B_CH11_COUNTS,                                            54,    6,   10;
;RIU_5B_CH12_COUNTS,                                            55,    4,   10;
;RIU_5B_CH13_COUNTS,                                            56,    2,   10;
;RIU_5B_CH14_COUNTS,                                            57,    0,   10;
;RIU_6A_CH1_COUNTS,                                             59,    6,   10;
;RIU_6A_CH4_COUNTS,                                             60,    4,   10;
;PDU_PRIO40_READ_PORT_VALUE_REG_7_0,                            61,    2,    8;
;PDU_PRIO42_READ_PORT_VALUE_REG_7_0,                            62,    2,    8;
;PDU_PRIO48_READ_PORT_VALUE_REG_7_0,                            63,    2,    8;
;PDU_PRIO4A_READ_PORT_VALUE_REG_7_0,                            64,    2,    8;
;PDU_PRIO80_READ_PORT_VALUE_REG_7_0,                            65,    2,    8;
;PDU_PRIO80_READ_PORT_VALUE_REG_15_8,                           66,    2,    8;
;PDU_PRIO82_READ_PORT_VALUE_REG_7_0,                            67,    2,    8;
;PDU_PRIO82_READ_PORT_VALUE_REG_15_8,                           68,    2,    8;
;PDU_PRIO84_READ_PORT_VALUE_REG_7_0,                            69,    2,    8;
;PDU_PRIO84_READ_PORT_VALUE_REG_15_8,                           70,    2,    8;
;PDU_PRIO88_READ_PORT_VALUE_REG_7_0,                            71,    2,    8;
;PDU_PRIO88_READ_PORT_VALUE_REG_15_8,                           72,    2,    8;
;PDU_PRIO8A_READ_PORT_VALUE_REG_7_0,                            73,    2,    8;
;PDU_PRIO8A_READ_PORT_VALUE_REG_15_8,                           74,    2,    8;
;PDU_PRIO8C_READ_PORT_VALUE_REG_7_0,                            75,    2,    8;
;PDU_PRIO8C_READ_PORT_VALUE_REG_15_8,                           76,    2,    8;
;PDU_PRIO90_READ_PORT_VALUE_REG_7_0,                            77,    2,    8;
;PDU_PRIO90_READ_PORT_VALUE_REG_15_8,                           78,    2,    8;
;PDU_PRIO92_READ_PORT_VALUE_REG_7_0,                            79,    2,    8;
;PDU_PRIO92_READ_PORT_VALUE_REG_15_8,                           80,    2,    8;
;PDU_PRIO94_READ_PORT_VALUE_REG_7_0,                            81,    2,    8;
;PDU_PRIO94_READ_PORT_VALUE_REG_15_8,                           82,    2,    8;
;PDU_PRIO98_READ_PORT_VALUE_REG_7_0,                            83,    2,    8;
;PDU_PRIO98_READ_PORT_VALUE_REG_15_8,                           84,    2,    8;
;PDU_PRIO9A_READ_PORT_VALUE_REG_7_0,                            85,    2,    8;
;PDU_PRIO9A_READ_PORT_VALUE_REG_15_8,                           86,    2,    8;
;PDU_PRIO9C_READ_PORT_VALUE_REG_7_0,                            87,    2,    8;
;PDU_PRIO9C_READ_PORT_VALUE_REG_15_8,                           88,    2,    8;
;PDU_PRIOA0_READ_PORT_VALUE_REG_7_0,                            89,    2,    8;
;PDU_PRIOA0_READ_PORT_VALUE_REG_15_8,                           90,    2,    8;
;PDU_PRIOA2_READ_PORT_VALUE_REG_7_0,                            91,    2,    8;
;PDU_PRIOA2_READ_PORT_VALUE_REG_15_8,                           92,    2,    8;
;PDU_PRIOA4_READ_PORT_VALUE_REG_7_0,                            93,    2,    8;
;PDU_PRIOA4_READ_PORT_VALUE_REG_15_8,                           94,    2,    8;
;PDU_PRIOA8_READ_PORT_VALUE_REG_7_0,                            95,    2,    8;
;PDU_PRIOA8_READ_PORT_VALUE_REG_15_8,                           96,    2,    8;
;PDU_PRIOAA_READ_PORT_VALUE_REG_7_0,                            97,    2,    8;
;PDU_PRIOAA_READ_PORT_VALUE_REG_15_8,                           98,    2,    8;
;PDU_PRIOAC_READ_PORT_VALUE_REG_7_0,                            99,    2,    8;
;PDU_PRIOAC_READ_PORT_VALUE_REG_15_8,                          100,    2,    8;
;RADIOA_STATUS_RESET_SRC,                                      101,    2,    8;
;RADIOA_STATUS_POWERON_RESET,                                  102,    2,    1;
;RADIOA_STATUS_SW_RESET,                                       102,    1,    1;
;RADIOA_STATUS_INT_MEM_DBL_EVENT_ERR,                          102,    0,    1;
;RADIOA_STATUS_FIRMWARE_RESET,                                 103,    7,    1;
;RADIOA_STATUS_EXT_MEM_DBL_EVENT_ERR,                          103,    6,    1;
;RADIOA_STATUS_MIPS_WDOG_TIMER,                                103,    5,    1;
;RADIOA_STATUS_RF_CCD_CLT,                                     103,    4,    1;
;RADIOA_STATUS_RX_1_CARRIER_LOOP_SWCH_LOCKOUT,                 103,    3,    1;
;RADIOA_STATUS_SW_WDOG_ENA,                                    103,    2,    1;
;RADIOA_STATUS_RX_1_CARRIER_LOCK,                              103,    1,    1;
;RADIOA_STATUS_COHERENCY_STATE,                                103,    0,    1;
;RADIOA_STATUS_DEU_SRAM_CNT,                                   104,    7,    8;
;RADIOA_STATUS_DSP_DECC_FRAME_BAD_CNT,                         105,    7,    8;
;RADIOA_STATUS_DSP_DECC_FRAME_GOOD_CNT,                        106,    7,    8;
;RADIOA_STATUS_RX_1_AGC_LEVEL,                                 107,    7,   12;
;RADIOA_STATUS_RX_1_CARRIER_AMPLITUDE,                         108,    3,   12;
;RADIOA_STATUS_RX_1_CARRIER_LOOP_SEL,                          110,    7,    2;
;RADIOA_STATUS_RX_1_SUBCAR_LOCK,                               110,    5,    1;
;RADIOA_STATUS_RX_1_COHERENCY_ENA,                             110,    4,    1;
;RADIOA_STATUS_RX_1_FAULT_STATUS,                              110,    3,    4;
;RADIOA_STATUS_DSP_TLM_DL_REJ_CNT,                             111,    7,    8;
;RADIOA_STATUS_RX_1_CARRIER_SPE,                               112,    7,   32;
;RADIOA_STATUS_RX_1_SUBCAR_SPE,                                116,    7,   32;
;RADIOA_STATUS_SEFI_DAC_CTRL_OVERRIDE,                         120,    7,    1;
;RADIOA_STATUS_SEFI_DAC_CTRL_ENA,                              120,    6,    1;
;RADIOA_STATUS_RX_1_SUBCAR_AMPLITUDE,                          120,    5,   16;
;RADIOB_STATUS_RESET_SRC,                                      122,    5,    8;
;RADIOB_STATUS_POWERON_RESET,                                  123,    5,    1;
;RADIOB_STATUS_SW_RESET,                                       123,    4,    1;
;RADIOB_STATUS_INT_MEM_DBL_EVENT_ERR,                          123,    3,    1;
;RADIOB_STATUS_FIRMWARE_RESET,                                 123,    2,    1;
;RADIOB_STATUS_EXT_MEM_DBL_EVENT_ERR,                          123,    1,    1;
;RADIOB_STATUS_MIPS_WDOG_TIMER,                                123,    0,    1;
;RADIOB_STATUS_RF_CCD_CLT,                                     124,    7,    1;
;RADIOB_STATUS_RX_1_CARRIER_LOOP_SWCH_LOCKOUT,                 124,    6,    1;
;RADIOB_STATUS_SW_WDOG_ENA,                                    124,    5,    1;
;RADIOB_STATUS_RX_1_CARRIER_LOCK,                              124,    4,    1;
;RADIOB_STATUS_COHERENCY_STATE,                                124,    3,    1;
;RADIOB_STATUS_DEU_SRAM_CNT,                                   124,    2,    8;
;RADIOB_STATUS_DSP_DECC_FRAME_BAD_CNT,                         125,    2,    8;
;RADIOB_STATUS_DSP_DECC_FRAME_GOOD_CNT,                        126,    2,    8;
;RADIOB_STATUS_RX_1_AGC_LEVEL,                                 127,    2,   12;
;RADIOB_STATUS_RX_1_CARRIER_AMPLITUDE,                         129,    6,   12;
;RADIOB_STATUS_RX_1_CARRIER_LOOP_SEL,                          130,    2,    2;
;RADIOB_STATUS_RX_1_SUBCAR_LOCK,                               130,    0,    1;
;RADIOB_STATUS_RX_1_COHERENCY_ENA,                             131,    7,    1;
;RADIOB_STATUS_RX_1_FAULT_STATUS,                              131,    6,    4;
;RADIOB_STATUS_DSP_TLM_DL_REJ_CNT,                             131,    2,    8;
;RADIOB_STATUS_RX_1_CARRIER_SPE,                               132,    2,   32;
;RADIOB_STATUS_RX_1_SUBCAR_SPE,                                136,    2,   32;
;RADIOB_STATUS_SEFI_DAC_CTRL_OVERRIDE,                         140,    2,    1;
;RADIOB_STATUS_SEFI_DAC_CTRL_ENA,                              140,    1,    1;
;RADIOB_STATUS_RX_1_SUBCAR_AMPLITUDE,                          140,    0,   16;
;PSE_5HZ_MF1_A_BATT_VOLT_A,                                    142,    0,   16;
;PSE_5HZ_MF1_A_PSE_BUS_VOLT_A,                                 144,    0,   16;
;PSE_5HZ_MF1_A_BATT_CURR_POS_A,                                146,    0,   16;
;PSE_5HZ_MF1_A_BATT_CURR_NEG_A,                                148,    0,   16;
;PSE_5HZ_MF1_A_SC_LOAD_CURR_A,                                 150,    0,   16;
;PSE_5HZ_MF1_A_SA_POSY_PRI_CURR_A,                             152,    0,   16;
;PSE_5HZ_MF1_A_SA_POSY_SEC_CURR_A,                             154,    0,   16;
;PSE_5HZ_MF1_A_SA_NEGY_PRI_CURR_A,                             156,    0,   16;
;PSE_5HZ_MF1_A_SA_NEGY_SEC_CURR_A,                             158,    0,   16;
;PSE_5HZ_MF1_A_SA_VOLT_A,                                      160,    0,   16;
;PSE_5HZ_MF1_A_SA_SCE_POSY_1_1_ISC_A,                          162,    0,   16;
;PSE_5HZ_MF1_A_SA_SCE_POSY_2_1_ISC_A,                          164,    0,   16;
;PSE_5HZ_MF1_A_SA_SCE_NEGY_1_1_ISC_A,                          166,    0,   16;
;PSE_5HZ_MF1_A_SA_SCE_NEGY_2_1_ISC_A,                          168,    0,   16;
;PSE_5HZ_MF1_A_SA_PRT_POSY_PRI_1_A,                            170,    0,   16;
;PSE_5HZ_MF1_A_SA_PRT_POSY_SEC_1_A,                            172,    0,   16;
;PSE_5HZ_MF1_A_SA_PRT_NEGY_PRI_1_A,                            174,    0,   16;
;PSE_5HZ_MF1_A_SA_PRT_NEGY_SEC_1_A,                            176,    0,   16;
;PSE_5HZ_MF1_A_BCB_CTRLR_STATUS,                               178,    0,    1;
;PSE_5HZ_MF1_A_SAV_PPT_CTRLR_STATUS,                           179,    7,    1;
;PSE_5HZ_MF1_A_CURR_WING_NEGY_CTRLR_STATUS,                    179,    6,    1;
;PSE_5HZ_MF1_A_CURR_WING_POSY_CTRLR_STATUS,                    179,    5,    1;
;PSE_5HZ_MF1_A_CURR_BATT_CTRLR_STATUS,                         179,    4,    1;
;PSE_5HZ_MF1_A_VOLT_BATT_CTRLR_STATUS,                         179,    3,    1;
;PSE_5HZ_MF1_B_BATT_VOLT_B,                                    179,    2,   16;
;PSE_5HZ_MF1_B_PSE_BUS_VOLT_B,                                 181,    2,   16;
;PSE_5HZ_MF1_B_BATT_CURR_POS_B,                                183,    2,   16;
;PSE_5HZ_MF1_B_BATT_CURR_NEG_B,                                185,    2,   16;
;PSE_5HZ_MF1_B_SC_LOAD_CURR_B,                                 187,    2,   16;
;PSE_5HZ_MF1_B_SA_POSY_PRI_CURR_B,                             189,    2,   16;
;PSE_5HZ_MF1_B_SA_POSY_SEC_CURR_B,                             191,    2,   16;
;PSE_5HZ_MF1_B_SA_NEGY_PRI_CURR_B,                             193,    2,   16;
;PSE_5HZ_MF1_B_SA_NEGY_SEC_CURR_B,                             195,    2,   16;
;PSE_5HZ_MF1_B_SA_VOLT_B,                                      197,    2,   16;
;PSE_5HZ_MF1_B_SA_SCE_POSY_1_1_ISC_B,                          199,    2,   16;
;PSE_5HZ_MF1_B_SA_SCE_POSY_2_1_ISC_B,                          201,    2,   16;
;PSE_5HZ_MF1_B_SA_SCE_NEGY_1_1_ISC_B,                          203,    2,   16;
;PSE_5HZ_MF1_B_SA_SCE_NEGY_2_1_ISC_B,                          205,    2,   16;
;PSE_5HZ_MF1_B_SA_PRT_POSY_PRI_1_B,                            207,    2,   16;
;PSE_5HZ_MF1_B_SA_PRT_POSY_SEC_1_B,                            209,    2,   16;
;PSE_5HZ_MF1_B_SA_PRT_NEGY_PRI_1_B,                            211,    2,   16;
;PSE_5HZ_MF1_B_SA_PRT_NEGY_SEC_1_B,                            213,    2,   16;
;PSE_5HZ_MF1_B_BCB_CTRLR_STATUS,                               215,    2,    1;
;PSE_5HZ_MF1_B_SAV_PPT_CTRLR_STATUS,                           215,    1,    1;
;PSE_5HZ_MF1_B_CURR_WING_NEGY_CTRLR_STATUS,                    215,    0,    1;
;PSE_5HZ_MF1_B_CURR_WING_POSY_CTRLR_STATUS,                    216,    7,    1;
;PSE_5HZ_MF1_B_CURR_BATT_CTRLR_STATUS,                         216,    6,    1;
;PSE_5HZ_MF1_B_VOLT_BATT_CTRLR_STATUS,                         216,    5,    1;
;FSW_GC_HK_HK_ECU_ERROR_CODE,                                  216,    4,   32;
;FSW_GC_HK_HK_ACT_ANG_CMD0,                                    220,    4,   16;
;FSW_GC_HK_HK_ACT_ANG_CMD1,                                    222,    4,   16;
;FSW_GC_HK_HK_TEMP_ARRAY_FILTER_STATE_T,                       224,    4,   16;
;FSW_GC_HK_HK_BATTERY_SOC,                                     226,    4,   16;
;FSW_GC_HK_HK_PSE_ERR_CODE,                                    228,    4,    8;
;FSW_GC_HK_HK_SMSA_HIGH_FLUX_ERR_CODE,                         229,    4,    8;
;FSW_GC_HK_HK_SMSA_LOW_FLUX_ERR_CODE,                          230,    4,    8;
;FSW_GC_HK_HK_ACTUATION_IN_PROGRESS0,                          231,    4,    8;
;FSW_GC_HK_HK_ACTUATION_IN_PROGRESS1,                          232,    4,    8;
;FSW_GC_HK_HK_ACTUATION_IN_PROGRESS2,                          233,    4,    8;
;FSW_GC_HK_HK_ACTUATION_IN_PROGRESS3,                          234,    4,    8;
;FSW_GC_HK_HK_ACTUATION_IN_PROGRESS4,                          235,    4,    8;
;FSW_GC_HK_HK_ECU_SIDE_A_FLAG,                                 236,    4,    8;
;FSW_GC_HK_HK_EPS_DATA_1HZ_VALID,                              237,    4,    8;
;FSW_GC_HK_HK_PPT_FLAG_1HZ,                                    238,    4,    8;
;FSW_GC_HK_HK_BATTERY_SOC_VALID,                               239,    4,    8;
;FSW_GC_HK_HK_TEMP_ARRAY_FILTER_STATE_VALID,                   240,    4,    8;
;FSW_GC_HK_HK_EPS_SIDE_A_FLAG,                                 241,    4,    8;
;FSW_GC_HK_HK_ST_PROC_MODE_STATUS_ST_TRANSITION_STATUS0,       242,    4,    8;
;FSW_GC_HK_HK_ST_PROC_MODE_STATUS_ST_MODE0,                    243,    4,    8;
;FSW_GC_HK_HK_ST_PROC_MODE_STATUS_ST_TRANSITION_STATUS1,       244,    4,    8;
;FSW_GC_HK_HK_ST_PROC_MODE_STATUS_ST_MODE1,                    245,    4,    8;
;FSW_GC_HK_HK_FLTR_RESET_CNT,                                  246,    4,   16;
;FSW_GC_HK_HK_OSC_ID,                                          248,    4,    8;
;FSW_GC_HK_HK_ST_VALID_NUM_MSMT0,                              249,    4,    8;
;FSW_GC_HK_HK_ST_VALID_NUM_MSMT1,                              250,    4,    8;
;FSW_GC_HK_HK_TDT_VALID,                                       251,    4,    8;
;FSW_GC_HK_HK_USE_LOCAL_TIME,                                  252,    4,    8;
;FSW_GC_HK_HK_ST_HW_PROBLEM_FLAG0,                             253,    4,    8;
;FSW_GC_HK_HK_ST_HW_PROBLEM_FLAG1,                             254,    4,    8;
;FSW_GC_HK_HK_IN_OUT_FLAG,                                     255,    4,    8;
;FSW_GC_HK_HK_TOTAL_VALID_QUAT,                                256,    4,    8;
;FSW_GC_HK_HK_ANGRATE_BODY_MAGNITUDE,                          257,    4,   32;
;FSW_GC_HK_HK_SYS_MOMENTUM_MAGNITUDE,                          261,    4,   16;
;FSW_GC_HK_HK_WHLSPD0,                                         263,    4,   16;
;FSW_GC_HK_HK_WHLSPD1,                                         265,    4,   16;
;FSW_GC_HK_HK_WHLSPD2,                                         267,    4,   16;
;FSW_GC_HK_HK_WHLSPD3,                                         269,    4,   16;
;FSW_GC_HK_HK_CTRL_MODE,                                       271,    4,    8;
;FSW_GC_HK_HK_POINTING_ACTIVITY,                               272,    4,    8;
;FSW_GC_HK_HK_SUN_SRC,                                         273,    4,    8;
;FSW_GC_HK_HK_DIST_BODY_TO_SUN_QUANTIZED,                      274,    4,    8;
;FSW_GC_HK_HK_RED_DUMP_MODE,                                   275,    4,    8;
;FSW_GC_HK_HK_WHITE_DUMP_MODE,                                 276,    4,    8;
;FSW_GC_HK_HK_DUMP_TYPE,                                       277,    4,    8;
;FSW_GC_HK_HK_WHEEL_CTRL_MODE,                                 278,    4,    8;
;FSW_GC_HK_HK_SLEW_SEG,                                        279,    4,    8;
;FSW_GC_HK_HK_BUFFER_CNT_VAL0,                                 280,    4,    8;
;FSW_GC_HK_HK_BUFFER_CNT_VAL1,                                 281,    4,    8;
;FSW_GC_HK_HK_BUFFER_CNT_VAL2,                                 282,    4,    8;
;FSW_GC_HK_HK_BUFFER_CNT_VAL3,                                 283,    4,    8;
;FSW_GC_HK_HK_SLS_WEIGHTED_SUN_PRESENCE_L30,                   284,    4,    8;
;FSW_GC_HK_HK_SLS_WEIGHTED_SUN_PRESENCE_L31,                   285,    4,    8;
;FSW_GC_HK_HK_SLS_WEIGHTED_SUN_PRESENCE_L32,                   286,    4,    8;
;FSW_GC_HK_HK_SLS_WEIGHTED_SUN_PRESENCE_L33,                   287,    4,    8;
;FSW_GC_HK_HK_SLS_WEIGHTED_SUN_PRESENCE_L34,                   288,    4,    8;
;FSW_GC_HK_HK_SLS_WEIGHTED_SUN_PRESENCE_L35,                   289,    4,    8;
;FSW_GC_HK_HK_SLS_WEIGHTED_SUN_PRESENCE_L36,                   290,    4,    8;
;FSW_GC_HK_HK_THR_CNTS_BY_SET0,                                291,    4,    8;
;FSW_GC_HK_HK_THR_CNTS_BY_SET1,                                292,    4,    8;
;FSW_GC_HK_HK_THR_CNTS_BY_SET2,                                293,    4,    8;
;FSW_GC_HK_HK_IN_SKI_AAV_UVOW,                                 294,    4,    8;
;FSW_GC_HK_HK_SOLAR_DIST_LESS_0P25AU_STICKY_FLAG,              295,    4,    8;
;FSW_GC_HK_HK_QUAT_VALID,                                      296,    4,    8;
;FSW_GC_HK_HK_RATE_VALID,                                      297,    4,    8;
;FSW_GC_HK_HK_KALMAN_INVERSE_FAIL,                             298,    4,    8;
;FSW_GC_HK_HK_CHI_SQUARED_FAIL,                                299,    4,    8;
;FSW_GC_HK_HK_PASS_QUAT_THRSHLD,                               300,    4,    8;
;FSW_GC_HK_HK_PASS_CMD_SUN_THRSHLD,                            301,    4,    8;
;FSW_GC_HK_HK_PASS_DEF_SUN_THRSHLD,                            302,    4,    8;
;FSW_GC_HK_HK_ANGRATE_ERR_IN_TOL,                              303,    4,    8;
;FSW_GC_HK_HK_THRUST_CTRL_ENA,                                 304,    4,    8;
;FSW_GC_HK_HK_USING_DEFAULT,                                   305,    4,    8;
;FSW_GC_HK_HK_RETARGET_PATH_PLAN,                              306,    4,    8;
;FSW_GC_HK_HK_IN_SKI_CMD,                                      307,    4,    8;
;FSW_GC_HK_HK_SC_EPH_VAL_FLAG,                                 308,    4,    8;
;FSW_GC_HK_HK_EARTH_EPH_VAL_FLAG,                              309,    4,    8;
;FSW_GC_HK_HK_VENUS_EPH_VAL_FLAG,                              310,    4,    8;
;FSW_GC_HK_HK_MET_VAL,                                         311,    4,    8;
;FSW_GC_HK_HK_PPSM_A_STATUS,                                   312,    4,    8;
;FSW_GC_HK_HK_GYRO_STATUS0,                                    313,    4,    8;
;FSW_GC_HK_HK_GYRO_STATUS1,                                    314,    4,    8;
;FSW_GC_HK_HK_GYRO_STATUS2,                                    315,    4,    8;
;FSW_GC_HK_HK_GYRO_STATUS3,                                    316,    4,    8;
;FSW_GC_HK_HK_ACCEL_STATUS0,                                   317,    4,    8;
;FSW_GC_HK_HK_ACCEL_STATUS1,                                   318,    4,    8;
;FSW_GC_HK_HK_ACCEL_STATUS2,                                   319,    4,    8;
;FSW_GC_HK_HK_ACCEL_STATUS3,                                   320,    4,    8;
;FSW_GC_HK_HK_SIRU_HW_PROBLEM,                                 321,    4,    8;
;FSW_GC_HK_HK_GYRO_FAILURE_PROBLEM0,                           322,    4,    8;
;FSW_GC_HK_HK_GYRO_FAILURE_PROBLEM1,                           323,    4,    8;
;FSW_GC_HK_HK_GYRO_FAILURE_PROBLEM2,                           324,    4,    8;
;FSW_GC_HK_HK_GYRO_FAILURE_PROBLEM3,                           325,    4,    8;
;FSW_GC_HK_HK_TOTAL_VAL_FLAG_PERSIST,                          326,    4,    8;
;FSW_GC_HK_HK_SSE_DATA_DROPOUT_FLAG0,                          327,    4,    8;
;FSW_GC_HK_HK_SSE_DATA_DROPOUT_FLAG1,                          328,    4,    8;
;FSW_GC_HK_HK_DATA_VAL_LEVEL2_SLS0,                            329,    4,    8;
;FSW_GC_HK_HK_DATA_VAL_LEVEL2_SLS1,                            330,    4,    8;
;FSW_GC_HK_HK_DATA_VAL_LEVEL2_SLS2,                            331,    4,    8;
;FSW_GC_HK_HK_DATA_VAL_LEVEL2_SLS3,                            332,    4,    8;
;FSW_GC_HK_HK_DATA_VAL_LEVEL2_SLS4,                            333,    4,    8;
;FSW_GC_HK_HK_DATA_VAL_LEVEL2_SLS5,                            334,    4,    8;
;FSW_GC_HK_HK_DATA_VAL_LEVEL2_SLS6,                            335,    4,    8;
;FSW_GC_HK_HK_DATA_VAL_LEVEL2_SLS7,                            336,    4,    8;
;FSW_GC_HK_HK_DATA_VAL_LEVEL2_SLS8,                            337,    4,    8;
;FSW_GC_HK_HK_DATA_VAL_LEVEL2_SLS9,                            338,    4,    8;
;FSW_GC_HK_HK_DATA_VAL_LEVEL2_SLS10,                           339,    4,    8;
;FSW_GC_HK_HK_DATA_VAL_LEVEL2_SLS11,                           340,    4,    8;
;FSW_GC_HK_HK_DATA_VAL_LEVEL2_SLS12,                           341,    4,    8;
;FSW_GC_HK_HK_DATA_VAL_LEVEL2_SLS13,                           342,    4,    8;
;FSW_GC_HK_HK_SUN_VEC_VAL_DSS0,                                343,    4,    8;
;FSW_GC_HK_HK_SUN_VEC_VAL_DSS1,                                344,    4,    8;
;FSW_GC_HK_HK_SP_FLAG_SLS0,                                    345,    4,    8;
;FSW_GC_HK_HK_SP_FLAG_SLS1,                                    346,    4,    8;
;FSW_GC_HK_HK_SP_FLAG_SLS2,                                    347,    4,    8;
;FSW_GC_HK_HK_SP_FLAG_SLS3,                                    348,    4,    8;
;FSW_GC_HK_HK_SP_FLAG_SLS4,                                    349,    4,    8;
;FSW_GC_HK_HK_SP_FLAG_SLS5,                                    350,    4,    8;
;FSW_GC_HK_HK_SP_FLAG_SLS6,                                    351,    4,    8;
;FSW_GC_HK_HK_SP_FLAG_SLS7,                                    352,    4,    8;
;FSW_GC_HK_HK_SP_FLAG_SLS8,                                    353,    4,    8;
;FSW_GC_HK_HK_SP_FLAG_SLS9,                                    354,    4,    8;
;FSW_GC_HK_HK_SP_FLAG_SLS10,                                   355,    4,    8;
;FSW_GC_HK_HK_SP_FLAG_SLS11,                                   356,    4,    8;
;FSW_GC_HK_HK_SP_FLAG_SLS12,                                   357,    4,    8;
;FSW_GC_HK_HK_SP_FLAG_SLS13,                                   358,    4,    8;
;FSW_GC_HK_HK_SAT_FLAG_SLS0,                                   359,    4,    8;
;FSW_GC_HK_HK_SAT_FLAG_SLS1,                                   360,    4,    8;
;FSW_GC_HK_HK_SAT_FLAG_SLS2,                                   361,    4,    8;
;FSW_GC_HK_HK_SAT_FLAG_SLS3,                                   362,    4,    8;
;FSW_GC_HK_HK_SAT_FLAG_SLS4,                                   363,    4,    8;
;FSW_GC_HK_HK_SAT_FLAG_SLS5,                                   364,    4,    8;
;FSW_GC_HK_HK_SAT_FLAG_SLS6,                                   365,    4,    8;
;FSW_GC_HK_HK_SAT_FLAG_SLS7,                                   366,    4,    8;
;FSW_GC_HK_HK_SAT_FLAG_SLS8,                                   367,    4,    8;
;FSW_GC_HK_HK_SAT_FLAG_SLS9,                                   368,    4,    8;
;FSW_GC_HK_HK_SAT_FLAG_SLS10,                                  369,    4,    8;
;FSW_GC_HK_HK_SAT_FLAG_SLS11,                                  370,    4,    8;
;FSW_GC_HK_HK_SAT_FLAG_SLS12,                                  371,    4,    8;
;FSW_GC_HK_HK_SAT_FLAG_SLS13,                                  372,    4,    8;
;FSW_GC_HK_HK_SUN_PRESENCE_FINAL_MATCH_SET_SLS0,               373,    4,    8;
;FSW_GC_HK_HK_SUN_PRESENCE_FINAL_MATCH_SET_SLS1,               374,    4,    8;
;FSW_GC_HK_HK_SUN_PRESENCE_FINAL_MATCH_SET_SLS2,               375,    4,    8;
;FSW_GC_HK_HK_SUN_PRESENCE_FINAL_MATCH_SET_SLS3,               376,    4,    8;
;FSW_GC_HK_HK_SUN_PRESENCE_FINAL_MATCH_SET_SLS4,               377,    4,    8;
;FSW_GC_HK_HK_SUN_PRESENCE_FINAL_MATCH_SET_SLS5,               378,    4,    8;
;FSW_GC_HK_HK_SUN_PRESENCE_FINAL_MATCH_SET_SLS6,               379,    4,    8;
;FSW_GC_HK_HK_WHEEL_SPD_DROP_CNTS_EXCEEDED,                    380,    4,    8;
;FSW_GC_HK_HK_WHEEL_GOOD0,                                     381,    4,    8;
;FSW_GC_HK_HK_WHEEL_GOOD1,                                     382,    4,    8;
;FSW_GC_HK_HK_WHEEL_GOOD2,                                     383,    4,    8;
;FSW_GC_HK_HK_WHEEL_GOOD3,                                     384,    4,    8;
;FSW_GC_HK_HK_NUM_IMU_MSGS,                                    385,    4,    8;
;FSW_GC_HK_HK_RESET_INTEGRAL_PATH,                             386,    4,    8;
;FSW_GC_HK_HK_RESET_INTEGRAL_PATH_FLAG,                        387,    4,    8;
;FSW_GC_HK_HK_SOLAR_DIST_LESS_07_AU_STKY,                      388,    4,    8;
;FSW_GC_HK_HK_SP_FLAG_DSS0,                                    389,    4,    8;
;FSW_GC_HK_HK_SP_FLAG_DSS1,                                    390,    4,    8;
;FSW_AUT_AUT_RULE_FAULT_TRIGGER_CNT,                           391,    4,   16;
;FSW_AUT_FAULT_ROLLING_AUT_RULE_NUM0,                          393,    4,   16;
;FSW_AUT_FAULT_ROLLING_AUT_RULE_MET0,                          395,    4,   32;
;FSW_SI_HK_SC_MODE,                                            399,    4,    8;
;FSW_SI_HK_PRIMARY_REM,                                        400,    4,    8;
;FSW_SI_HK_PRIMARY_RADIO,                                      401,    4,    8;
;FSW_SI_HK_PRIMARY_ECU,                                        402,    4,    8;
;FSW_SI_HK_PRIMARY_PUMP,                                       403,    4,    8;
;FSW_SI_HK_PRIMARY_IMU,                                        404,    4,    8;
;FSW_SI_HK_PRIMARY_ACTR_HTR,                                   405,    4,    8;
;FSW_SI_HK_PRIMARY_BATT_HTR,                                   406,    4,    8;
;FSW_SI_HK_PRIMARY_TWTA_KA,                                    407,    4,    8;
;RIU_SCIF_SIDE,                                                408,    4,   32;
;RIU_C1_PROP_PRES_VIA_REM_A,                                   412,    4,   10;
;RIU_C1_PROP_PRES_VIA_REM_B,                                   413,    2,   10;
;RIU_C1_PROP_LV_A_ST,                                          414,    0,    1;
;RIU_C1_PROP_LV_B_ST,                                          415,    7,    1;
;RIU_7A_CH8_COUNTS,                                            415,    6,   10;
;RIU_7B_CH9_COUNTS,                                            416,    4,   10;
;SCIF_SCIF_SIDE,                                               417,    2,   32;
;SCIF_TEST_SCIF_B_SEL_N,                                       421,    2,    1;
;SCIF_RED_SCIF_SIDE,                                           421,    1,   32;
;SCIF_RED_TEST_SCIF_B_SEL_N,                                   425,    1,    1;
;TAC_TIMECODE_TIMEOUT,                                         425,    0,    1;
;TAC_RIU_B_OVERCURR,                                           426,    7,    1;
;TAC_RIU_A_OVERCURR,                                           426,    6,    1;
;TAC_THRUST_CHNL_OVERCURR,                                     426,    5,    1;
;TAC_RIU_B_LDO_REG_STATUS,                                     426,    4,    1;
;TAC_THRUSTER_OC_12_1,                                         426,    3,   12;
;TAC_SCRUB_STATUS,                                             428,    7,   32;
;TAC_RED_TIMECODE_TIMEOUT,                                     432,    7,    1;
;TAC_RED_RIU_B_OVERCURR,                                       432,    6,    1;
;TAC_RED_RIU_A_OVERCURR,                                       432,    5,    1;
;TAC_RED_THRUST_CHNL_OVERCURR,                                 432,    4,    1;
;TAC_RED_RIU_B_LDO_REG_STATUS,                                 432,    3,    1;
;TAC_RED_THRUSTER_OC_12_1,                                     432,    2,   12;
;TAC_RED_SCRUB_STATUS,                                         434,    6,   32;
;HS_FSW_SPP_HK_POR_RESET,                                      438,    6,    1;
;HS_FSW_SPP_HK_MC_RESET,                                       438,    5,    1;
;HS_FSW_SPP_HK_SW_RESET,                                       438,    4,    1;
;HS_FSW_SPP_HK_WDOG_RESET,                                     438,    3,    1;
;HS_FSW_SPP_HK_FLASH_STATUS,                                   438,    2,    1;
;HS_FSW_SPP_HK_SOFTWARE_TIMER_STATUS,                          438,    1,    1;
;HS_FSW_SPP_HK_FLASH_PWR_STATUS,                               438,    0,    1;
;HS_FSW_SPP_HK_SMF,                                            439,    7,    1;
;HS_FSW_SPP_HK_IMAGE_2_WRITE_ENA,                              439,    6,    1;
;HS_FSW_SPP_HK_IMAGE_1_WRITE_ENA,                              439,    5,    1;
;HS_FSW_SPP_HK_MC_C_IMAGE_SEL,                                 439,    4,    1;
;HS_FSW_SPP_HK_MC_C_RESET_DCRT,                                439,    3,    1;
;HS_FSW_SPP_HK_MC_B_IMAGE_SEL,                                 439,    2,    1;
;HS_FSW_SPP_HK_MC_B_RESET_DCRT,                                439,    1,    1;
;HS_FSW_SPP_HK_MC_A_IMAGE_SEL,                                 439,    0,    1;
;HS_FSW_SPP_HK_MC_A_RESET_DCRT,                                440,    7,    1;
;HS_FSW_SPP_HK_SBC_APP_IMAGE_BOOTED,                           440,    6,    2;
;HS_FSW_SPP_HK_SECONDARY_CHECKSUM_FAIL,                        440,    4,    1;
;HS_FSW_SPP_HK_PRIMARY_CHECKSUM_FAIL,                          440,    3,    1;
;HS_FSW_SPP_HK_SBC_APP_IMAGE_VOTED,                            440,    2,    2;
;HS_FSW_SPP_HK_BRKWIRE0,                                       440,    0,    1;
;HS_FSW_SPP_HK_BRKWIRE1,                                       441,    7,    1;
;HS_FSW_SPP_HK_WATCHDOG_EN_DIS,                                441,    6,    1;
;FSW_SPP_HK_POR_RESET,                                         441,    5,    1;
;FSW_SPP_HK_MC_RESET,                                          441,    4,    1;
;FSW_SPP_HK_SW_RESET,                                          441,    3,    1;
;FSW_SPP_HK_WDOG_RESET,                                        441,    2,    1;
;FSW_SPP_HK_FLASH_STATUS,                                      441,    1,    1;
;FSW_SPP_HK_SOFTWARE_TIMER_STATUS,                             441,    0,    1;
;FSW_SPP_HK_FLASH_PWR_STATUS,                                  442,    7,    1;
;FSW_SPP_HK_SMF,                                               442,    6,    1;
;FSW_SPP_HK_IMAGE_2_WRITE_ENA,                                 442,    5,    1;
;FSW_SPP_HK_IMAGE_1_WRITE_ENA,                                 442,    4,    1;
;FSW_SPP_HK_MC_C_IMAGE_SEL,                                    442,    3,    1;
;FSW_SPP_HK_MC_C_RESET_DCRT,                                   442,    2,    1;
;FSW_SPP_HK_MC_B_IMAGE_SEL,                                    442,    1,    1;
;FSW_SPP_HK_MC_B_RESET_DCRT,                                   442,    0,    1;
;FSW_SPP_HK_MC_A_IMAGE_SEL,                                    443,    7,    1;
;FSW_SPP_HK_MC_A_RESET_DCRT,                                   443,    6,    1;
;FSW_SPP_HK_SBC_APP_IMAGE_BOOTED,                              443,    5,    2;
;FSW_SPP_HK_SECONDARY_CHECKSUM_FAIL,                           443,    3,    1;
;FSW_SPP_HK_PRIMARY_CHECKSUM_FAIL,                             443,    2,    1;
;FSW_SPP_HK_SBC_APP_IMAGE_VOTED,                               443,    1,    2;
;FSW_SPP_HK_BRKWIRE0,                                          444,    7,    1;
;FSW_SPP_HK_BRKWIRE1,                                          444,    6,    1;
;FSW_SPP_HK_WATCHDOG_EN_DIS,                                   444,    5,    1;
;BS_FSW_SPP_HK_POR_RESET,                                      444,    4,    1;
;BS_FSW_SPP_HK_MC_RESET,                                       444,    3,    1;
;BS_FSW_SPP_HK_SW_RESET,                                       444,    2,    1;
;BS_FSW_SPP_HK_WDOG_RESET,                                     444,    1,    1;
;BS_FSW_SPP_HK_FLASH_STATUS,                                   444,    0,    1;
;BS_FSW_SPP_HK_SOFTWARE_TIMER_STATUS,                          445,    7,    1;
;BS_FSW_SPP_HK_FLASH_PWR_STATUS,                               445,    6,    1;
;BS_FSW_SPP_HK_SMF,                                            445,    5,    1;
;BS_FSW_SPP_HK_IMAGE_2_WRITE_ENA,                              445,    4,    1;
;BS_FSW_SPP_HK_IMAGE_1_WRITE_ENA,                              445,    3,    1;
;BS_FSW_SPP_HK_MC_C_IMAGE_SEL,                                 445,    2,    1;
;BS_FSW_SPP_HK_MC_C_RESET_DCRT,                                445,    1,    1;
;BS_FSW_SPP_HK_MC_B_IMAGE_SEL,                                 445,    0,    1;
;BS_FSW_SPP_HK_MC_B_RESET_DCRT,                                446,    7,    1;
;BS_FSW_SPP_HK_MC_A_IMAGE_SEL,                                 446,    6,    1;
;BS_FSW_SPP_HK_MC_A_RESET_DCRT,                                446,    5,    1;
;BS_FSW_SPP_HK_SBC_APP_IMAGE_BOOTED,                           446,    4,    2;
;BS_FSW_SPP_HK_SECONDARY_CHECKSUM_FAIL,                        446,    2,    1;
;BS_FSW_SPP_HK_PRIMARY_CHECKSUM_FAIL,                          446,    1,    1;
;BS_FSW_SPP_HK_SBC_APP_IMAGE_VOTED,                            446,    0,    2;
;BS_FSW_SPP_HK_BRKWIRE0,                                       447,    6,    1;
;BS_FSW_SPP_HK_BRKWIRE1,                                       447,    5,    1;
;BS_FSW_SPP_HK_WATCHDOG_EN_DIS,                                447,    4,    1;
;FSW_CI_HK_RADIOA_CCD_CNT,                                     447,    3,   16;
;FSW_CI_HK_RADIOB_CCD_CNT,                                     449,    3,   16;
;FSW_CI_HK_ARC_CCD_CNT,                                        451,    3,   16;
;FSW_CI_HK_TT_RADIO_LOCK,                                      453,    3,    1;
;FSW_CI_HK_TT_RADIO_SCID,                                      453,    2,    1;
;FSW_CI_HK_TT_RADIO_VCID,                                      453,    1,    1;
;FSW_CI_HK_TT_RADIO_FRAME_LEN,                                 453,    0,    1;
;FSW_CI_HK_TT_RADIO_TAIL,                                      454,    7,    1;
;FSW_CI_HK_TT_RADIO_FERC,                                      454,    6,    1;
;FSW_CM_HK_AUT_CMD_EXEC_SUCCESS_CNT,                           454,    5,   16;
;FSW_CM_HK_TT_CMD_EXEC_SUCCESS_CNT,                            456,    5,   16;
;FSW_CM_HK_FI_CMD_EXEC_SUCCESS_CNT,                            458,    5,   16;
;FSW_CM_HK_FI_MACRO_CMD_EXEC_SUCCESS_CNT,                      460,    5,   16;
;FSW_CM_HK_AUT_CMD_FAIL_CNT,                                   462,    5,   16;
;FSW_CM_HK_TT_CMD_FAIL_CNT,                                    464,    5,   16;
;FSW_CM_HK_FI_CMD_FAIL_CNT,                                    466,    5,   16;
;FSW_CM_HK_FI_MACRO_CMD_FAIL_CNT,                              468,    5,   16;
;FSW_CPU_HK_POR_RESET,                                         470,    5,    1;
;FSW_CPU_HK_MC_RESET,                                          470,    4,    1;
;FSW_CPU_HK_SW_RESET,                                          470,    3,    1;
;FSW_CPU_HK_WDOG_RESET,                                        470,    2,    1;
;FSW_FI_HK_CDH_FILE_CNT,                                       470,    1,   16;
;FSW_FI_HK_CDH_SEQ_CNT,                                        472,    1,   16;
;FSW_FI_HK_CDH_STATE,                                          474,    1,   16;
;FSW_FI_HK_CDH_EXEC_CMDS,                                      476,    1,   16;
;FSW_FI_HK_CDH_FAILED_CMDS,                                    478,    1,   16;
;FSW_FI_HK_CDH_PROCESSING_FILE,                                480,    1,   16;
;FSW_FI_HK_CDH_STACK_INDEX,                                    482,    1,   32;
;FSW_FI_HK_CDH_DELAY,                                          486,    1,   32;
;FSW_FI_HK_CDH_DELAY_CNT,                                      490,    1,   32;
;FSW_FI_HK_AUTO_DELETE_STATE,                                  494,    1,    8;
;FSW_ITF_FIELDS1_CT_VC_ALIVE_TT,                               495,    1,    1;
;FSW_ITF_FIELDS2_CT_VC_ALIVE_TT,                               495,    0,    1;
;FSW_ITF_SWEAP_CT_VC_ALIVE_TT,                                 496,    7,    1;
;FSW_ITF_EPI_HI_CT_VC_ALIVE_TT,                                496,    6,    1;
;FSW_ITF_EPI_LO_CT_VC_ALIVE_TT,                                496,    5,    1;
;FSW_ITF_WISPR_CT_VC_ALIVE_TT,                                 496,    4,    1;
;FSW_ITF_WISPR_IMAGE_VC_ALIVE_TT,                              496,    3,    1;
;FSW_ITF_SBC_P_HS_CT_VC_ALIVE_TT,                              496,    2,    1;
;FSW_ITF_SBC_P_BS_CT_VC_ALIVE_TT,                              496,    1,    1;
;FSW_ITF_SBC_P_A_CT_VC_ALIVE_TT,                               496,    0,    1;
;FSW_ITF_SBC_P_B_CT_VC_ALIVE_TT,                               497,    7,    1;
;FSW_ITF_SBC_P_C_CT_VC_ALIVE_TT,                               497,    6,    1;
;FSW_ITF_SBC_P_HS_XSBC_VC_ALIVE_TT,                            497,    5,    1;
;FSW_ITF_SBC_P_BS_XSBC_VC_ALIVE_TT,                            497,    4,    1;
;FSW_ITF_SBC_P_A_XSBC_VC_ALIVE_TT,                             497,    3,    1;
;FSW_ITF_SBC_P_B_XSBC_VC_ALIVE_TT,                             497,    2,    1;
;FSW_ITF_SBC_P_C_XSBC_VC_ALIVE_TT,                             497,    1,    1;
;FSW_ITF_PCOM_SCIF_ACTIVE_VC_ALIVE_TT,                         497,    0,    1;
;FSW_ITF_PCOM_SCIF_BACKUP_VC_ALIVE_TT,                         498,    7,    1;
;FSW_ITF_ECUA_TLM_VC_ALIVE_TT,                                 498,    6,    1;
;FSW_ITF_ECUB_TLM_VC_ALIVE_TT,                                 498,    5,    1;
;FSW_ITF_RADIOA_TLM_VC_ALIVE_TT,                               498,    4,    1;
;FSW_ITF_RADIOB_TLM_VC_ALIVE_TT,                               498,    3,    1;
;FSW_ITF_PSEA_TLM_VC_ALIVE_TT,                                 498,    2,    1;
;FSW_ITF_PSEB_TLM_VC_ALIVE_TT,                                 498,    1,    1;
;FSW_ITF_PUMP_ELECA_TLM_VC_ALIVE_TT,                           498,    0,    1;
;FSW_ITF_PUMP_ELECB_TLM_VC_ALIVE_TT,                           499,    7,    1;
;FSW_ITF_SSEA_TLM_VC_ALIVE_TT,                                 499,    6,    1;
;FSW_ITF_SSEB_TLM_VC_ALIVE_TT,                                 499,    5,    1;
;FSW_ITF_PDUA_TLM_VC_ALIVE_TT,                                 499,    4,    1;
;FSW_ITF_PDUB_TLM_VC_ALIVE_TT,                                 499,    3,    1;
;FSW_TTAG_HK_LAST_FIRED_RULE_NUM,                              499,    2,   16;
;FSW_SI_HK_TIME_CODE_LAST_SIDE,                                501,    2,    8;
;FSW_SI_HK_SAFE_MODE_SA_FLAG,                                  502,    2,    1;
;FSW_SI_HK_SAFE_MODE_STB_FLAG,                                 502,    1,    1;
;FSW_SI_HK_SAFE_MODE_EA_FLAG,                                  502,    0,    1;
;FSW_SI_HK_OPER_MODE_LEVEL,                                    503,    7,    2;
;FSW_SI_HK_STATE_ACTIVITY_MODE,                                503,    5,    8;
;FSW_SI_HK_SBCA_LOGICAL_ID,                                    504,    5,    8;
;FSW_SI_HK_SBCB_LOGICAL_ID,                                    505,    5,    8;
;FSW_SI_HK_SBCC_LOGICAL_ID,                                    506,    5,    8;
;FSW_SI_HK_REM_TOTAL_MINOR_FRAME_SKIP_CNT,                     507,    5,   16;
;FSW_SI_HK_PROC_ROTATION_CNTR,                                 509,    5,   32;
;FSW_SI_HK_SIDE_SWCH_CNTR,                                     513,    5,   32;
;FSW_MOH_HK_COPY_DUMP_STATUS,                                  517,    5,   32;
;HS_FSW_MOH_HK_COPY_DUMP_STATUS,                               521,    5,   32;
;BS_FSW_MOH_HK_COPY_DUMP_STATUS,                               525,    5,   32;
;FSW_GC_HK_HK_FLAP_GUIDANCE_MODE,                              529,    5,    8;
;FSW_GC_HK_HK_FTHR_GUIDANCE_MODE,                              530,    5,    8;
;FSW_GC_HK_HK_HGA_GUIDANCE_MODE,                               531,    5,    8;
;FSW_AUT_AUT_RULE_MAINT_TRIGGER_CNT,                           532,    5,   16;
;FSW_AUT_AUT_RULE_SUSPEND_LEVEL,                               534,    5,   16;
;FSW_AUT_CT238_CLT_COUNTDOWN,                                  536,    5,   32;
;FSW_AUT_FAULT_ROLLING_AUT_RULE_MET1,                          540,    5,   32;
;FSW_AUT_FAULT_ROLLING_AUT_RULE_MET2,                          544,    5,   32;
;FSW_AUT_FAULT_ROLLING_AUT_RULE_NUM1,                          548,    5,   16;
;FSW_AUT_FAULT_ROLLING_AUT_RULE_NUM2,                          550,    5,   16;
;FSW_AUT_MAINT_ROLLING_AUT_RULE_MET0,                          552,    5,   32;
;FSW_AUT_MAINT_ROLLING_AUT_RULE_MET1,                          556,    5,   32;
;FSW_AUT_MAINT_ROLLING_AUT_RULE_MET2,                          560,    5,   32;
;FSW_AUT_MAINT_ROLLING_AUT_RULE_NUM0,                          564,    5,   16;
;FSW_AUT_MAINT_ROLLING_AUT_RULE_NUM1,                          566,    5,   16;
;FSW_AUT_MAINT_ROLLING_AUT_RULE_NUM2,                          568,    5,   16;
;FSW_AUT_SV036_CLT_EXPIRATION_MET,                             570,    5,   32;
;FSW_FI_HK_EPIHI_SEQ_CNT,                                      574,    5,   16;
;FSW_FI_HK_EPIHI_STATE,                                        576,    5,   16;
;FSW_FI_HK_EPILO_SEQ_CNT,                                      578,    5,   16;
;FSW_FI_HK_EPILO_STATE,                                        580,    5,   16;
;FSW_FI_HK_FIELDS1_SEQ_CNT,                                    582,    5,   16;
;FSW_FI_HK_FIELDS1_STATE,                                      584,    5,   16;
;FSW_FI_HK_FIELDS2_SEQ_CNT,                                    586,    5,   16;
;FSW_FI_HK_FIELDS2_STATE,                                      588,    5,   16;
;FSW_FI_HK_SWEAP_SEQ_CNT,                                      590,    5,   16;
;FSW_FI_HK_SWEAP_STATE,                                        592,    5,   16;
;FSW_FI_HK_WISPR_SEQ_CNT,                                      594,    5,   16;
;FSW_FI_HK_WISPR_STATE,                                        596,    5,   16;
;FSW_FM_HK_FS_ACCESS_SSR,                                      598,    5,    1;
;FSW_SI_HK_PRIMARY_PDU,                                        598,    4,    8;
;FSW_SI_HK_PRIMARY_PSE,                                        599,    4,    8;
;FSW_SI_HK_PRIMARY_TAC,                                        600,    4,    8;
;FSW_SI_TIME_REG_CRYSTAL_CLOCK_CNTR,                           601,    4,   27;
;FSW_SI_TIME_REG_EMXO_A_CLOCK_CNTR,                            604,    1,   27;
;FSW_SI_TIME_REG_EMXO_B_CLOCK_CNTR,                            608,    6,   27;
;FSW_TO_HK_TBL_SEL,                                            611,    3,    8;
;FSW_TTAG_HK_RULE_SUSPEND_LEVEL,                               612,    3,   16;
;HS_FSW_FI_HK_CDH_SEQ_CNT,                                     614,    3,   16;
;HS_FSW_FM_HK_FS_ACCESS_SSR,                                   616,    3,    1;
;BS_FSW_FI_HK_CDH_SEQ_CNT,                                     616,    2,   16;
;BS_FSW_FM_HK_FS_ACCESS_SSR,                                   618,    2,    1;
;MCA_TLM_HK_BACKUP_FAILED_PWR_STATE,                           618,    1,    1;
;MCA_TLM_HK_SW_VOTES_PDUA_PWR_STATE,                           618,    0,    1;
;MCA_TLM_HK_SW_VOTES_PDUB_PWR_STATE,                           619,    7,    1;
;MCA_TLM_HK_SW_VOTES_RADIOA_PWR_STATE,                         619,    6,    1;
;MCA_TLM_HK_SW_VOTES_RADIOB_PWR_STATE,                         619,    5,    1;
;MCA_TLM_HK_SW_VOTES_REMA_PWR_STATE,                           619,    4,    1;
;MCA_TLM_HK_SW_VOTES_REMB_PWR_STATE,                           619,    3,    1;
;MCB_TLM_HK_BACKUP_FAILED_PWR_STATE,                           619,    2,    1;
;MCB_TLM_HK_SW_VOTES_PDUA_PWR_STATE,                           619,    1,    1;
;MCB_TLM_HK_SW_VOTES_PDUB_PWR_STATE,                           619,    0,    1;
;MCB_TLM_HK_SW_VOTES_RADIOA_PWR_STATE,                         620,    7,    1;
;MCB_TLM_HK_SW_VOTES_RADIOB_PWR_STATE,                         620,    6,    1;
;MCB_TLM_HK_SW_VOTES_REMA_PWR_STATE,                           620,    5,    1;
;MCB_TLM_HK_SW_VOTES_REMB_PWR_STATE,                           620,    4,    1;
;MCC_TLM_HK_BACKUP_FAILED_PWR_STATE,                           620,    3,    1;
;MCC_TLM_HK_SW_VOTES_PDUA_PWR_STATE,                           620,    2,    1;
;MCC_TLM_HK_SW_VOTES_PDUB_PWR_STATE,                           620,    1,    1;
;MCC_TLM_HK_SW_VOTES_RADIOA_PWR_STATE,                         620,    0,    1;
;MCC_TLM_HK_SW_VOTES_RADIOB_PWR_STATE,                         621,    7,    1;
;MCC_TLM_HK_SW_VOTES_REMA_PWR_STATE,                           621,    6,    1;
;MCC_TLM_HK_SW_VOTES_REMB_PWR_STATE,                           621,    5,    1;
;PDU_EPIHI_PWR_STATE,                                          621,    4,    2;
;PDU_EPILO_PWR_STATE,                                          621,    2,    2;
;PDU_FIELDS1_ENA_STATE,                                        621,    0,    1;
;PDU_FIELDS1_PWR_STATE,                                        622,    7,    2;
;PDU_FIELDS2_ENA_STATE,                                        622,    5,    1;
;PDU_FIELDS2_PWR_STATE,                                        622,    4,    2;
;PDU_MAIN_BUS_A_VOLT,                                          622,    2,    8;
;PDU_MAIN_BUS_B_VOLT,                                          623,    2,    8;
;PDU_PUMP_ENA_A_FOR_PUMP_A_ENA_STATE_GRP21,                    624,    2,    1;
;PDU_PUMP_ENA_A_FOR_PUMP_A_PWR_STATE_GRP21,                    624,    1,    2;
;PDU_PUMP_ENA_A_FOR_PUMP_B_ENA_STATE_GRP21,                    625,    7,    1;
;PDU_PUMP_ENA_B_FOR_PUMP_A_PWR_STATE_GRP21,                    625,    6,    2;
;PDU_SWEAP_ENA_STATE,                                          625,    4,    1;
;PDU_SWEAP_PWR_STATE,                                          625,    3,    2;
;PDU_TOTAL_CURR_RELAY_CAP_0,                                   625,    1,    8;
;PDU_TOTAL_CURR_RELAY_CAP_1,                                   626,    1,    8;
;PDU_WISPR_ENA_STATE,                                          627,    1,    1;
;PDU_WISPR_PWR_STATE,                                          627,    0,    2;
;PSE_A_BATT_TEMP_1,                                            628,    6,   16;
;PSE_A_BATT_TEMP_2,                                            630,    6,   16;
;PSE_A_BATT_TEMP_3,                                            632,    6,   16;
;PSE_A_COUL,                                                   634,    6,   32;
;PSE_A_SA_PRT_NEGY_PRI_2,                                      638,    6,   16;
;PSE_A_SA_PRT_NEGY_SEC_2,                                      640,    6,   16;
;PSE_A_SA_PRT_POSY_PRI_2,                                      642,    6,   16;
;PSE_A_SA_PRT_POSY_SEC_2,                                      644,    6,   16;
;PSE_A_SA_SCE_NEGY_1_2_ISC,                                    646,    6,   16;
;PSE_A_SA_SCE_NEGY_2_2_ISC,                                    648,    6,   16;
;PSE_A_SA_SCE_POSY_1_2_ISC,                                    650,    6,   16;
;PSE_A_SA_SCE_POSY_2_2_ISC,                                    652,    6,   16;
;PSE_A_SOC,                                                    654,    6,   32;
;PSE_B_BATT_TEMP_1,                                            658,    6,   16;
;PSE_B_BATT_TEMP_2,                                            660,    6,   16;
;PSE_B_BATT_TEMP_3,                                            662,    6,   16;
;PSE_B_COUL,                                                   664,    6,   32;
;PSE_B_SA_PRT_NEGY_PRI_2,                                      668,    6,   16;
;PSE_B_SA_PRT_NEGY_SEC_2,                                      670,    6,   16;
;PSE_B_SA_PRT_POSY_PRI_2,                                      672,    6,   16;
;PSE_B_SA_PRT_POSY_SEC_2,                                      674,    6,   16;
;PSE_B_SA_SCE_NEGY_1_2_ISC,                                    676,    6,   16;
;PSE_B_SA_SCE_NEGY_2_2_ISC,                                    678,    6,   16;
;PSE_B_SA_SCE_POSY_1_2_ISC,                                    680,    6,   16;
;PSE_B_SA_SCE_POSY_2_2_ISC,                                    682,    6,   16;
;PSE_B_SOC,                                                    684,    6,   32;
;PSE_A_BCB1_INPUT_CURR,                                        688,    6,   16;
;PSE_A_BCB1_OUTPUT_CURR,                                       690,    6,   16;
;PSE_A_BCB2_INPUT_CURR,                                        692,    6,   16;
;PSE_A_BCB2_OUTPUT_CURR,                                       694,    6,   16;
;PSE_A_BCB3_INPUT_CURR,                                        696,    6,   16;
;PSE_A_BCB3_OUTPUT_CURR,                                       698,    6,   16;
;PSE_A_BCB4_INPUT_CURR,                                        700,    6,   16;
;PSE_A_BCB4_OUTPUT_CURR,                                       702,    6,   16;
;PSE_A_SA_NEGY_STRING_1_CURR,                                  704,    6,   16;
;PSE_A_SA_NEGY_STRING_2_CURR,                                  706,    6,   16;
;PSE_A_SA_POSY_STRING_1_CURR,                                  708,    6,   16;
;PSE_A_SA_POSY_STRING_2_CURR,                                  710,    6,   16;
;PSE_B_BCB1_INPUT_CURR,                                        712,    6,   16;
;PSE_B_BCB1_OUTPUT_CURR,                                       714,    6,   16;
;PSE_B_BCB2_INPUT_CURR,                                        716,    6,   16;
;PSE_B_BCB2_OUTPUT_CURR,                                       718,    6,   16;
;PSE_B_BCB3_INPUT_CURR,                                        720,    6,   16;
;PSE_B_BCB3_OUTPUT_CURR,                                       722,    6,   16;
;PSE_B_BCB4_INPUT_CURR,                                        724,    6,   16;
;PSE_B_BCB4_OUTPUT_CURR,                                       726,    6,   16;
;PSE_B_SA_NEGY_STRING_1_CURR,                                  728,    6,   16;
;PSE_B_SA_NEGY_STRING_2_CURR,                                  730,    6,   16;
;PSE_B_SA_POSY_STRING_1_CURR,                                  732,    6,   16;
;PSE_B_SA_POSY_STRING_2_CURR,                                  734,    6,   16;
;PUMP_A_MOTOR_ST,                                              736,    6,    1;
;PUMP_B_MOTOR_ST,                                              736,    5,    1;
;RADIOA_STATUS_MODC_RNG_ENA,                                   736,    4,    1;
;RADIOA_STATUS_OPER_MODE,                                      736,    3,    4;
;RADIOA_STATUS_RX_1_DATA_RATE,                                 737,    7,    4;
;RADIOB_STATUS_MODC_RNG_ENA,                                   737,    3,    1;
;RADIOB_STATUS_OPER_MODE,                                      737,    2,    4;
;RADIOB_STATUS_RX_1_DATA_RATE,                                 738,    6,    4;
;RIU_C2_DEVICE_DI1,                                            738,    2,    1;
;RIU_C2_DEVICE_DI2,                                            738,    1,    1;
;RIU_C2_DEVICE_DI3,                                            738,    0,    1;
;RIU_C2_DEVICE_DI4,                                            739,    7,    1;
;TAC_P1_PRESS0,                                                739,    6,   12;
;TAC_RED_P1_PRESS1,                                            740,    2,   12;
;RIU_1A_CH0_COUNTS,                                            742,    6,   10;
;RIU_1A_CH10_COUNTS,                                           743,    4,   10;
;RIU_1A_CH15N_COUNTS,                                          744,    2,   10;
;RIU_1A_CH9_COUNTS,                                            745,    0,   10;
;RIU_1B_CH0_COUNTS,                                            747,    6,   10;
;RIU_1B_CH15N_COUNTS,                                          748,    4,   10;
;RIU_1B_CH2_COUNTS,                                            749,    2,   10;
;RIU_1B_CH5_COUNTS,                                            750,    0,   10;
;RIU_3A_CH0_COUNTS,                                            752,    6,   10;
;RIU_3A_CH11_COUNTS,                                           753,    4,   10;
;RIU_3A_CH12_COUNTS,                                           754,    2,   10;
;RIU_3A_CH13_COUNTS,                                           755,    0,   10;
;RIU_3A_CH15N_COUNTS,                                          757,    6,   10;
;RIU_3B_CH0_COUNTS,                                            758,    4,   10;
;RIU_3B_CH12_COUNTS,                                           759,    2,   10;
;RIU_3B_CH13_COUNTS,                                           760,    0,   10;
;RIU_3B_CH15N_COUNTS,                                          762,    6,   10;
;RIU_7A_CH15N_COUNTS,                                          763,    4,   10;
;RIU_7B_CH15N_COUNTS,                                          764,    2,   10;
;RADIOA_STATUS_RX_1_TEMP,                                      765,    0,   12;
;RADIOB_STATUS_RX_1_TEMP,                                      767,    4,   12;
;PDU_GRP_A_CATBED_HTR_A_PWR_STATE,                             768,    0,    2;
;PDU_GRP_B_CATBED_HTR_A_PWR_STATE,                             769,    6,    2;
;PDU_GRP_C_CATBED_HTR_A_PWR_STATE,                             769,    4,    2;
;PDU_GRP_A_CATBED_HTR_B_PWR_STATE_GRP23,                       769,    2,    2;
;PDU_GRP_B_CATBED_HTR_B_PWR_STATE_GRP23,                       769,    0,    2;
;PDU_GRP_C_CATBED_HTR_B_PWR_STATE_GRP23,                       770,    6,    2;
;PDU_PROP_PRESXDCR_A_PWR_STATE,                                770,    4,    2;
;PDU_PROP_PRESXDCR_B_PWR_STATE,                                770,    2,    2;
;FSW_CPU_HK_RESET_MODE,                                        770,    0,   32;
;FSW_FM_HK_FS_ALMOST_FULL_SSR,                                 774,    0,    1;
;FSW_GC_HK_HK_AVG_WATER_TEMP,                                  775,    7,   32;
;FSW_GC_HK_HK_NO_MANIFOLD_TEMP,                                779,    7,    8;
;FSW_GC_HK_HK_ACT_ANG_CMD2,                                    780,    7,   16;
;FSW_GC_HK_HK_ACT_ANG_CMD3,                                    782,    7,   16;
;FSW_GC_HK_HK_ACT_ANG_CMD4,                                    784,    7,   16;
;FSW_GC_HK_HK_ACT_ANG_INIT_CODE2,                              786,    7,    8;
;FSW_GC_HK_HK_ACT_ANG_INIT_CODE3,                              787,    7,    8;
;FSW_GC_HK_HK_ACT_ANG_INIT_CODE4,                              788,    7,    8;
;}



