;+
; t04s_test
;
; Purpose: A few tests to verify that the model and the wrapper
; procedures work correctly
;
; $LastChangedBy: lphilpott $
; $LastChangedDate: 2012-06-14 11:16:07 -0700 (Thu, 14 Jun 2012) $
; $LastChangedRevision: 10562 $
; $URL: svn+ssh://thmsvn@ambrosia.ssl.berkeley.edu/repos/spdsoft/tags/spedas_5_0/external/IDL_GEOPACK/t04s/t04s_test.pro $
;-

;takes a matrix whose columns define a plane
;and an Nx3 series of points
;returns an Nx2 series of points generated by projecting x into a
function project_t04s, a, x

p = a ## invert(transpose(a) ## a) ## transpose(a)

return, p ## x

end

;constructs a vector field from orbital data, useful for visualization
;of results
pro orbital_vf_t04s, name

  get_data, name, data = d

  tt04s,name,pdyn=2.0D,dsti=-30.0D,yimf=0.0D,zimf=-5.0D,w1=8.0D,w2=5.0D,w3=9.5D,w4=30.0D,w5=18.5D,w6=60.0D,error=e

  get_data, name+'_bt04s', data = td

  t_size = n_elements(d.x)

  ;3 points selected to define a plane
  v1 = d.y[0, *]

  v2 = d.y[floor(t_size/3), *]

  v3 = d.y[floor(2*t_size/3), *]

  ;plane vectors are just v2, and v3 shifted by the reference point v1
  vp1 = v2-v1

  vp2 = v3-v1

  proj_pos = project_t04s([vp1, vp2], d.y)
  
  proj_mag = project_t04s([vp1, vp2], td.y)

  ivector, interpol(proj_mag[*, 0],20),interpol(proj_mag[*, 1],20), interpol(proj_pos[*, 0],20), interpol(proj_pos[*, 1],20),renderer=1

end

timespan, '2007-03-23'

;load state data
thm_load_state, probe = 'b', coord = 'gsm'

;test with single number argument
tt04s, 'thb_state_pos',pdyn=2.0D,dsti=-30.0D,yimf=0.0D,zimf=-5.0D,w1=8.0D,w2=5.0D,w3=9.5D,w4=30.0D,w5=18.5D,w6=60.0D,error=e

if e eq 0 then begin
    message,/continue,'error detected, stopping'
    stop
endif

tplot,'thb_state_pos_bt04s'

stop

del_data,'thb_state_pos_bt04s'

get_data,'thb_state_pos',data=d

n = n_elements(d.x)

;test with an array argument
tt04s, 'thb_state_pos',pdyn=replicate(2.0D,n),dsti=replicate(-30.0D,n),yimf=replicate(0.0D,n),zimf=replicate(-5.0D,n),w1=replicate(8.0D,n),w2=replicate(5.0D,n),w3=replicate(9.5D,n),w4=replicate(30.0D,n),w5=replicate(18.5D,n),w6=replicate(60.0D,n),error=e

if e eq 0 then begin
    message,/continue,'error detected, stopping'
    stop
endif

tplot,'thb_state_pos_bt04s'

stop

del_data,'thb_state_pos_bt04s'

d2 = {x:d.x[0],y:2.0D}

store_data,'t_pdyn',data=d2

d2 = {x:d.x[0],y:-30.0D}

store_data,'t_dsti',data=d2

d2 = {x:d.x[0],y:0.0D}

store_data,'t_yimf',data=d2

d2 = {x:d.x[0],y:-5.0D}

store_data,'t_zimf',data=d2

d2 = {x:d.x[0],y:8.0D}

store_data,'t_w1',data=d2

d2 = {x:d.x[0],y:5.0D}

store_data,'t_w2',data=d2

d2 = {x:d.x[0],y:9.5D}

store_data,'t_w3',data=d2

d2 = {x:d.x[0],y:30.0D}

store_data,'t_w4',data=d2

d2 = {x:d.x[0],y:18.5D}

store_data,'t_w5',data=d2

d2 = {x:d.x[0],y:60.0D}

store_data,'t_w6',data=d2

;test with tplot arguments
tt04s,'thb_state_pos',pdyn='t_pdyn',dsti='t_dsti',yimf='t_yimf',zimf='t_zimf',w1='t_w1',w2='t_w2',w3='t_w3',w4='t_w4',w5='t_w5',w6='t_w6',error=e

if e eq 0 then begin
    message,/continue,'error detected, stopping'
    stop
endif

tplot,'thb_state_pos_bt04s'

stop

del_data,'thb_state_pos_bt04s'

;test with newname
tt04s, 'thb_state_pos',pdyn=2.0D,dsti=-30.0D,yimf=0.0D,zimf=-5.0D,w1=8.0D,w2=5.0D,w3=9.5D,w4=30.0D,w5=18.5D,w6=60.0D,newname='test',error=e

if e eq 0 then begin
    message,/continue,'error detected, stopping'
    stop
endif

tplot,'test'

stop

del_data,'test'

;test with a different period

tt04s, 'thb_state_pos',pdyn=2.0D,dsti=-30.0D,yimf=0.0D,zimf=-5.0D,w1=8.0D,w2=5.0D,w3=9.5D,w4=30.0D,w5=18.5D,w6=60.0D,period=30,error=e

if e eq 0 then begin
    message,/continue,'error detected, stopping'
    stop
endif

tplot,'thb_state_pos_bt04s'

stop

;test with an incremented tilt
tt04s, 'thb_state_pos',pdyn=2.0D,dsti=-30.0D,yimf=0.0D,zimf=-5.0D,period=30,w1=8.0D,w2=5.0D,w3=9.5D,w4=30.0D,w5=18.5D,w6=60.0D,error=e,get_tilt='tilt_vals',get_nperiod=gn,add_tilt=1

if e eq 0 then begin
    message,/continue,'error detected, stopping'
    stop
endif

tplot,'tilt_vals'

stop

;test with a set tilt
tt04s, 'thb_state_pos',pdyn=2.0D,dsti=-30.0D,yimf=0.0D,zimf=-5.0D,period=30,w1=8.0D,w2=5.0D,w3=9.5D,w4=30.0D,w5=18.5D,w6=60.0D,error=e,get_tilt='tilt_vals',get_nperiod=gn,set_tilt=1

if e eq 0 then begin
    message,/continue,'error detected, stopping'
    stop
endif

options,'tilt_vals',yrange=[0,2]
tplot,'tilt_vals'
options,'tilt_vals',yrange=[1,1]  ;reset to auto-range
stop

orbital_vf_t04s,'thb_state_pos'

print,'The plot produced should look like the plot titled t04s_test.png'

end
