      SUBROUTINE ACC6S                                                          
C                                                                               
C   CALLED BY ACCUMS, ACCUMULATES DATA FROM IMP-6 SUMMARY COUNTS TAPE           
C   RECORD FOR IMP PLOT INPUT.                                                  
C                                                                               
C   MODIFY BY HENRY LO ON 9/90                                                  
C   CHANGE EQUIVALENCE STATEMENT TO CONFORM WITH VS-FORTRAN                     
C   COMPILER SYNTAX                                                             
C                                                                               
      IMPLICIT LOGICAL*1(Q),INTEGER*2(H)                                        
CLO   COMMON /ACCCUM/ VALS(6),DENS(6),INT                                       
CLO                                                                             
      COMMON /ACCCUM/ VALS(250),DENS(250),RDENS(250),INT                        
CLO                                                                             
CLO   COMMON /EXPON/ QEVTON(6),QEVCHK                                           
CLO                                                                             
      COMMON /EXPON/  QEVTON(250),QEVCHK                                        
CLO                                                                             
CLO   COMMON /GEOMF/ GEOM(70,3),TIMLIV(70,3),FACTOR(6),XMEV(6)                  
CLO                                                                             
      COMMON /GEOMF/  GEOM(70,3),TIMLIV(70,3),FACTOR(250),XMEV(250)             
CLO   COMMON /PARS/ IEVENT(6),ISECTR(6),MAP(6),IPLTPT(6),IMP(6),INOEV           
      COMMON /PARS/ IEVENT(250),ISECTR(250),MAP(6),IPLTPT(6),IMP(250),          
     *              INOEV                                                       
      COMMON /REJECT/ QPOINT,QFILTR                                             
      COMMON /REKORD/ KRECID(615,3)                                             
      COMMON /SEKOPT/ QFAILS,QSUN0S                                             
      DIMENSION ISMCT(495),SMCT(495),HSMCT(990)                                 
      EQUIVALENCE (KRECID(1,1),ISMCT(1),SMCT(1),HSMCT(1))                       
C                                                                               
      QSKIP = .FALSE.                                                           
      QDROP = .FALSE.                                                           
        DO 90 IEV=1,INOEV                                                       
C   CHECK FOR CORRECT IMP NUMBER AND FOR EVENT TYPE ON                          
          IF (IMP(IEV).NE.1) GOTO 90                                            
          IF (QEVCHK.AND..NOT.QEVTON(IEV)) GOTO 90                              
          IV = IEVENT(IEV)                                                      
          IF (IV.GT.58) GOTO 10                                                 
CLO                                                                             
C   STORE NON-SECTORED EVENT.                                                   
          VALUE = ISMCT(23 + 3*IV)                                              
          IF (.NOT.QPOINT) VALUE = VALUE + ISMCT(24 + 3*IV)                     
          DEN = HSMCT(49 + 6*IV)                                                
          IF (.NOT.QPOINT) DEN = DEN + HSMCT(50 + 6*IV)                         
          IF (DEN.EQ.0.0) GOTO 90                                               
          DEN = DEN*TIMLIV(IV,1)                                                
          GOTO 70                                                               
C   STORE SECTORED RATE.                                                        
 10     IF (QDROP) GOTO 90                                                      
        IVS = IV - 58                                                           
        IF (QSKIP) GOTO 30                                                      
        IF1 = HSMCT(399)                                                        
        IF (IVS.GT.4) IF1 = HSMCT(593)                                          
C   CHECK FOR ZERO SUN TIME.                                                    
        IF (QSUN0S.AND.IF1.GE.10) GOTO 20                                       
C   CHECK FOR UNDEFINED DATA.                                                   
        IF1 = MOD(IF1,10)                                                       
        IF (IF1.GE.2) GOTO 20                                                   
C   CHECK FOR FAIL DATA.                                                        
        QFAIL = .FALSE.                                                         
        IF (IF1.EQ.1) QFAIL = .TRUE.                                            
        IF (QFAILS.AND.QFAIL) GOTO 20                                           
C   IF OA BAD, THEN SKIP; ELSE CALCULATE LIVE TIME.                             
        IF (SMCT(495).LE.0.0.AND..NOT.QFAIL) GOTO 20                            
        TIMELV  = SMCT(495)*5.0/8.0                                             
        IF (.NOT.QFAIL) GOTO 18                                                 
        IRATE = 1                                                               
        IF (IGET(ISMCT(3),0,0).EQ.1) IRATE = 4                                  
C   IF FAIL, EACH SECTOR 1/8TH OF A SNAPSHOT.                                   
        TIMELV = .64*IRATE                                                      
 18     QSKIP = .TRUE.                                                          
        GOTO 30                                                                 
 20     QDROP = .TRUE.                                                          
        GOTO 90                                                                 
 30     IBASE = 174                                                             
        IF (IVS.GT.4) IBASE = 175                                               
        IF (ISECTR(IEV).EQ.0) GOTO 40                                           
C   SINGLE SECTOR ACCUMULATED.                                                  
          ILOC = IBASE + 24*IVS + 3*ISECTR(IEV)                                 
          VALUE = ISMCT(ILOC)                                                   
          IF (.NOT.QPOINT) VALUE = VALUE + ISMCT(ILOC+1)                        
          DEN = HSMCT(2*ILOC + 3)                                               
          IF (.NOT.QPOINT) DEN = DEN + HSMCT(2*ILOC + 4)                        
          GOTO 50                                                               
C   SECTOR SUM ACCUMULATED.                                                     
 40       JLOC = IBASE + 24*IVS                                                 
          VALUE = 0.0                                                           
          DEN = 0.0                                                             
          DO 45 ISC=1,8                                                         
            KLOC = JLOC + 3*ISC                                                 
            VALUE = VALUE + ISMCT(KLOC)                                         
            IF (.NOT.QPOINT) VALUE = VALUE + ISMCT(KLOC+1)                      
            DEN = DEN + HSMCT(2*KLOC+3)                                         
            IF (.NOT.QPOINT) DEN = DEN + HSMCT(2*KLOC+4)                        
 45         CONTINUE                                                            
 50       IF (DEN.EQ.0.0) GOTO 90                                               
          DEN = DEN*TIMELV                                                      
CLO                                                                             
70    CONTINUE                                                                  
CLO                                                                             
      DDEN = DEN                                                                
CLO                                                                             
          IF (IYTYPE.EQ.2) DEN = DEN*FACTOR(IEV)                                
          IF (IYTYPE.EQ.3) DEN = DEN*FACTOR(IEV)*XMEV(IEV)                      
          VALS(IEV) = VALS(IEV) + VALUE                                         
          DENS(IEV) = DENS(IEV) + DEN                                           
CLO                                                                             
          RDENS(IEV) = RDENS(IEV) + DDEN                                        
CLO                                                                             
 90       CONTINUE                                                              
      RETURN                                                                    
      END                                                                       
