      SUBROUTINE ACC6                                                   00000010
C                                                                       00000020
C   ACCUMULATES DATA IMP-6 INPUT TAPES FOR THE IMP PLOT PROGRAM         00000030
C   FOR ALL PLOT TYPES EXCEPT EVERY READOUT.                            00000040
C   ITAPE = 1 FOR COUNTS TAPE;  ITAPE = 2 FOR SMCT TAPE.                00000050
C   INTERVAL FRAME FROM ISTART TO ISTOP.                                00000060
C   ***QEVERY=TRUE, THEN EVERY READOUT AND THREE TIMES, JTIME(I,1-3);   00000070
C            =FALSE, THEN FIXED TIMES, ITIME(I).                        00000080
C   ***QSAT=TRUE MEANS SATELLITE NEEDED, QDAT=TRUE MEANS DATA EXISTS.   00000090
C                                                                       00000100
C   MODIFY BY HENRY LO ON 9/90                                                  
C   CHANGE EQUIVALENCE STATEMENTS TO CONFORM WITH THE VS-FORTRAN                
C   COMPILER SYNTAX                                                             
C                                                                               
      IMPLICIT LOGICAL*1(Q),INTEGER*2(H)                                00000110
CLO   COMMON /ACCCUM/ VALS(6),DENS(6),INT                               00000120
CLO                                                                     00000121
      COMMON /ACCCUM/ VALS(250),DENS(250),RDENS(250),INT                00000122
CLO                                                                     00000123
      COMMON /ALTITP/ GSEXYZ(4,2,3),PHI(2,3),THETA(2,3)                 00000130
CLO   COMMON /EXPON/ QEVTON(6),QEVCHK                                   00000131
CLO                                                                     00000132
      COMMON /EXPON/  QEVTON(250),QEVCHK                                00000140
      COMMON /BOUNDS/ ISTART,IYR1,ISTOP,IYR2,NORM2,M,N,IXRANG           00000150
      COMMON /FERMSG/ IMES(26)                                          00000160
      COMMON /FIRST/  QFIRST(4)                                         00000170
      COMMON /HEIGHT/ ALTPER                                            00000180
      COMMON /KOUNTS/ KCNT(373,2,3),IRATE(2,3)                          00000190
CLO   COMMON /PARS/ IEVENT(6),ISECTR(6),MAP(6),IPLTPT(6),IMP(6),INOEV           
      COMMON /PARS/ IEVENT(250),ISECTR(250),MAP(6),IPLTPT(6),IMP(250),          
     *              INOEV                                                       
      COMMON /PERIGK/ IUP(100),IDN(100),IUPNO,IDNNO,QPER(250),QANA(250) 00000220
CLO   COMMON /POINTS/ Y(250,6),YDEL(250,6),ITIME(250),IPTS,             00000230
CLO  *                JTIME(250,3),JPTS(3),Z(250,6),ZDEL(250,6),        00000240
CLO  *                IFUNCT(6),IARG1(6),IARG2(6),IFRMS,QSINGL,QEVERY   00000250
CLO                                                                     00000251
      COMMON /POINTS/ Y(250,250),YDEL(250,250),ITIME(250),IPTS,         00000252
     *                JTIME(250,3),JPTS(3),Z(250,6),ZDEL(250,6),        00000253
     *                IFUNCT(6),IARG1(6),IARG2(6),IFRMS,QSINGL,QEVERY   00000254
CLO                                                                     00000255
      REAL RATECT(250,250),RATELV(250,250)                                      
CLO                                                                             
      COMMON /PPRATE/ RATECT,RATELV                                             
CLO                                                                             
      COMMON /REJECT/ QPOINT,QFILTR                                     00000260
      COMMON /REKORD/ KSMCT(615,3)                                      00000270
      COMMON /SATLIT/ QSAT(3),QDAT(3)                                   00000280
      COMMON /TABS6/  ITAB(21),ITABT(21),ITABMX,IENT                    00000290
      COMMON /TAPE/   ITAPE,INUNIT(3)                                   00000300
      DIMENSION ISMCT(495),SMCT(495),HSMCT(990),GSE(4)                  00000310
      DIMENSION ICNT(373,2),CNT(373,2),HCNT(746,2)                      00000320
      EQUIVALENCE (KCNT(1,1,1),ICNT(1,1),CNT(1,1),HCNT(1,1))            00000330
      EQUIVALENCE (KSMCT(1,1),ISMCT(1),SMCT(1),HSMCT(1))                00000340
C                                                                       00000350
      KERROR = 0                                                        00000360
      QSEXYZ = .FALSE.                                                  00000370
      DO 10 I=1,4                                                       00000371
        DO 10 J=1,2                                                     00000460
 10       GSEXYZ(I,J,1) = 0.0                                           00000470
C   SET START TIMES                                                     00000480
      IF (ITAPE.EQ.2) MTIME = ISTART +                                  00000490
     *       IDIFF(ISMCT(1)+4500,ISMCT(24),ISTART,IYR1)                 00000500
      IF (ITAPE.EQ.2.OR..NOT.QFIRST(1)) GOTO 36                         00000510
C   SET UP COUNTS TAPE ARRAYS FIRST TIME THROUGH.                       00000520
      DO 20 J=1,373                                                     00000530
 20     ICNT(J,2) = ISMCT(J)                                            00000540
CLO                                                                     00000550
 21   CALL TAB6                                                         00000560
      DO 23 J=1,ITABMX                                                  00000570
        IF (ITABT(J).LT.ISTART) GOTO 23                                 00000580
        IENT = J                                                        00000590
        MTIME = ITABT(IENT)                                             00000600
        GOTO 36                                                         00000610
 23     CONTINUE                                                        00000620
      GOTO 21                                                           00000630
 36   IDEL = INT/2                                                      00000640
      DO 200 ITM=1,IPTS                                                 00000650
 40     IF (MTIME.GE.ITIME(ITM)+IDEL) GOTO 150                          00000660
C   HERE, PRESENT RECORD LIES IN INTERVAL #I.                           00000670
C   PERIGEE CALCULATIONS FOR IMP-6.                                     00000680
        IF (ITAPE.EQ.2.OR.(ITAPE.EQ.1.AND.IENT.EQ.2)) CALL PALTIT       00000690
      DO 50 K=1,4                                                       00000700
        IF (ITAPE.EQ.1) GSE(K) = CNT(K+10,1)                            00000710
        IF (ITAPE.EQ.2) GSE(K) = SMCT(K+10)                             00000720
 50     CONTINUE                                                        00000730
      IF (QSEXYZ) GOTO 80                                               00000740
      DO 60 K=1,4                                                       00000750
 60     GSEXYZ(K,1,1) = GSE(K)                                          00000760
      QSEXYZ = .TRUE.                                                   00000770
 80   IF (GSE(1).GE.ALTPER) GOTO 85                                     00000780
        QPER(ITM) = .TRUE.                                              00000790
        IF (QFILTR) GOTO 88                                             00000800
C   ACCUMULATE DATA.                                                    00000810
 85     IF (ITAPE.EQ.1) CALL ACC6C                                      00000830
        IF (ITAPE.EQ.2) CALL ACC6S                                      00000840
CLO                                                                             
CLO   COLLECT RATE COUNT AND RATE LIVETIME                                      
CLO                                                                             
      DO 190 IR = 1,INOEV                                                       
      RATECT(ITM,IR) = VALS(IR)                                                 
      RATELV(ITM,IR) = RDENS(IR)                                                
190   CONTINUE                                                                  
CLO                                                                             
 88     IF (ITAPE.EQ.1) GOTO 100                                        00000860
 90     CALL FREAD(ISMCT(1),INUNIT(1),LEN,&91,&600)                     00000870
C   CHECK FOR EXPERIMENTS ON (1 = IMP-6)                                00000880
        IF (QEVCHK) CALL ONOFF(1)                                       00000890
        MTIME = ISTART + IDIFF(ISMCT(1)+4500,ISMCT(24),ISTART,IYR1)     00000900
        GOTO 40                                                         00000910
 91     CALL PMOUNT(2,1,QDAT(1))                                        00000920
        IF (.NOT.QDAT(1)) GOTO 650                                      00000930
        GOTO 90                                                         00000940
100     IENT = IENT + 1                                                 00000950
        IF (IENT.GT.ITABMX) CALL TAB6                                   00000960
        MTIME = ITABT(IENT)                                             00000970
         GOTO 40                                                        00000980
C   TRANSFER DATA;  SET UP NEW AVERAGE INTERVAL.                        00000990
150     DO 160 J=1,INOEV                                                00001040
         IF (IMP(J).NE.1) GOTO 160                                      00001070
          IF (DENS(J).LE.0.0) GOTO 155                                  00001080
          Y(ITM,J) = VALS(J)/DENS(J)                                    00001090
          YDEL(ITM,J) = SQRT(VALS(J))/DENS(J)                           00001100
155       VALS(J) = 0.0                                                 00001110
          DENS(J) = 0.0                                                 00001120
CLO                                                                             
         RDENS(J) = 0.0                                                         
CLO                                                                             
160     CONTINUE                                                        00001130
200   CONTINUE                                                          00001140
      DO 210 K=1,4                                                      00001150
210     GSEXYZ(K,2,1) = GSE(K)                                          00001160
      RETURN                                                            00001170
600   PRINT 2000,IMES                                                   00001180
2000  FORMAT(' READING ERROR ON INPUT TAPE.'/                           00001190
     * 1X,Z8,I6,20A4,4(1X,Z8))                                          00001200
      KERROR = KERROR + 1                                               00001210
      IF (KERROR.LT.10) GOTO 90                                         00001220
      GOTO 990                                                          00001230
650   PRINT 2001                                                        00001240
2001  FORMAT('1ERROR IN PMOUNT CALLED BY ACC6.')                        00001250
990   CALL PMOUNT(2,3,QDAT(1))                                          00001260
      RETURN                                                            00001270
      END                                                               00001280
