      SUBROUTINE PHACT8(HPHA,NEVENT,IBXORB,HBXSUM,GAIN,IMP)             00000010
C***********************************************************************00000020
C  SUBROUTINE PHACT8 IS A SPECIALIZED VERSION OF PHACNT FOR IMP-8.      00000030
C  THIS SUBROUTINE EXAMINES THE PHA DATA PASSED TO IT IN THE            00000040
C  CALLING SEQUENCE. IT GAIN GAIN CORRECTS THE DATA AND SCREENS IT      00000050
C  FOR FURTHER PROCESSING. DATA WHICH MEETS THE EVENT REQUIREMENTS      00000060
C  ARE TESTED AGAINST CHANNEL LIMITS.                                   00000070
C                                                                       00000080
C   IBOX = 1 ---> EVENT TYPE A.^B.^C                                    00000090
C   IBOX = 2 ---> EVENT TYPE (A+B)1.^B.^C                               00000100
C   IBOX = 3 ---> EVENT TYPE (A+B)2.^B.^C                               00000110
C   IBOX = 4 ---> EVENT TYPE A.B.^C                                     00000120
C   IBOX = 5 ---> EVENT TYPE (A+B)1.B.^C                                00000130
C   IBOX = 6 ---> EVENT TYPE (A+B)2.B.^C                                00000140
C   IBOX = 7 ---> EVENT TYPE D1.E.F.G                                   00000150
C   IBOX = 8 ---> EVENT TYPE D1.E.^F.^G                                 00000160
C   IBOX = 9 ---> EVENT TYPE D1.E.F.^G                                  00000170
C   IBOX =10 ---> EVENT TYPE (D+E)1.E1.^F.^G                            00000180
C   IBOX =11 ---> EVENT TYPE (D+E)2.E1.^F.^G                            00000190
C                                                                       00000200
      IMPLICIT INTEGER*2(H),LOGICAL*1(Q)                                00000210
C                                                                       00000220
C  CALLING SEQUENCE                                                     00000230
C    ARGUMENT  I/O    TYPE             DESCRIPTION                      00000240
C    HPHA      I      I*2 (ARRAY 320)  PHA DATA                         00000250
C    NEVENT    I/O    I*4 (ARRAY 8)    RUNNING TOTAL OF EACH EVENT      00000260
C                                      COUNT FOR A 5 MIN. INTERVAL.     00000270
C                                      INITIALIZED IN FLX8PR.           00000280
C    IBXORB    I/O    I*4 (ARRAY 144)  RUNNING TOTAL FOR AN ORBIT       00000290
C                                      OF EACH BOX COUNT.  INITIALIZED  00000300
C                                      IN FLX8PR.                       00000310
C    HBXSUM    I/O    I*2 (ARRAY 144)  RUNNING TOTAL FOR EACH 5 MIN.    00000320
C                                      INTERVAL OF EACH BOX COUNT.      00000330
C                                      INITIALIZED IN FLX8PR            00000340
C    GAIN      I      R*4 (ARRAY 5)    GAIN CORRECTION FACTORS          00000350
C    IMP       I      I*4              = 8 FOR IMP-8                    00000360
C                                                                       00000370
C  COMMON BOX IS USED TO ACCESS THE BLOCK DATA WHICH CONTAINS TABLES.   00000380
C  1/11/78 - INCORPORATION OF NEW MED STOPPING P AND ALPHA BOXES.       00000390
C                                                                       00000400
C  THIS VERSION INTERCEPTS BAD MED EVENTS (THAT CAUSE 0C5 DUE TO        00000410
C  ILLEGAL EVENT TYPE), PRINTS DIAGNOSTICS AND SKIPS THE RECORD.        00000420
C  IF MORE THAN 50 SUCH OCCURRENCES PER RUN, AN ABEND(888) IS TAKEN.    00000430
C                                                                       00000440
C    MODIFIED 3/8/80 TO ACCOMODATE BOX ADDITIONS/REDEFINITIONS          00000450
C    OF R. MCGUIRE -   P. SCHUSTER CSC                                  00000460
C                                                                       00000470
C                                                                       00000480
C  PROGRAMMERS: J. CHILDS AND E. ENG, COMPUTER SCIENCES CORP., JAN. 77  00000490
C  SATELLITE: IMP-8                                                     00000500
C                                                                       00000510
c6/94
c
c     replace RAND(S) by RAND(iS), iS in an integer variable
c
c     comment out call PDUMP
C***********************************************************************00000520
C                                                                       00000530
      INTEGER HA,HB,HD,HE,HF                                            00000540
      INTEGER*2 IABA(3,163),IABP(3,42),IAA(170),IAP(41),ILCNO(56)       00000550
      INTEGER*2 IDEA(3,435),IDEP(3,97)                                  00000560
      INTEGER*2 IDFHA(3,48),HB43(2,10),IDFHG(3,44),HB49(2,31),          00000570
     *HB50(2,29),HB51(2,27),IDFHK(3,42),HB53(2,20),IDFHM(3,30),         00000580
     *IDFHN(3,32),IDFHO(3,34)                                           00000590
      INTEGER*2 HB44(2,16),HB45(2,13),HB64(2,7),HB65(2,8),HB72(2,11),   00000600
     *          HB73(2,8),HB74(2,8),HB75(2,7),HB76(2,10),               00000610
     *          HB67(2,13),HB68(2,18),HB69(2,12),HB70(2,6),HB71(2,11)   00000620
      DIMENSION HAA(128),HBB(128),HDD(128),HEE(128),HFF(128),           00000630
     *HPRTY1(128),HPRTY2(128),HMEDNT(128),QLEDGN(128),QMEDGN(128),      00000640
     *QMEDMF(128),HT1234(128)                                           00000650
      DIMENSION HPHA(640),NEVENT(11),GAIN(5),IBXORB(144)                00000660
      DIMENSION HBXSUM(144),MYBNO(6)                                    00000670
      DIMENSION LEDSL(5),LEDSLU(5)                                      00000680
      DATA LEDSL/46,47,57,58,59/, LEDSLU/140,141,142,143,144/           00000690
C  NUMBER OF BAD MED EVENT OCCURRENCES, IBAD.                           00000700
      DATA IBAD/50/                                                     00000710
      DATA MYBNO/7,10,9,11,0,8/                                         00000720
C                                                                       00000730
      COMMON/BOX/ IAA,IAP,IABA,IABP,ILCNO,IDEA,IDEP,IDFHA,HB43,         00000740
     *            IDFHG,HB49,HB50,HB51,IDFHK,HB53,IDFHM,IDFHN,IDFHO,    00000750
     *            HB44,HB45,HB64,HB65,HB72,HB73,HB74,HB75,HB76,         00000760
     *            HB67,HB68,HB69,HB70,HB71                              00000770
C                                                                       00000780
C***********************************************************************00000790
C   CALL SUBROUTINE TO EXTRACT OUT PHA INFORMATION FROM PHA RECORD.     00000800
C   HPHA IS INPUT PHA RECORD, HAA THRU HFF ARE DATA POINTS FOR          00000810
C   DETECTORS A,B,C,D,E,AND F; HPRTY1 AND HPRTY2 ARE PRIORITIES FOR     00000820
C   LED AND MED EVENTS, HMEDNT IS MED EVENT TYPE; QLEDGN AND QMEDGN     00000830
C   ARE MED AND LED GAIN FACTORS (0 OR 1); AND QMEDMF ARE MED           00000840
C   MULTIPLICATION FACTORS.                                             00000850
C***********************************************************************00000860
C                                                                       00000870
      CALL EXTRCJ(HPHA,HAA,HBB,HDD,HEE,HFF,HPRTY1,                      00000880
     *HPRTY2,HMEDNT,QLEDGN,QMEDGN,QMEDMF,HT1234)                        00000890
C                                                                       00000900
C   LOOP OVER PHA RECORD.                                               00000910
C                                                                       00000920
      DO 180 I=1,128                                                    00000930
C***********************************************************************00000940
C           L E D   DATA POINT                                          00000950
C***********************************************************************00000960
      HA = HAA(I)                                                       00000970
C   SKIP IF INVALID POINT.                                              00000980
      IF(HA.EQ.0) GO TO 130                                             00000990
C     IF T4 FLAG ON, SKIP LED EVENT.                                    00001000
C                                                                       00001010
      IT1234 = HT1234(I) - 1                                            00001020
      ITS = MOD(IT1234,2)                                               00001030
      IF(ITS .EQ. 1) GO TO 130                                          00001040
C                                                                       00001050
      HB = HBB(I)                                                       00001060
C                                                                       00001070
C     IF 1.LE.B.LE.4, CHECK IF CORRECTIONS TO B ARE NEEDED.             00001080
C                                                                       00001090
      IF(.NOT.((HB.GE.1).AND.(HB.LE.4))) GO TO 103                      00001100
C                                                                       00001110
      ITS = MOD(IT1234,4)                                               00001120
      IF((.NOT.QLEDGN(I)).AND.((ITS.EQ.2).OR.(ITS.EQ.3)))               00001130
     *     GO TO 10                                                     00001140
C                                                                       00001150
      IF((HB.LE.3).AND.((HA.LT.28).OR.((HA.GE.42).AND.(HA.LE.144))      00001160
     *  .OR.(HA.GE.166))) GO TO 10                                      00001170
C                                                                       00001180
      IF((HB.LE.2).AND.((HA.GE.28).AND.(HA.LT.42))) GO TO 10            00001190
      IF((HB.LE.2).AND.((HA.GT.144).AND.(HA.LT.166))) GO TO 10          00001200
       GO TO 103                                                        00001210
   10 HB = 0                                                            00001220
C   EVENT TYPE A.-B.-C                                                  00001230
C                                                                       00001240
  103 CONTINUE                                                          00001250
      IBOX = 1                                                          00001260
      IF(HT1234(I) .GE. 9) IBOX = 3                                     00001270
      IF(HB.GT.0) IBOX = 4                                              00001280
      IF((HT1234(I) .GE. 9).AND.(IBOX .EQ. 4)) IBOX = 6                 00001290
C  GAIN CORRECT DATA POINT                                              00001300
C  IF A OR NON-ZERO B GETS SHIFTED TO 0, SET TO 1.                      00001310
c6/94 HA = (HA + RAND(S))*GAIN(1)                                       00001320
      HA = (HA + RAND(iS))*GAIN(1)                                       00001320
      IF (HA.EQ.0) HA = 1                                               00001330
c6/94 IF (HB.NE.0) HB = (HB + RAND(S))*GAIN(2)                          00001340
      IF (HB.NE.0) HB = (HB + RAND(iS))*GAIN(2)                          00001340
      IF (HBB(I).NE.0.AND.HB.EQ.0) HB = 1                               00001350
      IF (QLEDGN(I)) GOTO 140                                           00001360
      NEVENT(IBOX) = NEVENT(IBOX) + 1                                   00001370
C***********************************************************************00001380
C      L E D ---  HIGH GAIN                                             00001390
C***********************************************************************00001400
      IF((IBOX .EQ. 1).OR.(IBOX .EQ. 3))GO TO 106                       00001410
      IF(HB.GT.42)  GO TO 105                                           00001420
C   CHECK STOPPING PROTONS  A.B.-C   (BOXES 12-15, 133-137)             00001430
      IF(HA.LT.IABP(1,HB).OR.HA.GT.IABP(2,HB)) GOTO 105                 00001440
      NBOX = IABP(3,HB)                                                 00001450
      GO TO 115                                                         00001460
C   CHECK ALPHA BOXES  A.B.-C        (BOXES 16-19, 46,47,57,58,59)      00001470
  105 IF(HB.GT.162) GO TO 130                                           00001480
      IF(HA.LT.IABA(1,HB).OR.HA.GT.IABA(2,HB)) GOTO 130                 00001490
      NBOX = IABA(3,HB)                                                 00001500
      GO TO 115                                                         00001510
C   STOPPING PROTONS   A.-B.-C       (BOXES 1-6)                        00001520
  106 IF(HA.LT.9)  GO TO 130                                            00001530
      IF(HA.GT.42)  GO TO 108                                           00001540
      IF(IAP(HA).EQ.0) GO TO 108                                        00001550
      NBOX = IAP(HA)                                                    00001560
      GO TO 115                                                         00001570
C   STOPPING ALPHAS    A.-B.-C       (BOXES 7-11)                       00001580
  108 IF(HA.GT.170) GO TO 130                                           00001590
      IF(IAA(HA).EQ.0) GO TO 130                                        00001600
      NBOX = IAA(HA)                                                    00001610
C                                                                       00001620
  115 CONTINUE                                                          00001630
C-----------------------OLD SLANT THRES. CODE ----------                00001640
C   ADJUST BOX NUMBERS FOR 'ALPHA-ONLY' SLANT THRESHOLDS.               00001650
C   BOXES 1-19 GO TO 80,98 AS  A  GOES TO  (A&B)2                       00001660
C     IF((IBOX .EQ. 3).OR.(IBOX .EQ. 6))NBOX = NBOX + 79                00001670
C   BOXES 30-41 GO TO 99-110 AS D.E GOES TO (D&E)1.E                    00001680
C     MBOX = NBOX                                                       00001690
C     IF (IBOX.EQ.10.AND.MBOX.LE.41) NBOX = NBOX + 69                   00001700
C   BOXES 77-8 GO TO 131-2 FOR ABOVE REASON.                            00001710
C     IF (IBOX.EQ.10.AND.MBOX.GT.41) NBOX = NBOX + 54                   00001720
C----------------------END OLD CODE ---------------                     00001730
      MMBOX=NBOX                                                        00001740
      IF(IBOX.NE.3 .AND. IBOX.NE.6) GO TO 1151                          00001750
      IF(MMBOX.LE.19) NBOX=NBOX+79                                      00001760
      IF(MMBOX.LE.19) GO TO 1151                                        00001770
C   LED ALPHA BOXES 46,47,57,58,59, GO TO 140-144                       00001780
      DO 1152 ILEDSL=1,5                                                00001790
         IF(MMBOX.NE. LEDSL(ILEDSL)) GO TO 1152                         00001800
         NBOX=LEDSLU(ILEDSL)                                            00001810
1152  CONTINUE                                                          00001820
C                                                                       00001830
1151  CONTINUE                                                          00001840
      MBOX = NBOX                                                       00001850
      IF(IBOX.EQ.10.AND.MBOX.LE.41) NBOX = NBOX +69                     00001860
      IF(IBOX.EQ.10.AND. (MBOX.EQ.77 .OR. MBOX.EQ.78))                  00001870
     *      NBOX=NBOX + 54                                              00001880
C                                                                       00001890
C++++ HERE INCREMENT BOX COUNTS AND EVENT COUNT                         00001900
C                                                                       00001910
      HBXSUM(NBOX) = HBXSUM(NBOX) + 1                                   00001920
      IBXORB(NBOX) = IBXORB(NBOX) + 1                                   00001930
      IF (IBOX.GT.6) GOTO 180                                           00001940
      GOTO 130                                                          00001950
C                                                                       00001960
C***********************************************************************00001970
C      L E D ---  LOW GAIN.                                             00001980
C***********************************************************************00001990
C  EVENT TYPE (A+B)1.^B.^C           (BOXES 20-23)                      00002000
  140 IBOX = 2                                                          00002010
C  EVENT TYPE (A+B)1.B.^C                                               00002020
      IF(HB.GT.0) IBOX = 5                                              00002030
      NEVENT(IBOX) = NEVENT(IBOX) + 1                                   00002040
C   CALL ROUTINE TO PROCESS LED LOW GAIN BOXES.                         00002050
      CALL GETBX8(HA,HB,NBOX,IFLAG)                                     00002060
      IF (NBOX.EQ.0) GOTO 130                                           00002070
      IF (NBOX.NE.0) GOTO 115                                           00002080
C                                                                       00002090
C***********************************************************************00002100
C           M E D   DATA POINT                                          00002110
C***********************************************************************00002120
C                                                                       00002130
130   HD = HDD(I)                                                       00002140
C   SKIP IF INVALID EVENT.                                              00002150
      IF(HD.EQ.0) GO TO 180                                             00002160
      HE = HEE(I)                                                       00002170
      HF = HFF(I)                                                       00002180
C                                                                       00002190
C   CHECK FOR BAD MED DATA. IF FOUND, PDUMP AND SKIP RECORD.            00002200
      IF (HE.LE.1023.AND.HMEDNT(I).LE.6) GOTO 135                       00002210
      PRINT 13000,I,HD,HE,HF,HMEDNT(I)                                  00002220
13000 FORMAT(1X,'***** BAD MED EVENT ENCOUNTERED AND SKIPPED *****',    00002230
     */10X,5I10)                                                        00002240
c6/94 CALL PDUMP(HPHA(1),HPHA(320),0)                                   00002250
      IBAD = IBAD - 1                                                   00002260
      IF (IBAD.LE.0) CALL ABEND(888)                                    00002270
      GOTO 181                                                          00002280
135   CONTINUE                                                          00002290
C                                                                       00002300
      IBOX = MYBNO(HMEDNT(I))                                           00002310
      IF (IBOX.EQ.11.AND..NOT.QMEDGN(I)) GOTO 180                       00002320
      NEVENT(IBOX) = NEVENT(IBOX) + 1                                   00002330
C   SKIP IF MED LOW GAIN EVENT.                                         00002340
      IF (QMEDGN(I)) GOTO 180                                           00002350
C   IF STOPPING EVENT (I.E., IBOX .NE. 7 NOR 9), MUST                   00002360
C   NORMALIZE TO IMP-8 STANDARD, NOT IMP-6 (AS FROM GAIN ARRAY).        00002370
C   USING FACTORS D(IMP-6)/D(IMP-8)=.8522, E(IMP-6)/E(IMP-8)=.9386      00002380
      GAIND = GAIN(3)                                                   00002390
      GAINE = GAIN(4)                                                   00002400
      IF (IBOX.NE.7.AND.IBOX.NE.9) GAIND = GAIND/.8522                  00002410
      IF (IBOX.NE.7.AND.IBOX.NE.9) GAINE = GAINE/.9386                  00002420
C  GAIN CORRECT MED POINTS                                              00002430
C  IF D OR E SHIFTED TO 0, SET TO 1.                                    00002440
c6/94 HD = (HD + RAND(S))*GAIND                                         00002450
      HD = (HD + RAND(iS))*GAIND                                         00002450
      IF (HD.EQ.0) HD = 1                                               00002460
c6/94 HE = (HE + RAND(S))*GAINE                                         00002470
      HE = (HE + RAND(iS))*GAINE                                         00002470
      IF (HE.EQ.0) HE = 1                                               00002480
C   GAIN CORRECT F AND MULTIPLY BY 2 (IF F NONZERO).                    00002490
c6/94 IF (HFF(I).NE.0) HF = (HF + RAND(S))*GAIN(5)                      00002500
      IF (HFF(I).NE.0) HF = (HF + RAND(iS))*GAIN(5)                      00002500
      IF (HFF(I).NE.0) HF = 2*HF                                        00002510
C  PROCESS DATA POINT                                                   00002520
      GO TO (180,180,180,180,180,180,180,146,150,146,180),IBOX          00002530
C                                                                       00002540
C   CHECK FOR MED ELECTRON BOXES.                                       00002550
146   IF (HD.GE.2.AND.HD.LE.35.AND.HE.GE.3.AND.HE.LE.16)                00002560
     *              CALL FLX8EL(HD,HE,HBXSUM,IBXORB)                    00002570
C                                                                       00002580
C   STOPPING PROTONS  D.E.-F.-G      (BOXES 30-35)                      00002590
      IF(HE.LT.4) GO TO 180                                             00002600
      IF(HE.GT.97) GO TO 147                                            00002610
      IF(HD.LT.IDEP(1,HE).OR.HD.GT.IDEP(2,HE)) GOTO 147                 00002620
      NBOX = IDEP(3,HE)                                                 00002630
      GO TO 115                                                         00002640
  147 CONTINUE                                                          00002650
      IF (HE.LT.16.OR.HE.GT.435) GO TO 180                              00002660
C   STOPPING ALPHAS   D.E.-F.-G      (BOXES 36-41)                      00002670
      IF(HD.LT.IDEA(1,HE).OR.HD.GT.IDEA(2,HE)) GOTO 180                 00002680
      NBOX = IDEA(3,HE)                                                 00002690
      GO TO 115                                                         00002700
C                                                                       00002710
C  PENETRATING PARTICLES -- D.E.F.^G                                    00002720
C                                                                       00002730
C   FIRST CHECK HELIUM BOXES (42-56) AND THEN PROTON BOXES (60-76).     00002740
C  LIMITS: 242<E<381  67<F<113 OR 151<F<369  (BOXES 42,43)              00002750
150   IF(HE.LT.243) GO TO 152                                           00002760
      IF(HE.GT.435) GO TO 165                                           00002770
      IF(HF.LT.68) GO TO 165                                            00002780
      IF(HF.GT.112) GO TO 151                                           00002790
      IF(HD.LT.IDFHA(1,HF-67).OR.HD.GT.IDFHA(2,HF-67)) GOTO 165         00002800
      NBOX = IDFHA(3,HF-67)                                             00002810
      GO TO 115                                                         00002820
C   FORWARD-MOVING PARTICLES IN THIS E-BAND.          (BOX 43)          00002830
151   IF (HD.LT.68.OR.HD.GT.107) GOTO 165                               00002840
      JHD = (HD-64)/4                                                   00002850
      IF (HF.LT.HB43(1,JHD).OR.HF.GT.HB43(2,JHD)) GOTO 165              00002860
      NBOX = 43                                                         00002870
      GO TO 115                                                         00002880
C                                                                       00002890
C  LIMITS: 205<E<243  66<F<99               (BOX 44)                    00002900
152   IF (HE.LT.206) GOTO 155                                           00002910
      IF (HF.LT.67) GOTO 165                                            00002920
      IF (HF.GT.98) GOTO 153                                            00002930
      L = (HF+1)/2 - 33                                                 00002940
      IF (HD.LT.HB44(1,L).OR.HD.GT.HB44(2,L)) GOTO 165                  00002950
      NBOX = 44                                                         00002960
      GOTO 115                                                          00002970
C                                                                       00002980
C  FORWARD MOVING PARTICLES IN SAME E-RANGE  (BOX 45)                   00002990
153   IF (HD.LT.64.OR.HD.GT.89) GOTO 165                                00003000
      L = HD/2 - 31                                                     00003010
      IF (HF.LT.HB45(1,L).OR.HF.GT.HB45(2,L)) GOTO 165                  00003020
      NBOX = 45                                                         00003030
      GOTO 115                                                          00003040
C                                                                       00003050
C  LIMITS: 168<E<206  53<F<97 OR 79<F<141    (BOX 48)                   00003060
155   IF(HE.LT.169) GO TO 158                                           00003070
      IF(HE.GT.205) GO TO 165                                           00003080
      IF(HF.LT.54) GO TO 165                                            00003090
      IF(HF.GT.96) GO TO 157                                            00003100
      IF(HD.LT.IDFHG(1,HF-53).OR.HD.GT.IDFHG(2,HF-53)) GOTO 157         00003110
      NBOX = IDFHG(3,HF-53)                                             00003120
      GO TO 115                                                         00003130
C  FORWARD MOVING PARTICLES IN THIS E-BAND            (BOX 49)          00003140
  157 IF(HF.LT.80.OR.HF.GT.141) GOTO 165                                00003150
      L = HF/2 - 39                                                     00003160
      IF (HD.LT.HB49(1,L).OR.HD.GT.HB49(2,L)) GOTO 165                  00003170
      NBOX = 49                                                         00003180
      GO TO 115                                                         00003190
C                                                                       00003200
C  LIMITS: 145<E<169  AND  51<F<109          (BOX 50)                   00003210
  158 IF(HE.LT.146) GO TO 159                                           00003220
      IF(HE.GT.168) GO TO 165                                           00003230
      IF(HF.LT.52.OR.HF.GT.109) GOTO 165                                00003240
      L = HF/2 - 25                                                     00003250
      IF (HD.LT.HB50(1,L).OR.HD.GT.HB50(2,L)) GOTO 165                  00003260
      NBOX = 50                                                         00003270
      GO TO 115                                                         00003280
C                                                                       00003290
C  LIMITS: 117<E<146  AND  39<F<93           (BOX 51)                   00003300
  159 IF(HE.LT.118) GO TO 160                                           00003310
      IF(HE.GT.145) GO TO 165                                           00003320
      IF(HF.LT.40.OR.HF.GT.93) GOTO 165                                 00003330
      L = HF/2 - 19                                                     00003340
      IF (HD.LT.HB51(1,L).OR.HD.GT.HB51(2,L)) GOTO 165                  00003350
      NBOX = 51                                                         00003360
      GO TO 115                                                         00003370
C                                                                       00003380
C  LIMITS: 102<E<118  AND  33<F<75           (BOX 52)                   00003390
  160 IF(HE.LT.103) GO TO 161                                           00003400
      IF(HE.GT.117) GO TO 165                                           00003410
      IF(HF.LT.34.OR.HF.GT.75) GOTO 165                                 00003420
      IF(HD.LT.IDFHK(1,HF-33).OR.HD.GT.IDFHK(2,HF-33)) GOTO 165         00003430
      NBOX = IDFHK(3,HF-33)                                             00003440
      GO TO 115                                                         00003450
C                                                                       00003460
C  LIMITS: 86<E<103  AND  29<F<69            (BOX 53)                   00003470
  161 IF(HE.LT.87) GO TO 162                                            00003480
      IF(HE.GT.102) GO TO 165                                           00003490
      IF(HF.LT.30.OR.HF.GT.69) GOTO 165                                 00003500
      L = HF/2 - 14                                                     00003510
      IF(HD.LT.HB53(1,L).OR.HD.GT.HB53(2,L)) GOTO 165                   00003520
      NBOX = 53                                                         00003530
      GO TO 115                                                         00003540
C                                                                       00003550
C  LIMITS: 75<E<87  AND  25<F<55              (BOX 54)                  00003560
  162 IF(HE.LT.76) GO TO 163                                            00003570
      IF(HE.GT.86) GO TO 165                                            00003580
      IF(HF.LT.26.OR.HF.GT.55) GOTO 165                                 00003590
      IF(HD.LT.IDFHM(1,HF-25).OR.HD.GT.IDFHM(2,HF-25)) GOTO 165         00003600
      NBOX = IDFHM(3,HF-25)                                             00003610
      GO TO 115                                                         00003620
C                                                                       00003630
C  LIMITS: 66<E<76  AND  21<F<53             (BOX 55)                   00003640
  163 IF(HE.LT.67) GO TO 164                                            00003650
      IF(HE.GT.75) GO TO 165                                            00003660
      IF(HF.LT.22.OR.HF.GT.53) GOTO 165                                 00003670
      IF(HD.LT.IDFHN(1,HF-21).OR.HD.GT.IDFHN(2,HF-21)) GOTO 165         00003680
      NBOX = IDFHN(3,HF-21)                                             00003690
      GO TO 115                                                         00003700
C                                                                       00003710
C  LIMITS: 60<E<67  AND  17<F<51             (BOX 56)                   00003720
  164 IF(HE.LT.61) GO TO 165                                            00003730
      IF(HE.GT.66) GO TO 165                                            00003740
      IF(HF.LT.18.OR.HF.GT.51) GOTO 165                                 00003750
      IF(HD.LT.IDFHO(1,HF-17).OR.HD.GT.IDFHO(2,HF-17)) GOTO 165         00003760
      NBOX = IDFHO(3,HF-17)                                             00003770
      GO TO 115                                                         00003780
C                                                                       00003790
C***********************************************************************00003800
C   PENETRATING PROTON BOXES    D.E.F.-G                                00003810
C***********************************************************************00003820
C                                                                       00003830
165   CONTINUE                                                          00003840
C                                                                       00003850
C  LIMITS:  E:76-91, D:57-240, F:17-38          (BOX 60)                00003860
      IF (HE.LT.76) GOTO 167                                            00003870
      IF (HE.GT.97) GOTO 180                                            00003880
      IF (HD.LT.57.OR.HD.GT.240) GOTO 166                               00003890
      IF (HF.LT.17.OR.HF.GT.38)  GOTO 166                               00003900
      NBOX = 60                                                         00003910
      GOTO 115                                                          00003920
C                                                                       00003930
C  LIMITS:  E:76-91, D:14-27, F:72-161           (BOX 61)               00003940
166   IF (HD.LT.14.OR.HD.GT.27) GOTO 180                                00003950
      IF (HF.LT.72.OR.HF.GT.161) GOTO 180                               00003960
      NBOX = 61                                                         00003970
      GOTO 115                                                          00003980
C                                                                       00003990
C   LIMITS:   E:66-75, D:59-178, F:13-32         (BOX 62)               00004000
167   IF (HE.LT.66) GOTO 170                                            00004010
      IF (HD.LT.59.OR.HD.GT.178) GOTO 169                               00004020
      IF (HF.LT.13.OR.HF.GT.32) GOTO 169                                00004030
      NBOX = 62                                                         00004040
      GOTO 115                                                          00004050
C                                                                       00004060
C  FORWARD, SAME E,  D:13-26, F:73-178           (BOX 63)               00004070
169   IF (HD.LT.14.OR.HD.GT.27) GOTO 180                                00004080
      IF (HF.LT.74.OR.HF.GT.179) GOTO 180                               00004090
      NBOX = 63                                                         00004100
      GOTO 115                                                          00004110
C                                                                       00004120
C   LIMITS:  E:57-65, F:11<38, D:39<200           (BOX 64)              00004130
170   IF (HE.LT.57) GOTO 172                                            00004140
      IF (HF.LT.16) GOTO 180                                            00004150
      IF (HF.GT.28) GOTO 171                                            00004160
      L = (HF)/2 - 7                                                    00004170
      IF (HD.LT.HB64(1,L).OR.HD.GT.HB64(2,L)) GOTO 180                  00004180
      NBOX = 64                                                         00004190
      GOTO 115                                                          00004200
C                                                                       00004210
C  FORWARD, SAME E,  D:11<24, F:51<166            (BOX 65)              00004220
171   IF (HD.LT.10.OR.HD.GT.25) GOTO 180                                00004230
      L =  HD/2 - 4                                                     00004240
      IF (HF.LT.HB65(1,L).OR.HF.GT.HB65(2,L)) GOTO 180                  00004250
      NBOX = 65                                                         00004260
      GOTO 115                                                          00004270
C                                                                       00004280
C  LIMITS E: 49-56, F: 16-37, D<37            (BOX 67)                  00004290
  172 IF(HE.LT.49) GO TO 1721                                           00004300
      IF (HF.LT.14.OR.HF.GT.64) GOTO 180                                00004310
      IF(HD.LE.30) GO TO 4536                                           00004320
C  BACKWARD TRACK = BOX 70                                              00004330
      L= HF/2 -6                                                        00004340
      IF(HD.LT.HB70(1,L) .OR. HD.GT.HB70(2,L)) GO TO 180                00004350
      NBOX=70                                                           00004360
      GO TO 115                                                         00004370
4536  CONTINUE                                                          00004380
      IF(HF.GE.34.AND.HD.LE.24) GO TO 4537                              00004390
C   BACKGROUND FOR BOX 67 = BOX 71                                      00004400
      L= HF/2 -7                                                        00004410
      IF(HD.LT. HB71(1,L) .OR. HD.GT.HB71(2,L)) GO TO 180               00004420
      NBOX=71                                                           00004430
      GO TO 115                                                         00004440
4537  CONTINUE                                                          00004450
C   BOX 67 - FORWARD                                                    00004460
      IF(HF.LT.HB67(1,HD-11) .OR.HF.GT. HB67(2,HD-11)) GO TO 180        00004470
      NBOX= 67                                                          00004480
      GO TO 115                                                         00004490
C                                                                       00004500
C  LIMITS E: 40-48, F: 14-34, D<38           (BOX 68)                   00004510
 1721 IF(HE.LT.40) GO TO 1722                                           00004520
      IF (HF.LT.12.OR.HF.GT.46) GOTO 180                                00004530
      L = HF/2 - 5                                                      00004540
      IF (HD.LT.HB68(1,L).OR.HD.GT.HB68(2,L)) GOTO 180                  00004550
      NBOX = 68                                                         00004560
      GO TO 115                                                         00004570
C                                                                       00004580
C  LIMITS E: 35-39, F: 12-24                 (BOX 69)                   00004590
 1722 IF(HE.LT.35) GO TO 1723                                           00004600
      IF (HF.LT.10.OR.HF.GT.32) GOTO 180                                00004610
      L = HF/2 - 4                                                      00004620
      IF (HD.LT.HB69(1,L).OR.HD.GT.HB69(2,L)) GOTO 180                  00004630
      NBOX = 69                                                         00004640
      GO TO 115                                                         00004650
C                                                                       00004660
C   LIMITS:  E:28-34, F:7<24, D:8<23              (BOX 72)              00004670
1723  IF (HE.LT.28) GOTO 173                                            00004680
      IF (HF.LT.8.OR.HF.GT.28) GOTO 180                                 00004690
      L = HF/2 - 3                                                      00004700
      IF (HD.LT.HB72(1,L).OR.HD.GT.HB72(2,L)) GOTO 180                  00004710
      NBOX = 72                                                         00004720
      GOTO 115                                                          00004730
C                                                                       00004740
C   LIMITS:  E:25-27,  F:7<20,  D:7<18            (BOX 73)              00004750
173   IF (HE.LT.25) GOTO 174                                            00004760
      IF (HF.LT.8.OR.HF.GT.22) GOTO 180                                 00004770
      L = HF/2 - 3                                                      00004780
      IF (HD.LT.HB73(1,L).OR.HD.GT.HB73(2,L)) GOTO 180                  00004790
      NBOX = 73                                                         00004800
      GOTO 115                                                          00004810
C                                                                       00004820
C   LIMITS:  E:21-24,  F:7<18,  D:6<17            (BOX 74)              00004830
174   IF (HE.LT.21) GOTO 175                                            00004840
      IF (HF.LT.6.OR.HF.GT.20) GOTO 180                                 00004850
      L = HF/2 -2                                                       00004860
      IF (HD.LT.HB74(1,L).OR.HD.GT.HB74(2,L)) GOTO 180                  00004870
      NBOX = 74                                                         00004880
      GOTO 115                                                          00004890
C                                                                       00004900
C   LIMITS:  E:17-20,  F:3<16,  D:3<15             (BOX 75)             00004910
175   IF (HE.LT.17) GOTO 176                                            00004920
      IF (HF.LT.4.OR.HF.GT.16) GOTO 180                                 00004930
      L = (HF+1)/2 - 1                                                  00004940
      IF (HD.LT.HB75(1,L).OR.HD.GT.HB75(2,L)) GOTO 180                  00004950
      NBOX = 75                                                         00004960
      GOTO 115                                                          00004970
C                                                                       00004980
C   LIMITS:  E:14-16,  F:1<20,  D:3<16             (BOX 76)             00004990
176   IF (HE.LT.14) GOTO 177                                            00005000
      IF (HF.LT.2.OR.HF.GT.20) GOTO 180                                 00005010
      L = (HF+1)/2                                                      00005020
      IF (HD.LT.HB76(1,L).OR.HD.GT.HB76(2,L)) GOTO 180                  00005030
      NBOX = 76                                                         00005040
      GOTO 115                                                          00005050
C                                                                       00005060
177   CONTINUE                                                          00005070
  180 CONTINUE                                                          00005080
C                                                                       00005090
  181 CONTINUE                                                          00005100
      RETURN                                                            00005110
      END                                                               00005120
