      SUBROUTINE IMPEAK(IMP,JC,ITYP,IPLOT,IX1,IX2,IY1,IY2,HIST,QLIM)    00000100
      IMPLICIT LOGICAL*1(Q),INTEGER*2(H)                                00000200
      DIMENSION IPLOT(128,128),KOUNTX(128),KOUNTY(128),HIST(4)          00000300
      REAL*4 DLOW(3)/.28 ,.37 ,.34 /,DHI(3)/.81 ,.77 ,.77 /,            00000400
     *       ELOW(3)/.122,.109,.104/,EHI(3)/.195,.174,.177/,            00000500
     *       FLOW(3)/.300,.344,.304/,FHI(3)/.725,.812,.696/             00000600
C                                                                       00000700
C   THIS SUBROUTINE DETERMINES PEAK POSITIONS OF MATRIX DATA (IPLOT) AS 00000800
C   DEFINED BY HISTOGRAM LIMITS (HIST).   IMP IS THE IMP NUMBER (6,7,8),00000900
C   JC IS THE COMPRESSION FACTOR, AND ITYP IS THE PLOT TYPE (=1AVSB,    00001000
C   =2DVSE, =3DVSF)                                                     00001100
C   ***** CALCULATES MEAN PEAK (MAX HE IONIZ) AS FOLLOWS:               00001200
C    1 - LOCATE MAXIMUM VALUE CHANNEL WITHIN HISTOGRAM LIMITS AND       00001300
C        SET NEW LIMITS ON EACH SIDE OF PEAK (USING DLOW, DUP,ETC.)     00001400
C    2 - CALCULATE NEW PEAK MEAN FROM THESE LIMITS.                     00001500
C   FIRST GET STANDARD CENTROIDS.                                       00001600
C   DEFINE PEAK LIMITS (PER CENT OF MAX CHANNEL VALUE).                 00001700
C     NOTE:  IF ITYP=3, THEN THE X-AXIS IS THE F DETECTOR, WHICH HAS    00001800
C   DATA IN EVERY OTHER CHANNEL (1,3,5,7,...,127).  THE CENTROID OF THE 00001900
C   F-PEAK IS DETERMINED BASED ON CONSECUTIVE CHANNELS (1,2,3,...,64),  00002000
C   SO THAT WE HAVE TO DEFINE KXLOW, KXHI, ETC. FOR INDEX LIMITS.       00002100
C     LIMITS PRESENTLY DETERMINED FROM 10% PEAK-HEIGHT FOR BOTH D       00002200
C   AND F PEAKS, AND 50% PEAK-HEIGHT FOR E PEAKS.                       00002300
C                                                                       00002400
      IIMP = IMP - 5                                                    00002500
      IF (IMP.LT.6.OR.IMP.GT.8) IIMP = 1                                00002600
      XC1  = 1.0                                                        00002700
      XC2  = 1.0                                                        00002800
      YC1 =  1.0                                                        00002900
      YC2  = 1.0                                                        00003000
      IF (ITYP.NE.1) YC1 = DLOW(IIMP)                                   00003100
      IF (ITYP.NE.1) YC2 = DHI (IIMP)                                   00003200
      IF (ITYP.EQ.2) XC1 = ELOW(IIMP)                                   00003300
      IF (ITYP.EQ.2) XC2 = EHI (IIMP)                                   00003400
      IF (ITYP.EQ.3) XC1 = FLOW(IIMP)                                   00003500
      IF (ITYP.EQ.3) XC2 = FHI (IIMP)                                   00003600
c
c6/96
c
      write(6,123)ITYP,IX1,IX2,IY1,IY2,HIST,QLIM
123   format(' ITYP IX1 IX2 IY1 IY2 HIST = ',9i5,5x,l1)
      write(6,124)ITYP,XC1,XC2,YC1,YC2
124   format(' ITYP XC1 XC2 YC1 YC2 = ',i5,4f8.3)
c
      MAXNUX = 0                                                        00003700
      MAXNUY = 0                                                        00003800
      DO 125 LQ=1,128                                                   00003900
        KOUNTX(LQ) = 0                                                  00004000
125     KOUNTY(LQ) = 0                                                  00004100
C   LOOK FOR MAXIMUM VALUE CHANNELS ON BOTH AXES (ICHX, ICHY).          00004200
      DO 160 I=IX1,IX2                                                  00004300
        DO 150 J=IY1,IY2                                                00004400
150       KOUNTX(I) = KOUNTX(I) + IPLOT(I,J)                            00004500
        IF (KOUNTX(I).LE.MAXNUX) GOTO 160                               00004600
        MAXNUX = KOUNTX(I)                                              00004700
        ICHX = I                                                        00004800
160     CONTINUE                                                        00004900
      IF (ITYP.EQ.3) ICHX = (ICHX+1)/2                                  00005000
      CHX = ICHX                                                        00005100
      DO 260 J=IY1,IY2                                                  00005200
        DO 250 I=IX1,IX2                                                00005300
250       KOUNTY(J) = KOUNTY(J) + IPLOT(I,J)                            00005400
        IF (KOUNTY(J).LE.MAXNUY) GOTO 260                               00005500
        MAXNUY = KOUNTY(J)                                              00005600
        ICHY = J                                                        00005700
260     CONTINUE                                                        00005800
      CHY = ICHY                                                        00005900
C   SET NEW PEAK LIMITS (IXLOW, IXHI, IYLOW, IYHI).                     00006000
      IF(QLIM) GO TO 300                                                00006050
      XLOW = (1.0 - XC1)*CHX                                            00006100
      XHI  = (1.0 + XC2)*CHX                                            00006200
      IXLOW = XLOW                                                      00006300
      IF (XLOW.NE.AINT(XLOW)) IXLOW = AINT(XLOW + 1.0)                  00006400
      IXHI  = XHI                                                       00006500
      FRACLX = FLOAT(IXLOW) - XLOW                                      00006600
      FRACHX = XHI  - FLOAT(IXHI )                                      00006700
c
c6/96
      write(6,225) IXLOW,XLOW,FRACLX
225   format(' IXLOW XLOW FRACLX = ',i6,5x,2F8.3)
c
      YLOW = (1.0 - YC1)*CHY                                            00006800
      YHI  = (1.0 + YC2)*CHY                                            00006900
      IYLOW = YLOW                                                      00007000
      IF (YLOW.NE.AINT(YLOW)) IYLOW = AINT(YLOW + 1.0)                  00007100
      IYHI = YHI                                                        00007200
      FRACLY = FLOAT(IYLOW) - YLOW                                      00007300
      FRACHY = YHI  - FLOAT(IYHI )                                      00007400
c
c6/96
      write(6,226) IYHI,YHI,FRACHY
226   format(' IYHI  YHI  FRACHY = ',i6,5x,2F8.3)
c
      JXLOW = IXLOW - 1                                                 00007500
      JXHI  = IXHI  + 1                                                 00007600
      JYLOW = IYLOW - 1                                                 00007700
      JYHI  = IYHI  + 1                                                 00007800
      KXLOW = JXLOW                                                     00007900
      KXHI  = JXHI                                                      00008000
      IF (ITYP.EQ.3) KXLOW = KXLOW*2 - 1                                00008100
      IF (ITYP.EQ.3) KXHI  =  KXHI*2 - 1                                00008200
310   CONTINUE                                                          00008250
C   SUM UP THE MOMENTS OF THE INCLUSIVE FULL CHANNELS ON X-AXIS.        00008300
      XMOMNT = 0                                                        00008400
      XINTEG = 0                                                        00008500
      DO 170 II=IXLOW,IXHI                                              00008600
        I = II                                                          00008700
        IF (ITYP.EQ.3 .AND. .NOT.QLIM) I = II*2 - 1                     00008800
        ISUM = 0                                                        00008900
        DO 165 J=JYLOW,JYHI                                             00009000
165          ISUM = ISUM + IPLOT(I,J)                                   00009100
        XMOMNT = XMOMNT + II*ISUM                                       00009200
170     XINTEG = XINTEG + ISUM                                          00009300
c
c6/96
      write(6,335) XINTEG
335   format('  before QLIM XINTEG = ',f8.3)
c
      IF(QLIM) GO TO 320                                                00009310
C   ADD FRACTION OF LOWEST AND HIGHEST CHANNELS IN X-AXIS PEAK.         00009400
      KOUNTL = 0                                                        00009500
      KOUNTH = 0                                                        00009600
c
      DO 175 J=JYLOW,JYHI                                               00009700
      write(6,470) J,KXLOW,KXHI,IPLOT(KXLOW,J),IPLOT(KXHI,J)
470   format('  J,KXLOW,KXHI,IPLOT= ',5i5)
        KOUNTL = KOUNTL + IPLOT(KXLOW,J)                                00009800
175     KOUNTH = KOUNTH + IPLOT(KXHI ,J)                                00009900
      XMOMNT = XMOMNT + FRACLX*FLOAT(JXLOW*KOUNTL)                      00010000
     *                + FRACHX*FLOAT(JXHI *KOUNTH)                      00010100
      XINTEG = XINTEG + FRACLX*FLOAT(KOUNTL) + FRACHX*FLOAT(KOUNTH)     00010200
      write(6,336) XINTEG
336   format('  after   QLIM XINTEG = ',f8.3)
C   CALCULATE MEAN CHANNEL NUMBER (XBAR).                               00010300
320   CONTINUE                                                          00010310
      XBAR = 0.0                                                        00010400
      IF (XINTEG.GT.0.0) XBAR = XMOMNT/XINTEG - 0.5                     00010500
      XBAR = XBAR*FLOAT(JC)                                             00010600
C                                                                       00010700
C   CALCULATE THE ABOVE, BUT FOR THE Y-AXIS                             00010800
C   SUM UP THE MOMENTS OF THE INCLUSIVE FULL CHANNELS ON Y-AXIS.        00010900
      YMOMNT = 0                                                        00011000
      YINTEG = 0                                                        00011100
      DO 270 J=IYLOW,IYHI                                               00011200
        ISUM = 0                                                        00011300
        DO 265 I=KXLOW,KXHI                                             00011400
265       ISUM = ISUM + IPLOT(I,J)                                      00011500
        YMOMNT = YMOMNT + J*ISUM                                        00011600
270     YINTEG = YINTEG + ISUM                                          00011700
      IF(QLIM) GO TO 330                                                00011710
C   ADD FRACTION OF LOWEST AND HIGHEST CHANNELS IN Y-AXIS PEAK.         00011800
      KOUNTL = 0                                                        00011900
      KOUNTH = 0                                                        00012000
      DO 275 I=KXLOW,KXHI                                               00012100
        KOUNTL = KOUNTL + IPLOT(I,JYLOW)                                00012200
275     KOUNTH = KOUNTH + IPLOT(I,JYHI )                                00012300
      YMOMNT = YMOMNT + FRACLY*FLOAT(JYLOW*KOUNTL)                      00012400
     *                + FRACHY*FLOAT(JYHI *KOUNTH)                      00012500
      YINTEG = YINTEG + FRACLY*FLOAT(KOUNTL) + FRACHY*FLOAT(KOUNTH)     00012600
C   CALCULATE MEAN CHANNEL NUMBER (YBAR).                               00012700
330    CONTINUE                                                         00012710
      YBAR = 0.0                                                        00012800
      IF (YINTEG.NE.0.0) YBAR = YMOMNT/YINTEG - 0.5                     00012900
      YBAR = YBAR*FLOAT(JC)                                             00013000
C   PLOT HISTOGRAMS AND PRINT OUT RESULTS - X-AXIS AND THEN Y-AXIS.     00013100
      INC = 1                                                           00013200
      IF(MAXNUX.GT.50) INC = 10                                         00013300
      NVAL = NTIC(MAXNUX,INC)                                           00013400
      CALL HISTOS(KOUNTX,IX1,IX2,NVAL,MAXNUX,JC)                        00013500
      WRITE(6,1700) HIST(1),HIST(2),JC,MAXNUX,XBAR,                     00013600
     *XLOW,XHI                                                          00013700
1700  FORMAT('0',50X,'RANGE OF ABSCISSAE',I4,' TO',I4/                  00013800
     * 54X,'COMPRESSION FACTOR:',I3/60X,'* = ' ,I7/                     00013900
     * 36X,'AVERAGE ABSCISSA =',F8.3,                                   00014000
     * 10X,'NEW LIMITS = (',F7.3,',',F7.3,')')                          00014100
C                                                                       00014200
      INC = 1                                                           00014300
      IF(MAXNUY.GT.50) INC = 10                                         00014400
      NVAL=NTIC(MAXNUY,INC)                                             00014500
      CALL HISTOS(KOUNTY,IY1,IY2,NVAL,MAXNUY,JC)                        00014600
      WRITE(6,1800) HIST(3),HIST(4),JC,MAXNUY,YBAR,                     00014700
     *YLOW,YHI                                                          00014800
1800  FORMAT('0',50X,'RANGE OF ORDINATE',I4,' TO',I4/                   00014900
     * 54X,'COMPRESSION FACTOR:',I3/60X,'* = ',I7/                      00015000
     * 36X,'AVERAGE ORDINATE =',F8.3,                                   00015100
     * 10X,'NEW LIMITS = (',F7.3,',',F7.3,')')                          00015200
      RETURN                                                            00015300
300   KXLOW=IX1                                                         00015310
      IXLOW=IX1                                                         00015320
      XLOW=IX1                                                          00015330
      KXHI=IX2                                                          00015340
      IXHI=IX2                                                          00015350
      XHI=IX2                                                           00015360
      IYLOW=IY1                                                         00015370
      YLOW=IY1                                                          00015380
      IYHI=IY2                                                          00015385
      YHI=IY2                                                           00015390
      JYLOW=IY1                                                         00015391
      JYHI=IY2                                                          00015392
      GO TO 310                                                         00015397
      END                                                               00015400
