      SUBROUTINE ACC7S                                                  00000010
C                                                                       00000020
C   CALLED BY ACCUMS, ACCUMULATES DATA FROM IMP-7 SUMMARY COUNTS TAPE   00000030
C   RECORD FOR IMP PLOT INPUT.                                          00000040
C                                                                       00000050
C   MODIFY BY HENRY LO ON 9/90                                                  
C   CHANGE EQUIVALENCE STATEMENT TO CONFORM WITH VS-FORTRAN                     
C   COMPILER SYNTAX                                                             
C                                                                               
      IMPLICIT LOGICAL*1(Q),INTEGER*2(H)                                00000060
CLO   COMMON /ACCCUM/ VALS(6),DENS(6),INT                               00000070
CLO                                                                     00000080
      COMMON /ACCCUM/ VALS(250),DENS(250),RDENS(250),INT                00000090
CLO                                                                     00000100
CLO   COMMON /EXPON/ QEVTON(6),QEVCHK                                           
CLO                                                                             
      COMMON /EXPON/  QEVTON(250),QEVCHK                                00000110
CLO                                                                             
CLO   COMMON /GEOMF/ GEOM(70,3),TIMLIV(70,3),FACTOR(6),XMEV(6)                  
CLO                                                                             
      COMMON /GEOMF/  GEOM(70,3),TIMLIV(70,3),FACTOR(250),XMEV(250)             
CLO   COMMON /PARS/ IEVENT(6),ISECTR(6),MAP(6),IPLTPT(6),IMP(6),INOEV           
      COMMON /PARS/ IEVENT(250),ISECTR(250),MAP(6),IPLTPT(6),IMP(250),          
     *              INOEV                                                       
      COMMON /PARS1/  IFRMNO,IFRMAX,IXTYPE,IYTYPE                       00000150
      COMMON /REJECT/ QPOINT,QFILTR                                     00000160
      COMMON /REKORD/ KRECID(615,3)                                     00000170
      COMMON /SEKOPT/ QFAILS,QSUN0S                                     00000180
      DIMENSION ISMCT(615),SMCT(615),HSMCT(1230)                        00000190
CLO   EQUIVALENCE (KRECID(616),ISMCT(1),SMCT(1),HSMCT(1))               00000200
      EQUIVALENCE (KRECID(1,2),ISMCT(1),SMCT(1),HSMCT(1))               00000200
C                                                                       00000210
      QSKIP = .FALSE.                                                   00000220
      QDROP = .FALSE.                                                   00000230
        DO 90 IEV=1,INOEV                                               00000320
C   CHECK FOR CORRECT IMP NUMBER AND FOR EVENT TYPE ON                  00000330
          IF (IMP(IEV).NE.2) GOTO 90                                    00000370
          IF (QEVCHK.AND..NOT.QEVTON(IEV)) GOTO 90                      00000380
          IV = IEVENT(IEV)                                              00000390
          IF (IV.GT.50) GOTO 10                                         00000430
C   STORE NON-SECTORED EVENT.                                           00000450
          VALUE = ISMCT(25 + 3*IV)                                      00000460
          IF (.NOT.QPOINT) VALUE = VALUE + ISMCT(26 + 3*IV)             00000470
          DEN = HSMCT(53 + 6*IV)                                        00000480
          IF (.NOT.QPOINT) DEN = DEN + HSMCT(54 + 6*IV)                 00000490
          IF (DEN.EQ.0.0) GOTO 90                                       00000500
          DEN = DEN*TIMLIV(IV,2)                                        00000510
          GOTO 70                                                       00000520
C   STORE SECTORED RATE.                                                00000530
 10     IF (QDROP) GOTO 90                                              00000540
        IVS = IV - 50                                                   00000550
        IF (QSKIP) GOTO 30                                              00000560
        IF1 = HSMCT(355)                                                00000570
C   CHECK FOR ZERO SUN TIME.                                            00000580
        IF (QSUN0S.AND.IF1.GE.3) GOTO 20                                00000590
C   CHECK FOR UNDETERMINED DATA.                                        00000600
        IF (IF1.EQ.2) GOTO 20                                           00000610
C   CHECK FOR FAIL DATA.                                                00000620
        QFAIL = .FALSE.                                                 00000630
        IF (IF1.EQ.1) QFAIL = .TRUE.                                    00000640
        IF (QFAILS.AND.QFAIL) GOTO 20                                   00000650
C   IF OA BAD, THEN SKIP; ELSE CALCULATE LIVE TIME.                     00000660
        IF (SMCT(615).LE.0.0.AND..NOT.QFAIL) GOTO 20                    00000670
        TIMELV  = SMCT(615)*14.0/8.0                                    00000680
        IF (.NOT.QFAIL) GOTO 18                                         00000690
        IRATE = 1                                                       00000700
        IF (IGET(ISMCT(3),0,0).EQ.1) IRATE = 4                          00000710
C   IF FAIL, EACH SECTOR 1/8TH OF A PAGE.                               00000720
        TIMELV = 2.56*IRATE                                             00000730
 18     QSKIP = .TRUE.                                                  00000740
        GOTO 30                                                         00000750
 20     QDROP = .TRUE.                                                  00000760
        GOTO 90                                                         00000770
 30     IBASE = 152                                                     00000780
        IF (IVS.GT.4) IBASE = 153                                       00000790
        IF (ISECTR(IEV).EQ.0) GOTO 40                                   00000800
C   SINGLE SECTOR ACCUMULATED.                                          00000810
          ILOC = IBASE + 24*IVS + 3*ISECTR(IEV)                         00000820
          VALUE = ISMCT(ILOC)                                           00000830
          IF (.NOT.QPOINT) VALUE = VALUE + ISMCT(ILOC+1)                00000840
          DEN = HSMCT(2*ILOC + 3)                                       00000850
          IF (.NOT.QPOINT) DEN = DEN + HSMCT(2*ILOC + 4)                00000860
          GOTO 50                                                       00000870
C   SECTOR SUM ACCUMULATED.                                             00000880
 40       JLOC = IBASE + 24*IVS                                         00000890
          VALUE = 0.0                                                   00000900
          DEN = 0.0                                                     00000910
          DO 45 ISC=1,8                                                 00000920
            KLOC = JLOC + 3*ISC                                         00000930
            VALUE = VALUE + ISMCT(KLOC)                                 00000940
            IF (.NOT.QPOINT) VALUE = VALUE + ISMCT(KLOC+1)              00000950
            DEN = DEN + HSMCT(2*KLOC+3)                                 00000960
            IF (.NOT.QPOINT) DEN = DEN + HSMCT(2*KLOC+4)                00000970
 45         CONTINUE                                                    00000980
 50       IF (DEN.EQ.0.0) GOTO 90                                       00000990
          DEN = DEN*TIMELV                                              00001000
CLO                                                                             
70    CONTINUE                                                                  
      DDEN = DEN                                                                
CLO                                                                             
          IF (IYTYPE.EQ.2) DEN = DEN*FACTOR(IEV)                        00001010
          IF (IYTYPE.EQ.3) DEN = DEN*FACTOR(IEV)*XMEV(IEV)              00001020
          VALS(IEV) = VALS(IEV) + VALUE                                 00001030
          DENS(IEV) = DENS(IEV) + DEN                                   00001040
          RDENS(IEV) = RDENS(IEV) + DDEN                                        
CLO                                                                             
 90       CONTINUE                                                      00001050
      RETURN                                                            00001060
      END                                                               00001070
