CH1   SUBROUTINE: SETNDX                                                00000010
C                                                                       00000020
CH2   FUNCTION: TO DETERMINE THE NEW START AND STOP                     00000030
CH2             INDICES FOR ACCESSING THE HOURLY FINEGAIN               00000040
CH2             FACTORS.                                                00000050
C                                                                       00000060
CH3   CALLING ROUTINES: PHFIL7,HMATN7,LMATN7,                           00000070
CH3                     PHFIL8,HMATN8,LMATN8                            00000080
CC                                                                      00000090
CH4   ROUTINES CALLED: FGDATE                                           00000100
C                                                                       00000110
CH5   VARIABLES USED                                                    00000120
CH5   NAME      TYPE   I/O               DEFINITION                     00000130
CH5                                                                     00000140
CH5   INTVAL     I*4    I    INTERVAL NUMBER IN WHICH THE               00000150
CH5                          START AND STOP TIMES OCCUR.                00000160
CH5                                                                     00000170
CH5   ISTYR      I*4    I    START YEAR OF THE DATA.                    00000180
CH5                                                                     00000190
CH5   ISTDAY     I*4    I    START DAY.                                 00000200
CH5                                                                     00000210
CH5   ISTMSC     I*4    I    START TIME OF DAY IN MILLISECONDS.         00000220
CH5                                                                     00000230
CH5   NDYR       I*4    I    END YEAR OF THE DATA.                      00000240
CH5                                                                     00000250
CH5   NDAY       I*4    I    END DAY.                                   00000260
CH5                                                                     00000270
CH5   NDMSC      I*4    I    END TIME OF DAY IN MILLISECONDS.           00000280
CH5                                                                     00000290
CH5   NDXST      I*4    O    INDEX REPRESENTING THE STARTING            00000300
CH5                          HOUR OF THE DATA WITHIN                    00000310
CH5                          THE INTERVAL.                              00000320
CH5                                                                     00000330
CH5   NDXND      I*4    O    INDEX REPRESENTING THE ENDING              00000340
CH5                          HOUR OF THE DATA WITHIN                    00000350
CH5                          THE INTERVAL.                              00000360
CH5                                                                     00000370
CH5                    NOTE: NDXST=NDXND=0 INDICATES THAT THE           00000380
CH5                          CURRENT TIME SPAN HAS THE SAME             00000390
CH5                          START AND STOP INDICES AND INTERVAL        00000400
CH5                          NUMBER AS THE PREVIOUS TIME SPAN.          00000410
CH5                          OTHERWISE NDXST AND NDXND RANGE IN         00000420
CH5                          VALUE FROM 1 TO 96, WHERE 96 IS THE        00000430
CH5                          NUMBER OF HOURS IN 4 DAYS.                 00000440
CH5                                                                     00000450
C                                                                       00000460
CH6   METHOD                                                            00000470
CH6                                                                     00000480
CH6   THE INDEX VALUES SET BY S/R SETNDX INDICATE TO THE                00000490
CH6   CALLING ROUTINE WHETHER IT IS TIME TO ACCESS THE FINEGAIN         00000500
CH6   TABLE FOR NEW FINEGAIN FACTORS.  AN INDEX VALUE OF ZERO           00000510
CH6   INDICATES THAT THE CURRENT DATA RECORD WILL USE THE               00000520
CH6   SAME FINEGAIN FACTORS AS THE PREVIOUS DATA RECORD.                00000530
CH6   AN INDEX VALUE BETWEEN 1 AND 96 INCLUSIVE SIGNALS                 00000540
CH6   THAT IT IS TIME TO ACCESS THE FINEGAIN TABLES FOR THE             00000550
CH6   RANGE OF HOURS SPECIFIED BY THE START AND STOP INDEX.             00000560
CH6                                                                     00000570
CH6   LET'S TAKE TIME OUT TO DISCUSS TERMS.  THE TERM                   00000580
CH6   "INTERVAL NUMBER" REPRESENTS THE NUMBER OF DAYS SINCE             00000590
CH6   IMP7 WAS LAUNCHED.  THE INTERVAL NUMBERS FOR IMP8 ARE             00000600
CH6   ALSO BASED ON IMP7'S LAUNCH DATE.  ONE INTERVAL EQUALS            00000610
CH6   FOUR DAYS, SO INTERVAL #102 ENDED 408 DAYS AFTER                  00000620
CH6   IMP7 WAS LAUNCHED.  THERE IS ONLY ONE REGULAR GAIN                00000630
CH6   FACTOR FOR A GIVEN INTERVAL, BUT THERE ARE 96 FINEGAIN            00000640
CH6   FACTORS.  THERE IS ONE FINEGAIN FACTOR FOR EACH HOUR              00000650
CH6   OF THE INTERVAL.  (4 DAYS X 24 HOURS PER DAY = 96                 00000660
CH6   HOURS.)  THESE FINEGAIN FACTORS EXIST FOR IMP7                    00000670
CH6   AND IMP8.                                                         00000680
CH6                                                                     00000690
CH6   THE FUNCTION OF S/R SETNDX IS TO TAKE A GIVEN INTERVAL            00000700
CH6   NUMBER AND TIME SPAN WITHIN THE INTERVAL, AND DETERMINE           00000710
CH6   WHICH HOUR OF THE INTERVAL THE START TIME OCCURS IN               00000720
CH6   AND WHICH HOUR THE STOP TIME OCCURS IN.  THERE IS                 00000730
CH6   NO REASON TO REPEATEDLY ACCESS THE FINEGAIN TABLE                 00000740
CH6   FOR THE SAME FINEGAIN FACTOR.  REMEMBER, FOR EXAMPLE,             00000750
CH6   THAT FOR PHA DATA A DATA RECORD SPANS 81.92 SECONDS.              00000760
CH6   FOR A SPAN OF PHA RECORDS WHICH OCCUR IN THE SAME INTERVAL        00000770
CH6   HOUR, THIS WOULD MEAN OVER 40 ACCESSES OF THE FINEGAIN            00000780
CH6   TABLE.  TO AVOID THIS S/R SETNDX IS DESIGNED TO REMEMBER ANY      00000790
CH6   NEW SET OF START AND STOP INDICES THAT ARE CALCULATED.            00000800
CH6   IN SUCCEEDING CALLS S/R SETNDX RETURNS INDEX VALUES               00000810
CH6   OF ZERO UNTIL THERE IS A CHANGE IN THE CALCULATED                 00000820
CH6   START OR STOP INDEX, OR UNTIL THE INTERVAL NUMBER                 00000830
CH6   CHANGES.  SEE S/R FINEGN IF YOU WISH TO LEARN HOW THE             00000840
CH6   INDICES ARE USED.                                                 00000850
C                                                                       00000860
CH7   PROGRAMMED BY: DEBORAH DERRICK        SEPTEMBER 1982              00000870
C                                                                       00000880
C                                                                       00000890
C                                                                       00000900
      SUBROUTINE SETNDX(INTVAL,ISTYR,ISTDAY,ISTMSC,NDYR,NDAY,NDMSC,     00000910
     *                    NDXST,NDXND)                                  00000920
      IMPLICIT LOGICAL*1(Q),REAL*8(D),INTEGER*2(H)                      00000930
      DATA LSTINT /0/                                                   00000940
CP                                                                      00000950
CP       IF THE OUTPUT START AND STOP INDICES WERE SET PREVIOUSLY       00000960
CP          THEN  SAVE THEIR OLD VALUES.                                00000970
CP                SET THE OUTPUT INDICES TO ZERO.                       00000980
CP       ENDIF                                                          00000990
CP                                                                      00001000
      IF (NDXST .EQ. 0) GO TO 100                                       00001010
         KOLDST = NDXST                                                 00001020
         KOLDND = NDXND                                                 00001030
         NDXST  = 0                                                     00001040
         NDXND  = 0                                                     00001050
 100  CONTINUE                                                          00001060
CP                                                                      00001070
CP       IF CURRENT INTERVAL DIFFERS FROM PREVIOUS INTERVAL             00001080
CP          THEN  RESET PAST PARAMETERS.                                00001090
CP                EXPRESS INTERVAL NUMBER AS A DAY AND YEAR             00001100
CP                BY USING S/R FGDATE.                                  00001110
CP                CALCULATE NUMBER OF DAYS IN INTERVAL YEAR.            00001120
CP       ENDIF                                                          00001130
CP                                                                      00001140
      IF (INTVAL .EQ. LSTINT) GO TO 250                                 00001150
         LSTINT = INTVAL                                                00001160
         KOLDST = 0                                                     00001170
         KOLDND = 0                                                     00001180
         CALL FGDATE(INTVAL,KYR,JDAY)                                   00001190
         NUMDAY = 365                                                   00001200
         IF ( MOD(KYR,4) .EQ. 0) NUMDAY = 366                           00001210
 250  CONTINUE                                                          00001220
CP                                                                      00001230
CP       CALCULATE START AND STOP INDICES FROM THE GIVEN TIMES.         00001240
CP                                                                      00001250
      KDAY = ISTDAY                                                     00001260
      IF (ISTYR .NE. KYR) KDAY = KDAY + NUMDAY                          00001270
      KHRS = ISTMSC/3600000                                             00001280
      KSTART = (KDAY - JDAY) * 24  + KHRS + 1                           00001290
      IF (KSTART .GT. 0  .AND.  KSTART .LT. 97) GO TO 500               00001300
          WRITE(6,325)                                                  00001310
 325      FORMAT('0 ---> FINEGAIN STARTING INDEX OUT OF RANGE.')        00001320
         WRITE (6,350) KSTART,ISTYR,ISTDAY,ISTMSC,INTVAL                00001330
 350     FORMAT('  ---> INDEX = ',I4,' FOR ',                           00001340
     *            'YEAR ',I4,' DAY ',I4,' MSECS ',I8,'.  INTERVAL ',    00001350
     *            'NUMBER IS ',I6)                                      00001360
         IF (KSTART .LT. 1) KSTART = 1                                  00001370
         IF (KSTART .GT. 96) KSTART = 96                                00001380
 500  CONTINUE                                                          00001390
      KDAY = NDAY                                                       00001400
      IF (NDYR .NE. KYR) KDAY = KDAY + NUMDAY                           00001410
      KHRS = NDMSC/3600000                                              00001420
      KSTOP = (KDAY - JDAY) * 24  +  KHRS  + 1                          00001430
      IF (KSTOP .GT. 0  .AND.  KSTOP .LT. 97) GO TO 750                 00001440
         WRITE(6,525)                                                   00001450
 525     FORMAT('0 ---> FINEGAIN STOPPING INDEX OUT OF RANGE.')         00001460
         WRITE(6,350) KSTOP,NDYR,NDAY,NDMSC,INTVAL                      00001470
         IF (KSTOP .LT. 1) KSTOP = 1                                    00001480
         IF (KSTOP .GT. 96) KSTOP = 96                                  00001490
 750  CONTINUE                                                          00001500
      IF (KSTART .LE. KSTOP) GO TO 900                                  00001510
         WRITE(6,850) KSTART,KSTOP,ISTYR,ISTDAY,ISTMSC,NDYR,NDAY,       00001520
     *                NDMSC,INTVAL                                      00001530
 850     FORMAT('  ---> ERROR.  START INDEX = ',I4,' WHICH IS ',        00001540
     *            'GREATER THAN THE STOP INDEX OF ',I4,/,'  WILL SET ', 00001550
     *            'THE START INDEX EQUAL TO THE STOP INDEX.',/,         00001560
     *            '  START YEAR, DAY, MSEC WERE ',I4,1X,I4,1X,I8,       00001570
     *            '  STOP YEAR, DAY, MSEC WERE ',I4,1X,I4,1X,I8,        00001580
     *            '  INTERVAL NUMBER WAS ',I5)                          00001590
         KSTART = KSTOP                                                 00001600
 900  CONTINUE                                                          00001610
CP                                                                      00001620
CP       IF THE INDICES HAVE CHANGED SINCE THE LAST TIME                00001630
CP       THEY WERE CALCULATED                                           00001640
CP          THEN  SET OUTPUT INDICES                                    00001650
CP                                                                      00001660
      IF (KOLDST .EQ. KSTART   .AND.   KOLDND .EQ. KSTOP)  RETURN       00001670
C     IHRST = KSTART - 1                                                00001680
C     IHRND = KSTOP - 1                                                 00001690
C     WRITE(6,950)INTVAL,IHRST,IHRND                                    00001700
C950  FORMAT(' WILL ATTEMPT TO ACCESS FINEGAIN TABLE FOR ',             00001710
C    *         'INTERVAL ',I4,' HOURS ',I4,' THRU ',I4)                 00001720
      NDXST = KSTART                                                    00001730
      NDXND = KSTOP                                                     00001740
CP       END SETNDX                                                     00001750
      RETURN                                                            00001760
      END                                                               00001770
