CH1   SUBROUTINE: FINEGN                                                00000010
C                                                                       00000020
CH2   FUNCTION: TO CALCULATE THE FINEGAIN FACTORS FOR                   00000030
CH2             A GIVEN INTERVAL TIME SPAN.                             00000040
C                                                                       00000050
CH3   CALLING ROUTINES: PHFIL7,HMATN7,LMATN7,                           00000060
CH3                     PHFIL8,HMATN8,LMATN8                            00000070
C                                                                       00000080
CH4   ROUTINES CALLED: SYSTEM ROUTINES ABEND, DREAD                     00000090
C                                                                       00000100
CH5   VARIABLES USED                                                    00000110
CH5   NAME      TYPE  I/O               DEFINITION                      00000120
CH5                                                                     00000130
CH5   INTVAL    I*4    I     INTERVAL NUMBER OF THE DATA RECORD.        00000140
CH5                                                                     00000150
CH5   IGTBLE    I*4    I     NORMALIZATION FACTOR.                      00000160
CH5                          =2 THE DATA WILL BE NORMALIZED             00000170
CH5                             TO IMP-6 DATA.                          00000180
CH5                                                                     00000190
CH5   NDXST     I*4    I     START INDEX TO BE USED WHEN                00000200
CH5                          ACCESSING THE FINEGAIN RECORD FOR          00000210
CH5                          THE INTERVAL.                              00000220
CH5                                                                     00000230
CH5   NDXND     I*4    I     STOP INDEX TO BE USED WHEN                 00000240
CH5                          ACCESSING THE FINEGAIN RECORD FOR          00000250
CH5                          THE INTERVAL.                              00000260
CH5                                                                     00000270
CH5   RGAINS(3) R*4    O     FINEGAIN FACTORS FOR EACH                  00000280
CH5                          OF THE MED DETECTORS.                      00000290
CH5                                                                     00000300
CH5 *** THE FOLLOWING VARIABLE IS IN COMMON BLOCK /FINE/ ***            00000310
CH5                                                                     00000320
CH5   IADR      I*4    I     LOGICAL RECORD NUMBER WHERE THE            00000330
CH5                          FINEGAIN DATA FOR THE CURRENT INTERVAL     00000340
CH5                          CAN BE FOUND.                              00000350
CH5                          IADR = 0 INDICATES THAT NO FINEGAIN        00000360
CH5                          FACTORS EXIST FOR THE INTERVAL.            00000370
CH5                                                                     00000380
CH5   *** THE FOLLOWING VARIABLE IS INTERNAL TO S/R FINEGN ***          00000390
CH5                                                                     00000400
CH5   RFGAIN(3,97)    R*4    CONTAINS THE FINEGAIN FACTORS FOR          00000410
CH5                          AN INTERVAL.  GIVEN RFGAIN(I,J):           00000420
CH5                             I = 1,3  REPRESENTS MED DETECTORS       00000430
CH5                                      D, E AND F RESPECTIVELY.       00000440
CH5                             J = 1,96 REPRESENTS THE FINEGAIN        00000450
CH5                                      FACTORS FOR EACH HOUR OF       00000460
CH5                                      THE INTERVAL.                  00000470
CH5                             J = 97   IS MISCELLANEOUS INFORMATION.  00000480
CH5                                                                     00000490
C                                                                       00000500
CH6        METHOD                                                       00000510
CH6                                                                     00000520
CH6   THIS SUBROUTINE IS VERY STRAIGHTFORWARD. THE PDL                  00000530
CH6   PROVIDES SUFFICIENT INFORMATION.  IT IS UNDERSTOOD                00000540
CH6   THAT THIS SUBROUTINE IS FOR USE WITH IMP7 AND IMP8                00000550
CH6   DATA.                                                             00000560
C                                                                       00000570
CH7   PROGRAMMED BY: DEBORAH DERRICK        SEPTEMBER 1982              00000580
C                                                                       00000590
C                                                                       00000600
C     7/95
C
C         change DREAD to READ
C
C         replace RFGAIN etc.
C
C***********************************************************************00000610
      SUBROUTINE FINEGN (INTVAL,IGTBLE,NDXST,NDXND,RGAINS)              00000620
      IMPLICIT LOGICAL*1(Q),REAL*8(D),INTEGER*2(H)                      00000630
      COMMON /FINE/IADR,QFINE                                           00000640
CL
CL7/95
CL
CL    DIMENSION RFGAIN(3,97),HGAIN(2,3,97)                              00000650
      DIMENSION RFGAIN(3,96),HGAIN(2),JGAIN(290)
      EQUIVALENCE (RFGAIN(1,1),JGAIN(1)) 
      EQUIVALENCE (HGAIN(1),JGAIN(289))
CL                                                                              
CL7/95                                                                          
CL                                                                              
CL    EQUIVALENCE (RFGAIN(1),HGAIN(1))                                  00000660
CL    EQUIVALENCE (RFGAIN(1,1),HGAIN(1,1,1))                            00000660
      DIMENSION RGAINS(3),XNORM(3,2)                                    00000670
      DATA XNORM / 1.04, .9804,   1.2,                                  00000680
     *            .8522, .9386, .8826/                                  00000690
      DATA LSTINT/0/                                                    00000700
C                                                                       00000710
CP       IF THE CURRENT INTERVAL HAS NO FINEGAINS                       00000720
CP          THEN  TELL USER( IF THEY HAVE NOT BEEN TOLD SO BEFORE)      00000730
CP                RETURN TO CALLING ROUTINE                             00000740
CP       ENDIF                                                          00000750
C                                                                       00000760
      IF (IADR .GT. 0) GO TO 200                                        00000770
         IF (INTVAL .EQ. LSTINT) RETURN                                 00000780
            WRITE (6,110) INTVAL                                        00000790
 110        FORMAT('0',60('*'),//,'   ----> THERE ARE NO FINEGAINS ',   00000800
     *               'FOR INTERVAL ',I4,'.  <-----',//,60('*'),///)     00000810
            LSTINT = INTVAL                                             00000820
            RETURN                                                      00000830
 200  CONTINUE                                                          00000840
CP       IF CURRENT INTERVAL DIFFERS FROM PREVIOUS INTERVAL             00000850
CP          THEN  RECORD NEW INTERVAL NUMBER                            00000860
CP                READ IN THE FINEGAIN DATA FOR THE INTERVAL            00000870
CP                GET IMP NUMBER.                                       00000880
CP       ENDIF                                                          00000890
C                                                                       00000900
      IF (LSTINT .EQ. INTVAL) GO TO 250                                 00000910
         LSTINT = INTVAL                                                00000920
CL
CL7/95
CL
CL       CALL DREAD(40,IADR,RFGAIN,&9000)                               00000930
CL
         READ(UNIT=40,REC=IADR,ERR=9000) JGAIN
CL
CL       IMP = HGAIN(1,1,97)                                            00000940
         IMP = HGAIN(1)
 250  CONTINUE                                                          00000950
C                                                                       00000960
CP       DO FOR EACH HOUR OF FINEGAIN DATA TO BE ACCESSED               00000970
CP          SUM THE FINEGAINS FOR EACH DETECTOR INDIVIDUALLY            00000980
CP       END DO                                                         00000990
C                                                                       00001000
      FGAIND = 0.0                                                      00001010
      FGAINE = 0.0                                                      00001020
      FGAINF = 0.0                                                      00001030
      DO 400 K = NDXST,NDXND                                            00001040
         FGAIND = RFGAIN(1,K) + FGAIND                                  00001050
         FGAINE = RFGAIN(2,K) + FGAINE                                  00001060
         FGAINF = RFGAIN(3,K) + FGAINF                                  00001070
 400  CONTINUE                                                          00001080
C                                                                       00001090
CP       AVERAGE THE FINEGAINS FOR EACH DETECTOR                        00001100
CP       IF THE INDICES SPAN MORE THAN ONE HOUR.                        00001110
C                                                                       00001120
      IF (NDXND .EQ. NDXST) GO TO 500                                   00001130
         NHRS = NDXND - NDXST + 1                                       00001140
         FGAIND = FGAIND/NHRS                                           00001150
         FGAINE = FGAINE/NHRS                                           00001160
         FGAINF = FGAINF/NHRS                                           00001170
 500  CONTINUE                                                          00001180
C                                                                       00001190
CP       NORMALIZE THE FINEGAINS IF GTABLE = 2.                         00001200
C                                                                       00001210
      IF (IGTBLE .NE. 2) GO TO 800                                      00001220
         JIMP = IMP - 6                                                 00001230
         FGAIND = FGAIND * XNORM(1,JIMP)                                00001240
         FGAINE = FGAINE * XNORM(2,JIMP)                                00001250
         FGAINF = FGAINF * XNORM(3,JIMP)                                00001260
 800  CONTINUE                                                          00001270
      RGAINS(1) = FGAIND                                                00001280
      RGAINS(2) = FGAINE                                                00001290
      RGAINS(3) = FGAINF                                                00001300
C                                                                       00001310
CP       WRITE OUT THE FINEGAIN DATA FOR THE CURRENT TIME SPAN          00001320
C                                                                       00001330
      WRITE(6,850) IMP,INTVAL,RGAINS(1),RGAINS(2),RGAINS(3)             00001340
 850  FORMAT('0 ----> FOR IMP ',I2,' INTERVAL ',I4,                     00001350
     *         ' THE FINEGAIN FACTORS FOR D,E,F ARE ',                  00001360
     *         'RESPECTIVELY ',3F7.3)                                   00001370
      IHRST = NDXST - 1                                                 00001380
      IHRND = NDXND - 1                                                 00001390
      WRITE(6,860) IHRST,IHRND,IGTBLE                                   00001400
 860  FORMAT('  ----> THESE FINEGAINS ARE AVERAGED OVER ',              00001410
     *         ' HOURS ',I2,' THRU ',I2,'.    GTABLE = ',I2)            00001420
      RETURN                                                            00001430
C                                                                       00001440
C                                                                       00001450
C                                                                       00001460
9000  CONTINUE                                                          00001470
C                    FATAL ERROR DURING DREAD OF FINEGAIN DISK          00001480
      CALL ABEND(123)                                                   00001490
      STOP                                                              00001500
CP   END FINEGN                                                         00001510
      END                                                               00001520
