      SUBROUTINE FCN(X,Y)                                               00000010
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC00000020
C                                                                       00000030
C   FCN  -  SUBROUTINE FOR ANALIMP8.                                    00000040
C                                                                       00000050
C   THIS SUBROUTINE SOLVES THE PARTICLE SHOWER CURVE FOR Y CHANNEL      00000060
C  GIVEN X CHANNEL NUMBER.                                              00000070
C                                                                       00000080
C     C(W,X,Y,Z) CONTAINS COEFFICIENTS FOR THE EQUATION TO BE           00000090
C  EVALUATED.  DIMENSION Z DIVIDES THE ARRAY INTO DETECTOR AND GAIN     00000100
C  SEGMENTS; LED HIGH, MED HIGH, LED LOW, AND MED LOW RESPECTIVELY.     00000110
C  DIMENSION Y INDICATES THE PARTICLE TO BE ANALYZED WHERE Y            00000120
C  CORRESPONDS TO THE INDEX INTO THE ARRAY NEWZZ WHICH DEFINES THE      00000130
C  PARTICLE TYPE. DIMENSION X FURTHER DIVIDES THE PARTICLE INTO         00000140
C  ISOTOPES. DEFINE PRINCIPLE ISOTOPE AS THAT IN WHICH THE ATOMIC       00000150
C  WEIGHT IS 2 * ATOMIC NUMBER. X=1 INDICATES A PARTICLE WITH ATOMIC    00000160
C  WEIGHT LESS THAN THE PRINCIPLE ISOTOPE; X=2 INDICATES THE PRINCIPLE  00000170
C  ISOTOPE; X=3 INDICATES A PARTICLE WITH ATOMIC WEIGHT GREATER THAN    00000180
C  THE PRINCIPLE ISOTOPE. DIMENSION W CONTAINS THE COEFFICIENTS OF      00000190
C  THE EQUATION FOR THE PARTICULAR PARTICLE,ISOTOPE, AND DETECTOR-GAIN  00000200
C  COMBINATION.                                                         00000210
C                                                                       00000220
C   MODIFIED 1/28/81 ; CHANGE FUNCTION OF Y INDEX TO BE                 00000230
C   THAT DEFINED IN ARRAY NEWZZ, AND THE ACCOMPANYING CODE;             00000240
C   P. SCHUSTER, CSC                                                    00000250
C                                                                       00000260
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC00000270
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC00000280
      REAL*8 XX,B(5),C(5, 3,20,4)                                       00000290
C**********                                                             00000300
C**********   LEDH                                                      00000310
C**********                                                             00000320
      REAL*8 LEDH(5,3,20 )/                                             00000330
C  HYDROGEN 1                                                           00000340
     1 9.73348D 02,-6.49413D-06, 3.03516D 01, 1.53219D 00, 4.66650D 00, 00000350
     2 5*0.0,                                                           00000360
     3 10*0.0,                                                          00000370
C   ALPHA 4                                                             00000380
     4 7.77354D 03,-1.30244D-05, 4.97613D 01, 1.13066D 00, 3.62937D 00, 00000390
     5 275*0.0/                                                         00000400
C**********                                                             00000410
C**********   MEDH                                                      00000420
C**********                                                             00000430
      REAL*8 MEDH(5, 3,20)/                                             00000440
C   HYDROGEN 1                                                          00000450
     1 1.23995D 04,-2.13438D-02, 9.09758D 01, 1.21511D 00, 1.87149D 01, 00000460
     2 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00000470
     3 10*0.0,                                                          00000480
C  ALPHA 4                                                              00000490
     4 3.60293D 05,-6.34040D-05, 7.70310D 02, 1.34089D 00, 2.29360D 01, 00000500
     5 275*0.0/                                                         00000510
C**********                                                             00000520
C**********   LEDL1                                                     00000530
C**********                                                             00000540
      REAL*8 LEDL1(5,3,10)/                                             00000550
C   HYDROGEN 1                                                          00000560
     1 5*0.0,                                                           00000570
C   HYDROGEN 2                                                          00000580
     2 5*0.0,                                                           00000590
     3 10*0.0,                                                          00000600
C   ALPHA 4                                                             00000610
     4 5*0.0,                                                           00000620
C   POSITIONS 3,4,5 AVAILABLE FOR NUCLEUS DEFINITION IN ARRAY           00000630
C    NEWZZ                                                              00000640
     5  5*0.0,15*0.0,15*0.0,15*0.0, 5*0.0,                              00000650
C   CARBON 12                                                           00000660
     6 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00000670
     7 10*0.0,                                                          00000680
C   NITROGEN 14                                                         00000690
     8 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00000700
     9 10*0.0,                                                          00000710
C   OXYGEN 16                                                           00000720
     A 0.00000D 00,0.00000D 00,0.00000D 00,0.00000D 00, 0.00000D 00,    00000730
     B  5*0.0, 15*0.0, 5*0.0,                                           00000740
C   NEON 20                                                             00000750
     C0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00,  00000760
     D   5*0.0/                                                         00000770
C**********                                                             00000780
C**********   LEDL2                                                     00000790
C**********                                                             00000800
      REAL*8 LEDL2(5,3,10)/                                             00000810
     1 15*0.0, 5*0.0,                                                   00000820
C   MAGNESIUM 24                                                        00000830
     2 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00000840
     3 5*0.0, 15*0.0, 5*0.0,                                            00000850
C   SILICON 28                                                          00000860
     4 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00000870
     5 5*0.0, 15*0.0, 5*0.0,                                            00000880
C   SULFUR 32                                                           00000890
     6 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00000900
     7 5*0.0, 5*0.0,                                                    00000910
C        34                                                             00000920
     A 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00000930
     * 5*0.0, 5*0.0,                                                    00000940
C   ARGON 36                                                            00000950
     8 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00000960
     9 5*0.0, 5*0.0,                                                    00000970
C   IRON 52                                                             00000980
     A 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00000990
     * 5*0.0, 5*0.0,                                                    00001000
C   CALCIUM 40                                                          00001010
     A 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00001020
     B 5*0.0/                                                           00001030
C*********                                                              00001040
C*********   MEDL1                                                      00001050
C*********                                                              00001060
      REAL*8 MEDL1(5, 3,20)/                                            00001070
C   HYDROGEN 1                                                          00001080
     1 5*0.0,                                                           00001090
C   HYDROGEN 2                                                          00001100
     2 5*0.0,                                                           00001110
     3 10*0.0,                                                          00001120
C   ALPHA 4                                                             00001130
     4 5*0.0,                                                           00001140
C   POSITIONS 3,4,5 AVAILABLE FOR NUCLEUS DEFINITION IN ARRAY           00001150
C    NEWZZ                                                              00001160
     5  5*0.0,15*0.0,15*0.0,15*0.0, 5*0.0,                              00001170
C   CARBON 12                                                           00001180
     6 2.60250D 04, 2.49410D-03, 1.41720D 02, 1.15020D 00,-4.73890D 00, 00001190
     7 10*0.0,                                                          00001200
C   NITROGEN 14                                                         00001210
     8 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00001220
     9 10*0.0,                                                          00001230
C   OXYGEN 16                                                           00001240
     A 5.05850D 03, -6.07190D-03,2.31510D 01,5.55370D-01, 7.92870D 01,  00001250
     B  5*0.0, 15*0.0, 5*0.0,                                           00001260
C   NEON 20                                                             00001270
     C2.70060D 04, 5.19600D-05, 5.95790D 01, 9.32820D-01, 6.23630D 01,  00001280
     D   5*0.0,150*0.0/                                                 00001290
C*********                                                              00001300
C*********   MEDL2                                                      00001310
C*********                                                              00001320
      REAL*8 MEDL2(5, 3,20)/                                            00001330
     1 15*0.0, 5*0.0,                                                   00001340
C   MAGNESIUM 24                                                        00001350
     2 4.75610D 04, 2.71390D-05, 1.00080D 02, 1.07040D 00, 1.36780D 02, 00001360
     3 5*0.0, 15*0.0, 5*0.0,                                            00001370
C   SILICON 28                                                          00001380
     4 6.04140D 04, 5.29800D-05, 9.39590D 01, 1.08760D 00, 1.94450D 02, 00001390
     5 5*0.0, 15*0.0, 5*0.0,                                            00001400
C   SULFUR 32                                                           00001410
     6 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00001420
     7 5*0.0, 15*0.0, 5*0.0,                                            00001430
C   ARGON 36                                                            00001440
     8 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00001450
     9 5*0.0, 5*0.0,                                                    00001460
C   IRON 52                                                             00001470
     A 5.00790D 05, 1.69620D-04, 4.17010D 02, 1.02780D 00, 2.39090D 02, 00001480
     * 5*0.0, 5*0.0,                                                    00001490
C   CALCIUM 40                                                          00001500
     A 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00001510
     B 5*0.0,150*0.0/                                                   00001520
      EQUIVALENCE (LEDH(1,1,1),C(1,1,1,1)),(MEDH(1,1,1),C(1,1,1,2)),    00001530
     1 (LEDL1(1,1,1),C(1,1,1,3)),(MEDL1(1,1,1),C(1,1,1,4)),             00001540
     2 (LEDL2(1,1,1),C(1,1,11,3)),(MEDL2(1,1,1),C(1,1,11,4))            00001550
C    ARRAY # CORRESPONDS WITH THE  Y INDEX (AT. NUM) POSITION           00001560
C    IN THE ARRAY 'C'                                                   00001570
      DIMENSION NEWZZ(20)                                               00001580
      DATA NEWZZ/1,2,0,0,0,6,7,8,9,10,11,12,13,14,                      00001590
     * 0,16,0,18,26,20/                                                 00001600
      DATA INEWZ/20/                                                    00001610
C    THE NUCLEI IN THE ABOVE ARRAY, WHICH CONTAINS THEIR                00001620
C    ATOMIC NUMBERS, ARE AS FOLLOWS:                                    00001630
C    H,HE,-,-,-,C,N,O,F,NE,NA,MG,AL,SI                                  00001640
C    -,S,-,AR,FE,CA                                                     00001650
C                                                                       00001660
C    THE POSITONS IN THE ARRAY NEWZZ 3,4,5,15,17 ARE AVAILABLE          00001670
C    TO DEFINE OTHER NUCLEI                                             00001680
C    IN THIS WAY, REDIMENSIONING ARRAY C TO ALLOW FOR FE DATA           00001690
C    IS NOT NECESSARY                                                   00001700
      XX=X                                                              00001710
      Y = (B(1)*DEXP(B(2)*XX  )/(B(3)+(XX  )**B(4))+B(5))               00001720
      RETURN                                                            00001730
      ENTRY FCNWRT(NZ,XA,L)                                             00001740
      NA=XA+.5                                                          00001750
      NA1 = 2                                                           00001760
      IF ( NA.LT.2*NZ) NA1 = 1                                          00001770
      IF ( NA.GT.2*NZ ) NA1 = 3                                         00001780
C  CHANGE ATOMIC NUMBER INTO C INDEX                                    00001790
          NEWZ=0                                                        00001800
          DO 10 INZ=1,INEWZ                                             00001810
             IF(NZ .EQ. NEWZZ(INZ)) NEWZ=INZ                            00001820
  10      CONTINUE                                                      00001830
          IF(NEWZ.EQ.0) CALL ABEND(101)                                 00001840
      DO 1 I=1,5                                                        00001850
    1 B(I) = C(I,NA1,NEWZ,L)                                            00001860
      WRITE(6,1000) (B(I),I=1,5)                                        00001870
 1000 FORMAT(15X,'CURVES USED TO PRODUCE HISTOGRAMS:',/,20X,'Y=(',      00001880
     1 D12.5,'*DEXP(',D12.5,'*X',      ')/(',D12.5,'+X**',              00001890
     2       D12.5,')+',D12.5,')')                                      00001900
      RETURN                                                            00001910
      END                                                               00001920
