      FUNCTION ENERGY(EMDE,DE)                                          00000010
C                                                                       00000020
C  THIS IS THE ENERGY EVALUATION FUNCTION FOR IMP-8 ANALIMP.            00000030
C  (NOT TO BE CONFUSED WITH ENERGY FUNCTIONS OF THE SAME NAME FOR       00000040
C  OTHER IMPS.  THIS CURRENTLY BELONGS IN K3.AIJTD.SB008.OIMPJLIB)      00000050
C                                                                       00000060
C THIS FUNCTION DETERMINES THE INCIDENT ENERGY IN MEV/NUCLEON GIVEN     00000070
C    THE E-DE CHANNEL.                                                  00000080
C                                                                       00000090
C     C(W,X,Y,Z) CONTAINS COEFFICIENTS FOR THE EQUATION TO BE           00000100
C  EVALUATED.  DIMENSION Z DIVIDES THE ARRAY INTO DETECTOR AND GAIN     00000110
C  SEGMENTS; LED HIGH, MED HIGH, LED LOW, AND MED LOW RESPECTIVELY.     00000120
C  DIMENSION Y INDICATES THE PARTICLE TO BE ANALYZED WHERE Y            00000130
C  CORRESPONDS TO THE INDEX INTO THE ARRAY NEWZZ WHICH DEFINES THE      00000140
C  PARTICLE TYPE. DIMENSION X FURTHER DIVIDES THE PARTICLE INTO         00000150
C  ISOTOPES. DEFINE PRINCIPLE ISOTOPE AS THAT IN WHICH THE ATOMIC       00000160
C  WEIGH
C  WEIGHT LESS THAN THE PRINCIPLE ISOTOPE; X=2 INDICATES THE PRINCIPLE  00000180
C  ISOTOPE; X=3 INDICATES A PARTICLE WITH ATOMIC WEIGHT GREATER THAN    00000190
C  THE PRINCIPLE ISOTOPE. DIMENSION W CONTAINS THE COEFFICIENTS OF      00000200
C  THE EQUATION FOR THE PARTICULAR PARTICLE,ISOTOPE, AND DETECTOR-GAIN  00000210
C  COMBINATION.                                                         00000220
C                                                                       00000230
C   MODIFIED 1/28/81 ; CHANGE FUNCTION OF Y INDEX TO BE                 00000240
C   THAT DEFINED IN ARRAY NEWZZ, AND THE ACCOMPANYING CODE;             00000250
C   P. SCHUSTER, CSC                                                    00000260
C                                                                       00000270
c   7/95
c
c   add 150*0.0 at the data statement real*8 MEDL1(5,3,20)
c   add 150*0.0 at the data statement real*8 MEDL2(5,3,20)
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC00000280
      REAL*8 B(5),C(5,3, 20,4)                                          00000290
C************                                                           00000300
C************                                                           00000310
C************  LEDH                                                     00000320
C************                                                           00000330
C************                                                           00000340
      REAL*8 LEDH(5, 3,20)/                                             00000350
C   HYDROGEN 1                                                          00000360
     1 -2.4226D-02, 6.07630D 01, 5.17100D-01, -8.2999D-01, 2.90430D 00, 00000370
     2 5*0.0,                                                           00000380
     3 10*0.0,                                                          00000390
C   ALPHA 4                                                             00000400
     4 -1.0868D 00, 1.56300D 01, 1.36560D-01, -1.8261D-01, 1.71190D 00, 00000410
     5 275*0.0/                                                         00000420
      REAL*8 MEDH(5, 3,20)/                                             00000430
C   HYDROGEN 1                                                          00000440
     1-1.70920D 00, 1.88113D 02, 8.21087D-01, 3.78936D-01, 1.72948D 00, 00000450
     2 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00000460
     3 10*0.0,                                                          00000470
C      THE FOLLOWING COEFFS ARE FOR MED ALPHAS USING THE ALTERNATE      00000480
C        FUNCTION WHICH WAS DEVELOPED WHEN COSTAS CALIBRATION COULD     00000490
C        NOT BE FIT WITH THE ORIGINAL FUNCTION.                         00000500
C        IFLAG IS SET TO 1 WHEN THIS DATA IS REQUESTED.                 00000510
     4 2.89187D 00, 3.10694D-03, 7.09110D-03, 1.81687D-04, -2.8379D-07, 00000520
     5 275*0.0/                                                         00000530
C************                                                           00000540
C************                                                           00000550
C************  LEDL1                                                    00000560
C************                                                           00000570
C************                                                           00000580
      REAL*8 LEDL1(5,3,10)/                                             00000590
C   HYDROGEN 1                                                          00000600
     1 5*0.0,                                                           00000610
C   HYDROGEN 2                                                          00000620
     2 5*0.0,                                                           00000630
     3 10*0.0,                                                          00000640
C   ALPHA 4                                                             00000650
     4 5*0.0,                                                           00000660
C   POSITIONS 3,4,5 AVAILABLE FOR NUCLEUS DEFINITION IN ARRAY           00000670
C    NEWZZ                                                              00000680
     5  5*0.0,15*0.0,15*0.0,15*0.0, 5*0.0,                              00000690
C   CARBON 12                                                           00000700
C   THE CARBON 12 COEFFS. ARE THE ANALIMP7 ONES (FOR TESTING)           00000710
     6-1.65139D 00, 3.88792D 01, 5.09898D-01,-5.58626D-01, 1.67125D 00, 00000720
     7 10*0.0,                                                          00000730
C   NITROGEN 14                                                         00000740
     8 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00000750
     9 10*0.0,                                                          00000760
C   OXYGEN 16                                                           00000770
     A 0.00000D 00,0.00000D 00,0.00000D 00,0.00000D 00, 0.00000D 00,    00000780
     B  5*0.0, 15*0.0, 5*0.0,                                           00000790
C   NEON 20                                                             00000800
     C0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00,  00000810
     D   5*0.0/                                                         00000820
C************                                                           00000830
C************                                                           00000840
C************  LEDL2                                                    00000850
C************                                                           00000860
C************                                                           00000870
      REAL*8 LEDL2(5,3,10)/                                             00000880
     1 15*0.0, 5*0.0,                                                   00000890
C   MAGNESIUM 24                                                        00000900
     2 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00000910
     3 5*0.0, 15*0.0, 5*0.0,                                            00000920
C   SILICON 28                                                          00000930
     4 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00000940
     5 5*0.0, 15*0.0, 5*0.0,                                            00000950
C   SULFUR 32                                                           00000960
     6 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00000970
     7 5*0.0, 5*0.0,                                                    00000980
C        34                                                             00000990
     A 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00001000
     * 5*0.0, 5*0.0,                                                    00001010
C   ARGON 36                                                            00001020
     8 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00001030
     9 5*0.0, 5*0.0,                                                    00001040
C   IRON 52                                                             00001050
     A 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00001060
     * 5*0.0, 5*0.0,                                                    00001070
C   CALCIUM 40                                                          00001080
     A 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00001090
     B 5*0.0/                                                           00001100
C************                                                           00001110
C************                                                           00001120
C************  MEDL1                                                    00001130
C************                                                           00001140
C************                                                           00001150
      REAL*8 MEDL1(5,3, 20)/                                            00001160
C   HYDROGEN 1                                                          00001170
     1 5*0.0,                                                           00001180
C   HYDROGEN 2                                                          00001190
     2 5*0.0,                                                           00001200
     3 10*0.0,                                                          00001210
C   ALPHA 4                                                             00001220
     4 5*0.0,                                                           00001230
C   POSITIONS 3,4,5 AVAILABLE FOR NUCLEUS DEFINITION IN ARRAY           00001240
C    NEWZZ                                                              00001250
     5  5*0.0,15*0.0,15*0.0,15*0.0, 5*0.0,                              00001260
C   CARBON 12                                                           00001270
     6 0.00000D 00, 0.00000D 00, 1.00000D 00, 0.00000D 00, 1.00000D 00, 00001280
     7 10*0.0,                                                          00001290
C   NITROGEN 14                                                         00001300
     8 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00001310
     9 10*0.0,                                                          00001320
C   OXYGEN 16                                                           00001330
     A 0.00000D 00,0.00000D 00,1.00000D 00,0.00000D 00, 1.00000D 00,    00001340
     B  5*0.0, 15*0.0, 5*0.0,                                           00001350
C   NEON 20                                                             00001360
     C0.00000D 00, 0.00000D 00, 1.00000D 00, 0.00000D 00, 1.00000D 00,  00001370
CL
CL7/95
CL   C   5*0.0/                                                         00001380
     C   5*0.0,150*0.0/
C************                                                           00001390
C************                                                           00001400
C************  MEDL2                                                    00001410
C************                                                           00001420
C************                                                           00001430
      REAL*8 MEDL2(5,3, 20)/                                            00001440
     1 15*0.0, 5*0.0,                                                   00001450
C   MAGNESIUM 24                                                        00001460
     2 0.00000D 00, 0.00000D 00, 1.00000D 00, 0.00000D 00, 1.00000D 00, 00001470
     3 5*0.0, 15*0.0, 5*0.0,                                            00001480
C   SILICON 28                                                          00001490
     4 0.00000D 00, 0.00000D 00, 1.00000D 00, 0.00000D 00, 1.00000D 00, 00001500
     5 5*0.0, 15*0.0, 5*0.0,                                            00001510
C   SULFUR 32                                                           00001520
     6 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00001530
     7 5*0.0, 15*0.0, 5*0.0,                                            00001540
C   ARGON 36                                                            00001550
     8 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00001560
     9 5*0.0, 5*0.0,                                                    00001570
C   IRON 52                                                             00001580
     A 0.00000D 00, 0.00000D 00, 1.00000D 00, 0.00000D 00, 1.00000D 00, 00001590
     * 5*0.0, 5*0.0,                                                    00001600
C   CALCIUM 40                                                          00001610
     A 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 0.00000D 00, 00001620
CL
CL7/95
     B 5*0.0,150*0.0/                                                   00001630
c    B 5*0.0,150*0.0/
      EQUIVALENCE (LEDH(1,1,1),C(1,1,1,1)),(MEDH(1,1,1),C(1,1,1,2)),    00001640
     1 (LEDL1(1,1,1),C(1,1,1,3)),(MEDL1(1,1,1),C(1,1,1,4)),             00001650
     2 (LEDL2(1,1,1),C(1,1,11,3)),(MEDL2(1,1,1),C(1,1,11,4))            00001660
      REAL*8 DEMDE,DARG                                                 00001670
      REAL*8 DEMID,DE1,DE2                                              00001680
C    ARRAY # CORRESPONDS WITH THE  Y INDEX (AT. NUM) POSITION           00001690
C    IN THE ARRAY 'C'                                                   00001700
      DIMENSION NEWZZ(20)                                               00001710
      DATA NEWZZ/1,2,0,0,0,6,7,8,9,10,11,12,13,14,                      00001720
     * 0,16,0,18,26,20/                                                 00001730
      DATA INEWZ/20/                                                    00001740
C    THE NUCLEI IN THE ABOVE ARRAY, WHICH CONTAINS THEIR                00001750
C    ATOMIC NUMBERS, ARE AS FOLLOWS:                                    00001760
C    H,HE,-,-,-,C,N,O,F,NE,NA,MG,AL,SI                                  00001770
C    -,S,-,AR,FE,CA                                                     00001780
C                                                                       00001790
C    THE POSITONS IN THE ARRAY NEWZZ 3,4,5,15,17 ARE AVAILABLE          00001800
C    TO DEFINE OTHER NUCLEI                                             00001810
C    IN THIS WAY, REDIMENSIONING ARRAY C TO ALLOW FOR FE DATA           00001820
C    IS NOT NECESSARY                                                   00001830
C                                                                       00001840
      DEMDE = EMDE                                                      00001850
      IF(IFLAG.EQ.1)GO TO 100                                           00001860
      DARG = B(3)*DEMDE-B(4)                                            00001870
      IF ( DARG .LT. 1.0D-60 ) DARG = 1.0D-60                           00001880
      ENERGY = B(1)+(B(2)+DARG**B(5))**(1.0/B(5))                       00001890
      GO TO 101                                                         00001900
  100 CONTINUE                                                          00001910
      D1=DEXP(B(1)+B(2)*DEMDE)                                          00001920
      D2=B(3)*DEMDE+B(4)*DEMDE**2+B(5)*DEMDE*DEMDE*DEMDE                00001930
      ENERGY = D1+D2                                                    00001940
  101 CONTINUE                                                          00001950
      RETURN                                                            00001960
C                                                                       00001970
C                                                                       00001980
      ENTRY ENGWRT(NZ,XA,L,EMDE,DE)                                     00001990
      IFLAG=0                                                           00002000
      IF(L.EQ.2.AND.NZ.EQ.2)IFLAG=1                                     00002010
      DEMDE = EMDE                                                      00002020
      NA = XA + 0.5                                                     00002030
      NA1 = 2                                                           00002040
      IF ( NA.LT.2*NZ ) NA1 = 1                                         00002050
      IF ( NA.GT.2*NZ ) NA1 = 3                                         00002060
C  CHANGE ATOMIC NUMBER INTO C INDEX                                    00002070
          NEWZ=0                                                        00002080
          DO 12 INZ=1,INEWZ                                             00002090
             IF(NZ .EQ. NEWZZ(INZ)) NEWZ=INZ                            00002100
  12      CONTINUE                                                      00002110
          IF(NEWZ.EQ.0) CALL ABEND(101)                                 00002120
      DO 1 I=1,5                                                        00002130
    1 B(I) = C(I,NA1,NEWZ,L)                                            00002140
      IF(IFLAG.EQ.1)GO TO 10                                            00002150
      WRITE(6,1000) (B(I),I=1,5),B(5)                                   00002160
 1000 FORMAT(20X,'ENERGY=',D13.6,'+(',D13.6,'+(',D13.6,'*X-',D13.6,     00002170
     1 ')**',D13.6,')**(1/',D13.6,')',/)                                00002180
      DARG = B(3)*DEMDE-B(4)                                            00002190
      IF ( DARG .LT. 1.0D-60 ) DARG = 1.0D-60                           00002200
      ENGWRT = B(1)+(B(2)+DARG**B(5))**(1.0/B(5))                       00002210
      GO TO 11                                                          00002220
   10 CONTINUE                                                          00002230
      PRINT 1002                                                        00002240
 1002  FORMAT(/10X,'**********MED ALPHA  - ALTERNATE FUNCTION USED *****00002250
     ******')                                                           00002260
      PRINT 1001,(B(I),I=1,5)                                           00002270
1001  FORMAT(20X,'ENERGY=  EXP(',D13.6,' + X*',D13.6,') + X*',D13.6,    00002280
     2' + X**2(',D13.6,') + X*X*X*(',D13.6,')')                         00002290
      D1=DEXP(B(1)+B(2)*DEMDE)                                          00002300
      D2=B(3)*DEMDE+B(4)*DEMDE**2+B(5)*DEMDE*DEMDE*DEMDE                00002310
      ENGWRT = D1+D2                                                    00002320
   11 CONTINUE                                                          00002330
      RETURN                                                            00002340
C                                                                       00002350
C                                                                       00002360
      ENTRY ENGCHL(EMID,XX)                                             00002370
C      RETURN X VALUE GIVEN ENERGY                                      00002380
C      USED FOR ALL EXCEPT IMP-8 MED ALPHAS                             00002390
       IF(IFLAG.NE.0) GO TO 200                                         00002400
C                                                                       00002410
C      ORIGINAL ENERGY FUNCTION SOLVED FOR X, GIVEN E                   00002420
C                                                                       00002430
C                ( (EMID-B(1))**B(5) - B(2) )**(1.0/B(5))  - B(4)       00002440
C   X(CHANNEL) = ------------------------------------------------       00002450
C                                     B(3)                              00002460
C                                                                       00002470
C                                                                       00002480
       DEMID=EMID                                                       00002490
       DE1 = (DEMID-B(1))                                               00002500
       DE2 = DE1**B(5)  - B(2)                                          00002510
       DE1 = DE2**(1.0/B(5))  - B(4)                                    00002520
       XX  = DE1 / B(3)                                                 00002530
       ENGCHL=XX                                                        00002540
       RETURN                                                           00002550
 200   CONTINUE                                                         00002560
C      IMP-8 MED ALPHAS SHOULD HAVE BEEN PROCESSED IN                   00002570
C      SPCTR8 THRU ROUTINE EMDCMD                                       00002580
        ENGCHL=0.0                                                      00002590
       RETURN                                                           00002600
       END                                                              00002610
