pro xfr2_calculate, index
  @xfr2_common

  if distUpdated eq 0 then begin
      ; calculate distance matrix
      indices = polyfillv([0,0,599,599],[0,599,599,0],600,600)
      dists = dblarr(600,600)
      xvals = indices mod 600 - 300
      yvals = floor(indices / 600.0) - 300
      distlist = sqrt(xvals ^ 2.0 + yvals ^ 2.0) / earthRadius
      dists[indices] = distlist
      dists[where(dists lt 1 or dists gt maxL)] = -10000
      distUpdated = 1
  end

  sliceAngle = 2 * !pi / nSlices
  iOffs = index * sliceAngle
  bigRad = earthRadius * (maxL + 1)

  c0 = cos(iOffs + angleOffset - sliceAngle * 0.5 * relWidth)
  s0 = sin(iOffs + angleOffset - sliceAngle * 0.5 * relWidth)

  c1 = cos(iOffs + angleOffset + sliceAngle * 0.5 * relWidth)
  s1 = sin(iOffs + angleOffset + sliceAngle * 0.5 * relWidth)

  xpoints = [299 + earthRadius * c0, $
             299 + bigRad * c0, $
             299 + bigRad * c1, $
             299 + earthRadius * c1]

  ypoints = [299 + earthRadius * s0, $
             299 + bigRad * s0, $
             299 + bigRad * s1, $
             299 + earthRadius * s1]

  indices = polyfillv(xpoints, ypoints, 600, 600)
  b = dblarr(600,600) - 1
  b[indices] = dists[indices]
  indices = where(b ge 1 and b lt maxL)  
  buffer = dblarr(600,600) - 1
  buffer[indices] = floor(b[indices] / lstep - 1/lstep) + 1
  
  wset, h_draw
  tvscl, buffer
  
  x = data[indices]
  g = buffer[indices]
 
  numGroups = ((maxL - 1) / lstep)
  grpX = dblarr(numGroups)
  grpY = dblarr(numGroups)

  b = dblarr(600,600)

  for i = 0.0, numGroups - 1 do begin
      z = where(g eq i + 1)
      lval = 1 + lstep / 2.0 + lstep * i
      grpX[i] = lval
      if z ne [-1] then grpY[i] = mean(x[z]) else grpY[i] = 0/0.0
  end
end
