;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
; xf_load_fits_azisum - load the display from a FITS file
;                       (created by xform program).
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

; last modified: 16-Oct-2002

pro xf_load_fits_azisum, filename

@xf_azisum_common

; -------------
; read the data
; -------------
darray = readfits(filename, fitshead)
darray = alog10((darray + 1.0) > 1.0)

; -------------------------------------------------
; get the angle mode, max L and timestamps from
; the FITS header
; -------------------------------------------------
angle_mode = sxpar(fitshead, 'ANG_MODE')
maxL       = sxpar(fitshead, 'MAX_L')
stamp1     = sxpar(fitshead, 'STARTMID')
stamp2     = sxpar(fitshead, 'STOPMID')
shadowAngle = sxpar(fitshead, 'SHADOWAN')

if stamp1 eq 0 then begin
    stamp1 = '<>'
    stamp2 = '<>'
end

end
