pro convertXY, xx, yy, minL, mlt_look, tp_maglon

; --------------------------------------------------------
; convert mouse coordinates to L-shell and either MLT
; or magnetic longitude
; --------------------------------------------------------

  @xf_azisum_common
  
; angle_mode = 0, angle is mlon
; angle_mode = 1, angle is MLT

  pixelsize = 0.02666667        ; (16 L / 600)

; ------------------------------------------------  
; initialize the angles to zero, since we are only
; going to calculate one of them
; ------------------------------------------------
  tp_maglon = 0.0
  mlt_look  = 0.0
  
; ----------------------------------------------
; calculate the distance from the defined center
; ----------------------------------------------
  x = fix(xx)
  y = fix(yy)
  xpos = x - cir_x
  ypos = y - cir_y
  
; -------------------  
; determine minimum L
; -------------------
  minL = sqrt(float(xpos)*float(xpos) + float(ypos)*float(ypos)) * pixelsize
  
; ----------------------------
; calculate either MLT or mlon
; ----------------------------
  ang  = atan(ypos, xpos)

  if angle_mode eq 0 then begin
      tp_maglon = ang * !RADEG
      if(tp_maglon lt 0.0) then tp_maglon = tp_maglon + 360.0
  endif else begin
      mlt_look = (ang * !RADEG) / 15.0
      if(mlt_look lt 0.0) then mlt_look = mlt_look + 24.0
  endelse

end
