pro seamfix_loadframe, n
  @seamfix_common
  @euv_imtool-commons

  n = n > 0 < (fitsFilesN - 1)
  currentFile = n
  seamfix_load_fits, fitsFiles[n]

  darrayLinear = 10 ^ darray
  darrayModified = darray
  for i = 0, 139 do begin
      darrayModified[(i*2):(i*2+1), *] = alog10(darrayLinear[(i*2):(i*2+1), *] * multFacts[i])
  endfor
  
  widget_control, w_slider_time, set_value = n
  widget_control, w_label_date, sensitive = 1, $
                                set_value = zeroPad(s0year, 4) + '/' + zeroPad(s0doy, 3) + '/' + $
                                            zeroPad(s0hour, 2) + ':' + zeroPad(s0min, 2)

  fn = fitsFiles[n]
  i = strpos(fn, '/', /reverse_search)
  if(i ne -1) then fn = strmid(fn, i + 1)

  widget_control, w_label_fname, sensitive = 1, $
                                set_value = fn

  if n eq 0 then $
    widget_control, w_button_prev, sensitive = 0 $
  else $
    widget_control, w_button_prev, sensitive = 1

  widget_control, w_button_graphfactors, set_value = 'Graph factors'
  widget_control, w_button_graphfactors, sensitive = 0
  widget_control, w_button_savefactors, sensitive = 0
  widget_control, w_button_resetgraph, sensitive = 1
  widget_control, w_button_savefits, sensitive = 1

  if n eq (fitsFilesN - 1) then $
    widget_control, w_button_next, sensitive = 0 $
  else $
    widget_control, w_button_next, sensitive = 1

  wset, 1
  seamfix_draw, darray, x = 0, y = 400
  seamfix_draw, darray, x = 280, y = 400, /altcolor

  wset, h_draw_main
  device, copy = [0, 400, 280, 300, 0, 0, 1]
  draw_main_y1 = -1

  wset, h_draw_secondary
  seamfix_draw, darrayModified
  
  wset, h_draw_graph
  device, copy = [0, 0, 848, 200, 0, 0, 1]

  fileOpened = 1
  graphExists = 0
end
