pro drawEarth, x, y
  @rotsum_common

  wset, h_draw1
  Device, Copy = [0, 0, 280, 300, 0, 0, 3]
  smoothness = 16
  circle = fltarr(2, smoothness + 1)
  for i = 0.0, smoothness do begin
      j = i / smoothness * 3.14159 * 2
      circle[0, i] = x + re_pix * cos(j)
      circle[1, i] = y + re_pix * sin(j)
  endfor
  plots, circle, /device, color = 0, psym = 3     
  for i = 0.0, smoothness do begin
      j = (i + 0.5) / smoothness * 3.14159 * 2
      circle[0, i] = x + re_pix * cos(j)
      circle[1, i] = y + re_pix * sin(j)
  endfor
  plots, circle, /device, color = 255 * (1 + 256 + 256 * 256L), psym = 3 
end

