function zeropad, i, l
  n = fix(i)
  x = strmid(strcompress(string(n)), 1, 1000)
  while(strlen(x) lt l) do x = '0' + x
  return, x
end

pro setupPS, fname
  !p.thick=4
  !p.charsize=1
  !p.charthick=4
  !x.thick=3
  !y.thick=3
  !y.margin=2
  !p.linestyle = 0
  
  !p.font =  0
  set_plot,'ps'
  device, /helvetica
  device,filename=fname
  device,/landscape
  device,BITS = 8, /color

  TVLCT, [0,192,255], [0,192,0], [0,192,0]
end

pro closePS
  device,/close
  !p.thick=1
  !p.thick=1
  !p.charsize=1
  !p.charthick=1
  !x.thick=1
  !y.thick=1
  !p.font = -1
  !x.margin=[10,4]
  !y.margin=[5,2]
  if !version.os eq 'Win32' then set_plot,'win' $
  else if !version.os eq 'MacOS' then set_plot,'mac' $
  else set_plot, 'x'            ; default to linux
end

function fltToStr, f
  ipart = fix(f)
  fpart = fix((f mod 1.0 * 100) + 0.5)
 
  if ipart lt 10 then $
    a = string(format = '(I1)', ipart) $
  else if ipart lt 100 then $
    a = string(format = '(I2)', ipart) $
  else $
    a = string(format = '(I3)', ipart)
  
  if fpart lt 10 then b = string(format = '("0", I1)', fpart) $
                 else b = string(format = '(I2)', fpart)
  return, a + "." + b
end

pro redrawCircle
  @radial_common
  if fileLoaded then begin
      x = cir_x
      y = cir_y
      r = re_pix

      smoothness = 24

      circle = fltarr(2, smoothness + 1)
      circle2 = fltarr(2, smoothness + 1)
      for i = 0.0, smoothness do begin
          j = i / smoothness * 3.14159 * 2
          circle[0, i] = x + r * cos(j)
          circle[1, i] = y + r * sin(j)
      endfor

      for i = 0.0, smoothness do begin
          j = (i + 0.5) / smoothness * 3.14159 * 2
          circle2[0, i] = x + r * cos(j)
          circle2[1, i] = y + r * sin(j)
      endfor
      
      white = 255 * (1 + 256 + 256 * 256L)

      la = lineAngle

      stepX = cos(la / 180.0D * !pi)
      stepY = sin(la / 180.0D * !pi)

      if stepX eq 0.0 then stepX = 0.0000001D
      if stepY eq 0.0 then stepY = 0.0000001D

      perpX = cos((la + 90) / 180.0D * !pi)
      perpY = sin((la + 90) / 180.0D * !pi)

      centerX1 = cir_x + perpX * (lineWidth / 2)
      centerY1 = cir_y + perpY * (lineWidth / 2)

      centerX2 = cir_x - perpX * (lineWidth / 2)
      centerY2 = cir_y - perpY * (lineWidth / 2)

      c = 255

      if stepX lt 0.0 then begin
          x1 = centerX1
          x2 = centerX2
          x3 = centerX1 - 280
          x4 = centerX2 - 280
      endif else begin
          x1 = centerX1 - 280
          x2 = centerX2 - 280
          x3 = centerX1
          x4 = centerX2
      endelse

      if stepY lt 0.0 then begin
          y1 = centerY1
          y2 = centerY2
          y3 = centerY1 - 300
          y4 = centerY2 - 300         
      endif else begin
          y1 = centerY1 - 300
          y2 = centerY2 - 300
          y3 = centerY1
          y4 = centerY2
      endelse

      dist1 = (abs(x1 / stepX) < abs(y1 / stepY) < abs(x2 / stepX) < abs(y2 / stepY))
      dist2 = -1.0 * (abs(x3 / stepX) < abs(y3 / stepY) < abs(x4 / stepX) < abs(y4 / stepY))
      
      boxX = [centerX1 + stepX * dist1, $
              centerX1 + stepX * dist2, $
              centerX2 + stepX * dist2, $
              centerX2 + stepX * dist1, $
              centerX1 + stepX * dist1]

      boxY = [centerY1 + stepY * dist1, $
              centerY1 + stepY * dist2, $
              centerY2 + stepY * dist2, $
              centerY2 + stepY * dist1, $
              centerY1 + stepY * dist1]

      dotlineX = intarr((numGroups - 1))
      dotlineY = intarr((numGroups - 1))

      dlstartX = cir_x + stepX * dist1
      dlstepX = abs((dist1 - dist2)) * stepX / double(numGroups)

      dlstartY = cir_y + stepY * dist1
      dlstepY = abs((dist1 - dist2)) * stepY / double(numGroups)
      
      for i = 0, numGroups - 2 do begin
          dotlineX[i] = dlstartX - (i + 1) * dlstepX
          dotlineY[i] = dlstartY - (i + 1) * dlstepY
      endfor

      Device, Copy = [0, 0, 280, 300, 0, 0, 1]

      plots, circle, /device, color = white, psym = 3
      plots, circle2, /device, color = 0 * (1 + 256 + 256 * 256L), psym = 3

      if not showLine then return 

      plots, dotlineX, dotlineY, /device, color = 255, psym = 3
      plots, boxX, boxY, /device, color = c, psym = 0
     
  endif
end

pro radial_event, ev
  @radial_common
  @euv_imtool-commons

  if suspendEvents then return

  suspendEvents = 1

  widget_control, ev.id, get_uvalue = info

  if info eq 'savegraph' then begin
      savegraph = not savegraph
  endif

  if info eq 'logscale' then begin
      logscale = not logscale
  endif

  if info eq 'text1' then begin
      widget_control, w_text1, get_value = v
      v = float(v)
      if v lt 0.0 then v = 0.0
      if v gt 360.0 then v = 360.0
      widget_control, w_slider1, set_value = fix(v * 100)
      widget_control, w_text1, set_value = zeroPad(fix(v), 1) + '.' + $
                      zeroPad(fix((v mod 1.0) * 100), 2)
      lineAngle = v
      redrawCircle      
  endif     
 
  if info eq 'text2' then begin
      widget_control, w_text2, get_value = v
      v = float(v)
      if v lt 3 then v = 3
      if v gt 75 then v = 75
      widget_control, w_text2, set_value = fltToStr(v)
      widget_control, w_slider2, set_value = fix(v)
      lineWidth = v
      redrawCircle      
  endif     
 
  if info eq 'text3' then begin
      widget_control, w_text3, get_value = v
      v = fix(v)
      if v lt 8 then v = 8
      if v gt 128 then v = 128
      widget_control, w_text3, set_value = zeroPad(v, 0)
      widget_control, w_slider3, set_value = fix(v)
      numGroups = v
      redrawCircle      
  endif     
 
  if info eq 'slider1' then begin
      v = ev.value / 100.0
      widget_control, w_text1, set_value = zeroPad(fix(v), 1) + '.' + $
                      zeroPad(fix((v mod 1.0) * 100), 2)
      lineAngle = v
      redrawCircle
  endif

  if info eq 'slider2' then begin
      v = ev.value
      widget_control, w_text2, set_value = zeroPad(v, 0)
      lineWidth = v
      redrawCircle
  endif

  if info eq 'slider3' then begin
      v = ev.value
      widget_control, w_text3, set_value = zeroPad(v, 0)
      numGroups = v
      redrawCircle      
  endif

  if info eq 'draw' and fileLoaded then begin  
      cursor, a, b, /nowait

      if (!mouse.button) eq 1 then begin
          cir_x = ev.x
          cir_y = ev.y
          if cir_x lt re_pix then cir_x = re_pix
          if cir_y lt re_pix then cir_y = re_pix
          if cir_x gt (280 - re_pix) then cir_x = 280 - re_pix
          if cir_y gt (300 - re_pix) then cir_y = 300 - re_pix

          redrawCircle
      endif 
      if (!mouse.button) eq 2 then begin
          convertxy, ev.x, ev.y, minl, mlt, maglon
          posStr = 'r: ' + fltToStr(minl) + '  (' + fltToStr(mlt) + '/' + $
                   fltToStr(maglon) + ')'
          print, posstr
      endif
      if (!mouse.button) eq 4 then begin
          deltaY = double(ev.y - cir_y)
          deltaX = double(ev.x - cir_x)
          if deltaX eq 0 then deltaX = 0.00001
          v = 180.0D * atan(deltaY / deltaX) / !pi
          if deltaX lt 0 then v = v + 180.0
          if v lt 0 then v = v + 360.0
          widget_control, w_slider1, set_value = long(v * 100L)
          widget_control, w_text1, set_value = zeroPad(fix(v), 1) + '.' + $
                          zeroPad(fix((v mod 1.0) * 100), 2)
          lineAngle = v
          redrawCircle
      endif
  endif

  if info eq 'go' then begin
      la = lineAngle

      stepX = cos(la / 180.0D * !pi)
      stepY = sin(la / 180.0D * !pi)

      if stepX eq 0.0 then stepX = 0.0000001D
      if stepY eq 0.0 then stepY = 0.0000001D

      perpX = cos((la + 90) / 180.0D * !pi)
      perpY = sin((la + 90) / 180.0D * !pi)

      centerX1 = cir_x + perpX * (lineWidth / 2)
      centerY1 = cir_y + perpY * (lineWidth / 2)

      centerX2 = cir_x - perpX * (lineWidth / 2)
      centerY2 = cir_y - perpY * (lineWidth / 2)

      if stepX lt 0.0 then begin
          x1 = centerX1
          x2 = centerX2
          x3 = centerX1 - 280
          x4 = centerX2 - 280
      endif else begin
          x1 = centerX1 - 280
          x2 = centerX2 - 280
          x3 = centerX1
          x4 = centerX2
      endelse

      if stepY lt 0.0 then begin
          y1 = centerY1
          y2 = centerY2
          y3 = centerY1 - 300
          y4 = centerY2 - 300         
      endif else begin
          y1 = centerY1 - 300
          y2 = centerY2 - 300
          y3 = centerY1
          y4 = centerY2
      endelse

      dist1 = (abs(x1 / stepX) < abs(y1 / stepY) < abs(x2 / stepX) < abs(y2 / stepY))
      dist2 = -1.0 * (abs(x3 / stepX) < abs(y3 / stepY) < abs(x4 / stepX) < abs(y4 / stepY))
      
      boxX = [centerX1 + stepX * dist1, $
              centerX1 + stepX * dist2, $
              centerX2 + stepX * dist2, $
              centerX2 + stepX * dist1]

      boxY = [centerY1 + stepY * dist1, $
              centerY1 + stepY * dist2, $
              centerY2 + stepY * dist2, $
              centerY2 + stepY * dist1]  

      d = intarr(280,300)

      xstart = fix(min(boxX) > 0)
      xend = fix(max(boxX) < 279)
      ystart = fix(min(boxY) > 0)
      yend = fix(max(boxY) < 299)

      xtrans = cos(la / 180.0D * !pi)
      ytrans = sin(la / 180.0D * !pi)

      totaldist = abs(dist1 - dist2)
      
      for x = xstart, xend, 2 do begin
          for y = ystart, yend, 2 do begin
              u = xtrans * (x - cir_x) + ytrans * (y - cir_y)
              v = -ytrans * (x - cir_x) + xtrans * (y - cir_y)
              if abs(v) lt lineWidth / 2 then begin
                  if (u) lt dist1 and u gt dist2 then begin
                      n = fix((dist1 - u) / totaldist * numGroups) + 1
                      d[x,y] = n
                  endif
              endif
          endfor
      endfor

      grpAvgs = dblarr(numGroups)
      grpDists = dblarr(numGroups)

      dlstartX = cir_x + stepX * dist1
      dlstepX = abs((dist1 - dist2)) * stepX / double(numGroups)

      dlstartY = cir_y + stepY * dist1
      dlstepY = abs((dist1 - dist2)) * stepY / double(numGroups)

      e = darray / 2

      prefix = ''
      widget_control, w_text4, get_value = prefix

      midX = dlstartX - (0.5) * dlstepX
      midY = dlstartY - (0.5) * dlstepY
      convertxy, midX, midY, minl, mlt, maglon         

      fname = zeropad(s0year, 4) + zeropad(s0doy,3) + zeropad(s0hour,2) + $
              zeropad(s0min, 2) + '_t' + zeropad(lineWidth, 2) + '_mlon' + $
              zeropad(fix(maglon), 3)

      if !version.os eq 'Win32' then delim = '\' $
      else if !version.os eq 'MacOS' then delim = ':' $
      else delim = '/'              ; default to linux

      if strlen(prefix) lt 1 then prefix = '.'
      if strmid(prefix, strlen(prefix) - 1, 1) ne delim then prefix = prefix + delim

      get_lun, u1
      openw, u1, prefix + fname + '.txt', width = 160

      printf, u1, '; File automatically generated by Radial.pro'
      printf, u1, ';'
      printf, u1, '; Date/time: ' + dateStr
      printf, u1, '; Line width: ' + zeroPad(lineWidth, 0) + $
                  ' (' + fltToStr(lineWidth / float(re_pix)) + ' Re)'
      printf, u1, '; MLT/maglon in direction of positive distance: ' + fltToStr(mlt) + $
                  ' / ' + fltToStr(maglon)
      printf, u1, ';'
      printf, u1, ';      minimum L    radial distance       MLT           maglon         intensity'
      for i = 1, numGroups do begin
          ind = where(d eq i)
          if ind[0] ne -1 then begin
              grpAvgs[i - 1] = mean(darray[ind])
              midX = dlstartX - (i - 0.5) * dlstepX
              midY = dlstartY - (i - 0.5) * dlstepY
              midU = xtrans * (midX - cir_x) + ytrans * (midY - cir_y)
              pixdist = abs(midU / re_pix)
              minl = 0.0D
              mlt = 0.0D
              maglon = 0.0D
              convertxy, midX, midY, minl, mlt, maglon         
              if pixdist gt 1.0 then grpDists[i - 1] = minl else grpDists[i - 1] = pixdist
              if midU lt 0 then begin
                  grpDists[i - 1] = -grpDists[i - 1]
                  pixdist = -pixdist
              endif
              
              printf, u1, minl, pixdist, mlt, maglon, 10 ^ grpAvgs[i - 1]
              e[ind] = grpAvgs[i - 1]
              e[ind + 1] = grpAvgs[i - 1]
              e[ind + 281] = grpAvgs[i - 1]
              e[ind + 282] = grpAvgs[i - 1]
          endif
      endfor

      close, u1
      free_lun, u1

      midX = dlstartX - (0.5) * dlstepX
      midY = dlstartY - (0.5) * dlstepY
      convertxy, midX, midY, minl, mlt, maglon         

      xt = ' (positive radius faces MLT ' + fltToStr(mlt) + ' / maglon ' + fltToStr(maglon) + ')'

      if not logScale then grpAvgs = 10 ^ grpAvgs
      if logScale then isLog = ' (logarithmic)' else isLog = ''

      tvscl, e
   
      window, 5, title = 'Graph'

      ymax = max(grpAvgs) * 1.05

      !x.minor = 1

      plot, grpDists, grpAvgs, background = 255 * (1 + 256 + 256 * 256L), color = 0, $
            /nodata, yrange = [0, ymax], ystyle = 1, $
            yTitle = 'Intensity' + isLog, xTitle = 'Radius from earth' + xt, $
            xtickinterval = 1, title = '   '
      polyfill, [-1, -1, 1, 1], [0, ymax, ymax, 0], $
                color = 240 * (1 + 256 + 256 * 256L)
      plot, grpDists, grpAvgs, color = 0, $
            /noerase, yrange = [0, ymax], ystyle = 1, $
            yTitle = 'Intensity' + isLog, xTitle = 'Radius from earth' + xt, $
            xtickinterval = 1, $
            title = 'Radial intensity, ' + dateStr + ', width = ' + $
            zeroPad(lineWidth, 0) + ' pixels (' + fltToStr(lineWidth / float(re_pix)) + ' Re)'

      widget_control, w_draw, get_value = v
      wset, v

      if saveGraph then begin
          filename = prefix + fname + '.ps'

          setupPS, filename
          !x.minor = 1
          !y.margin = [4, 3]

          plot, grpDists, grpAvgs, background = 255 * (1 + 256 + 256 * 256L), color = 0, $
                /nodata, yrange = [0, ymax], ystyle = 1, $
                yTitle = 'Intensity' + isLog, xTitle = 'Radius from earth' + xt, $
                xtickinterval = 1, title = '   '
          polyfill, [-1, -1, 1, 1], [0, ymax, ymax, 0], $
                    color = 240 * (1 + 256 + 256 * 256L)
          plot, grpDists, grpAvgs, color = 0, $
                /noerase, yrange = [0, ymax], ystyle = 1, $
                yTitle = 'Intensity' + isLog, xTitle = 'Radius from earth' + xt, $
                xtickinterval = 1, $
                title = 'Radial intensity, ' + dateStr + ', width = ' + $
                zeroPad(lineWidth, 0) + ' pixels (' + fltToStr(lineWidth / float(re_pix)) + ' Re)'
          
          closePS
      endif

  endif
  suspendEvents = 0
end

pro radial_quit, ev
  widget_control, ev.top, /destroy
end

pro radial_load, ev
  @euv_imtool-commons
  @radial_common

  f_filename = dialog_pickfile(filter = '*.fits', /must_exist, /read)

  ; load FITS file
  load_fits_azisum, f_filename
  
  ; calculate pixel size of 1 Re
  re_pix = (asin(1.0/(vmag(image_x, image_y, image_z) / 6378)) * !RADEG) / 0.3

  ; do truecolor palette setup
  intensityArray = fix((10 ^ darray))
  normArray = darray / 3.0
  r = (((normArray - 0.5) > 0) * 2) ^ 1
  g = normArray
  b = (normArray + r + normArray ^ 2) / 3
  dispArray = [[[fix(r * 255)]], $
               [[fix(g * 255)]], $
               [[fix(b * 255)]]]

  wset, 1

  tv,  dispArray, true = 3

  widget_control, w_draw, get_value = v
  wset, v

  dateStr = zeropad(s0year, 4) + '/' + zeropad(s0doy,3) + '/' + $
            zeropad(s0hour,2) + ':' + zeropad(s0min, 2)

  widget_control, w_label1, set_value = dateStr

  widget_control, w_button5, sensitive = 1

  calc_sm_coords
  fileLoaded = 1
  tp_saved = t5##t1##transpose(t2)##transpose(t3)##transpose(t4)
  widget_control, w_toggleLine, sensitive = 1
  redrawCircle
end

pro radial_toggleLine, ev
  @radial_common
  if showLine then begin
      showLine = 0
      widget_control, w_toggleLine, set_value = 'Show line'
  endif else begin
      showLine = 1
      widget_control, w_toggleLine, set_value = 'Hide line'
  endelse
  redrawCircle
end

pro radial
  @euv_imtool-commons
  @radial_common

  fileLoaded = 0
  showLine = 1
  suspendEvents = 0

  ; set up GUI
  set_plot, 'x'
  device, true_color = 24
  device, retain = 2
  !p.thick = 1
  !x.thick = 1
  !y.thick = 1
  w_base = widget_base(xsize = 288, $
                       ysize = 524, $
                       mbar = w_menubar, title = 'radial')

  w_draw = widget_draw(w_base, uvalue = 'draw', xoffset = 4, yoffset = 24, $
                       xsize = 280, ysize = 300, /motion_events, $
                       /button_events)

  w_slider1 = widget_slider(w_base, uvalue = 'slider1', xoffset = 4, $
                            yoffset = 333, xsize = 226, /suppress_value, $
                            minimum = 0, maximum = 36000, value = 0, /drag)

  lineAngle = 0.0
 
  w_text1 = widget_text(w_base, /editable, xoffset = 232, $
                       xsize = 6, yoffset = 328, value = '0.00', $
                       uvalue = 'text1')

  w_slider2 = widget_slider(w_base, uvalue = 'slider2', xoffset = 4, $
                            yoffset = 365, xsize = 226, /suppress_value, $
                            minimum = 3, maximum = 75, value = 5, /drag)

  lineWidth = 5

  w_text2 = widget_text(w_base, /editable, xoffset = 232, $
                       xsize = 6, yoffset = 360, value = '5', $
                       uvalue = 'text2')

  w_slider3 = widget_slider(w_base, uvalue = 'slider3', xoffset = 4, $
                            yoffset = 397, xsize = 236, /suppress_value, $
                            minimum = 8, maximum = 128, value = 72, /drag)

  numGroups = 72

  w_text3 = widget_text(w_base, /editable, xoffset = 242, $
                       xsize = 4, yoffset = 392, value = '72', $
                       uvalue = 'text3')

  w_label1 = WIDGET_LABEL(w_base, xoffset = 184, yoffset = 4, xsize = 100, $
                          ysize = 16, value = '', /align_right)
 
  w_base2 = widget_base(w_base, /nonexclusive, yoffset = 424, xoffset = 0, xsize = 255)

  w_button1 = widget_button(w_base2, value = 'Save graph to postscript file', $
                            yoffset = 0, xoffset = 4, uvalue = 'savegraph')

  w_button2 = widget_button(w_base2, value = 'Use logarithmic intensity scale', $
                            yoffset = 0, xoffset = 4, uvalue = 'logscale')

  w_button5 = widget_button(w_base, value = 'Go', yoffset = 2, xoffset = 4, $
                            uvalue = 'go', scr_ysize = 20, scr_xsize = 50, sensitive = 0)

  Widget_Control, w_button1, Set_Button=1

  saveGraph = 1

  Widget_Control, w_button2, Set_Button=1
  
  logScale = 1

  w_label3 = WIDGET_LABEL(w_base, xoffset = 4, yoffset = 496, xsize = 102, $
                          ysize = 16, value = 'Output directory', $
                          /align_left)

  if !version.os eq 'Win32' then delim = '\' $
  else if !version.os eq 'MacOS' then delim = ':' $
  else delim = '/'            ; default to linux

  w_text4 = widget_text(w_base, /editable, xoffset = 108, $
                       scr_xsize = 176, yoffset = 488, value = 'output' + delim, $
                       uvalue = 'text3')

  w_file = widget_button(w_menubar, value = 'File', /menu)
  w_load = widget_button(w_file, value = 'Load FITS file...', $
                         Event_Pro = 'radial_load')
  w_quit = widget_button(w_file, value = 'Quit', Event_Pro = 'radial_quit')

  w_view = widget_button(w_menubar, value = 'View', /menu)
  w_toggleLine = widget_button(w_view, value = 'Hide line', $
                                  Event_Pro = 'radial_toggleLine', sensitive = 0)
 
  ; set up color constants and circle info
  white = 'ffffff'XUL
  black = '000000'XUL
  circlecolor = '77dd00'XUL
  cir_x = 140
  cir_y = 150
  cir_r1 = 1.10
  cir_thick = 0.50

  ; setup invisible graphics buffer
  window, 1, /Pixmap, XSize = width, YSize = height

  ; display window
  widget_control, w_base, /realize
 
  ; initialize event handler
  xmanager, 'radial', w_base, /no_block

  redrawCircle

  print, 'done'
end

