;#include "solve.h"

;#define Epsilon     1e-5
;#define MaxPathLen  50
;#define Lmax        1000

;// dipole along   +z
;// view point     org[3]
;// view dir       dir[3]

;typedef struct {
;  double     minL;
;  double     px;
;  double     py;
;  double     pz;
;} minLret;
  
;static double L_( double ro2, double s, double *ro, double *no )
function l_, ro2, s, ro, no
  Epsilon = 10.0 ^ (-5)
;{
;	double r2 = ro2 + s * s       ;
  r2 = ro2 + s ^ 2.0D
;	double z  = ro[2] + s * no[2] ;
  z = ro[2] + s * no[2]
;	double d  = r2 - z * z        ;
  d = r2 - z ^ 2.0D
;	if( fabs(d) < Epsilon || d < 0.0 )
;		return 1e5 ;
  if(abs(d) lt Epsilon or d lt 0.0) then return, (10.0D) ^ 5
;	return pow(r2,1.5) / (r2 - z*z) ;
  return, (r2 ^ (1.5D)) / (r2 - z ^ (2.0D))
;	}
end

;int get_min_L( double *org, double *dir, Res *rp )
function get_min_L, org, dir, rp
  MaxPathLen = 50.0D
  Epsilon = 1.0D ^ (-5)
;{
;	int k, cnt ;
;	double root[3]   ;
;	double ns, no[3], ro[3]  ;
;	double c3, c2, c1, c0    ;
;	double si, sf, nz, zo    ;
;	double r2, ro2, s, minS  ;
;	double L, Li, Lf, minL   ;

  root = dblarr(3)
  no = dblarr(3)
  ro = dblarr(3)

;	ns  = 0.0 ;
  ns = 0.0D
;	si  = 0.0 ;
  si = 0.0D
;	ro2 = 0.0 ;
  ro2 = 0.0D

;	for( k = 0 ; k < 3 ; k++ ) {
  for k = 0, 2 do begin
;		ns += dir[k] * dir[k] ;
;		si += dir[k] * org[k] ;
      ns = ns + dir[k] ^ 2.0D
      si = si + dir[k] * org[k]
;		}
  endfor

;	ns = sqrt(ns) ;
  ns = ns ^ (0.5D)
;	si = si / ns  ;
  si = si / ns;

;	for( k = 0 ; k < 3 ; k++ ) {
  for k = 0, 2 do begin
;		no[k]  = dir[k] / ns         ;
      no[k] = dir[k] / ns
;		ro[k]  = org[k] - si * no[k] ;
      ro[k] = org[k] - si * no[k]
;		ro2   += ro[k] * ro[k]       ;
      ro2 = ro2 + ro[k] ^ 2.0D
;		}
  endfor

;	nz = no[2]         ;
  nz = no[2]
;	zo = ro[2]         ;
  zo = ro[2]
;	c3 = 1.0 - nz * nz ;
  c3 = 1.0 - nz ^ 2.0D
;	c2 = - 4.0 * zo * nz ;
  c2 = -4.0D * zo * nz
;	c1 = ro2 - 3.0 * zo * zo + 2.0 * ro2 * nz * nz ;
  c1 = ro2 - 3.0D * (zo ^ (2.0D)) + 2.0 * ro2 * (nz ^ (2.0D))
;	c0 = 2.0 * ro2 * zo * nz ;	
  c0 = 2.0D * ro2 * zo * nz
;	sf = (ro2 > 1.0) ? MaxPathLen : (si < 0.0) ? -sqrt( 1.0 - ro2)
;                                                                 : MaxPathLen ;
  if ro2 gt 1.0 then $
    sf = MaxPathLen $
  else if si lt 0.0 then $
    sf = -((1.0 - ro2) ^ (0.5D)) $
  else $
    sf = MaxPathLen

;	if( ro2 < Epsilon ) {
  if ro2 lt Epsilon then begin
;		minS = (si > 0.0) ? si : sf    ;
      if si gt 0.0 then $
        minS = si $
      else $
        minS = sf
;		minL = L_( ro2, minS, ro, no ) ;
      minL = L_( ro2, minS, ro, no )
;		}
;	else if( fabs(c3) < Epsilon ) {
  endif else if (abs(c3) lt Epsilon) then begin
;		minS = (si > 0.0) ? si : (ro2 > 1.0) ? 0.0 : sf ;
      if si gt 0.0 then $
          minS = si $
      else if ro2 gt 1.0 then $
          minS = 0.0 $
      else $
          minS = sf
;		minL = L_( ro2, minS, ro, no ) ;
      minL = L_( ro2, minS, ro, no )
;		}
;	else {
  endif else begin
;		Li = L_( ro2, si, ro, no ) ;
      Li = L_( ro2, si, ro, no )
;		Lf = L_( ro2, sf, ro, no ) ;
      Lf = L_( ro2, sf, ro, no )
;		if( Li < Lf )
      if Li lt Lf then begin
;			minS = si, minL = Li ;
        minS = si
        minL = Li     
;		else
      endif else begin
;			minS = sf, minL = Lf ;
	minS = sf
        minL = Lf
      endelse
    endelse
;		cnt  = gsl_poly_solve_cubic( c2/c3, c1/c3, c0/c3,
;		root+0, root+1, root+2 ) ;
    root = cuberoot([c0/c3, c1/c3, c2/c3, 1])
    cnt = n_elements(where(root gt -1 * (10.0D)^29))
;		for( k = 0 ; k < cnt ; k++ ) {
    for k = 0, cnt - 1 do begin
;			s = root[k] ;	
        s = root[k]        
;			if( s < si || s > sf )
;				continue ;
        if not (s lt si or s gt sf) then begin
;			r2 = ro2 + s * s ;
            r2 = ro2 + s ^ 2
;			if( r2 < 1.0 )
;				continue ;
            if not (r2 lt 1.0) then begin
;			L = L_( ro2, s, ro, no ) ;
                L = L_(ro2, s, ro, no)
;			if( L < 1.0 )
;				continue ;
;			if( L < minL )
                if (not (L lt 1.0)) and (L lt minL) then begin
;				minS = s, minL = L ;
                    minS = s
                    minL = L
                endif
            endif
        endif
    endfor  

    px = ro[0] + minS * no[0]
    py = ro[1] + minS * no[1]
    pz = ro[2] + minS * no[2]

    return, [minL, px, py, pz]
end
;			}
;		}

;	rp->L  = minL ;
;	rp->s  = minS ;
;	rp->si = si   ;
;	rp->sf = sf   ;
;	rp->Ro = sqrt( ro2 ) ;
;	rp->R  = sqrt( ro2 + minS * minS ) ;
;	rp->lambda = acos(sqrt(rp->R/rp->L)) * r2d ;

; for( k = 0 ; k < 3 ; k++ ) {
;		rp->no[k] = no[k] ;
;		rp->ro[k] = ro[k] ;
;		rp->r [k] = ro[k] + minS * no[k] ;
;		}

;	return 1 ;
;	}

