;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
; load_fits - load the display from a FITS file (created by
;             euv_display program).
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

; last modified: 30-Nov-2001
; (altered slightly for tracer program, 20-Jun-2002)

pro bgsub_loadfits, filename

; forward_function get_midpoint

@euv_imtool-commons

name = 'abc'
eqsign = '='
value = 'abc'
rest = 'abc'
s0time = 'abc'
s0year = 0
s0doy = 0
s0hour = 0
s0min = 0
s0sec = 0

; -------------
; read the data
; -------------
tmp = readfits(filename, fitshead)

linear = sxpar(fitshead,'LINEAR')

if(linear) then begin
    darray = rebin(alog10((tmp + 1.0) > 1.0), 280, 300, /sample)
    darrayl = tmp
endif else begin
    darray = tmp
    darrayl = rebin(10 ^ darray, 140, 150, /sample)
endelse

; --------------------------------------
; decode necessary stuff from the header
; --------------------------------------
s0time = sxpar(fitshead,'IMTIME')
reads,s0time,s0year,s0doy,s0hour,s0min,s0sec,$
  format='(I4,1x,I3,1x,I2,1x,I2,1x,I2)'

jd = calc_jd(s0year,s0doy,s0hour,s0min,s0sec,0) - (180.0/86400.0)

image_x = sxpar(fitshead,'IMAGE_X')
image_y = sxpar(fitshead,'IMAGE_Y')
image_z = sxpar(fitshead,'IMAGE_Z')

image_vx = sxpar(fitshead,'IMAGE_VX')
image_vy = sxpar(fitshead,'IMAGE_VY')
image_vz = sxpar(fitshead,'IMAGE_VZ')

sun_x = sxpar(fitshead,'SUN_X')
sun_y = sxpar(fitshead,'SUN_Y')
sun_z = sxpar(fitshead,'SUN_Z')

moon_x = sxpar(fitshead,'MOON_X')
moon_y = sxpar(fitshead,'MOON_Y')
moon_z = sxpar(fitshead,'MOON_Z')

image_gci_lat = sxpar(fitshead,'IMAGELAT')
image_gci_lon = sxpar(fitshead,'IMAGELON')
image_w_lon   = sxpar(fitshead,'IMAGWLON')

; solar longitude of the spacecraft
solarlong = atan(sun_y,sun_x) * !RADEG
solarlong = image_gci_lon - solarlong
if (solarlong lt 0.0) then solarlong = solarlong + 360.0
if (solarlong gt 360.0) then solarlong = solarlong - 360.0

spin_axis_x = sxpar(fitshead,'SPINAXX')
spin_axis_y = sxpar(fitshead,'SPINAXY')
spin_axis_z = sxpar(fitshead,'SPINAXZ')

end
