pro bgsub
  @euv_imtool-commons
  @bgsub_common
  
  @bgsub_initialize
  
  ; set up widgets
  @bgsub_setupwidgets

  fprefix = dialog_pickfile(/must_exist, filter = '*.fits', $
                            title = 'Please select directory to get FITS files from')

  if fprefix eq '' then return

  if !version.os eq 'Win32' then delim = '\' $
  else if !version.os eq 'MacOS' then delim = ':' $
  else delim = '/'            ; default to linux

  if strpos(fprefix, delim) eq -1 then $
    fprefix = fprefix + delim $
  else $
    fprefix = strmid(fprefix, 0, strpos(fprefix, delim, /reverse_search) + 1)

  inputDir = fprefix
  outputDir = './corrected/'

  bgsub_scandirectory, inputDir

  bgsub_loadframe, 0

  xmanager, 'bgsub', w_base
end
