#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "local_defs.h"
#include "user_defs.h"
#include "idf_defs.h"
#include "DbDefs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "Util1Ansi.h"
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"
#include "libCfg.h"
#include "StrHier.h"
#include "dbf.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

/***************\
|*  UDF_TIMES  *|  Given a key, return an array of times available in the UDF
\***************/

FUNCTION UDF_MISC(int Argc, IDL_VPTR Argv[], char *kw_unused)
{
   extern struct general_info ginfo;
   extern struct fh_cache fh_list[];
   extern ByTe_1 Ext[];
   extern u_ByTe_2 Version;
   extern void *s_udf_misc;

   struct experiment_info *ex;
   struct fh_cache *fh;
   struct udf_misc *UdfMisc;

   IDL_MEMINT      one = 1;

   ByTe_4   FhNum;
   ByTe_4   fSize, RLen;
   ByTe_2   rV;

  /* Input the offset to the file handler to be queried */

   if (Argc == 1) {
      FhNum = Argv[0]->value.i;
      fh = &fh_list[FhNum];
   } else
      IDL_Message(IDL_M_GENERIC, IDL_MSG_LONGJMP, "Usage: uM = UDF_MISC(fh)");

   if (ir_locate_ex (fh->Key, Ext, Version, 0) != ALL_OKAY) 
        idl_barf("UDF_MISC: Failed to find ex structure");

   UdfMisc = (struct udf_misc *)malloc(sizeof(struct udf_misc));

   ex  = ginfo.expt;
   rV = FileLength (ex->data_name, &fSize);
   rV = read_idf(fh->Key, Ext, Version, (ByTe_1 *)&RLen, _DataLeN, 0, 0, 1);
   if (rV != ALL_OKAY)
      udf_barf("ReadIdf[DataLen]", rV);

  /* Store the results into an array of IDL structures */

   UdfMisc->RLen = RLen;
   UdfMisc->FLen = fSize;
   UdfMisc->NRecs = fSize / RLen;

  return IDL_ImportArray(1, &one, IDL_TYP_STRUCT, (UCHAR*)UdfMisc, 
                         UdfFree, s_udf_misc);
}
