static char const Ident[] =
  "@(#) $Id: udf_errmsgs.c: built 2000-06-13 by gen_udf_errmsgs.pl $";
/*
** udf_errmsgs.c
**
** Given a numeric return code from UDF, find the proper name.
*/

#include "ret_codes.h"
#include "DbDefs.h"

char *retcode_to_ascii( short rV )
{
  switch (rV) {
    /* from ret_codes.h */
    case ALL_OKAY:
      return "ALL_OKAY";
    case EOF_STATUS:
      return "EOF_STATUS";
    case LOS_STATUS:
      return "LOS_STATUS";
    case NEXT_FILE_STATUS:
      return "NEXT_FILE_STATUS";
    case FILE_BACK_UP:
      return "FILE_BACK_UP";
    case TIME_NOT_FOUND:
      return "TIME_NOT_FOUND";
    case RTIME_BAD_SRC:
      return "RTIME_BAD_SRC";
    case PBACK_BAD_SRC:
      return "PBACK_BAD_SRC";
    case LOCATE_NOT_FOUND:
      return "LOCATE_NOT_FOUND";
    case LOCATE_EX_MALLOC:
      return "LOCATE_EX_MALLOC";
    case LOCATE_PTR_MALLOC:
      return "LOCATE_PTR_MALLOC";
    case LOCATE_EX_REALLOC:
      return "LOCATE_EX_REALLOC";
    case OPEN_EX_MALLOC:
      return "OPEN_EX_MALLOC";
    case OPEN_PTR_MALLOC:
      return "OPEN_PTR_MALLOC";
    case OPEN_EX_REALLOC:
      return "OPEN_EX_REALLOC";
    case RTIME_NO_HEADER:
      return "RTIME_NO_HEADER";
    case RTIME_NO_DATA:
      return "RTIME_NO_DATA";
    case RTIME_NO_VIDF:
      return "RTIME_NO_VIDF";
    case ALL_FLAG_MALLOC:
      return "ALL_FLAG_MALLOC";
    case ALLOC_HDR_READ_ERROR:
      return "ALLOC_HDR_READ_ERROR";
    case ALLOC_HDR_MALLOC:
      return "ALLOC_HDR_MALLOC";
    case ALLOC_HDR_REALLOC:
      return "ALLOC_HDR_REALLOC";
    case CAL_DATA_MALLOC:
      return "CAL_DATA_MALLOC";
    case PARTIAL_READ:
      return "PARTIAL_READ";
    case SEL_SEN_NOT_FOUND:
      return "SEL_SEN_NOT_FOUND";
    case TIME_OFF_MALLOC:
      return "TIME_OFF_MALLOC";
    case SCOM_TBL_MALLOC:
      return "SCOM_TBL_MALLOC";
    case SCOM_INDEX_MALLOC:
      return "SCOM_INDEX_MALLOC";
    case SCOM_SEN_PTR_MALLOC:
      return "SCOM_SEN_PTR_MALLOC";
    case SCOM_PTR_MALLOC:
      return "SCOM_PTR_MALLOC";
    case SCOM_IDF_NOT_FOUND:
      return "SCOM_IDF_NOT_FOUND";
    case SCOM_IDF_MANY_BYTES:
      return "SCOM_IDF_MANY_BYTES";
    case SCOM_IDF_TBL_NUM:
      return "SCOM_IDF_TBL_NUM";
    case SCOM_IDF_CON_NUM:
      return "SCOM_IDF_CON_NUM";
    case SCOM_IDF_NO_ENTRY:
      return "SCOM_IDF_NO_ENTRY";
    case CCOM_MATCH_MALLOC:
      return "CCOM_MATCH_MALLOC";
    case CCOM_VAL_MALLOC:
      return "CCOM_VAL_MALLOC";
    case CONV_MODE_MISMATCH:
      return "CONV_MODE_MISMATCH";
    case GET_ACTION_MALLOC:
      return "GET_ACTION_MALLOC";
    case POS_NOT_FOUND:
      return "POS_NOT_FOUND";
    case FILE_POS_MODE:
      return "FILE_POS_MODE";
    case POS_DATA_READ_ERROR:
      return "POS_DATA_READ_ERROR";
    case POS_HDR_READ_ERROR:
      return "POS_HDR_READ_ERROR";
    case POS_HDR_MALLOC:
      return "POS_HDR_MALLOC";
    case POS_HDR_REALLOC:
      return "POS_HDR_REALLOC";
    case PBACK_LOS:
      return "PBACK_LOS";
    case PBACK_NEXT_FILE:
      return "PBACK_NEXT_FILE";
    case RHDR_READ_ERROR:
      return "RHDR_READ_ERROR";
    case RHDR_HDR_MALLOC:
      return "RHDR_HDR_MALLOC";
    case RHDR_HDR_REALLOC:
      return "RHDR_HDR_REALLOC";
    case FILL_HEADER:
      return "FILL_HEADER";
    case DREC_NOT_FOUND:
      return "DREC_NOT_FOUND";
    case CONV_CAL_MALLOC:
      return "CONV_CAL_MALLOC";
    case DREC_NO_FILES:
      return "DREC_NO_FILES";
    case DREC_READ_ERROR:
      return "DREC_READ_ERROR";
    case DREC_HDR_READ_ERROR:
      return "DREC_HDR_READ_ERROR";
    case DREC_HDR_MALLOC:
      return "DREC_HDR_MALLOC";
    case DREC_HDR_REALLOC:
      return "DREC_HDR_REALLOC";
    case DREC_EOF_NO_SENSOR:
      return "DREC_EOF_NO_SENSOR";
    case DREC_NO_SENSOR:
      return "DREC_NO_SENSOR";
    case DREC_EOF_SENSOR:
      return "DREC_EOF_SENSOR";
    case RESET_MODE_MALLOC:
      return "RESET_MODE_MALLOC";
    case RESET_MODE_REALLOC:
      return "RESET_MODE_REALLOC";
    case RESET_NOT_FOUND:
      return "RESET_NOT_FOUND";
    case RESET_DATA_MALLOC:
      return "RESET_DATA_MALLOC";
    case RESET_DATA_REALLOC:
      return "RESET_DATA_REALLOC";
    case RESET_ANGLE_MALLOC:
      return "RESET_ANGLE_MALLOC";
    case RESET_ANGLE_REALLOC:
      return "RESET_ANGLE_REALLOC";
    case ALLOC_EV_MALLOC:
      return "ALLOC_EV_MALLOC";
    case ALLOC_EV_REALLOC:
      return "ALLOC_EV_REALLOC";
    case CRIT_TBL_NOT_FOUND:
      return "CRIT_TBL_NOT_FOUND";
    case CONST_ANG_MALLOC:
      return "CONST_ANG_MALLOC";
    case CONST_TEMP_MALLOC:
      return "CONST_TEMP_MALLOC";
    case CNVT_NOT_FOUND:
      return "CNVT_NOT_FOUND";
    case TBL_MISC_MALLOC:
      return "TBL_MISC_MALLOC";
    case TBL_MALLOC:
      return "TBL_MALLOC";
    case TBL_IDF_NOT_FOUND:
      return "TBL_IDF_NOT_FOUND";
    case TBL_IDF_MANY_BYTES:
      return "TBL_IDF_MANY_BYTES";
    case TBL_IDF_TBL_NUM:
      return "TBL_IDF_TBL_NUM";
    case TBL_IDF_CON_NUM:
      return "TBL_IDF_CON_NUM";
    case TBL_IDF_NO_ENTRY:
      return "TBL_IDF_NO_ENTRY";
    case IDF_NOT_FOUND:
      return "IDF_NOT_FOUND";
    case IDF_MANY_BYTES:
      return "IDF_MANY_BYTES";
    case IDF_TBL_NUM:
      return "IDF_TBL_NUM";
    case IDF_CON_NUM:
      return "IDF_CON_NUM";
    case IDF_NO_ENTRY:
      return "IDF_NO_ENTRY";
    case SEN_IDF_NOT_FOUND:
      return "SEN_IDF_NOT_FOUND";
    case SEN_IDF_MANY_BYTES:
      return "SEN_IDF_MANY_BYTES";
    case SEN_IDF_TBL_NUM:
      return "SEN_IDF_TBL_NUM";
    case SEN_IDF_CON_NUM:
      return "SEN_IDF_CON_NUM";
    case SEN_IDF_NO_ENTRY:
      return "SEN_IDF_NO_ENTRY";
    case ONCE_IDF_NOT_FOUND:
      return "ONCE_IDF_NOT_FOUND";
    case ONCE_IDF_MANY_BYTES:
      return "ONCE_IDF_MANY_BYTES";
    case ONCE_IDF_TBL_NUM:
      return "ONCE_IDF_TBL_NUM";
    case ONCE_IDF_CON_NUM:
      return "ONCE_IDF_CON_NUM";
    case ONCE_IDF_NO_ENTRY:
      return "ONCE_IDF_NO_ENTRY";
    case ONCE_DATA_MALLOC:
      return "ONCE_DATA_MALLOC";
    case ONCE_D_TYPE_MALLOC:
      return "ONCE_D_TYPE_MALLOC";
    case ONCE_VAR_MALLOC:
      return "ONCE_VAR_MALLOC";
    case ONCE_CTARGET_MALLOC:
      return "ONCE_CTARGET_MALLOC";
    case ONCE_CLEN_MALLOC:
      return "ONCE_CLEN_MALLOC";
    case ONCE_TDW_LEN_MALLOC:
      return "ONCE_TDW_LEN_MALLOC";
    case ONCE_TYPE_MALLOC:
      return "ONCE_TYPE_MALLOC";
    case ONCE_SEN_STAT_MALLOC:
      return "ONCE_SEN_STAT_MALLOC";
    case ONCE_EXPAND_MALLOC:
      return "ONCE_EXPAND_MALLOC";
    case MODE_TBL_SZ_IDF_NOT_FOUND:
      return "MODE_TBL_SZ_IDF_NOT_FOUND";
    case MODE_TBL_SZ_IDF_MANY_BYTES:
      return "MODE_TBL_SZ_IDF_MANY_BYTES";
    case MODE_TBL_SZ_IDF_TBL_NUM:
      return "MODE_TBL_SZ_IDF_TBL_NUM";
    case MODE_TBL_SZ_IDF_CON_NUM:
      return "MODE_TBL_SZ_IDF_CON_NUM";
    case MODE_TBL_SZ_IDF_NO_ENTRY:
      return "MODE_TBL_SZ_IDF_NO_ENTRY";
    case EXP_IDF_NOT_FOUND:
      return "EXP_IDF_NOT_FOUND";
    case EXP_IDF_MANY_BYTES:
      return "EXP_IDF_MANY_BYTES";
    case EXP_IDF_TBL_NUM:
      return "EXP_IDF_TBL_NUM";
    case EXP_IDF_CON_NUM:
      return "EXP_IDF_CON_NUM";
    case EXP_IDF_NO_ENTRY:
      return "EXP_IDF_NO_ENTRY";
    case CRIT_IDF_NOT_FOUND:
      return "CRIT_IDF_NOT_FOUND";
    case CRIT_IDF_MANY_BYTES:
      return "CRIT_IDF_MANY_BYTES";
    case CRIT_IDF_TBL_NUM:
      return "CRIT_IDF_TBL_NUM";
    case CRIT_IDF_CON_NUM:
      return "CRIT_IDF_CON_NUM";
    case CRIT_IDF_NO_ENTRY:
      return "CRIT_IDF_NO_ENTRY";
    case NEW_IDF_NOT_FOUND:
      return "NEW_IDF_NOT_FOUND";
    case NEW_IDF_MANY_BYTES:
      return "NEW_IDF_MANY_BYTES";
    case NEW_IDF_TBL_NUM:
      return "NEW_IDF_TBL_NUM";
    case NEW_IDF_CON_NUM:
      return "NEW_IDF_CON_NUM";
    case NEW_IDF_NO_ENTRY:
      return "NEW_IDF_NO_ENTRY";
    case NEW_SCALE_MALLOC:
      return "NEW_SCALE_MALLOC";
    case CONV_CAL_VECTOR_MISMATCH:
      return "CONV_CAL_VECTOR_MISMATCH";
    case TIMING_MALLOC:
      return "TIMING_MALLOC";
    case PBACK_NO_HEADER:
      return "PBACK_NO_HEADER";
    case PBACK_NO_DATA:
      return "PBACK_NO_DATA";
    case PBACK_NO_VIDF:
      return "PBACK_NO_VIDF";
    case NUM_CAL_MALLOC:
      return "NUM_CAL_MALLOC";
    case NUM_CAL_REALLOC:
      return "NUM_CAL_REALLOC";
    case READ_IN_MALLOC:
      return "READ_IN_MALLOC";
    case READ_IN_IDF_NOT_FOUND:
      return "READ_IN_IDF_NOT_FOUND";
    case READ_IN_IDF_MANY_BYTES:
      return "READ_IN_IDF_MANY_BYTES";
    case READ_IN_IDF_TBL_NUM:
      return "READ_IN_IDF_TBL_NUM";
    case READ_IN_IDF_CON_NUM:
      return "READ_IN_IDF_CON_NUM";
    case READ_IN_IDF_NO_ENTRY:
      return "READ_IN_IDF_NO_ENTRY";
    case CREATE_TBL_MALLOC:
      return "CREATE_TBL_MALLOC";
    case CREATE_IDF_NOT_FOUND:
      return "CREATE_IDF_NOT_FOUND";
    case CREATE_IDF_MANY_BYTES:
      return "CREATE_IDF_MANY_BYTES";
    case CREATE_IDF_TBL_NUM:
      return "CREATE_IDF_TBL_NUM";
    case CREATE_IDF_CON_NUM:
      return "CREATE_IDF_CON_NUM";
    case CREATE_IDF_NO_ENTRY:
      return "CREATE_IDF_NO_ENTRY";
    case CONST_IDF_NOT_FOUND:
      return "CONST_IDF_NOT_FOUND";
    case CONST_IDF_MANY_BYTES:
      return "CONST_IDF_MANY_BYTES";
    case CONST_IDF_TBL_NUM:
      return "CONST_IDF_TBL_NUM";
    case CONST_IDF_CON_NUM:
      return "CONST_IDF_CON_NUM";
    case CONST_IDF_NO_ENTRY:
      return "CONST_IDF_NO_ENTRY";
    case SET_VWIDTH_BAND_MALLOC:
      return "SET_VWIDTH_BAND_MALLOC";
    case SET_VWIDTH_CENTER_MALLOC:
      return "SET_VWIDTH_CENTER_MALLOC";
    case BAD_VFMT:
      return "BAD_VFMT";
    case DKEY_PROJECT:
      return "DKEY_PROJECT";
    case DKEY_MISSION:
      return "DKEY_MISSION";
    case DKEY_EXPERIMENT:
      return "DKEY_EXPERIMENT";
    case DKEY_INSTRUMENT:
      return "DKEY_INSTRUMENT";
    case DKEY_VINST:
      return "DKEY_VINST";
    case FILL_SEN_NOT_FOUND:
      return "FILL_SEN_NOT_FOUND";
    case FILL_SEN_MALLOC:
      return "FILL_SEN_MALLOC";
    case FILL_SEN_REALLOC:
      return "FILL_SEN_REALLOC";
    case FILL_SEN_BASE_MALLOC:
      return "FILL_SEN_BASE_MALLOC";
    case FILL_SEN_BASE_REALLOC:
      return "FILL_SEN_BASE_REALLOC";
    case FILL_SEN_TBL_MALLOC:
      return "FILL_SEN_TBL_MALLOC";
    case FILL_BIN_MISSING:
      return "FILL_BIN_MISSING";
    case FILL_NOT_FOUND:
      return "FILL_NOT_FOUND";
    case FILL_ARRAY_MALLOC:
      return "FILL_ARRAY_MALLOC";
    case FILL_UNITS_MALLOC:
      return "FILL_UNITS_MALLOC";
    case FILL_UNITS_REALLOC:
      return "FILL_UNITS_REALLOC";
    case FILL_SWP_MALLOC:
      return "FILL_SWP_MALLOC";
    case FILL_SWP_REALLOC:
      return "FILL_SWP_REALLOC";
    case FILL_DATA_MALLOC:
      return "FILL_DATA_MALLOC";
    case FILL_INFO_MALLOC:
      return "FILL_INFO_MALLOC";
    case NO_EMPTY_BUFFERS:
      return "NO_EMPTY_BUFFERS";
    case UNITS_IND_NOT_FOUND:
      return "UNITS_IND_NOT_FOUND";
    case UNITS_NO_SENSOR:
      return "UNITS_NO_SENSOR";
    case UNITS_NO_MATCH:
      return "UNITS_NO_MATCH";
    case COLLAPSE_NOT_FOUND:
      return "COLLAPSE_NOT_FOUND";
    case COLLAPSE_MALLOC:
      return "COLLAPSE_MALLOC";
    case COLLAPSE_SEN_MALLOC:
      return "COLLAPSE_SEN_MALLOC";
    case COLLAPSE_DATA_MALLOC:
      return "COLLAPSE_DATA_MALLOC";
    case THETA_CHK_MALLOC:
      return "THETA_CHK_MALLOC";
    case THETA_BIN_MALLOC:
      return "THETA_BIN_MALLOC";
    case ORDER_THETA_MALLOC:
      return "ORDER_THETA_MALLOC";
    case PHI_DIFF_UNITS:
      return "PHI_DIFF_UNITS";
    case FILL_PHI_FIRST:
      return "FILL_PHI_FIRST";
    case FILL_PHI_LAST:
      return "FILL_PHI_LAST";
    case THETA_DIFF_UNITS:
      return "THETA_DIFF_UNITS";
    case CDIMEN_NOT_FOUND:
      return "CDIMEN_NOT_FOUND";
    case CDIMEN_COLLAPSE:
      return "CDIMEN_COLLAPSE";
    case CDIMEN_MANY_SCAN:
      return "CDIMEN_MANY_SCAN";
    case CENTER_NOT_FOUND:
      return "CENTER_NOT_FOUND";
    case CENTER_NO_SENSOR:
      return "CENTER_NO_SENSOR";
    case BPTR_NOT_FOUND:
      return "BPTR_NOT_FOUND";
    case CENTER_TMP_MALLOC:
      return "CENTER_TMP_MALLOC";
    case BAND_MALLOC:
      return "BAND_MALLOC";
    case CENTER_MALLOC:
      return "CENTER_MALLOC";
    case SET_BIN_NOT_FOUND:
      return "SET_BIN_NOT_FOUND";
    case SET_BIN_MALLOC:
      return "SET_BIN_MALLOC";
    case SET_BIN_INDEX_MALLOC:
      return "SET_BIN_INDEX_MALLOC";
    case SET_BIN_BAD_FMT:
      return "SET_BIN_BAD_FMT";
    case CALC_TRES_NOT_FOUND:
      return "CALC_TRES_NOT_FOUND";
    case CALC_CENTER_DREC:
      return "CALC_CENTER_DREC";
    case RET_PHI_NOT_FOUND:
      return "RET_PHI_NOT_FOUND";
    case CPTR_RET_PHI:
      return "CPTR_RET_PHI";
    case NO_RET_PHI:
      return "NO_RET_PHI";
    case FILL_THETA_NOT_FOUND:
      return "FILL_THETA_NOT_FOUND";
    case FILL_THETA_COLLAPSE:
      return "FILL_THETA_COLLAPSE";
    case IMAGE_NOT_FOUND:
      return "IMAGE_NOT_FOUND";
    case IMAGE_READ_ERROR:
      return "IMAGE_READ_ERROR";
    case IMAGE_HDR_MALLOC:
      return "IMAGE_HDR_MALLOC";
    case IMAGE_HDR_REALLOC:
      return "IMAGE_HDR_REALLOC";
    case INIT_VIDF_NOT_FOUND:
      return "INIT_VIDF_NOT_FOUND";
    case INIT_VIDF_BAD_VERSION:
      return "INIT_VIDF_BAD_VERSION";
    case INIT_VIDF_TBL_MALLOC:
      return "INIT_VIDF_TBL_MALLOC";
    case INIT_VIDF_CONST_MALLOC:
      return "INIT_VIDF_CONST_MALLOC";
    case SET_SCAN_NOT_FOUND:
      return "SET_SCAN_NOT_FOUND";
    case SCAN_BIN_MISSING:
      return "SCAN_BIN_MISSING";
    case SET_SCAN_TBL_MALLOC:
      return "SET_SCAN_TBL_MALLOC";
    case SCAN_INDEX_MALLOC:
      return "SCAN_INDEX_MALLOC";
    case SCAN_IDF_NOT_FOUND:
      return "SCAN_IDF_NOT_FOUND";
    case SCAN_IDF_MANY_BYTES:
      return "SCAN_IDF_MANY_BYTES";
    case SCAN_IDF_TBL_NUM:
      return "SCAN_IDF_TBL_NUM";
    case SCAN_IDF_CON_NUM:
      return "SCAN_IDF_CON_NUM";
    case SCAN_IDF_NO_ENTRY:
      return "SCAN_IDF_NO_ENTRY";
    case BUF_BIN_NOT_FOUND:
      return "BUF_BIN_NOT_FOUND";
    case FILL_DISC_NOT_FOUND:
      return "FILL_DISC_NOT_FOUND";
    case FILL_DISC_BIN_MISSING:
      return "FILL_DISC_BIN_MISSING";
    case FILL_DISC_NO_PHI:
      return "FILL_DISC_NO_PHI";
    case FILL_DISC_MALLOC:
      return "FILL_DISC_MALLOC";
    case DISC_DATA_MALLOC:
      return "DISC_DATA_MALLOC";
    case DISC_TMP_MALLOC:
      return "DISC_TMP_MALLOC";
    case TBL_VAR_NOT_CAL:
      return "TBL_VAR_NOT_CAL";
    case TBL_VAR_NOT_RAW:
      return "TBL_VAR_NOT_RAW";
    case CNVT_BAD_TBL_OPER:
      return "CNVT_BAD_TBL_OPER";
    case CNVT_NO_TMP:
      return "CNVT_NO_TMP";
    case CNVT_TMP_MALLOC:
      return "CNVT_TMP_MALLOC";
    case CNVT_BAD_TBL_NUM:
      return "CNVT_BAD_TBL_NUM";
    case MODE_PTR_MALLOC:
      return "MODE_PTR_MALLOC";
    case MODE_TBL_MISC_MALLOC:
      return "MODE_TBL_MISC_MALLOC";
    case MODE_TBL_IDF_NOT_FOUND:
      return "MODE_TBL_IDF_NOT_FOUND";
    case MODE_TBL_IDF_MANY_BYTES:
      return "MODE_TBL_IDF_MANY_BYTES";
    case MODE_TBL_IDF_TBL_NUM:
      return "MODE_TBL_IDF_TBL_NUM";
    case MODE_TBL_IDF_CON_NUM:
      return "MODE_TBL_IDF_CON_NUM";
    case MODE_TBL_IDF_NO_ENTRY:
      return "MODE_TBL_IDF_NO_ENTRY";
    case MODE_TBL_VAR_NOT_CAL:
      return "MODE_TBL_VAR_NOT_CAL";
    case MODE_TBL_VAR_NOT_RAW:
      return "MODE_TBL_VAR_NOT_RAW";
    case MODE_TBL_MALLOC:
      return "MODE_TBL_MALLOC";
    case ASCII_AFTER_SENSOR:
      return "ASCII_AFTER_SENSOR";
    case CONV_MODE_BAD_MODE:
      return "CONV_MODE_BAD_MODE";
    case CONV_MODE_BAD_TBL_NUM:
      return "CONV_MODE_BAD_TBL_NUM";
    case FILL_SEN_MODE_TYPE:
      return "FILL_SEN_MODE_TYPE";
    case UNITS_IND_MODE_TYPE:
      return "UNITS_IND_MODE_TYPE";
    case MODE_INFO_NOT_FOUND:
      return "MODE_INFO_NOT_FOUND";
    case MODE_INFO_MALLOC:
      return "MODE_INFO_MALLOC";
    case MODE_INFO_REALLOC:
      return "MODE_INFO_REALLOC";
    case MODE_INFO_BASE_MALLOC:
      return "MODE_INFO_BASE_MALLOC";
    case MODE_INFO_BASE_REALLOC:
      return "MODE_INFO_BASE_REALLOC";
    case MODE_INFO_TBL_MALLOC:
      return "MODE_INFO_TBL_MALLOC";
    case MODE_INFO_NO_MODES:
      return "MODE_INFO_NO_MODES";
    case MODE_UNITS_IND_NOT_FOUND:
      return "MODE_UNITS_IND_NOT_FOUND";
    case MODE_UNITS_FILE_OPEN:
      return "MODE_UNITS_FILE_OPEN";
    case MODE_UNITS_INFO_DUP:
      return "MODE_UNITS_INFO_DUP";
    case MODE_UNITS_NO_MODE:
      return "MODE_UNITS_NO_MODE";
    case MODE_UNITS_NO_MATCH:
      return "MODE_UNITS_NO_MATCH";
    case FILL_MODE_ARRAY_MALLOC:
      return "FILL_MODE_ARRAY_MALLOC";
    case MODE_UNITS_MALLOC:
      return "MODE_UNITS_MALLOC";
    case MODE_UNITS_REALLOC:
      return "MODE_UNITS_REALLOC";
    case MODE_DATA_MALLOC:
      return "MODE_DATA_MALLOC";
    case FILL_MODE_NOT_FOUND:
      return "FILL_MODE_NOT_FOUND";
    case FILL_MODE_FILE_OPEN:
      return "FILL_MODE_FILE_OPEN";
    case FILL_MODE_INFO_DUP:
      return "FILL_MODE_INFO_DUP";
    case MODES_NOT_REQUESTED:
      return "MODES_NOT_REQUESTED";
    case ALLOC_MODE_INFO_MALLOC:
      return "ALLOC_MODE_INFO_MALLOC";
    case MODE_FILE_OPEN:
      return "MODE_FILE_OPEN";
    case MODE_INFO_DUP:
      return "MODE_INFO_DUP";
    case CRIT_ACT_MALLOC:
      return "CRIT_ACT_MALLOC";
    case FILL_BASE_TIME_MISSING:
      return "FILL_BASE_TIME_MISSING";
    case FILL_DISC_BASE_TIME_MISSING:
      return "FILL_DISC_BASE_TIME_MISSING";
    case FILL_MODE_BASE_TIME_MISSING:
      return "FILL_MODE_BASE_TIME_MISSING";
    case CREATE_DATA_MALLOC:
      return "CREATE_DATA_MALLOC";
    case CREATE_DATA_ALL_MALLOC:
      return "CREATE_DATA_ALL_MALLOC";
    case CREATE_DATA_ALL_REALLOC:
      return "CREATE_DATA_ALL_REALLOC";
    case CHK_DATA_NOT_FOUND:
      return "CHK_DATA_NOT_FOUND";
    case CUR_TIME_NOT_FOUND:
      return "CUR_TIME_NOT_FOUND";
    case RESET_PITCH_MALLOC:
      return "RESET_PITCH_MALLOC";
    case RESET_PITCH_REALLOC:
      return "RESET_PITCH_REALLOC";
    case PITCH_MALLOC:
      return "PITCH_MALLOC";
    case PA_TBL_MALLOC:
      return "PA_TBL_MALLOC";
    case PA_TIME_MALLOC:
      return "PA_TIME_MALLOC";
    case PINFO_IDF_NOT_FOUND:
      return "PINFO_IDF_NOT_FOUND";
    case PINFO_IDF_MANY_BYTES:
      return "PINFO_IDF_MANY_BYTES";
    case PINFO_IDF_TBL_NUM:
      return "PINFO_IDF_TBL_NUM";
    case PINFO_IDF_CON_NUM:
      return "PINFO_IDF_CON_NUM";
    case PINFO_IDF_NO_ENTRY:
      return "PINFO_IDF_NO_ENTRY";
    case FILE_POS_PA:
      return "FILE_POS_PA";
    case PA_BAD_SRC:
      return "PA_BAD_SRC";
    case PA_BAD_FRAC:
      return "PA_BAD_FRAC";
    case PA_UNIT_NORMAL:
      return "PA_UNIT_NORMAL";
    case PA_UNIT_MALLOC:
      return "PA_UNIT_MALLOC";
    case PA_DATA_MALLOC:
      return "PA_DATA_MALLOC";
    case CNVT_BAD_DTYPE:
      return "CNVT_BAD_DTYPE";
    case PA_BAD_TIMES:
      return "PA_BAD_TIMES";
    case SWEEP_NOT_FOUND:
      return "SWEEP_NOT_FOUND";
    case SWEEP_BIN_MISSING:
      return "SWEEP_BIN_MISSING";
    case SWEEP_UNITS_MALLOC:
      return "SWEEP_UNITS_MALLOC";
    case SWEEP_UNITS_REALLOC:
      return "SWEEP_UNITS_REALLOC";
    case SWEEP_SWP_MALLOC:
      return "SWEEP_SWP_MALLOC";
    case SWEEP_SWP_REALLOC:
      return "SWEEP_SWP_REALLOC";
    case SWEEP_DATA_MALLOC:
      return "SWEEP_DATA_MALLOC";
    case SWEEP_INFO_MALLOC:
      return "SWEEP_INFO_MALLOC";
    case SWEEP_WITH_FILL:
      return "SWEEP_WITH_FILL";
    case FILL_WITH_SWEEP:
      return "FILL_WITH_SWEEP";
    case SMODE_UNITS_MALLOC:
      return "SMODE_UNITS_MALLOC";
    case SMODE_UNITS_REALLOC:
      return "SMODE_UNITS_REALLOC";
    case SMODE_DATA_MALLOC:
      return "SMODE_DATA_MALLOC";
    case ALLOC_SMODE_INFO_MALLOC:
      return "ALLOC_SMODE_INFO_MALLOC";
    case SWEEP_MODE_NOT_FOUND:
      return "SWEEP_MODE_NOT_FOUND";
    case SWEEP_MODE_FILE_OPEN:
      return "SWEEP_MODE_FILE_OPEN";
    case SWEEP_MODE_INFO_DUP:
      return "SWEEP_MODE_INFO_DUP";
    case SWEEP_MODES_NOT_REQUESTED:
      return "SWEEP_MODES_NOT_REQUESTED";
    case SWEEP_MODE_WITH_FILL:
      return "SWEEP_MODE_WITH_FILL";
    case FILL_WITH_SWEEP_MODE:
      return "FILL_WITH_SWEEP_MODE";
    case SWEEP_DISC_NOT_FOUND:
      return "SWEEP_DISC_NOT_FOUND";
    case SWEEP_DISC_BIN_MISSING:
      return "SWEEP_DISC_BIN_MISSING";
    case SWEEP_DISC_NO_PHI:
      return "SWEEP_DISC_NO_PHI";
    case SWEEP_DISC_WITH_FILL:
      return "SWEEP_DISC_WITH_FILL";
    case FILL_WITH_SWEEP_DISC:
      return "FILL_WITH_SWEEP_DISC";
    case PA_MAIN_DATA_MISSING:
      return "PA_MAIN_DATA_MISSING";
    case BUF_BIN_MALLOC:
      return "BUF_BIN_MALLOC";
    case NEXT_FILE_TIME_NOT_FOUND:
      return "NEXT_FILE_TIME_NOT_FOUND";
    case NEXT_FILE_TIME_FILE_OPEN:
      return "NEXT_FILE_TIME_FILE_OPEN";
    case NEXT_FILE_TIME_INFO_DUP:
      return "NEXT_FILE_TIME_INFO_DUP";
    case RESET_CSET_MALLOC:
      return "RESET_CSET_MALLOC";
    case ILLEGAL_SMP_ID:
      return "ILLEGAL_SMP_ID";
    case NO_ERROR_STR:
      return "NO_ERROR_STR";
    case AUTOSWAP_ERROR:
      return "AUTOSWAP_ERROR";
    /* from DbDefs.h */
    case NO_DATA:
      return "NO_DATA";
    case NO_DATA_AOS:
      return "NO_DATA_AOS";
    case RETRIEVING_DATA:
      return "RETRIEVING_DATA";
    case INDEX_OPEN_ERROR:
      return "INDEX_OPEN_ERROR";
    case INDEX_CLOSE_ERROR:
      return "INDEX_CLOSE_ERROR";
    case INDEX_READ_ERROR:
      return "INDEX_READ_ERROR";
    case INDEX_WRITE_ERROR:
      return "INDEX_WRITE_ERROR";
    case DBF_OPEN_ERROR:
      return "DBF_OPEN_ERROR";
    case DBF_CLOSE_ERROR:
      return "DBF_CLOSE_ERROR";
    case DBF_READ_ERROR:
      return "DBF_READ_ERROR";
    case DBF_WRITE_ERROR:
      return "DBF_WRITE_ERROR";
    case DBF_FIND_ERROR:
      return "DBF_FIND_ERROR";
    case DBF_EMPTY:
      return "DBF_EMPTY";
    case DBF_LSEEK_ERROR:
      return "DBF_LSEEK_ERROR";
    case DBF_REPLACE_ERROR:
      return "DBF_REPLACE_ERROR";
    case DBF_APPEND_ERROR:
      return "DBF_APPEND_ERROR";
    case NO_VIDF_MATCH:
      return "NO_VIDF_MATCH";
    case NO_VIDF_FILE:
      return "NO_VIDF_FILE";
    case VIDF_OPEN_ERROR:
      return "VIDF_OPEN_ERROR";
    case NO_DATA_FILE:
      return "NO_DATA_FILE";
    case DATA_OPEN_ERROR:
      return "DATA_OPEN_ERROR";
    case DATA_READ_ERROR:
      return "DATA_READ_ERROR";
    case NO_HEADER_FILE:
      return "NO_HEADER_FILE";
    case HEADER_OPEN_ERROR:
      return "HEADER_OPEN_ERROR";
    case HEADER_READ_ERROR:
      return "HEADER_READ_ERROR";
    case TIMES_NOT_FOUND:
      return "TIMES_NOT_FOUND";
    case BAD_START_TIME:
      return "BAD_START_TIME";
    case BAD_END_TIME:
      return "BAD_END_TIME";
    case SOCKET_OPEN_ERROR:
      return "SOCKET_OPEN_ERROR";
    case SOCKET_BIND_ERROR:
      return "SOCKET_BIND_ERROR";
    case SENDTO_ERROR:
      return "SENDTO_ERROR";
    case RECVFROM_ERROR:
      return "RECVFROM_ERROR";
    case TAR_ZERO_LEN_FILE:
      return "TAR_ZERO_LEN_FILE";
    case TAR_SHORT_READ:
      return "TAR_SHORT_READ";
    case TAR_UNKNOWN_FILE_TYPE:
      return "TAR_UNKNOWN_FILE_TYPE";
    case TAR_EXTRACT_DIR:
      return "TAR_EXTRACT_DIR";
    case TAR_MKDIR_ERROR:
      return "TAR_MKDIR_ERROR";
    case TAR_CHMOD_ERROR:
      return "TAR_CHMOD_ERROR";
    case TAR_BAD_HEADER:
      return "TAR_BAD_HEADER";
    case TAR_EOA:
      return "TAR_EOA";
    case TAR_SHORT_WRITE:
      return "TAR_SHORT_WRITE";
    case TAR_MULTI_LINK:
      return "TAR_MULTI_LINK";
    case FIRST_ARCHIVE_FILE:
      return "FIRST_ARCHIVE_FILE";
    case READ_LABEL_ERROR:
      return "READ_LABEL_ERROR";
    case ALLOC_ERROR:
      return "ALLOC_ERROR";
    case NO_ARCHIVE_LABEL:
      return "NO_ARCHIVE_LABEL";
    case NEED_NEW_LABEL:
      return "NEED_NEW_LABEL";
    case NEW_TAPE:
      return "NEW_TAPE";
    case ARCHIVE_WRITE_ERROR:
      return "ARCHIVE_WRITE_ERROR";
    case CHANGE_MEDIA:
      return "CHANGE_MEDIA";
    case ARCHIVE_OPEN_ERROR:
      return "ARCHIVE_OPEN_ERROR";
    case CONFIG_FILE_ERROR:
      return "CONFIG_FILE_ERROR";
    case KEY_ERROR:
      return "KEY_ERROR";
    case VINST_ERROR:
      return "VINST_ERROR";
    case DB_FIELD_ERROR:
      return "DB_FIELD_ERROR";
  }		/* switch             */

  return "???????";
}		/* retcode_to_ascii() */
