#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "local_defs.h"
#include "user_defs.h"
#include "idf_defs.h"
#include "DbDefs.h"
#include "ret_codes.h"
#include "util_str.h"
#include "libbase_udf.h"
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"
#include "libCfg.h"
#include "StrHier.h"
#include "dbf.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"
#include "udfdlm_str.h"

/**************\
|*  UDF_READ  *|  Reads one complete record from the UDF dataset
\**************/

FUNCTION UDF_READ(int Argc, IDL_VPTR Argv[], char *kw_unused)
{
   extern struct general_info ginfo;
   extern struct fh_cache fh_list[];
   extern void *TmpSpace;
   extern u_ByTe_2 Version;
   extern ByTe_1 Ext[];
   extern void *UDF;

   struct idf_data    *U;
   struct Pidf        *P;
   struct PidfSensor  *Px;
   struct PidfUnit    *Pu;
   struct PidfAnc     *Pa;

   struct experiment_info *eX;
   struct ptr_rec *pTr;

   void *dS;

   ReaL_8 *d1;
   ReaL_4 *f1, Q;
   ByTe_4 NSmp, SPer, oFF, eN, ceN, TsN, I, L, SLen, ALen;
   ByTe_4 tF, vN;
   ByTe_2 *s1, *s2, *s3;
   ByTe_2 SeN, M, N, rV, uN;
   ByTe_2 EndN, EndM, FmT;
   ByTe_1 TimeFilled = 0, dF;
   ByTe_1 *c1, *c2;
   ByTe_1 Fwd, mN;

   IDL_MEMINT         one = 1;
   IDL_VPTR    *vP;

   struct basic_struct *arr;
   ByTe_1 *mB;

   struct fh_cache *fh;

   ByTe_4 FhNum;


  /*************************************************************************/
  /* Get the file handler for this UDF definition                          */
  /*************************************************************************/

   if (Argc == 1) {
      FhNum = Argv[0]->value.i;
      fh = &fh_list[FhNum];
   } else {
      IDL_Message(IDL_M_GENERIC, IDL_MSG_LONGJMP, "Usage: dS = UDF_READ(fh)");
   }

  /*************************************************************************/
  /* Allocate space for the structure if no space present                  */
  /*************************************************************************/

   U = (struct idf_data *)UDF;
   if (fh->dA == NULL) {
      if ((fh->dA = malloc(fh->dSize)) == NULL)
        idl_barf("UDF_READ: malloc(fh->dA) failed!");
   }
   arr = (struct basic_struct *)fh->dA;
   mB = (ByTe_1 *) &(arr->data);

  /*************************************************************************/
  /* POINTERS to the PIDF information for this UDF                         */
  /*************************************************************************/

   P = (struct Pidf *)fh->PIDF;
   Px = (struct PidfSensor *)P->Sensors;
   Pu = (struct PidfUnit *)P->Units;
   Pa = (struct PidfAnc *)P->Ancil;

  /*************************************************************************/
  /*  THE structure definition and the output data format as StoreData     */
  /*  wants to see it.                                                     */
  /*************************************************************************/

   dS = fh->sdef;
   FmT = (fh->sType == IDL_TYP_DOUBLE) ? 4 : 3;

  /*************************************************************************/
  /* SET up a pointer to the experiment information structure for this     */
  /*  this UDF definition                                                  */
  /*************************************************************************/

   rV = ir_locate_ex (fh->Key, Ext, Version, 0);
   if (rV == ALL_OKAY) {
       eX = ginfo.expt;
   } else { udf_barf("LOCATE_EX", rV); }

  /*************************************************************************/
  /*                                                                       */
  /*                   HERE STARTS THE GREAT DATA GRAB                     */
  /*                                                                       */
  /*  Loop over the ordered sensors.  Only pick up the VIDF sensors and    */
  /*  not the ancillary data.                                              */
  /*                                                                       */
  /*  Outer loop is the matrix column loop.  Needs to be outer in case     */
  /*  there are multiple sensors and the matrix extends beyond a single    */
  /*  data record.                                                         */
  /*                                                                       */
  /*************************************************************************/

   EndN = fh->TotVSen - 1;
   EndM = fh->NCols - 1;
   for (M = 0; M < fh->NCols; M++) {
      s1 = (ByTe_2 *)fh->Order;
      for (N = 0; N < fh->TotVSen; N++, ++s1) {
         SeN = Px[*s1].VidfNum; 
         Fwd = (M == EndM && N == EndN) ? 1 : 0; 

         fh->LastRead = read_drec(fh->Key, Ext, Version, UDF, SeN, M, Fwd, 0);
         if (fh->LastRead <= 0) { udf_barf("ReadDrec", fh->LastRead); }

  /*************************************************************************/
  /* Save off the number of samples returned, the spin period, and the     */
  /*   maximum possible number of samples which can be returned.           */
  /*************************************************************************/

         NSmp = U->num_sample;
         SPer = U->spin_rate;
	 SLen = eX->swp_len;

  /*************************************************************************/
  /* IF the sensor wasn't there then first figure out how many samples     */
  /*  should have been returned and then zero out NSmp elements in the     */
  /*  in the TmpSpace array. We'll use that as fill data when the time     */
  /*  comes.                                                               */
  /*************************************************************************/

         if (!U->filled_data) {
	    pTr = eX->info_ptr;
	    NSmp = (eX->smp_id == 2) ? 1 : *pTr->N_SAMPLE;
  	    if (fh->sType == IDL_TYP_DOUBLE) {
	        d1 = (ReaL_8 *)TmpSpace;
                for (I = 0; I < NSmp; ++I) { *d1++ = 0.0; }
            } else {
	        f1 = (ReaL_4 *)TmpSpace;
                for (I = 0; I < NSmp; ++I) { *f1++ = 0.0; }
            }
         }

  /*************************************************************************/
  /* FILL in the start time, the number of samples and spin period it not  */
  /* yet filled in.  These are elements 0, 2, and 3 in the data structure  */ 
  /*************************************************************************/

         if (!TimeFilled) {
            TimeFilled = 1;
	    TimeFill( fh, _BTIME_);
	    StoreData(dS, mB, (ByTe_1 *)&NSmp, 2, 2, 2, 1, 0);
	    vP = NULL;
	    StoreData(dS, mB, (ByTe_1 *)&SPer, 2, 2, 3, 1, 0);
         }

  /*************************************************************************/
  /* Continually update the end time so its current when we finally finish */
  /* all of the reads,                                                     */
  /*************************************************************************/

	 TimeFill(fh, _ETIME_);

  /*************************************************************************/
  /*  QUALITY flags go into the 4th structure element.  If the requested   */
  /*  sensor was not found its quality flag is set to -1.                  */
  /*************************************************************************/

         eN = 4;
	 oFF = M + N * fh->NCols;
         Q = (!U->filled_data) ? -1.0 : U->d_qual;
	 StoreData(dS, mB, (ByTe_1 *)&Q, 3, 3, eN++, 1, oFF);
 
  /*************************************************************************/
  /*  PHASE angles go into the 5th and 6th structure elements. There are 2 */
  /*  storage formats, either one per set valid for all sensors or one per */
  /*  sensor.  In the latter the values are concantenated into the two     */
  /*  structure elements.                                                  */
  /*************************************************************************/

         if (fh->flags.azimuth == 0) {
            oFF = (N == 0 && M == 0) ? 0 : -1;
	 } else { oFF = SLen * (M + N * fh->NCols); }

         if (oFF >= 0 ) {
            StoreData(dS, mB, (ByTe_1 *)U->start_az, 3, 3, eN++, NSmp, oFF);
            StoreData(dS, mB, (ByTe_1 *)U->stop_az, 3, 3, eN++, NSmp, oFF);
         } else { eN += 2; }

  /*************************************************************************/
  /*   THETA angles go into the 7th and 8th structure elements.  Use the   */
  /*   dummy data if no sensor was found.  Like the phase angles there are */
  /*   two storage formats, either one per sensor or one per returned      */
  /*   value.                                                              */
  /*************************************************************************/

         TsN = (fh->flags.theta == 0) ? 1 : U->num_sample;
         if (fh->flags.theta == 0) {
             oFF = M + N * fh->NCols;
	 } else { oFF = SLen * (M + N * fh->NCols); }

         f1 = (ReaL_4 *)TmpSpace;
         if (U->filled_data) { f1 = (ReaL_4 *)U->start_theta; }
         StoreData(dS, mB, (ByTe_1 *)f1, 3, 3, eN++, TsN, oFF);
         if (U->filled_data) { f1 = (ReaL_4 *)U->stop_theta; }
         StoreData(dS, mB, (ByTe_1 *)f1, 3, 3, eN++, TsN, oFF);

  /*************************************************************************/
  /*   ARRAY index data go into the 9th and possibly the 10th structure    */
  /*   elements.  Two formats, either one for all returned sensors or one  */
  /*   per sensor.  There is no array index array if the data being        */
  /*   returned is scalar data.                                            */
  /*************************************************************************/

         if (eX->smp_id != 2) {
            if (fh->flags.indices == 0) {
               oFF = (N == 0 && M == 0) ? 0 : -1;
	    } else { oFF = SLen * (M + N * fh->NCols); }

            if (oFF >= 0 ) {
               s2 = fh->Units + fh->TotVSen + fh->TotAnc + fh->TotMode;
               for (I = 0; I < fh->TotIndex; ++I) {
                  if (U->filled_data) {
                     uN = *s2++;
                     rV = convert_to_units(fh->Key, Ext, Version, UDF, 
		                 SCAN_INDEX, 0, (ByTe_1)Pu[uN].NTbls, 
				 Pu[uN].Tbls, Pu[uN].Ops, (ReaL_4*)TmpSpace, 
				 0, 0);
                     if (rV != ALL_OKAY) { udf_barf("ConvUnits(SCAN)", rV); }
                  }
                  StoreData(dS, mB, (ByTe_1 *)TmpSpace, 3, 3, eN++, NSmp, oFF);
               } 
            } else { eN += fh->TotIndex; }
         }

  /*************************************************************************/
  /* DATA goes here.  Three formats.  Can squash all of the sensor data    */
  /*  data into one structure element, can concatinate all of the data     */
  /*  from similar groups into elements named after the groups, or can     */
  /*  give each measurement its own structure element.                     */
  /*************************************************************************/
       
         if (fh->flags.sformat == 1) {
	    oFF = SLen * (M + N * fh->NCols);
            ceN = eN;
         } else {
	    oFF = (fh->NCols > 1) ? SLen * M : 0; 
            ceN = eN;
            eN += N;
         } 

	 uN = *(fh->Units + N);
	 dF =  (fh->sType == IDL_TYP_DOUBLE) ? DSENSOR : SENSOR;
         if  (U->filled_data) {
	    rV = convert_to_units(fh->Key, Ext, Version, UDF, dF,
	                           0, (ByTe_1)Pu[uN].NTbls, Pu[uN].Tbls,
	                           Pu[uN].Ops, (ReaL_4*)TmpSpace, 0, 0);
	    if (rV != ALL_OKAY) { udf_barf("ConvUnits(SENSOR)", rV); }
         }
         StoreData(dS, mB, (ByTe_1 *)TmpSpace, FmT, FmT, eN, NSmp, oFF);

  /*************************************************************************/
  /*  Modes go here.  They start in the structure right after the last     */
  /*  the last sensor data set.                                            */
  /*************************************************************************/

         if (N == 0 && M == 0) { 
	    eN = ceN + fh->TotSeN;
            dF =  (fh->sType == IDL_TYP_DOUBLE) ? DMODE : MODE;
            s2 = fh->Units + fh->TotVSen + fh->TotAnc;
            s3 = fh->Order + fh->TotVSen + fh->TotAnc;
            for (I = 0; I < fh->TotMode; ++I) {
               uN = *s2++;
               mN = *s3++;

               rV = convert_to_units(fh->Key, Ext, Version, UDF, dF,
                             mN, (ByTe_1)Pu[uN].NTbls, Pu[uN].Tbls, 
                             Pu[uN].Ops, (ReaL_4*)TmpSpace, 0, 0);
               if (rV != ALL_OKAY) { udf_barf("ConvUnits(MODE)", rV); }
               StoreData(dS, mB, (ByTe_1 *)TmpSpace, FmT, FmT, eN++, 1, 0);
            }
         }

  /*************************************************************************/
  /*  Last - stick in any ancillary data.  Depending on the type of        */
  /*   ancillary data there is either 1 set of ancillary data per sensor   */
  /*   sensor value, one per sensor, or one per read                       */
  /*************************************************************************/

	 eN = ceN + fh->TotSeN + fh->TotMode;

         dF = (fh->sType == IDL_TYP_DOUBLE) ? DANCILLARY : ANCILLARY;
         c1 = fh->Set + fh->TotVSen;
         c2 = fh->Dim + fh->TotVSen;
         s2 = fh->Units + fh->TotVSen;

	 L = fh->TotVSen;
         for (I = 0; I < fh->TotAnc; ++I, ++c1, ++c2, ++s2, ++eN, ++L) {
	    vN = (*(fh->Loc + L) == 'S') ? Px[*(fh->Order + L)].VidfNum :
                                           Pa[*(fh->Order + L)].VidfNum;
	    tF = *(eX->cal_target + vN);

            if (tF < 2) {
	       ALen = (*(fh->Dim + L) == 0) ? 1 : SLen;
	       oFF = N * ALen * fh->NCols + M * ALen;
	    } else if (tF == 2) {
	       oFF = (N == 0) ? M : -1;
	    } else if (tF == 3) {
	       oFF = ((N == 0) && (M == 0)) ? 0 : -1;
	    }

            if (oFF  >= 0) {
               uN = *s2;
               rV = convert_to_units(fh->Key, Ext, Version, UDF, dF,
                                     *c1, (ByTe_1)Pu[uN].NTbls, Pu[uN].Tbls, 
                                     Pu[uN].Ops, (ReaL_4*)TmpSpace, 0, 0);
               if (rV != ALL_OKAY) { udf_barf("ConvUnits(ANC)", rV); }

               TsN = (*c2 == 0) ? 1 : NSmp;
               StoreData(dS, mB, (ByTe_1 *)TmpSpace, FmT, FmT, eN, TsN, oFF);
            }
         }
      }
   }

  /*
  ** Move the data we just read in into an IDL structure
  */


   return IDL_ImportArray(1, &one, IDL_TYP_STRUCT, (UCHAR*)arr, NULL, dS);
}
