#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "util_str.h"
#include "local_defs.h"
#include "idf_defs.h"
#include "DbDefs.h"
#include "libCfg.h"
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"
#include "user_defs.h"
#include "ret_codes.h"
#include "libbase_udf.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

/**************\
|*  UDF_OPEN  *|  Given a key, initializes access to UDF data
\**************/

FUNCTION UDF_OPEN(int Argc, IDL_VPTR Argv[], char *Argk)
{
   extern struct fh_cache fh_list[];
   extern ByTe_1 Ext[];
   extern u_ByTe_2 Version;
   extern LinkList Projects;
   extern void *UDF;
   extern struct general_info ginfo;
                                                                                
   struct experiment_info *ex;
   struct ptr_rec *ptr;
   struct Pidf         *P;
                                                                                
   ByTe_4    HH, MM, SS, *l1, tM[5], tMDef[5], I, J;
   StrHier   scode;
   ByTe_2    FieldId[5], DiM;
   ByTe_2    rV, Rv;
   u_ByTe_4  Key;
   ByTe_2    By, Bd, Ey, Ed, TyPe;
   ByTe_2    *s1;
   ByTe_4    Bs, Bns, Es, Ens;
   ByTe_4    fP;

   IDL_VPTR  retval;

   struct fh_cache *fh;

  /************************************************************************/
  /*  Calling Arguments:                                                  */
  /*                                                                      */
  /*  1.  Key - UDF Key                                                   */
  /*  2.  Beginning Year, Day, Hh, Mm, Ss Msec  - mandatory               */
  /*  3.  Ending Year, Day, Hh, Mm, Ss Msec  - optional                   */
  /*                                                                      */
  /*  If the ending time is omitted it is set to the end of the beginning */
  /*  day.                                                                */
  /************************************************************************/

  if (Argc < 2)
     IDL_Message(IDL_M_GENERIC, IDL_MSG_LONGJMP,
      "Usage:\n fh = UDF_OPEN(key, [BT], {[ET]})\n fh=UDF_OPEN(key, BT, {ET})");

  /************************************************************************/
  /*  Get the key so we can get the file handler                          */
  /************************************************************************/

  Key = Argv[0]->value.ul;

  fP = FindFh(Key);
  fh = &fh_list[fP];

  /************************************************************************/
  /* PROCESS Keywords before all else  but only if we haven't already got */
  /* them through a */
  /************************************************************************/

  if (!fh->flags.gotkeys) { Argc = ProcKeyWords (Argc, Argv, Argk); }

  if (Argv[1]->flags & IDL_V_NOT_SCALAR) {
     if (Argv[1]->value.arr->dim[0] < 2)
        idl_barf("UDF_OPEN: Must Have At Least BYear and BDay");

     DiM = Argv[1]->value.arr->dim[0];
     if (Argv[1]->type == IDL_TYP_INT) {
         s1 = (ByTe_2 *)Argv[1]->value.arr->data;
         By  = *s1++;
         Bd  = *s1++;
         HH  = (DiM > 2) ? *s1++ : 00;
         MM  = (DiM > 3) ? *s1++ : 00;
         SS  = (DiM > 4) ? *s1++ : 00;
     } else {
         l1 = (ByTe_4 *)Argv[1]->value.arr->data;
         By  = *l1++;
         Bd  = *l1++;
         HH  = (DiM > 2) ? *l1++ : 00;
         MM  = (DiM > 3) ? *l1++ : 00;
         SS  = (DiM > 4) ? *l1++ : 00;
     }

     Bs =  3600 * HH + 60 * MM + SS;
     Bns = 0;

     if (Argc == 3) {
        DiM = Argv[2]->value.arr->dim[0];
        if (Argv[2]->type == IDL_TYP_INT) {
            s1 = (ByTe_2 *)Argv[2]->value.arr->data;
            Ey  = *s1++;
            Ed  = *s1++;
            HH  = (DiM > 2) ? *s1++ : 23;
            MM  = (DiM > 3) ? *s1++ : 59;
            SS  = (DiM > 4) ? *s1++ : 59;
        } else {
            l1 = (ByTe_4 *)Argv[2]->value.arr->data;
            Ey  = *l1++;
            Ed  = *l1++;
            HH  = (DiM > 2) ? *l1++ : 23;
            MM  = (DiM > 3) ? *l1++ : 59;
            SS  = (DiM > 4) ? *l1++ : 59;
        }

        Es =  3600 * HH + 60 * MM + SS;
        Ens = 0;
     } else {
        Ey  = By;
        Ed  = Bd;
        HH  = 23;
        MM  = 59;
        SS  = 59;
        Es =  3600 * HH + 60 * MM + SS;
        Ens = 0;
     }
  } else {
     if (Argc < 3)
        idl_barf("UDF_OPEN: Must Have At Least BYear and BDay");

     tMDef[0] = 0; tMDef[1] = 0; tMDef[2] = 0; tMDef[3] = 0; tMDef[4] = 0;
     for (I = 0, J = 1; I < 5; ++I, ++J ) {
        TyPe =  Argv[J]->type;
        if (Argc > J) {  
           tM[I] = (TyPe == IDL_TYP_INT) ? Argv[J]->value.i : Argv[J]->value.l;
        } else { tM[I] = tMDef[I]; }
     }

     By = tM[0] ; Bd = tM[1];
     Bs =  3600 * tM[2] + 60 * tM[3] + tM[4];
     Bns = 0;

     tMDef[0] = By; tMDef[1] = Bd; tMDef[2] = 23; tMDef[3] = 59; tMDef[4] = 59;
     for (I = 0, J = 6; I < 5; ++I, ++J ) {
        TyPe =  Argv[J]->type;
        if (Argc > J) {  
           tM[I] = (TyPe == IDL_TYP_INT) ? Argv[J]->value.i : Argv[J]->value.l;
        } else { tM[I] = tMDef[I]; }
     }

     Ey = tM[0] ; Ed = tM[1];
     Es =  3600 * tM[2] + 60 * tM[3] + tM[4];
     Ens = 0;
  }

  /*********************************************************************/
  /*  Open the Data files                                              */
  /*                                                                   */
  /* file_open is a safe call at anytime since it has its own built in */
  /* protection to prevent multiple opens.  If the file is open this   */
  /* routine will return doing nothing.  NOTE that with each call the  */
  /* expt begining times will be reset to those passed in              */ 
  /*********************************************************************/

   rV = file_open(Key, Ext, Version,
                  By, Bd, Bs, Bns,	/* Beginning time	    */
	          Ey, Ed, Es, Ens,	/* Ending time: forever     */
		  0);			/* 1 to be all encompassing */

   Rv = ir_locate_ex (Key, Ext, Version, 0);
   if (Rv == ALL_OKAY) { 
      ex = ginfo.expt;
   } else { udf_barf("LOCATE_EX", Rv); }

   if (rV != ALL_OKAY) {
      ex->num_modes = 0;
      ex->num_combo = 0;
      FreeUpOne (Key, Ext, Version);
      FhClose(fP);
   }
   if (rV == NO_DATA || rV == EOF_STATUS)
      idl_barf("FileOpen: No Data For This Time Period");
   if (rV != ALL_OKAY) 
      udf_barf("FileOpen", rV);

  /*************************************************************************/ 
  /* Get the PIDF info for this key and fill in a few parameters           */
  /*************************************************************************/ 

   ReadPidf (Key, fh->PIDF);
   P = (struct Pidf *)fh->PIDF;

  /*************************************************************************/ 
  /* Place file pointer to beginning time in the file according to how     */
  /* the PIDF blocking is set.                                             */
  /*************************************************************************/ 

   if (P->Pf.Blocking == 0)
      rV = file_pos(Key, Ext, Version, UDF, By, Bd, Bs, Bns, Ey, Ed, Es, Ens);
   else
      rV = FilePosRec(Key, Ext, Version, UDF, By, Bd, Bs, Bns, Ey, Ed, Es, Ens);

   if (rV != ALL_OKAY)
       udf_barf("FilePos", rV);

   if (ex->smp_id == 3) {
      ptr = ex->info_ptr;
      fh->NCols = *ptr->TOT_COLS;
   } else { fh->NCols = 1; }

   /* Done!  Mark this spot as open */

   fh->is_open = 1;

  /************************************************************/ 
  /* Need to construct a unique structure name.               */
  /* To make it both unique and partially user friendly, it   */
  /* is formed as [VINST]_K[VALUE]_V[VALUE] where VINST is    */
  /* the UDF virtual acronym, the value following K is the    */
  /* UDF Key and the value following V is the version number  */
  /* associated with the key.                                 */
  /************************************************************/ 

   key_to_fields(fh->Key, FieldId);
   scode = SourceByNum(Projects, FieldId[0], FieldId[1], FieldId[2], 
		                 FieldId[3], FieldId[4], NULL);
   sprintf (fh->BaseName, "%s_K%d_V%d", SNAME(scode), fh->Key, Version);

  /**********************************************/ 
  /* Make IDL structures out of all this info   */
  /**********************************************/ 

   fh->sdef = MkDataStruc(fh);

   /* Remember the desired ending time, so we can check in UDF_EOF */

   fh->Ey  = Ey;
   fh->Ed  = Ed;
   fh->Ems = (Es * 1000) + (Ens / 1000000);

   retval          = IDL_Gettmp();
   retval->type    = IDL_TYP_INT;
   retval->value.i = fP;
   return retval;
}
