#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "libbase_udf.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

/**************\
|*  UDF_CLOSE  *|  Cleans up when done reading from a UDF
\**************/

PROCEDURE UDF_CLOSE( int Argc, IDL_VPTR Argv[], char *kw_unused )
{
   extern struct fh_cache fh_list[];
   extern u_ByTe_2 Version;
   extern ByTe_1 Ext[];
  
   u_ByTe_4 KeY;
   ByTe_4 FhNum, OpeN;
   struct fh_cache *fh;

   if (Argc == 1) {
      FhNum = Argv[0]->value.i;
      fh = &fh_list[FhNum];
   } else
      IDL_Message(IDL_M_GENERIC, IDL_MSG_LONGJMP, "Usage: UDF_CLOSE, fh");

   KeY = fh->Key;
   OpeN = fh->is_open;
   FhClose( FhNum );
   if (OpeN == 1) { FreeUpOne (KeY, Ext, Version); }
}
