#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "local_defs.h"
#include "user_defs.h"
#include "idf_defs.h"
#include "DbDefs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"
#include "libCfg.h"
#include "StrHier.h"
#include "dbf.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"
#include "udfdlm_str.h"

void *MkVidfStruc( struct fh_cache *fh, ByTe_2 FmT, ByTe_2 Blk, ByTe_2 mN, 
                                        ByTe_2 mV, size_t *mS, size_t *sS)
{
   extern void *TmpDim;
   extern u_ByTe_2 Version;
   extern ByTe_1   Ext[];
   extern void     *TmpName;
   extern void     *TmpType;
   extern void     *TaGs;

   ByTe_4          MxT, I;
   int             nTag = 0;
   void            *vD;

   u_ByTe_4        KeY;
   ByTe_4          Dim[3], tLen = 1;
   ByTe_4          B, CritSz, SSz, TSz, lS;

   ByTe_2          nSen, nCom, PaAppS;
   u_ByTe_2        VeR;

   ByTe_1          FillFlag, nStat, nAnc, nQual, pAng, tType;
   ByTe_1          nT, nC;

   VeR = Version;

   TaGs = NULL;
   TmpName = NULL;
   TmpDim = NULL;
   TmpType = NULL;

   KeY = fh->Key;

   if (fh->mV == NULL) {
      read_idf(KeY, Ext, VeR, &nT, _NumTblS, 0, 0, 0);
      read_idf(KeY, Ext, VeR, &nC, _NumConstS, 0, 0, 0);
      B = sizeof(void **) * (2 * (nT + nC) + 1); 

      if ((fh->mV = malloc(B)) == NULL) {
         idl_barf("MkVidfStruc: malloc(fh->mV)");
      }
      if ((fh->vA = malloc(B)) == NULL) {
         idl_barf("MkVidfStruc: malloc(fh->vA)");
      }

      B = 2 * (nT + nC) + 1; 
      fh->vNum = B;
      for ( I = 0; I < B; ++I ) { 
         fh->mV[I] = NULL; 
         fh->vA[I] = NULL; 
      }
      fh->nC = nC;
      fh->nT = nT;
   }

/* ALWAYS seem to need to know the number of sensors     */

   read_idf(KeY, Ext, VeR, (ByTe_1 *)&nSen, _SeN, 0, 0, 0);

/* SWITCH on the type of structure we need to build      */
/*   0 - BODY                                            */
/*   1 - TABLERAW                                        */
/*   2 - TABLECOOKED                                     */
/*   3 - CONSTANTRAW                                     */
/*   4 - CONSTANTCOOKED                                  */

   switch (FmT) {
      case 0: 

/* READ in some of the variable fields. These are used   */
/*   to determine how many tags we need to create as     */
/*   well as array sizes to use in the tags              */

         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nCom, _NumComntS, 0, 0, 0);
         read_idf(KeY, Ext, VeR, &FillFlag, _FillFlaG, 0, 0, 0);
         read_idf(KeY, Ext, VeR, &nStat, _StatuS, 0, 0, 0);
         read_idf(KeY, Ext, VeR, &nAnc, _CalSetS, 0, 0, 0);
         read_idf(KeY, Ext, VeR, &nQual, _NumQuaL, 0, 0, 0);
         read_idf(KeY, Ext, VeR, &pAng, _PaDefineD, 0, 0, 0);

/* GET an estimate on how many tags we need and then add */
/*   some padding.                                       */

/* WE need at least one tag per field + 4 for the extra  */
/*  lines in the contact field                           */

	 MxT = _TblScaSZ + 4;

/*  IF there is ntot pitch angle information that's 10   */
/*  less tags needed.                                    */

	 if ( pAng == 0 ) { MxT -= 10; }

/* AND a 20 tag pad                                      */

         MxT += 10;

/* NOW malloc all of the memeory we need for the tags   */
   
         B = MxT * MAX_TAG_LEN;
         if ((TmpName = malloc(B)) == NULL)
            idl_barf("MkVidfStruc: malloc(TmpName)");

         B = MxT * (4 * sizeof(IDL_MEMINT));
         if ((TmpDim = malloc(B)) == NULL)
             idl_barf("MkVidfStruc: malloc(TmpDim)");

         B = MxT * sizeof(ByTe_2);
         if ((TmpType = malloc(B)) == NULL)
             idl_barf("MkVidfStruc: malloc(TmpType)");

/* THERE are no 2D arrays so set Dim[1] and Dim[2] to  */
/*   0 now and forget it                               */

         Dim[0] = 0;
         Dim[1] = 0;
         Dim[2] = 0;

/* GET the number of bytes that are used in all the    */
/*   80 byte string fields now                         */

	 *sS = 720 + 80 * (nCom + nSen + nAnc + nQual + nStat);
	 if (pAng == 1) { *sS += 400; } 

/* NOW create the tags.  Update sS in chunks           */

         SetUpTag("PROJECT", IDL_TYP_STRING, Dim, nTag++, &MxT);
         SetUpTag("MISSION", IDL_TYP_STRING, Dim, nTag++, &MxT);
         SetUpTag("EXPERIMENT", IDL_TYP_STRING, Dim, nTag++, &MxT);
         SetUpTag("INSTRUMENT", IDL_TYP_STRING, Dim, nTag++, &MxT);
         Dim[0] = 5;
         lS = SetUpTag("CONTACT", IDL_TYP_STRING, Dim, nTag++, &MxT);

         SetUpTag("NUMCOMLINES", IDL_TYP_LONG, Dim, nTag++, &MxT);
         Dim[0] = nCom;
         SetUpTag("COMMENT", IDL_TYP_STRING, Dim, nTag++, &MxT);

         Dim[0] = 0;
         SetUpTag("BYEAR", IDL_TYP_LONG, Dim, nTag++, &MxT);
         SetUpTag("BDAY",  IDL_TYP_LONG, Dim, nTag++, &MxT);
         SetUpTag("BMSEC", IDL_TYP_LONG, Dim, nTag++, &MxT);
         SetUpTag("BUSEC", IDL_TYP_LONG, Dim, nTag++, &MxT);
         SetUpTag("EYEAR", IDL_TYP_LONG, Dim, nTag++, &MxT);
         SetUpTag("EDAY",  IDL_TYP_LONG, Dim, nTag++, &MxT);
         SetUpTag("EMSEC", IDL_TYP_LONG, Dim, nTag++, &MxT);
         SetUpTag("EUSEC", IDL_TYP_LONG, Dim, nTag++, &MxT);
         SetUpTag("SMPID", IDL_TYP_LONG, Dim, nTag++, &MxT);
         SetUpTag("SENMODE", IDL_TYP_LONG, Dim, nTag++, &MxT);
         SetUpTag("NUMQUAL", IDL_TYP_LONG, Dim, nTag++, &MxT);
         SetUpTag("ANCSETS", IDL_TYP_LONG, Dim, nTag++, &MxT);
         SetUpTag("NUMTBLS", IDL_TYP_LONG, Dim, nTag++, &MxT);
         SetUpTag("NUMCONSTS", IDL_TYP_LONG, Dim, nTag++, &MxT);
         SetUpTag("STATUS", IDL_TYP_LONG, Dim, nTag++, &MxT);
         SetUpTag("PADEFINED", IDL_TYP_LONG, Dim, nTag++, &MxT);
         SetUpTag("NUMSEN", IDL_TYP_LONG, Dim, nTag++, &MxT);
         SetUpTag("ARRAYLEN", IDL_TYP_LONG, Dim, nTag++, &MxT);
         SetUpTag("MAXNSS", IDL_TYP_LONG, Dim, nTag++, &MxT);
         SetUpTag("DATALEN", IDL_TYP_LONG, Dim, nTag++, &MxT);
         SetUpTag("FILLFLAG", IDL_TYP_LONG, Dim, nTag++, &MxT);
         if (FillFlag == 1 ) {
            SetUpTag("FILLVAL", IDL_TYP_ULONG, Dim, nTag++, &MxT);
         }
         SetUpTag("DAMETHOD", IDL_TYP_LONG, Dim, nTag++, &MxT);

	 if ( nStat > 0 ) {
            Dim[0] = nStat;
            lS = SetUpTag("STATUSNAME", IDL_TYP_STRING, Dim, nTag++, &MxT);
            lS = SetUpTag("STATES", IDL_TYP_LONG, Dim, nTag++, &MxT);
	 }

	 if ( nSen > 0 ) {
            Dim[0] = nSen;
            lS = SetUpTag("SENNAME", IDL_TYP_STRING, Dim, nTag++, &MxT);
            lS = SetUpTag("SENTYPE", IDL_TYP_LONG, Dim, nTag++, &MxT);
            lS = SetUpTag("SENLEN", IDL_TYP_LONG, Dim, nTag++, &MxT);
            lS = SetUpTag("SENTIMEOFF", IDL_TYP_LONG, Dim, nTag++, &MxT);
	 }

	 if ( nAnc > 0 ) {
            Dim[0] = nAnc;
            lS = SetUpTag("ANCNAME", IDL_TYP_STRING, Dim, nTag++, &MxT);
            lS = SetUpTag("ANCUSE", IDL_TYP_LONG, Dim, nTag++, &MxT);
            lS = SetUpTag("ANCLEN", IDL_TYP_LONG, Dim, nTag++, &MxT);
            lS = SetUpTag("ANCTARGET", IDL_TYP_LONG, Dim, nTag++, &MxT);
	 }

	 if ( nQual > 0 ) {
            Dim[0] = nQual;
            lS = SetUpTag("QUALNAME", IDL_TYP_STRING, Dim, nTag++, &MxT);
	 }

	 if ( pAng == 1 ) {
            Dim[0] = 0;
            lS = SetUpTag("PAPROJECT", IDL_TYP_STRING, Dim, nTag++, &MxT);
            lS = SetUpTag("PAMISSION", IDL_TYP_STRING, Dim, nTag++, &MxT);
            lS = SetUpTag("PAEXPER", IDL_TYP_STRING, Dim, nTag++, &MxT);
            lS = SetUpTag("PAINST", IDL_TYP_STRING, Dim, nTag++, &MxT);
            lS = SetUpTag("PAVINST", IDL_TYP_STRING, Dim, nTag++, &MxT);

            lS = SetUpTag("PAFORMAT", IDL_TYP_LONG, Dim, nTag++, &MxT);

            Dim[0] = 3;
            lS = SetUpTag("PAMFSENS", IDL_TYP_LONG, Dim, nTag++, &MxT);

            read_idf(KeY, Ext, VeR, (ByTe_1 *)&PaAppS, _PaAppS, 0, 0, 0);
            Dim[0] = 0;
            lS = SetUpTag("MFALGSTEPNUM", IDL_TYP_LONG, Dim, nTag++, &MxT);

	    if (PaAppS > 0 ) {
               Dim[0] = PaAppS;
               lS = SetUpTag("PATBLS", IDL_TYP_LONG, Dim, nTag++, &MxT);
               lS = SetUpTag("PAOPERS", IDL_TYP_LONG, Dim, nTag++, &MxT);
	    }
	 }
      break;
      case 1: 
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nCom, _TblDescLeN, Blk, 0, 0);
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&CritSz, _CritActSZ, Blk, 0, 0);
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&SSz, _TblScaSZ, Blk, 0, 0);
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&TSz, _TblEleSZ, Blk, 0, 0);
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nSen, _SeN, 0, 0, 0);
         read_idf(KeY, Ext, VeR, &tType, _TblTypE, Blk, 0, 0);

	 MxT = _TbL - _TblScaSZ + 1;
	 if ( CritSz == 0 ) { MxT -= 3; }
         MxT += nCom;
         MxT += 10;
         
         B = MxT * MAX_TAG_LEN;
         if ((TmpName = malloc(B)) == NULL)
            idl_barf("MkDataStruc: malloc(TmpName)");

         B = MxT * (4 * sizeof(IDL_LONG));
         if ((TmpDim = malloc(B)) == NULL)
             idl_barf("MkDataStruc: malloc(TmpDim)");

         B = MxT * sizeof(ByTe_2);
         if ((TmpType = malloc(B)) == NULL)
             idl_barf("MkDataStruc: malloc(TmpType)");

         *sS = nCom * 80;
	 if (tType == 1) { *sS += TSz * 80; }

         Dim[1] = 0;
         Dim[2] = 0;

         Dim[0] = 0;
         lS = SetUpTag("TBLSCASZ", IDL_TYP_LONG, Dim, nTag++, &MxT);
         lS = SetUpTag("TBLELEMSZ", IDL_TYP_LONG, Dim, nTag++, &MxT);
         lS = SetUpTag("TBLTYPE", IDL_TYP_LONG, Dim, nTag++, &MxT);
         lS = SetUpTag("NUMCOMLINES", IDL_TYP_LONG, Dim, nTag++, &MxT);
	 if (nCom > 0) {
            Dim[0] = nCom;
            lS = SetUpTag("TBLCOMMENT", IDL_TYP_STRING, Dim, nTag++, &MxT);
         }

         Dim[0] = 0;
         lS = SetUpTag("TBLVAR", IDL_TYP_LONG, Dim, nTag++, &MxT);
         lS = SetUpTag("TBLEXPAND",  IDL_TYP_LONG, Dim, nTag++, &MxT);

	 if ( CritSz > 0 ) {
            Dim[0] = nSen;
            lS = SetUpTag("TBLCRITSTAT", IDL_TYP_LONG, Dim, nTag++, &MxT);
            lS = SetUpTag("TBLCRITOFFS", IDL_TYP_LONG, Dim, nTag++, &MxT);
            Dim[0] = CritSz;
            lS = SetUpTag("TBLCRITACT", IDL_TYP_LONG, Dim, nTag++, &MxT);
	 }

         Dim[0] = nSen;
         lS = SetUpTag("TBLFMT", IDL_TYP_LONG, Dim, nTag++, &MxT);
         lS = SetUpTag("TBLOFFSETS", IDL_TYP_LONG, Dim, nTag++, &MxT);

         if  (SSz != 0) {
	    Dim[0] = ( SSz < 0 ) ? -SSz : SSz;
            lS = SetUpTag("TBLSCALEVALS", IDL_TYP_LONG, Dim, nTag++, &MxT);
         }

	 Dim[0] = TSz;
	 if (tType != 1) {
            lS = SetUpTag("TBLVALS", IDL_TYP_LONG, Dim, nTag++, &MxT);
         } else {
            lS = SetUpTag("TBLVALS", IDL_TYP_STRING, Dim, nTag++, &MxT);
         }
      break;
      case 2: 
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nCom, _TblDescLeN, Blk, 0, 0);
         read_idf(KeY, Ext, VeR, &tType, _TblTypE, Blk, 0, 0);

	 MxT = _TbL - _TblScaSZ + 1;
         MxT += nCom;
         MxT += 10;

/* DETERMINE HOW MANY TABLE VALUES ARE COMING BACK.                     */

         tLen = NumTblVals (KeY, Blk, mN); 

         B = MxT * MAX_TAG_LEN;
         if ((TmpName = malloc(B)) == NULL)
            idl_barf("MkDataStruc: malloc(TmpName)");

         B = MxT * (4 * sizeof(IDL_LONG));
         if ((TmpDim = malloc(B)) == NULL)
             idl_barf("MkDataStruc: malloc(TmpDim)");

         B = MxT * sizeof(ByTe_2);
         if ((TmpType = malloc(B)) == NULL)
             idl_barf("MkDataStruc: malloc(TmpType)");

         *sS = nCom * 80;
	 if (tType == 1) { *sS += TSz * 80; }

         Dim[0] = 0;
         Dim[1] = 0;
         Dim[2] = 0;
         lS = SetUpTag("TBLTYPE", IDL_TYP_LONG, Dim, nTag++, &MxT);
         lS = SetUpTag("NUMCOMLINES", IDL_TYP_LONG, Dim, nTag++, &MxT);

	 if (nCom > 0) {
            Dim[0] = nCom;
            lS = SetUpTag("TBLCOMMENT", IDL_TYP_STRING, Dim, nTag++, &MxT);
         }

         Dim[0] = 0;
         lS = SetUpTag("TBLVAR", IDL_TYP_LONG, Dim, nTag++, &MxT);
         lS = SetUpTag("TBLFMT", IDL_TYP_LONG, Dim, nTag++, &MxT);

         if (tLen > 0) {
	    Dim[0] = tLen;
	    if (tType != 1) {
               lS = SetUpTag("TBLVALS", IDL_TYP_DOUBLE, Dim, nTag++, &MxT);
            } else {
               lS = SetUpTag("TBLVALS", IDL_TYP_STRING, Dim, nTag++, &MxT);
            }
         }
      break;
      case 3: 
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nCom, _ConstDescLeN, Blk, 0, 0);
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nSen, _SeN, 0, 0, 0);

	 MxT = _ConsT - _ConstID + 1;
         MxT += nCom;
         MxT += 10;

         B = MxT * MAX_TAG_LEN;
         if ((TmpName = malloc(B)) == NULL)
            idl_barf("MkDataStruc: malloc(TmpName)");

         B = MxT * (4 * sizeof(IDL_LONG));
         if ((TmpDim = malloc(B)) == NULL)
             idl_barf("MkDataStruc: malloc(TmpDim)");

         B = MxT * sizeof(ByTe_2);
         if ((TmpType = malloc(B)) == NULL)
             idl_barf("MkDataStruc: malloc(TmpType)");

         *sS = nCom * 80;

         Dim[1] = 0;
         Dim[2] = 0;

         Dim[0] = 0;
         lS = SetUpTag("CONSTANTID", IDL_TYP_LONG, Dim, nTag++, &MxT);
         lS = SetUpTag("NUMCOMLINES", IDL_TYP_LONG, Dim, nTag++, &MxT);

	 if (nCom > 0) {
            Dim[0] = nCom;
            lS = SetUpTag("CONSTCOMMENT", IDL_TYP_STRING, Dim, nTag++, &MxT);
         }

         Dim[0] = nSen;
         lS = SetUpTag("CONSTSCA", IDL_TYP_LONG, Dim, nTag++, &MxT);
         lS = SetUpTag("CONSTVAL", IDL_TYP_LONG, Dim, nTag++, &MxT);
      break;
      case 4: 
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nCom, _ConstDescLeN, Blk, 0, 0);
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nSen, _SeN, 0, 0, 0);

	 MxT = _ConsT - _ConstID + 1;
         MxT += nCom;
	 if (tType == 1) { MxT += TSz; }
         MxT += 10;


         B = MxT * MAX_TAG_LEN;
         if ((TmpName = malloc(B)) == NULL)
            idl_barf("MkDataStruc: malloc(TmpName)");

         B = MxT * (4 * sizeof(IDL_LONG));
         if ((TmpDim = malloc(B)) == NULL)
             idl_barf("MkDataStruc: malloc(TmpDim)");

         B = MxT * sizeof(ByTe_2);
         if ((TmpType = malloc(B)) == NULL)
             idl_barf("MkDataStruc: malloc(TmpType)");

         *sS = nCom * 80;

         Dim[1] = 0;
         Dim[2] = 0;

         Dim[0] = 0;
         lS = SetUpTag("CONSTANTID", IDL_TYP_LONG, Dim, nTag++, &MxT);
	 lS = SetUpTag("NUMCOMLINES", IDL_TYP_LONG, Dim, nTag++, &MxT);

	 if (nCom > 0) {
            Dim[0] = nCom;
            lS = SetUpTag("CONSTCOMMENT", IDL_TYP_STRING, Dim, nTag++, &MxT);
         }

         Dim[0] = nSen;
         lS = SetUpTag("CONSTVAL", IDL_TYP_DOUBLE, Dim, nTag++, &MxT);
      break;
   }

   FormTags (nTag);
   vD = IDL_MakeStruct((ByTe_1 *)NULL, TaGs);

   *mS = lS + IDL_StructTagInfoByIndex(vD, (int)(nTag - 1), 0, (IDL_VPTR *)0);

   *mS += 500;
   *sS += 240;

   free (TaGs);
   free (TmpName);
   free (TmpDim);
   free (TmpType);
   return vD;
}
