#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "user_defs.h"
#include "PidfStr.h"
#include "PidfAnsi.h"

#include "udfdlm_ansi.h"
#include "udfdlm_str.h"

ByTe_1 FillUnits (ByTe_4 DataField, struct fh_cache *fh)
{
   struct Pidf *P;
   struct PidfSensor *Px;
   struct PidfMode   *Pm;
   struct PidfAnc    *Pa;
   struct PidfScan   *Pi;

   register ByTe_2 *s1, *s2;
   register ByTe_1 *c1, *c2;

   ByTe_4 N;
   ByTe_2 uN1, uN2;

   P = (struct Pidf *)fh->PIDF;
   Px = (struct PidfSensor *)P->Sensors;
   Pm = (struct PidfMode *)P->Modes;
   Pa = (struct PidfAnc *)P->Ancil;
   Pi = (struct PidfScan *)P->Scans;

   /**********************************************************************/
   /* Nunits is the number of units defined for the sensor               */
   /* unitN  PIDF unit number to use                                     */
   /*                                                                    */
   /* uN must be less than or equal to Nunits                            */
   /* Nunits should be > 0                                               */
   /**********************************************************************/

   switch (DataField) {
      case SENSOR:
         s1 = fh->Units;
         s2 = fh->Order;
         c1 = fh->uNDef;
         for (N=0; N < fh->TotVSen; N++) {
            RetUnit (fh, *s2++, 'S', &uN1, &uN2);
            *s1++ = (*c1++ <= 1) ? uN1 : uN2;
         }
      break;
      case MODE:
         s1 = fh->Units + fh->TotVSen + fh->TotAnc;
         s2 = fh->Order + fh->TotVSen + fh->TotAnc;
         c1 = fh->uNDef + fh->TotVSen + fh->TotAnc;
         for (N=0; N < fh->TotMode; N++) {
            RetUnit (fh, *s2++, 'M', &uN1, &uN2);
            *s1++ = (*c1++ <= 1) ? uN1 : uN2;
         }
      break;
      case ANCILLARY:
         s1 = fh->Units + fh->TotVSen;
         s2 = fh->Order + fh->TotVSen;
         c1 = fh->Loc + fh->TotVSen;
         c2 = fh->uNDef + fh->TotVSen;
         for (N=0; N < fh->TotAnc; N++) {
            RetUnit (fh, *s2++, *c1++, &uN1, &uN2);
            *s1++ = (*c2++ <= 1) ? uN1 : uN2;
         }
      break;
      case SCAN_INDEX:
         s1 = fh->Units + fh->TotVSen + fh->TotAnc + fh->TotMode;
         RetUnit (fh, 0, 'I', &uN1, &uN2);
         *s1++ = uN1;
         if (uN2 >= 0)
            *s1++ = uN2;
      break;
   }

   return (1);
}
