#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "user_defs.h"
#include "ret_codes.h"
#include "PidfAnsi.h"
#include "ret_codes.h"
#include "libbase_udf.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

/*  This routine checks that the UDF and PIDF structures exist and if not  */
/*  creates them.  These structures are generally created right up front   */
/*  in UDF_KEY but are freed with UDF_CLOSE.  If you reopen the same UDF   */
/*  because you already have the key they might not exist.                 */

void CheckStructs (u_ByTe_4 Key)
{
   extern struct fh_cache fh_list[];
   extern u_ByTe_2 Version;
   extern void   *UDF;

   struct    fh_cache *fh;
   ByTe_4    fP;
   ByTe_2    rV;

   fP = FindFh(Key);
   fh = &fh_list[fP];
   if (UDF == NULL) {
      get_version_number(&Version);
      rV = create_idf_data_structure(&UDF);
      if (rV != ALL_OKAY) { udf_barf("CreateIdf", rV); }
   }

   if (fh->PIDF == NULL) { CreatePidfStruc(&fh->PIDF); }
}
