/* idl_load.c  --  loads the UDF package                                   */
/*                                                                         */
/* THIS routine was based on one found in the IDL 7.0 External Development */
/*   Guide.  There is a set of message codes defined in the example for    */
/*   each defined procedure and routine which I have omitted.  I think     */
/*   that they are optional.                                               */

#include <stdio.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

/* THIS defines the IDL procedure and funtion type defs - makes the        */
/*    definitions a bit more readable.                                     */

#define PROCEDURE void
#define FUNCTION  IDL_VPTR

/* NOW define the routines which will can be invoked from the dlm          */

extern PROCEDURE UDF_CLOSE( int Argc, IDL_VPTR Argv[], char *kw_unused );
extern PROCEDURE UDF_DONE( int Argc, IDL_VPTR Argv[], char *kw_unused );
extern FUNCTION  UDF_KEY(int Argc, IDL_VPTR Argv[], char *kw_unused);
extern FUNCTION  UDF_OPEN(int Argc, IDL_VPTR Argv[], char *Argk);
extern FUNCTION  UDF_READ(int Argc, IDL_VPTR Argv[], char *kw_unused);
extern FUNCTION  UDF_EOF(int Argc, IDL_VPTR Argv[], char *kw_unused);
extern PROCEDURE UDF_JUMPTIME(int Argc, IDL_VPTR Argv[], char *kw_unused);
extern FUNCTION  UDF_TIMES(int Argc, IDL_VPTR Argv[], char *kw_unused);
extern FUNCTION  UDF_MISC(int Argc, IDL_VPTR Argv[], char *kw_unused);
extern FUNCTION  UDF_VIDF(int Argc, IDL_VPTR Argv[], char *kw_unused);
extern PROCEDURE UDF_VFREE(int Argc, IDL_VPTR Argv[], char *kw_unused);

/* THIS is the routine which is invoked right after idl_load and does     */
/*   and is responsible for initialization.  I don't see an               */
/*   equivalent routine in the example code but I don't thing leaving     */
/*   it here will hurt.  It was in the original code.                     */

extern int udfdlm_post_idl_load( void );

/* THE idl_load routine begins here.                                      */

int IDL_Load(void)
{

/* THIS is the procedure information structure                            */

   static IDL_SYSFUN_DEF2 proc_addr[] = {
     {{(IDL_SYSRTN_GENERIC) UDF_DONE}, "UDF_DONE",  0, 15, 0 },
     {{(IDL_SYSRTN_GENERIC) UDF_CLOSE}, "UDF_CLOSE",  0, 15, 0 },
     {{(IDL_SYSRTN_GENERIC) UDF_JUMPTIME}, "UDF_JUMPTIME",  0, 15, 0 },
     {{(IDL_SYSRTN_GENERIC) UDF_VFREE}, "UDF_VFREE",  0, 15, 0 },
   };

/* THIS is the function information structure                            */

   static IDL_SYSFUN_DEF2 func_addr[] = {
     { {UDF_KEY},   "UDF_KEY",   0, 15, 0 },
     { {UDF_OPEN},  "UDF_OPEN",  0, 15, IDL_SYSFUN_DEF_F_KEYWORDS },
     { {UDF_READ},  "UDF_READ",  0, 15, 0 },
     { {UDF_EOF},   "UDF_EOF",   0, 15, 0 },
     { {UDF_TIMES}, "UDF_TIMES", 0, 15, 0 },
     { {UDF_MISC},  "UDF_MISC",  0, 15, 0 },
     { {UDF_VIDF},  "UDF_VIDF",  0, 15, 0 },
   };

   return IDL_SysRtnAdd(func_addr, TRUE, IDL_CARRAY_ELTS(func_addr))
      &&  IDL_SysRtnAdd(proc_addr, FALSE, IDL_CARRAY_ELTS(proc_addr))
      && udfdlm_post_idl_load();
}
