#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "local_defs.h"
#include "user_defs.h"
#include "idf_defs.h"
#include "DbDefs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "Util1Ansi.h"
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"
#include "libCfg.h"
#include "StrHier.h"
#include "dbf.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

/***************\
|*  UDF_TIMES  *|  Given a key, return an array of times available in the UDF
\***************/

FUNCTION UDF_VIDF(int Argc, IDL_VPTR Argv[], char *kw_unused)
{
   extern struct fh_cache fh_list[];
   extern ByTe_1 Ext[];
   extern u_ByTe_2 Version;

   struct fh_cache *fh;
   struct basic_struct *arr;
   ByTe_1 *base;

   IDL_MEMINT       one = 1;
   IDL_STRING       *Sa;
   IDL_LONG *l1;

   ReaL_8 *d1;
   u_ByTe_4  KeY;
   ByTe_4    FhNum, mS, sS, I, B;
   ByTe_4   *l2, nTS, nTV, cAS, EnD;
   ByTe_4   tO;
   ByTe_2   tL;
   u_ByTe_2 VeR;
   ByTe_2   *s1, vFmT = 0;
   ByTe_2   sH, nCom, nSen, PaAppS;
   ByTe_1   cH, FillFlag, nAnc, nQual, pAng, nStat, tType;
   ByTe_1   *tP;
   ByTe_1   *tS;
   ByTe_1   nT, nC;
   ByTe_1   *SecTioN;
   ByTe_2   Block = 0;
   ByTe_2   TyPe, mN = 0, sV = 0;
   void  *vdef;
   void     *tScratch;
   void     *rV;

  /* Input the offset to the file handler to be queried */

   if (Argc >= 2) {
      FhNum = Argv[0]->value.i;
      fh = &fh_list[FhNum];
      if (Argv[1]->type != IDL_TYP_STRING) {
         idl_barf("UDF_VIDF: SECTION - Must Be a String Argument");
      } else { SecTioN = IDL_STRING_STR(&Argv[1]->value.str); }
   } else
      IDL_Message(IDL_M_GENERIC, IDL_MSG_LONGJMP, "Usage: uM = UDF_VIDF(fh)");

   if (Argc > 2) {
     TyPe =  Argv[2]->type;
     Block = (TyPe == IDL_TYP_INT) ? Argv[2]->value.i : Argv[2]->value.l;
   }

   if (Argc > 3) {
     TyPe =  Argv[3]->type;
     mN = (TyPe == IDL_TYP_INT) ? Argv[3]->value.i : Argv[3]->value.l;
   }

   if (Argc > 4) {
     TyPe =  Argv[4]->type;
     sV = (TyPe == IDL_TYP_INT) ? Argv[3]->value.i : Argv[3]->value.l;
   }

   KeY = fh->Key;
   VeR = Version;
   tScratch = NULL;

   if ( strcmp(SecTioN, "BODY") == 0 )           { vFmT = 0; }
   if ( strcmp(SecTioN, "TABLERAW") == 0 )       { vFmT = 1; }
   if ( strcmp(SecTioN, "TABLECOOKED") == 0 )    { vFmT = 2; }
   if ( strcmp(SecTioN, "CONSTANTRAW") == 0 )    { vFmT = 3; }
   if ( strcmp(SecTioN, "CONSTANTCOOKED") == 0 ) { vFmT = 4; }

/* CREATE the structure                                           */

   vdef = MkVidfStruc(fh, vFmT, Block, 0, 0, &mS, &sS);

/* ALLOCATE the memory to hold the data                          */

   if (fh->vA == NULL) {
      if ((fh->vA = malloc(mS)) == NULL) {
          idl_barf("UDF_READ: malloc(fh->vA) failed!");
      }
      fh->vSize = mS;
   } else {
      if (mS > fh->vSize) 
      if ((fh->vA = realloc(fh->vA, mS)) == NULL) {
          idl_barf("UDF_READ: malloc(fh->vA) failed!");
      }
      fh->vSize = mS;
   }

   arr = (struct basic_struct *)fh->vA;
   base = (ByTe_1 *) &(arr->data);

/* GET the number of defined sensors.  Always need that           */

   read_idf(KeY, Ext, VeR, (ByTe_1 *)&nSen, _SeN, 0, 0, 0);
   read_idf(KeY, Ext, VeR, &nT, _NumTblS, 0, 0, 0);
   read_idf(KeY, Ext, VeR, &nC, _NumConstS, 0, 0, 0);

   switch (vFmT) {
      case 0:
         I = 0;
	 if (fh->mV[I] == NULL) {
            if ((fh->mV[I] = malloc(sS)) == NULL) {
               idl_barf("UDF_READ: malloc(fh->mV[I]) failed!");
            }
         } 
         tP = (ByTe_1 *)fh->mV[I];

         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nCom, _NumComntS, 0, 0, 0);
         read_idf(KeY, Ext, VeR, &FillFlag, _FillFlaG, 0, 0, 0);
         read_idf(KeY, Ext, VeR, &nStat, _StatuS, 0, 0, 0);
         read_idf(KeY, Ext, VeR, &nAnc, _CalSetS, 0, 0, 0);
         read_idf(KeY, Ext, VeR, &nQual, _NumQuaL, 0, 0, 0);
         read_idf(KeY, Ext, VeR, &pAng, _PaDefineD, 0, 0, 0);

/* MALLOC some temporary scratch space to hold arrays             */

         B = sizeof(ByTe_4) * (nSen + nAnc + nStat + 40);
         if ((tScratch = malloc(B)) == NULL) {
             idl_barf("UDF_READ: malloc(tScratch) failed!");
         }
         tS = (ByTe_1 *)tScratch;

         read_idf(KeY, Ext, VeR, tP, _ProjecT, 0, 0, 0);
         Sa = (IDL_STRING *)base;
         Sa->slen = 80;
         Sa->stype = 0;
         Sa->s = tP;
         base += sizeof(IDL_STRING);
         tP += 80;

         read_idf(KeY, Ext, VeR, tP, _MissioN, 0, 0, 0);
         Sa = (IDL_STRING *)base;
         Sa->slen = 80;
         Sa->stype = 0;
         Sa->s = tP;
         base += sizeof(IDL_STRING);
         tP += 80;

         read_idf(KeY, Ext, VeR, tP, _ExpDesC, 0, 0, 0);
         Sa = (IDL_STRING *)base;
         Sa->slen = 80;
         Sa->stype = 0;
         Sa->s = tP;
         base += sizeof(IDL_STRING);
         tP += 80;

         read_idf(KeY, Ext, VeR, tP, _InstDesC, 0, 0, 0);
         Sa = (IDL_STRING *)base;
         Sa->slen = 80;
         Sa->stype = 0;
         Sa->s = tP;
         base += sizeof(IDL_STRING);
         tP += 80;
      
         read_idf(KeY, Ext, VeR, tP, _ContacT, 0, 0, 0);
         for (I = 0; I < 5; ++I) {
            Sa = (IDL_STRING *)base;
            Sa->slen = 80;
            Sa->stype = 0;
            Sa->s = tP;
            base += sizeof(IDL_STRING);
            tP += 80;
         }
      
         if ( nCom > 0 ) {
            l1 = (IDL_LONG *)base;
	    *l1++ = nCom;
            base = (ByTe_1 *)l1;
            read_idf(KeY, Ext, VeR, tP, _CommentS, 0, 0, 0);
            for (I = 0; I < nCom; ++I) {
               Sa = (IDL_STRING *)base;
               Sa->slen = 80;
               Sa->stype = 0;
               Sa->s = tP;
               base += sizeof(IDL_STRING);
               tP += 80;
            }
         }
      
         l1 = (IDL_LONG *)base;
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&sH, _DsYeaR, 0, 0, 0);
         *l1++ = sH;
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&sH, _DsDaY, 0, 0, 0);
         *l1++ = sH;
         read_idf(KeY, Ext, VeR, (ByTe_1 *)l1, _DsMseC, 0, 0, 0);
         l1++;
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&sH, _DsUseC, 0, 0, 0);
         *l1++ = sH;
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&sH, _DeYeaR, 0, 0, 0);
         *l1++ = sH;
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&sH, _DeDaY, 0, 0, 0);
         *l1++ = sH;
         read_idf(KeY, Ext, VeR, (ByTe_1 *)l1, _DeMseC, 0, 0, 0);
         ++l1;
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&sH, _DeUseC, 0, 0, 0);
         *l1++ = sH;
         read_idf(KeY, Ext, VeR, &cH, _SmpID, 0, 0, 0);
         *l1++ = cH;
         read_idf(KeY, Ext, VeR, &cH, _SenModE, 0, 0, 0);
         *l1++ = cH;
         read_idf(KeY, Ext, VeR, &cH, _NumQuaL, 0, 0, 0);
         *l1++ = cH;
         read_idf(KeY, Ext, VeR, &cH, _CalSetS, 0, 0, 0);
         *l1++ = cH;
         read_idf(KeY, Ext, VeR, &cH, _NumTblS, 0, 0, 0);
         *l1++ = cH;
         read_idf(KeY, Ext, VeR, &cH, _NumConstS, 0, 0, 0);
         *l1++ = cH;
         read_idf(KeY, Ext, VeR, &cH, _StatuS, 0, 0, 0);
         *l1++ = cH;
         read_idf(KeY, Ext, VeR, &cH, _PaDefineD, 0, 0, 0);
         *l1++ = cH;
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&sH, _SeN, 0, 0, 0);
         *l1++ = sH;
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&sH, _SwpLeN, 0, 0, 0);
         *l1++ = sH;
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&sH, _MaxNsS, 0, 0, 0);
         *l1++ = sH;
         read_idf(KeY, Ext, VeR, (ByTe_1 *)l1, _DataLeN, 0, 0, 0);
         l1++;
         read_idf(KeY, Ext, VeR, &cH, _FillFlaG, 0, 0, 0);
         *l1++ = cH;
         if (FillFlag == 1) { 
            read_idf(KeY, Ext, VeR, (ByTe_1 *)l1, _FilL, 0, 0, 0);
            l1++;
         }
         read_idf(KeY, Ext, VeR, &cH, _DaMethoD, 0, 0, 0);
         *l1++ = cH;
      
         if (nStat > 0) { 
            base = (ByTe_1 *)l1;
            read_idf(KeY, Ext, VeR, tP, _StatusNamE, 0, 0, 0);
            for (I = 0; I < nStat; ++I) {
               Sa = (IDL_STRING *)base;
               Sa->slen = 80;
               Sa->stype = 0;
               Sa->s = tP;
               base += sizeof(IDL_STRING);
               tP += 80;
            }
      
            l1 = (IDL_LONG *)base;
            read_idf(KeY, Ext, VeR, tS, _StateS, 0, 0, 0);
            for (I = 0; I < nStat; ++I ) { *l1++ = tS[I]; }
         }
      
         if (nSen > 0) { 
            base = (ByTe_1 *)l1;
            read_idf(KeY, Ext, VeR, tP, _SenNamE, 0, 0, 0);
            for (I = 0; I < nSen; ++I) {
               Sa = (IDL_STRING *)base;
               Sa->slen = 80;
               Sa->stype = 0;
               Sa->s = tP;
               base += sizeof(IDL_STRING);
               tP += 80;
            }
      
            l1 = (IDL_LONG *)base;
            read_idf(KeY, Ext, VeR, tS, _DataTypE, 0, 0, 0);
            for (I = 0; I < nSen; ++I ) { *l1++ = tS[I]; }
      
            read_idf(KeY, Ext, VeR, tS, _TdwLeN, 0, 0, 0);
            for (I = 0; I < nSen; ++I ) { *l1++ = tS[I]; }
      
            read_idf(KeY, Ext, VeR, tS, _TimeOfF, 0, 0, 0);
            l2 = (ByTe_4 *)tS;
            for (I = 0; I < nSen; ++I ) { *l1++ = *l2++; }
         }
      
         if (nAnc > 0) { 
            base = (ByTe_1 *)l1;
            read_idf(KeY, Ext, VeR, tP, _CalNameS, 0, 0, 0);
            for (I = 0; I < nAnc; ++I) {
               Sa = (IDL_STRING *)base;
               Sa->slen = 80;
               Sa->stype = 0;
               Sa->s = tP;
               base += sizeof(IDL_STRING);
               tP += 80;
            }
      
            l1 = (IDL_LONG *)base;
            read_idf(KeY, Ext, VeR, tS, _CalUsE, 0, 0, 0);
            for (I = 0; I < nAnc; ++I ) { *l1++ = tS[I]; }
      
            read_idf(KeY, Ext, VeR, tS, _CalWleN, 0, 0, 0);
            for (I = 0; I < nAnc; ++I ) { *l1++ = tS[I]; }
      
            read_idf(KeY, Ext, VeR, tS, _CalTargeT, 0, 0, 0);
            for (I = 0; I < nAnc; ++I ) { *l1++ = tS[I]; }
         }
      
         if (nQual > 0) { 
            base = (ByTe_1 *)l1;
            read_idf(KeY, Ext, VeR, tP, _QualNamE, 0, 0, 0);
            for (I = 0; I < nQual; ++I) {
               Sa = (IDL_STRING *)base;
               Sa->slen = 80;
               Sa->stype = 0;
               Sa->s = tP;
               base += sizeof(IDL_STRING);
               tP += 80;
            }
         }

         if (pAng == 1) { 
            l1 = (IDL_LONG *)base;
            read_idf(KeY, Ext, VeR, (ByTe_1 *)&sH, _PaFormaT, 0, 0, 0);
            *l1++ = sH;
      
            base = (ByTe_1 *)l1;
            read_idf(KeY, Ext, VeR, tP, _PaProjecT, 0, 0, 0);
            Sa = (IDL_STRING *)base;
            Sa->slen = 21;
            Sa->stype = 0;
            Sa->s = tP;
            base += sizeof(IDL_STRING);
            tP += 21;
            read_idf(KeY, Ext, VeR, tP, _PaMissioN, 0, 0, 0);
            Sa = (IDL_STRING *)base;
            Sa->slen = 21;
            Sa->stype = 0;
            Sa->s = tP;
            base += sizeof(IDL_STRING);
            tP += 21;
            read_idf(KeY, Ext, VeR, tP, _PaExpeR, 0, 0, 0);
            Sa = (IDL_STRING *)base;
            Sa->slen = 21;
            Sa->stype = 0;
            Sa->s = tP;
            base += sizeof(IDL_STRING);
            tP += 21;
            read_idf(KeY, Ext, VeR, tP, _PaInsT, 0, 0, 0);
            Sa = (IDL_STRING *)base;
            Sa->slen = 21;
            Sa->stype = 0;
            Sa->s = tP;
            base += sizeof(IDL_STRING);
            tP += 21;
            read_idf(KeY, Ext, VeR, tP, _PaVinsT, 0, 0, 0);
            Sa = (IDL_STRING *)base;
            Sa->slen = 21;
            Sa->stype = 0;
            Sa->s = tP;
            base += sizeof(IDL_STRING);
            tP += 21;
      
            l1 = (IDL_LONG *)base;
            read_idf(KeY, Ext, VeR, tS, _PaBxbybZ, 0, 0, 0);
            s1 = (ByTe_2 *)tS;
            for (I = 0; I < 3; ++I ) { *l1++ = *s1++; }
      
            read_idf(KeY, Ext, VeR, (ByTe_1 *)&PaAppS, _PaAppS, 0, 0, 0);
            *l1++ = PaAppS;
            if ( sH > 0 ) {
               read_idf(KeY, Ext, VeR, tS, _PaTblS, 0, 0, 0);
               s1 = (ByTe_2 *)tS;
               for (I = 0; I < PaAppS; ++I ) { *l1++ = *s1++; }
      
               read_idf(KeY, Ext, VeR, tS, _PaOpS, 0, 0, 0);
               s1 = (ByTe_2 *)tS;
               for (I = 0; I < PaAppS; ++I ) { *l1++ = *s1++; }
            }
         }

      break;
      case 1:
         I = Block * 2 + 1;
	 if (fh->mV[I] == NULL) {
            if ((fh->mV[I] = malloc(sS)) == NULL) {
               idl_barf("UDF_READ: malloc(fh->mV[I]) failed!");
            }
         } 
         tP = (ByTe_1 *)fh->mV[I];

         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nCom, _TblDescLeN, Block, 0, 0);
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nTS, _TblScaSZ, Block, 0, 0);
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nTV, _TblEleSZ, Block, 0, 0);
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&cAS, _CritActSZ, Block, 0, 0);
         read_idf(KeY, Ext, VeR, &tType, _TblTypE, Block, 0, 0);

	 B = (nTS < 0) ? -nTS : nTS;
         B = sizeof(ByTe_4) * (B + nSen + nTS + cAS + 40);
         if ((tScratch = malloc(B)) == NULL) {
             idl_barf("UDF_READ: malloc(tScratch) failed!");
         }
         tS = (ByTe_1 *)tScratch;

         l1 = (IDL_LONG *)base;
         *l1++ = nTS;
         *l1++ = nTV;
         read_idf(KeY, Ext, VeR, &cH, _TblTypE, Block, 0, 0);
         *l1++ = cH;
         *l1++ = nCom;

         if ( nCom > 0 ) {
            base = (ByTe_1 *)l1;
            read_idf(KeY, Ext, VeR, tP, _TblDesC, Block, 0, 0);
            for (I = 0; I < nCom; ++I) {
               Sa = (IDL_STRING *)base;
               Sa->slen = 80;
               Sa->stype = 0;
               Sa->s = tP;
               base += sizeof(IDL_STRING);
               tP += 80;
            }
         }

         l1 = (IDL_LONG *)base;
         read_idf(KeY, Ext, VeR, &cH, _TblVaR, Block, 0, 0);
         *l1++ = cH;
         read_idf(KeY, Ext, VeR, &cH, _TblExpanD, Block, 0, 0);
         *l1++ = cH;

	 if ( cAS > 0 ) {
            read_idf(KeY, Ext, VeR, tS, _CritStatuS, Block, 0, 0);
            for (I = 0; I < nSen; ++I ) { *l1++ = tS[I]; }

            read_idf(KeY, Ext, VeR, tS, _CritOfF, Block, 0, 0);
            s1 = (ByTe_2 *)tS;
            for (I = 0; I < nSen; ++I ) { *l1++ = *s1++; }

            read_idf(KeY, Ext, VeR, (ByTe_1 *)l1, _CritActioN, Block, 0, 0);
            l1 += cAS;
	 }

         read_idf(KeY, Ext, VeR, tS, _TblFmT, Block, 0, 0);
         for (I = 0; I < nSen; ++I ) { *l1++ = tS[I]; }

         read_idf(KeY, Ext, VeR, (ByTe_1 *)l1, _TblOfF, Block, 0, 0);
	 l1 += nSen;

         if ( nTS != 0 ) {
	    EnD = (nTS < 0) ? -nTS : nTS;
            read_idf(KeY, Ext, VeR, tS, _TblScA, Block, 0, 0);
            for (I = 0; I < EnD; ++I ) { *l1++ = tS[I]; }
         }

         if (tType != 1 ) {
            read_idf(KeY, Ext, VeR, (ByTe_1 *)l1, _TbL, Block, 0, 0);
	    l1 += nTV;
         } else {
            base = (ByTe_1 *)l1;
            read_idf(KeY, Ext, VeR, tP, _TbL, Block, 0, 0);
            for (I = 0; I < nTV; ++I) {
               Sa = (IDL_STRING *)base;
               Sa->slen = 21;
               Sa->stype = 0;
               Sa->s = tP;
               base += sizeof(IDL_STRING);
               tP += 21;
            }
	 }

      break;
      case 2:
         I = Block * 2 + 2;
	 if (fh->mV[I] == NULL) {
            if ((fh->mV[I] = malloc(sS)) == NULL) {
               idl_barf("UDF_READ: malloc(fh->mV[I]) failed!");
            }
         } 

         tP = (ByTe_1 *)fh->mV[I];

         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nCom, _TblDescLeN, Block, 0, 0);
         read_idf(KeY, Ext, VeR, &tType, _TblTypE, Block, 0, 0);

         l1 = (IDL_LONG *)base;
         read_idf(KeY, Ext, VeR, &cH, _TblTypE, Block, 0, 0);
         *l1++ = cH;
         *l1++ = nCom;

         if ( nCom > 0 ) {
            base = (ByTe_1 *)l1;
            read_idf(KeY, Ext, VeR, tP, _TblDesC, Block, 0, 0);
            for (I = 0; I < nCom; ++I) {
               Sa = (IDL_STRING *)base;
               Sa->slen = 80;
               Sa->stype = 0;
               Sa->s = tP;
               base += sizeof(IDL_STRING);
               tP += 80;
            }
         }

         l1 = (IDL_LONG *)base;
         read_idf(KeY, Ext, VeR, &cH, _TblVaR, Block, 0, 0);
         *l1++ = cH;
         read_idf(KeY, Ext, VeR, &cH, _TblFmT, Block, mN, 1);
         *l1++ = cH;


         if (tType != 1 ) {
            base = (ByTe_1 *)l1;
	    tL = NumTblVals (KeY, Block, mN);
	    tO = TblOffset (KeY, Block, mN, sV);
	    CookedVals (KeY, Block, mN, tO, tL, (ReaL_8 *)base);
         } else {
            base = (ByTe_1 *)l1;
            read_idf(KeY, Ext, VeR, tP, _TbL, Block, tO, tL);
            for (I = 0; I < tL; ++I) {
               Sa = (IDL_STRING *)base;
               Sa->slen = 21;
               Sa->stype = 0;
               Sa->s = tP;
               base += sizeof(IDL_STRING);
               tP += 21;
            }
	 }

      break;
      case 3:
         I = nT * 2 + Block * 2 + 1;
	 if (fh->mV[I] == NULL) {
            if ((fh->mV[I] = malloc(sS)) == NULL) {
               idl_barf("UDF_READ: malloc(fh->mV[I]) failed!");
            }
         } 
         tP = (ByTe_1 *)fh->mV[I];

         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nCom, _ConstDescLeN, Block, 0, 0);

         B = sizeof(ByTe_4) * nSen;
         if ((tScratch = malloc(B)) == NULL) {
             idl_barf("UDF_READ: malloc(tScratch) failed!");
         }
         tS = (ByTe_1 *)tScratch;

         l1 = (IDL_LONG *)base;
         read_idf(KeY, Ext, VeR, &cH, _ConstID, Block, 0, 0);
         *l1++ = cH;
         *l1++ = nCom;

         if ( nCom > 0 ) {
            base = (ByTe_1 *)l1;
            read_idf(KeY, Ext, VeR, tP, _ConstDesC, Block, 0, 0);
            for (I = 0; I < nCom; ++I) {
               Sa = (IDL_STRING *)base;
               Sa->slen = 80;
               Sa->stype = 0;
               Sa->s = tP;
               base += sizeof(IDL_STRING);
               tP += 80;
            }
         }

         l1 = (IDL_LONG *)base;
         read_idf(KeY, Ext, VeR, tS, _ConstScA, Block, 0, 0);
         for (I = 0; I < nSen; ++I ) { *l1++ = tS[I]; }
         read_idf(KeY, Ext, VeR, (ByTe_1 *)l1, _ConsT, Block, 0, 0);

      break;
      case 4:
         I = nT * 2 + Block * 2 + 2;
	 if (fh->mV[I] == NULL) {
            if ((fh->mV[I] = malloc(sS)) == NULL) {
               idl_barf("UDF_READ: malloc(fh->mV[I]) failed!");
            }
         } 
         tP = (ByTe_1 *)fh->mV[I];

         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nCom, _ConstDescLeN, Block, 0, 0);

         B = sizeof(ByTe_4) * nSen * 2;
         if ((tScratch = malloc(B)) == NULL) {
             idl_barf("UDF_READ: malloc(tScratch) failed!");
         }
         tS = (ByTe_1 *)tScratch;

         l1 = (IDL_LONG *)base;
         read_idf(KeY, Ext, VeR, &cH, _ConstID, Block, 0, 0);
         *l1++ = cH;
         *l1++ = nCom;

         if ( nCom > 0 ) {
            base = (ByTe_1 *)l1;
            read_idf(KeY, Ext, VeR, tP, _ConstDesC, Block, 0, 0);
            for (I = 0; I < nCom; ++I) {
               Sa = (IDL_STRING *)base;
               Sa->slen = 80;
               Sa->stype = 0;
               Sa->s = tP;
               base += sizeof(IDL_STRING);
               tP += 80;
            }
         }

         base += 4;
         d1 = (ReaL_8 *)base;
	 l2 = (ByTe_4 *)tS + nSen;

         read_idf(KeY, Ext, VeR, tS, _ConstScA, Block, 0, 0);
         read_idf(KeY, Ext, VeR, (ByTe_1 *)l2, _ConsT, Block, 0, 0);

	 for ( I = 0; I < nSen; ++I ) {
	    *d1++ = (ReaL_8)*l2++ * pow(10,(ReaL_8)tS[I]);  
	 }

      break;
   }

   if (tScratch != NULL) { free(tScratch); }

   rV =  IDL_ImportArray(1, &one, IDL_TYP_STRUCT, (UCHAR*)arr, NULL, vdef);

   return rV;
}
