#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "user_defs.h"
#include "ret_codes.h"
#include "PidfAnsi.h"
#include "ret_codes.h"
#include "libbase_udf.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

/*************\
|*  UDF_KEY  *|  Given the 5 strings (project, etc), return a "Key"
\*************/

FUNCTION UDF_KEY(int Argc, IDL_VPTR Argv[], char *kw_unused)
{
   ByTe_1    *uN[5];		/* our 5 input args, converted to C strings */
   ByTe_1    *OptFile;		/* our Opt File Name                        */
   ByTe_2    rV;		/* return code of UDF functions             */
   ByTe_4    I;
   u_ByTe_4  Key;		/* the end result                           */

   IDL_VPTR  retval;		/* How we return it                         */
   IDL_STRING  *in_str;		

   const ByTe_1 Usage[] = 
     "Usage:\n key =  UDF_KEY(['P','M','E','I','V'])\n key= UDF_KEY('P','M','E','I','V')\n key = UDF_KEY('MenuFile')";

  /**************************************************************************/
  /* Process input arguments.  This must be exactly five character strings. */
  /* OR the name of an OPTS FILE                                            */
  /**************************************************************************/
 
   if (Argc == 1) {	                                    /* Opt File     */
       if (Argv[0]->type != IDL_TYP_STRING)
          idl_barf("UDF_KEY: Only String Arguments");
       if (Argv[0]->flags & IDL_V_ARR) {
          if (Argv[0]->value.arr->dim[0] != 5)
              IDL_Message(IDL_M_GENERIC, IDL_MSG_LONGJMP, Usage);
          in_str = (IDL_STRING*)(Argv[0]->value.arr->data);
          for (I = 0; I < 5; I++)
             uN[I] = IDL_STRING_STR(&in_str[I]);
          rV = get_data_key(uN[0], uN[1], uN[2], uN[3], uN[4], &Key);
             if (rV != ALL_OKAY) 
                udf_barf(NULL, rV);
       } else {
          OptFile = IDL_STRING_STR(&Argv[0]->value.str);     /* OPT FILE!    */
          Key = ReadOpts (OptFile);                          /* injest it    */
       }
   } else if (Argc == 5) {                                   /* PMEIV        */
      for (I = 0; I < 5; I++) {
          if (Argv[I]->type != IDL_TYP_STRING)              /* String Check */
            idl_barf("UDF_KEY: Input Name %d Must Be A String", I);
 
          if (Argv[I]->flags & IDL_V_NOT_SCALAR)            /* Array check  */
            idl_barf("UDF_KEY: Input Name %d Must Be A Scalar", I);
 
          uN[I] = IDL_STRING_STR(&Argv[I]->value.str);
      }

      rV = get_data_key(uN[0], uN[1], uN[2], uN[3], uN[4], &Key);

      if (rV != ALL_OKAY) 
         udf_barf("GetDataKey", rV);
   } else {
      IDL_Message(IDL_M_GENERIC, IDL_MSG_LONGJMP, Usage);
   }

   CheckStructs (Key);

  /************************************************************************/
  /* Return the key                                                       */
  /************************************************************************/

   retval           = IDL_Gettmp();
   retval->type     = IDL_TYP_ULONG;
   retval->value.ul = Key;

   return retval;
}
