#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "user_defs.h"
#include "ret_codes.h"
#include "libbase_udf.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

/*************\
|*  UDF_EOF  *|  Checks to see if there are more UDF records out there
\*************/

FUNCTION UDF_EOF(int Argc, IDL_VPTR Argv[], char *kw_unused)
{
   extern struct fh_cache fh_list[];
   extern ByTe_1 Ext[];
   extern u_ByTe_2 Version;
   extern void *UDF;

   struct fh_cache *fh;
   struct idf_data *udf;

   ByTe_4  FhNum, nS;
   ByTe_2  rV;
   ByTe_1  EoFTm;

   IDL_VPTR retval;
 
   if (Argc == 1) {
      FhNum = Argv[0]->value.i;
      fh = &fh_list[FhNum];
   } else
      IDL_Message(IDL_M_GENERIC, IDL_MSG_LONGJMP, 
                                "Usage: Eot = UDF_EOF(fh)");

  /* allocate a temporary variable to hold our return status */

    retval       = IDL_Gettmp();
    retval->type = IDL_TYP_BYTE;

  /* If there has never been a read - we don't need any of these checks */

    if (fh->LastRead == 999) {
       retval->value.c = 0;
       return retval;
    }

    udf = (struct idf_data *)UDF;

  /*
  ** Just prior to us getting called, UDF_READ() should have done a
  ** read_drec() with the FORWARD bit set... thus theoretically pointing
  ** us at the next record.
  **
  ** The current UDF structure should have the beginning and ending times
  ** of the last read.  Use this end time to see if there is more data
  ** to get or if we are past the end time requested by the user  
  **
  */

     EoFTm = (udf->eyear >  fh->Ey) ||
             (udf->eyear == fh->Ey && udf->eday > fh->Ed) ||
             (udf->eyear == fh->Ey && udf->eday == fh->Ed && 
              udf->emilli > fh->Ems);
  /*
  **  If there is still time left to get then check the status of the
  **  UDF file.  If we need to open the next file - now is the time to
  **  to do that.
  */

    if (!EoFTm) {
       if (fh->LastRead == NEXT_FILE_STATUS) {
          nS = (fh->Ems % 1000) * 1000000;
          rV = ReOpenFile(fh->Key, Ext, Version, UDF, 0, 0, 0, 0,
                           fh->Ey, fh->Ed, fh->Ems/1000, nS, fh->LastRead);
          fh->LastRead = 999;             /* cancel last read status       */
          if (rV == EOF_STATUS) {
              fh->is_open = 0;            /* On reopen, call "file_open()" */
              retval->value.c = 1;
              return retval;
          }
          if (rV != ALL_OKAY) { udf_barf("ReOpenFile",rV); }
       }
    }

  /* Return tome state of data relative to requested end time  */

    retval->value.c =  EoFTm;

    return retval;
}
